/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.flight.rim.movetransactions;

import ch.icit.pegasus.client.converter.FlightConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;

public class MoveRiMTransactionsComponent
extends DefaultScrollablePrintPopup2<FlightLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node<FlightLight> node;
    private TitledItem<TextLabel> oldFlight;
    private TitledItem<DateChooser> selectedFlightDate;
    private TitledItem<SearchTextField2<FlightLight>> newFlight;
    private TitledItem<CheckBox> moveOutbound;
    private TitledItem<CheckBox> moveInbound;

    public MoveRiMTransactionsComponent(Node<FlightLight> node) {
        super(false, false, false, false, null);
        this.node = node;
        this.insertElements();
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.reportTypesLoaded = true;
        this.createComponents();
        Node dateNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(((FlightLight)this.node.getValue()).getStd().getTime()), false, false);
        this.oldFlight = new TitledItem<TextLabel>(new TextLabel(this.node, ConverterRegistry.getConverter(FlightConverter.class)), Words.ORIGIN_FLIGHT, TitledItem.TitledItemOrientation.NORTH);
        this.selectedFlightDate = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.DATE, TitledItem.TitledItemOrientation.NORTH);
        this.newFlight = new TitledItem<SearchTextField2<FlightLight>>(SearchTextField2Factory.getFlightSearchField(true, new DTOProxyNode()), Words.NEW_FLIGHT, TitledItem.TitledItemOrientation.NORTH);
        Object[] o = new Object[]{dateNode, true};
        this.newFlight.getElement().setAdditionalSearchField(o);
        this.moveOutbound = new TitledItem<CheckBox>(new CheckBox(), Words.OUTBOUND, TitledItem.TitledItemOrientation.EAST);
        this.moveInbound = new TitledItem<CheckBox>(new CheckBox(), Words.INBOUND, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.oldFlight);
        this.getViewContainer().add(this.selectedFlightDate);
        this.getViewContainer().add(this.newFlight);
        this.getViewContainer().add(this.moveOutbound);
        this.getViewContainer().add(this.moveInbound);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        if (this.node.getChildNamed(FlightLight_.outboundCode).getValue() == null) {
            return "-";
        }
        return "" + (String)this.node.getChildNamed(FlightLight_.outboundCode).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightLight originFlight = (FlightLight)MoveRiMTransactionsComponent.this.node.getValue();
                FlightLight targetFlight = (FlightLight)((SearchTextField2)MoveRiMTransactionsComponent.this.newFlight.getElement()).getNode().getValue();
                boolean inbound = ((CheckBox)MoveRiMTransactionsComponent.this.moveInbound.getElement()).isChecked();
                boolean outbound = ((CheckBox)MoveRiMTransactionsComponent.this.moveOutbound.getElement()).isChecked();
                ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).moveTransactionsFiltered(originFlight, targetFlight, outbound, inbound);
                FlightComplete flightC = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(originFlight.getId())).getValue();
                MoveRiMTransactionsComponent.this.node.removeExistingValues();
                MoveRiMTransactionsComponent.this.node.setValue((Object)flightC, 0L);
                MoveRiMTransactionsComponent.this.node.updateNode();
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return MoveRiMTransactionsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.node;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = MoveRiMTransactionsComponent.this.layoutInheritedComponents(parent);
            MoveRiMTransactionsComponent.this.oldFlight.setLocation(MoveRiMTransactionsComponent.this.border, y);
            MoveRiMTransactionsComponent.this.oldFlight.setSize(200, (int)MoveRiMTransactionsComponent.this.oldFlight.getPreferredSize().getHeight());
            MoveRiMTransactionsComponent.this.selectedFlightDate.setLocation(MoveRiMTransactionsComponent.this.border, MoveRiMTransactionsComponent.this.oldFlight.getY() + MoveRiMTransactionsComponent.this.oldFlight.getHeight() + MoveRiMTransactionsComponent.this.border * 2);
            MoveRiMTransactionsComponent.this.selectedFlightDate.setSize(MoveRiMTransactionsComponent.this.selectedFlightDate.getPreferredSize());
            MoveRiMTransactionsComponent.this.newFlight.setLocation(MoveRiMTransactionsComponent.this.border, MoveRiMTransactionsComponent.this.selectedFlightDate.getY() + MoveRiMTransactionsComponent.this.selectedFlightDate.getHeight() + MoveRiMTransactionsComponent.this.border);
            MoveRiMTransactionsComponent.this.newFlight.setSize(200, (int)MoveRiMTransactionsComponent.this.newFlight.getPreferredSize().getHeight());
            MoveRiMTransactionsComponent.this.moveOutbound.setLocation(MoveRiMTransactionsComponent.this.border, MoveRiMTransactionsComponent.this.newFlight.getY() + MoveRiMTransactionsComponent.this.newFlight.getHeight() + MoveRiMTransactionsComponent.this.border * 2);
            MoveRiMTransactionsComponent.this.moveOutbound.setSize(MoveRiMTransactionsComponent.this.moveOutbound.getPreferredSize());
            MoveRiMTransactionsComponent.this.moveInbound.setLocation(MoveRiMTransactionsComponent.this.border, MoveRiMTransactionsComponent.this.moveOutbound.getY() + MoveRiMTransactionsComponent.this.moveOutbound.getHeight() + MoveRiMTransactionsComponent.this.border);
            MoveRiMTransactionsComponent.this.moveInbound.setSize(MoveRiMTransactionsComponent.this.moveInbound.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = MoveRiMTransactionsComponent.this.getInheritedComponentsHeight();
            h += MoveRiMTransactionsComponent.this.border;
            if (MoveRiMTransactionsComponent.this.animation != null) {
                h = (int)((double)h + MoveRiMTransactionsComponent.this.animation.getPreferredSize().getHeight());
                return new Dimension((int)((double)(MoveRiMTransactionsComponent.this.border * 2) + MoveRiMTransactionsComponent.this.animation.getPreferredSize().getWidth()), h += MoveRiMTransactionsComponent.this.border);
            }
            h = (int)((double)h + MoveRiMTransactionsComponent.this.oldFlight.getPreferredSize().getHeight());
            h += MoveRiMTransactionsComponent.this.border * 2;
            h = (int)((double)h + MoveRiMTransactionsComponent.this.selectedFlightDate.getPreferredSize().getHeight());
            h += MoveRiMTransactionsComponent.this.border;
            h = (int)((double)h + MoveRiMTransactionsComponent.this.newFlight.getPreferredSize().getHeight());
            h += MoveRiMTransactionsComponent.this.border * 2;
            h = (int)((double)h + MoveRiMTransactionsComponent.this.moveOutbound.getPreferredSize().getHeight());
            h += MoveRiMTransactionsComponent.this.border;
            h = (int)((double)h + MoveRiMTransactionsComponent.this.moveInbound.getPreferredSize().getHeight());
            return new Dimension(0, h);
        }
    }
}

