/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.flight.wagon;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.submodules.action.flight.wagon.utils.WagonPanel;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.FlightWagonComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.FlightWagonProductComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;

public class ActionWagonConfigComponent
extends DefaultScrollablePrintPopup2<FlightLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node<List<FlightWagonComplete>> wagonNodes;
    private Node<FlightLight> node;
    private RowModel<FlightLight> rowModel;
    private WagonPanel wagonPanel;

    public ActionWagonConfigComponent(Node<FlightLight> node, RowModel<FlightLight> m) {
        super(false, false, false, false, null);
        this.node = node;
        this.rowModel = m;
        Runnable r = () -> {
            try {
                ListWrapper flightWagons = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightWagons(new FlightReference(((FlightLight)node.getValue()).getId()));
                FlightComplete flight = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(((FlightLight)node.getValue()).getId())).getValue();
                this.wagonNodes = INodeCreator.getDefaultImpl().createNodes(flightWagons.getList(), false);
                this.wagonPanel.setData(flight, this.wagonNodes);
            }
            catch (ClientServerCallException e) {
                e.printStackTrace();
            }
        };
        this.loadBeforeShowing(r);
        this.insertElements();
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.reportTypesLoaded = true;
        this.wagonPanel = new WagonPanel();
        this.getViewContainer().add(this.wagonPanel);
        this.createComponents();
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        if (this.node.getChildNamed(FlightLight_.outboundCode).getValue() == null) {
            return "-";
        }
        return "" + (String)this.node.getChildNamed(FlightLight_.outboundCode).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> a = super.validateBeforePrint();
        return a;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.rowModel.getView().refreshCells();
        super.remoteObjectLoaded(node);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ActionWagonConfigComponent.this.wagonNodes.commit();
                List wagons = (List)ActionWagonConfigComponent.this.wagonNodes.getValue();
                Iterator it = wagons.iterator();
                while (it.hasNext()) {
                    FlightWagonComplete wagon = (FlightWagonComplete)it.next();
                    boolean hasProduct = false;
                    Iterator it2 = wagon.getProducts().iterator();
                    while (it2.hasNext()) {
                        FlightWagonProductComplete product = (FlightWagonProductComplete)it2.next();
                        if (product.getQuantity() == null || product.getQuantity() < 1) {
                            it2.remove();
                            continue;
                        }
                        hasProduct = true;
                    }
                    if (hasProduct) continue;
                    it.remove();
                }
                ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).updateFlightWagons(new FlightReference(((FlightLight)ActionWagonConfigComponent.this.node.getValue()).getId()), new ListWrapper(wagons));
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionWagonConfigComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.node;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ActionWagonConfigComponent.this.layoutInheritedComponents(parent);
            ActionWagonConfigComponent.this.wagonPanel.setLocation(0, y);
            ActionWagonConfigComponent.this.wagonPanel.setSize(parent.getWidth(), parent.getHeight() - y);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ActionWagonConfigComponent.this.getInheritedComponentsHeight();
            h += ActionWagonConfigComponent.this.border;
            if (ActionWagonConfigComponent.this.animation != null) {
                h = (int)((double)h + ActionWagonConfigComponent.this.animation.getPreferredSize().getHeight());
                return new Dimension((int)((double)(ActionWagonConfigComponent.this.border * 2) + ActionWagonConfigComponent.this.animation.getPreferredSize().getWidth()), h += ActionWagonConfigComponent.this.border);
            }
            return new Dimension(500, 400);
        }
    }
}

