/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.store.recipechargecount;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.tables.InventoryRecipeChargeCountTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.RecipeCountTransactionComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.RecipeSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RecipeChargeCountActionComponent
extends DefaultScrollablePrintPopup2<StoreLight> {
    private static final long serialVersionUID = 1L;
    private Node<StoreLight> storeNode;
    private InventoryRecipeChargeCountTable countTable;
    private TextButton importFromExcel;

    public RecipeChargeCountActionComponent(Node<StoreLight> dto) {
        super(false, false, false, false, null);
        this.storeNode = dto;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String string = s[1];
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.countTable);
        CheckedListAdder.addToList(focusList, this.importFromExcel);
        return focusList;
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.countTable = new InventoryRecipeChargeCountTable(this.popup);
        this.importFromExcel = new TextButton("Import from Excel");
        this.importFromExcel.addButtonListener((source, x, y) -> this.importFile());
        this.getViewContainer().add(this.countTable);
        this.getViewContainer().add(this.importFromExcel);
    }

    private void importFile() {
        this.setEnabled(false);
        final File file = FileChooserUtil.loadFile();
        if (file != null) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    List rows = ExcelToolkit.readRows((File)file);
                    Node node = RecipeChargeCountActionComponent.this.countTable.getModel().getNode();
                    for (ExcelRow row : rows) {
                        RecipeCountTransactionComplete counting = new RecipeCountTransactionComplete();
                        counting.setClientOId(Long.valueOf(ADTO.getNextId()));
                        counting.setOriginStore(((StoreLight)RecipeChargeCountActionComponent.this.storeNode.getValue()).getDefaultStorePosition());
                        Integer pNumber = ExcelToolkit.readAsInteger((ExcelRow)row, (int)0);
                        Integer pCount = ExcelToolkit.readAsInteger((ExcelRow)row, (int)2);
                        counting.setQuantity(new StoreQuantityComplete(Long.valueOf(pCount.longValue()), null));
                        RecipeSearchConfiguration pSearch = new RecipeSearchConfiguration();
                        pSearch.setNumber(pNumber);
                        pSearch.setName(null);
                        SearchResult result = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)pSearch);
                        RecipeComplete recipe = (RecipeComplete)result.getSingleResult();
                        counting.setRecipe(recipe);
                        counting.getQuantity().setUnit(recipe.getCurrentVariant().getYield().getUnit());
                        node.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)counting, true, false), 0L);
                    }
                    return new ViewNode("");
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            RecipeChargeCountActionComponent.this.setEnabled(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            RecipeChargeCountActionComponent.this.setEnabled(true);
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)RecipeChargeCountActionComponent.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            InnerPopupFactory.showErrorDialog("No File selected", (Component)this);
        }
    }

    @Override
    protected String getProgressText() {
        return Words.SAVE_DATA;
    }

    @Override
    public String getTitleString() {
        return Words.STORE;
    }

    @Override
    public String getTitleValue() {
        return ((StoreLight)this.storeNode.getValue()).getCode();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node node = RecipeChargeCountActionComponent.this.countTable.getModel().getNode();
                ArrayList<String> warnings = new ArrayList<String>();
                InventoryReference inventoryInProgress = ((StoreLight)RecipeChargeCountActionComponent.this.storeNode.getValue()).getInventoryInProgress();
                UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
                Iterator it = node.getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node next = (Node)it.next();
                    next.commitThis();
                    RecipeCountTransactionComplete transaction = (RecipeCountTransactionComplete)next.getValue();
                    if (transaction == null || transaction.getRecipe() == null) continue;
                    transaction.setTransactionDate(new Timestamp(System.currentTimeMillis()));
                    transaction.setInventory(inventoryInProgress);
                    transaction.setMobileAppCount(Boolean.valueOf(false));
                    transaction.setUser((UserLight)currentUser);
                    transaction.setOriginStore(((StoreLight)RecipeChargeCountActionComponent.this.storeNode.getValue()).getDefaultStorePosition());
                    try {
                        ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).countRecipePositionBased(transaction);
                    }
                    catch (Exception e) {
                        warnings.add(e.getMessage());
                    }
                }
                if (!warnings.isEmpty()) {
                    String text = "<ul>";
                    for (String warning : warnings) {
                        text = text + "<li>" + warning + "</li><br/>";
                    }
                    throw new ClientServerCallException(text);
                }
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return RecipeChargeCountActionComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<StoreLight> getCurrentNode() {
        return INodeCreator.getDefaultImpl().getNode4DTO(this.storeNode.getValue(), false, true);
    }

    @Override
    public BatchJob<StoreLight> createBatchJob(Node<StoreLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = RecipeChargeCountActionComponent.this.layoutInheritedComponents(parent);
            RecipeChargeCountActionComponent.this.countTable.setLocation(0, y);
            RecipeChargeCountActionComponent.this.countTable.setSize(parent.getWidth() - 4, (int)((double)parent.getHeight() - ((double)y + RecipeChargeCountActionComponent.this.importFromExcel.getPreferredSize().getHeight() + (double)(RecipeChargeCountActionComponent.this.border * 2))));
            RecipeChargeCountActionComponent.this.importFromExcel.setLocation(RecipeChargeCountActionComponent.this.border, RecipeChargeCountActionComponent.this.countTable.getY() + RecipeChargeCountActionComponent.this.countTable.getHeight() + RecipeChargeCountActionComponent.this.border);
            RecipeChargeCountActionComponent.this.importFromExcel.setSize(RecipeChargeCountActionComponent.this.importFromExcel.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = RecipeChargeCountActionComponent.this.getInheritedComponentsHeight();
            int w = 250;
            return new Dimension(w, h);
        }
    }
}

