/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.mealplan;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

public class AnalysisFlightMealPlanComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> includeProductFactSheets;
    private TitledItem<CheckBox> resolveRecipesToArticles;
    private TitledItem<DateChooser> validityDate;
    private TitledItem<CheckBox> showCosts;
    private TitledItem<ComboBox> useVariantType;

    public AnalysisFlightMealPlanComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        boolean canExportCosts = ProductToolkit.canExportFlightProductCosts();
        boolean canExportTender = ProductToolkit.canExportTenderProductCosts();
        if (canExportCosts) {
            this.showCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COSTS, TitledItem.TitledItemOrientation.EAST);
            this.addOptionsItem(new CheckBoxAnalysisItem(this.showCosts, "costs"));
        }
        if (canExportTender) {
            this.useVariantType = new TitledItem<ComboBox>(ComboBoxFactory.getProductTenderType(false), Words.VARIANTS, TitledItem.TitledItemOrientation.NORTH);
            this.addOptionsItem(new ComboBoxAnalysisItem(this.useVariantType, "variantType"));
        }
        this.includeProductFactSheets = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_FACT_SHEETS, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeProductFactSheets, "factSheets"));
        this.resolveRecipesToArticles = new TitledItem<CheckBox>(new CheckBox(), Words.RESOLVE_RECIPES_AS_ARTICLE, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.resolveRecipesToArticles, "articlesForRecipes"));
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(), Words.FACT_SHEETS_DUE_DATE, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public String getTitleString() {
        return Words.MEAL_PLAN;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        if (item.getId() != null) {
            return new FlightReference(item.getId());
        }
        return item;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List s = this.loadItemReferences();
        boolean includeFactSheets = this.includeProductFactSheets.getElement().isChecked();
        boolean resolveRecipesToArticle = this.resolveRecipesToArticles.getElement().isChecked();
        Date date = (Date)this.validityDate.getElement().getNode().getValue();
        Timestamp validity = new Timestamp(date.getTime());
        boolean sc = this.showCosts != null ? this.showCosts.getElement().isChecked() : false;
        Boolean showProductive = true;
        if (this.useVariantType != null) {
            showProductive = Words.ALL.equals(this.useVariantType.getElement().getSelectedItem()) ? null : (Words.PRODUCTIVE.equals(this.useVariantType.getElement().getSelectedItem()) ? Boolean.valueOf(true) : (Words.TENDER.equals(this.useVariantType.getElement().getSelectedItem()) ? Boolean.valueOf(false) : null));
        }
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).getFlightMealPlanReport(new ListWrapper(s), sc, showProductive, includeFactSheets, resolveRecipesToArticle, new TimestampWrapper(validity)).getValue();
        return file;
    }
}

