/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.picknpay.articlecost;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.modules.picknpay.PickNPayModule;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.PickNPayServiceManager;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.dataexchange.picknpay.PickNPayTransferComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.picknpay.PickNPayTransferReference;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import javax.swing.SwingUtilities;

public class CheckArticleCostPickNPayDataComponent
extends DefaultServerSideAnalysisComponent<PickNPayTransferComplete, PickNPayTransferReference> {
    private static final long serialVersionUID = 1L;

    public CheckArticleCostPickNPayDataComponent(AnalysisSmartExternalOpenTool<PickNPayTransferComplete> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
    }

    @Override
    public String getTitleString() {
        return Words.CHECK_FOR_UPDATES;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.setPreviewButtonText("Continue");
        ip.hideOkButton();
    }

    @Override
    public String getTitleText() {
        return "Press Continue to validate Article Cost Data by Pick n Pay";
    }

    @Override
    public boolean useSearch() {
        return false;
    }

    @Override
    public void errorOccurred(ClientException exception) {
        super.errorOccurred(exception);
        this.popup.enableCancelButton(true);
    }

    @Override
    public PickNPayTransferReference createReference(PickNPayTransferComplete item) {
        if (item.getId() != null) {
            return new PickNPayTransferReference(item.getId());
        }
        return null;
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        Boolean changes = ((PickNPayServiceManager)ServiceManagerRegistry.getService(PickNPayServiceManager.class)).checkForArticleCostUpdate();
        String t = Boolean.TRUE.equals(changes) ? "Found Changes, see Pick n Pay List" : "No changes found";
        SwingUtilities.invokeLater(() -> InnerPopupFactory.showOkMessage(this.getTitleString(), t, null, this, 350, 150));
        PickNPayModule view = (PickNPayModule)this.externalOpenTool.getMainFrame().getCurrenScreen().getView();
        view.reloadData();
        return null;
    }
}

