/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.productcatalog.productlist;

import ch.icit.pegasus.client.gui.submodules.analysis.productcatalog.productlist.AnalysisProductListReport;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductCatalogAccess;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AnalysisProductListComponent
extends DefaultServerSideAnalysisComponent<ProductCatalogLight, ProductCatalogReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<CheckBox> includeSalesPrice;
    private TitledItem<CheckBox> includeMatCostsC;
    private TitledItem<CheckBox> includeLaborC;
    private TitledItem<CheckBox> includeProductionC;
    private TitledItem<CheckBox> includeAdditional;
    private TitledItem<CheckBox> includeTaxesC;
    private TitledItem<ComboBox> includeTender;
    private TitledItem<CheckBox> includeDepartmentCheck;

    public AnalysisProductListComponent(AnalysisProductListReport productListAnalysis) {
        super(productListAnalysis);
    }

    @Override
    public void addOptionItems() {
        UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        ModuleAccessRightComplete r = HUDToolkit.getCurrentAccessRight(ProductCatalogAccess.MODULE_PRODUCT_CATALOG, user);
        boolean sp = false;
        boolean sm = false;
        boolean sl = false;
        boolean production = false;
        boolean taxes = false;
        boolean tender = false;
        for (DataFieldAccessRightComplete a : r.getFieldAccessRights()) {
            switch (a.getField().getName()) {
                case "showProductSales": {
                    sp = true;
                    break;
                }
                case "showProductMatCost": {
                    sm = true;
                    break;
                }
                case "showProductLaborCost": {
                    sl = true;
                    break;
                }
                case "printExternalCostFactSheet": {
                    tender = true;
                    break;
                }
                case "showProductProductionCost": {
                    production = true;
                    break;
                }
                case "showTaxesCosts": {
                    taxes = true;
                }
            }
        }
        Node n = new Node();
        n.setValue((Object)new Timestamp(System.currentTimeMillis()), 0L);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(n), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setIsTimestamp(true);
        this.addOptionsItem(new DateChooserAnalysisItem(this.dueDate, "dueDate"));
        if (sp) {
            this.includeSalesPrice = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SALE_PRICE, TitledItem.TitledItemOrientation.EAST);
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeSalesPrice, "sales"));
        }
        if (sm) {
            this.includeMatCostsC = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MAT_COSTS, TitledItem.TitledItemOrientation.EAST);
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeMatCostsC, "matCosts"));
        }
        if (sl) {
            this.includeLaborC = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_LABOR_COST, TitledItem.TitledItemOrientation.EAST);
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeLaborC, "laborCosts"));
        }
        if (production) {
            this.includeProductionC = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PRODUCTION_COST, TitledItem.TitledItemOrientation.EAST);
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeProductionC, "productionCosts"));
        }
        if (sp) {
            this.includeAdditional = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ADDITIONAL_COST, TitledItem.TitledItemOrientation.EAST);
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAdditional, "additionals"));
        }
        if (taxes) {
            this.includeTaxesC = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_TAXES, TitledItem.TitledItemOrientation.EAST);
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeTaxesC, "taxes"));
        }
        if (tender) {
            this.includeTender = new TitledItem<ComboBox>(new ComboBox(), Words.TENDER, TitledItem.TitledItemOrientation.NORTH);
            this.includeTender.getElement().addItem(Words.PRODUCTIVE);
            this.includeTender.getElement().addItem(Words.TENDER);
            this.addOptionsItem(new ComboBoxAnalysisItem(this.includeTender, "tender"));
        }
        this.includeDepartmentCheck = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_DEPARTMENT_CHECK, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeDepartmentCheck, "departmentCheck"));
    }

    @Override
    public ProductCatalogReference createReference(ProductCatalogLight item) {
        return new ProductCatalogReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        List references = this.loadItemReferences();
        Timestamp validity = null;
        Object data = this.dueDate.getElement().getNode().getValue();
        validity = data instanceof Timestamp ? (Timestamp)data : new Timestamp(((Date)data).getTime());
        ArrayList warnings = new ArrayList();
        boolean includeCosts = false;
        boolean includeLabor = false;
        boolean includeMat = false;
        boolean includeProduction = false;
        boolean includeAdditionalCost = false;
        boolean taxes = false;
        if (this.includeSalesPrice != null) {
            includeCosts = this.includeSalesPrice.getElement().isChecked();
        }
        if (this.includeMatCostsC != null) {
            includeMat = this.includeMatCostsC.getElement().isChecked();
        }
        if (this.includeLaborC != null) {
            includeLabor = this.includeLaborC.getElement().isChecked();
        }
        if (this.includeAdditional != null) {
            includeAdditionalCost = this.includeAdditional.getElement().isChecked();
        }
        if (this.includeProductionC != null) {
            includeProduction = this.includeProductionC.getElement().isChecked();
        }
        if (this.includeTaxesC != null) {
            taxes = this.includeTaxesC.getElement().isChecked();
        }
        Boolean showTender = false;
        if (this.includeTender == null) {
            showTender = false;
        } else if (this.includeTender.getElement().getSelectedItem().equals(Words.ALL)) {
            showTender = null;
        } else if (this.includeTender.getElement().getSelectedItem().equals(Words.TENDER)) {
            showTender = true;
        } else if (this.includeTender.getElement().getSelectedItem().equals(Words.PRODUCTIVE)) {
            showTender = false;
        }
        PegasusFileComplete file = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).createProductCatalogProductList(new ListWrapper(references), includeMat, includeLabor, includeProduction, includeAdditionalCost, includeCosts, taxes, showTender, this.includeDepartmentCheck.getElement().isChecked(), new TimestampWrapper(validity), new ListWrapper(warnings)).getValue();
        if (!warnings.isEmpty()) {
            ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
            for (String m : warnings) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, m));
            }
            InnerPopupFactory.showErrorDialog(o, Words.UNABLE_TO_CALCULATE_PRODUCTS, (Component)this);
        }
        return file;
    }
}

