/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.purchaseorder.correction;

import ch.icit.pegasus.client.converter.ChargeTransactionConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.PurchaseOrderConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TableRowLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class AnalysisOrderCorrectionsComponent
extends DefaultScrollablePrintPopup2<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField2<ArticleChargeLight>> chargeSearch;
    private TitledItem<TextLabel> creationDateInfo;
    private TitledItem<TextLabel> purchaseInfo;
    private TitledItem<TextLabel> quantity;
    private Table2 batchesTable;
    private Table2 transactionTable;
    private BasicArticleComplete bac;
    private StoreQuantityComplete originQuantity;
    private ArticleChargeComplete chargeComplete;
    private Node<List<StockTransactionComplete>> transactionNode;
    private PurchaseOrderLight purchaseOrder;

    public AnalysisOrderCorrectionsComponent() {
        super(false, false, false, false, ReportTypeE.PURCHASE_ORDER);
    }

    @Override
    public void insertElements() {
        this.createComponents();
        this.chargeSearch = new TitledItem<SearchTextField2<ArticleChargeLight>>(SearchTextField2Factory.getArticleChargeSearchField(true, new DTOProxyNode()), "Charge to correct", TitledItem.TitledItemOrientation.NORTH);
        this.creationDateInfo = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(DateTimeConverter.class)), "Creation Date", TitledItem.TitledItemOrientation.NORTH);
        this.purchaseInfo = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(PurchaseOrderConverter.class)), "Purchase Order", TitledItem.TitledItemOrientation.NORTH);
        this.quantity = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(QuantityConverter2Decimal.class)), "Total Quantity", TitledItem.TitledItemOrientation.NORTH);
        this.batchesTable = this.createBatchTable();
        this.transactionTable = this.createTransactionTable();
        this.chargeSearch.getElement().addSearchTextFieldListener(new SearchTextField2Listener(){

            @Override
            public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
                ArticleChargeLight charge = (ArticleChargeLight)n.getValue(ArticleChargeLight.class);
                AnalysisOrderCorrectionsComponent.this.newChargeSelected(charge);
            }
        });
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.chargeSearch);
        this.getViewContainer().add(this.creationDateInfo);
        this.getViewContainer().add(this.purchaseInfo);
        this.getViewContainer().add(this.quantity);
        this.getViewContainer().add(this.batchesTable);
        this.getViewContainer().add(this.transactionTable);
    }

    private void newChargeSelected(final ArticleChargeLight charge) {
        if (charge == null) {
            this.creationDateInfo.getElement().setNode((Node)null);
            this.purchaseInfo.getElement().setNode((Node)null);
            this.quantity.getElement().setNode((Node)null);
            this.batchesTable.getModel().setNode((Node)new ViewNode(""));
            this.transactionTable.getModel().setNode((Node)new ViewNode(""));
        } else {
            this.setEnabled(false);
            this.ensureAnimation("Load Charge data");
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    AnalysisOrderCorrectionsComponent.this.chargeComplete = (ArticleChargeComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getArticleChargeWithAllBatches(new ArticleChargeReference(charge.getId())).getValue();
                    ((SearchTextField2)AnalysisOrderCorrectionsComponent.this.chargeSearch.getElement()).getNode().removeExistingValues();
                    ((SearchTextField2)AnalysisOrderCorrectionsComponent.this.chargeSearch.getElement()).getNode().setValue((Object)AnalysisOrderCorrectionsComponent.this.chargeComplete, 0L);
                    AnalysisOrderCorrectionsComponent.this.originQuantity = AnalysisOrderCorrectionsComponent.this.chargeComplete.getQuantity();
                    AnalysisOrderCorrectionsComponent.this.bac = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(AnalysisOrderCorrectionsComponent.this.chargeComplete.getBasicArticle().getId())).getValue();
                    StockTransactionSearchConfiguration config = new StockTransactionSearchConfiguration();
                    config.setCharge(new ArticleChargeReference(AnalysisOrderCorrectionsComponent.this.chargeComplete.getId()));
                    PurchaseOrderComplete referencedOrder = null;
                    ArrayList<StockTransactionComplete> transactions = new ArrayList<StockTransactionComplete>();
                    SearchResultIterator result = new SearchResultIterator((ASearchConfiguration)config);
                    while (result.hasNext()) {
                        StockTransactionComplete next = (StockTransactionComplete)result.next();
                        if (next instanceof PurchaseOrderAcceptationComplete) {
                            PurchaseOrderAcceptationComplete acceptation = (PurchaseOrderAcceptationComplete)next;
                            if (acceptation.getOrderPosition() == null && acceptation.getOrderPositionID() != null) {
                                PurchaseOrderPositionComplete position = (PurchaseOrderPositionComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrderPosition(acceptation.getOrderPositionID()).getValue();
                                acceptation.setOrderPosition((PurchaseOrderPositionLight)position);
                            }
                            if (acceptation.getOrderPosition().getOrder() == null && acceptation.getOrderPosition().getOrderId() != null) {
                                PurchaseOrderComplete order = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrder(new PurchaseOrderReference(acceptation.getOrderPosition().getOrderId())).getValue();
                                acceptation.getOrderPosition().setOrder(order);
                            }
                            referencedOrder = ((PurchaseOrderAcceptationComplete)next).getOrderPosition().getOrder();
                        }
                        transactions.add(next);
                    }
                    AnalysisOrderCorrectionsComponent.this.purchaseOrder = referencedOrder;
                    AnalysisOrderCorrectionsComponent.this.transactionNode = INodeCreator.getDefaultImpl().createNodes(transactions, false);
                    return new Node();
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (AnalysisOrderCorrectionsComponent.this.purchaseOrder == null) {
                                InnerPopupFactory.showErrorDialog("No Purchase Order for Charge found", (Component)AnalysisOrderCorrectionsComponent.this);
                            } else {
                                ((TextLabel)AnalysisOrderCorrectionsComponent.this.creationDateInfo.getElement()).setNode(((SearchTextField2)AnalysisOrderCorrectionsComponent.this.chargeSearch.getElement()).getNode().getChildNamed(ArticleChargeLight_.creationDate));
                                ((TextLabel)AnalysisOrderCorrectionsComponent.this.quantity.getElement()).setNode(((SearchTextField2)AnalysisOrderCorrectionsComponent.this.chargeSearch.getElement()).getNode().getChildNamed(ArticleChargeComplete_.quantity));
                                ((TextLabel)AnalysisOrderCorrectionsComponent.this.purchaseInfo.getElement()).setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)AnalysisOrderCorrectionsComponent.this.purchaseOrder, false, true));
                                AnalysisOrderCorrectionsComponent.this.batchesTable.getModel().setNode(((SearchTextField2)AnalysisOrderCorrectionsComponent.this.chargeSearch.getElement()).getNode().getChildNamed(ArticleChargeComplete_.batches));
                                AnalysisOrderCorrectionsComponent.this.transactionTable.getModel().setNode(AnalysisOrderCorrectionsComponent.this.transactionNode);
                            }
                            AnalysisOrderCorrectionsComponent.this.removeAnimation(false);
                            AnalysisOrderCorrectionsComponent.this.setEnabled(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)AnalysisOrderCorrectionsComponent.this);
                            AnalysisOrderCorrectionsComponent.this.removeAnimation(false);
                            AnalysisOrderCorrectionsComponent.this.setEnabled(true);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    private Table2 createTransactionTable() {
        Table2 table = new Table2(false, "", true, true);
        table.setTitleText(Words.TRANSACTIONS);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.QUANTITY, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.33);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.33);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.34);
        table.setModel(new Table2Model(columns, model -> new TransactionTableRowImpl(model)));
        return table;
    }

    private Table2 createBatchTable() {
        Table2 table = new Table2(false, "", true, true);
        table.setTitleText(Words.BATCHES);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.STORE_POSITION, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.QUANTITY, null, null, null, "", 30, 30, 30));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        table.setModel(new Table2Model(columns, model -> new BatchTableRowImpl(model)));
        return table;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public boolean isReportAllowed(ReportFileComplete reportFile) {
        if (reportFile.getFileName().contains("CACP")) {
            return false;
        }
        if (reportFile.getFileName().contains("HACCP")) {
            return false;
        }
        return super.isReportAllowed(reportFile);
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.chargeSearch.setVisible(true);
        this.creationDateInfo.setVisible(true);
        this.purchaseInfo.setVisible(true);
        this.quantity.setVisible(true);
        this.batchesTable.setVisible(true);
        this.transactionTable.setVisible(true);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.chargeSearch.setVisible(false);
        this.creationDateInfo.setVisible(false);
        this.purchaseInfo.setVisible(false);
        this.quantity.setVisible(false);
        this.batchesTable.setVisible(false);
        this.transactionTable.setVisible(false);
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<ArticleChargeBatchComplete> batchesToFix = new ArrayList<ArticleChargeBatchComplete>();
                ArrayList<StockTransactionComplete> transactionsToFix = new ArrayList<StockTransactionComplete>();
                for (Table2RowPanel row : AnalysisOrderCorrectionsComponent.this.transactionTable.getRows()) {
                    row.getModel().getNode().commit(StockTransactionComplete.class);
                    StockTransactionComplete transaction = (StockTransactionComplete)row.getModel().getNode().getValue(StockTransactionComplete.class);
                    transactionsToFix.add(transaction);
                }
                for (Table2RowPanel row : AnalysisOrderCorrectionsComponent.this.batchesTable.getRows()) {
                    row.getModel().getNode().commit(ArticleChargeBatchComplete.class);
                    ArticleChargeBatchComplete batch = (ArticleChargeBatchComplete)row.getModel().getNode().getValue(ArticleChargeBatchComplete.class);
                    batchesToFix.add(batch);
                }
                ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).fixPurchase(new ArticleChargeReference(AnalysisOrderCorrectionsComponent.this.chargeComplete.getId()), new ListWrapper(batchesToFix), new ListWrapper(transactionsToFix));
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return AnalysisOrderCorrectionsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        if (this.chargeComplete == null) {
            return ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Charge selected")});
        }
        return super.validateBeforePrint();
    }

    @Override
    public Node<PurchaseOrderLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<PurchaseOrderLight> createBatchJob(Node<PurchaseOrderLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public String getTitleString() {
        return Words.ORDER_POSITIONS;
    }

    @Override
    public String getTitleValue() {
        return Words.OPEN_POSITIONS;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.chargeSearch);
        CheckedListAdder.addToList(focusList, this.batchesTable);
        CheckedListAdder.addToList(focusList, this.transactionTable);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.chargeSearch != null) {
            this.chargeSearch.kill();
        }
        this.chargeSearch = null;
        if (this.creationDateInfo != null) {
            this.creationDateInfo.kill();
        }
        this.creationDateInfo = null;
        if (this.purchaseInfo != null) {
            this.purchaseInfo.kill();
        }
        this.purchaseInfo = null;
        if (this.quantity != null) {
            this.quantity.kill();
        }
        this.quantity = null;
        if (this.batchesTable != null) {
            this.batchesTable.kill();
        }
        this.batchesTable = null;
        if (this.transactionTable != null) {
            this.transactionTable.kill();
        }
        this.transactionTable = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    private class TransactionTableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel date;
        private TextLabel type;
        private InputComboBox2 quantity;

        public TransactionTableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.date = new TextLabel(m.getNode().getChildNamed(StockTransactionComplete_.date), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.type = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ChargeTransactionConverter.class));
            this.quantity = new InputComboBox2(m.getNode().getChildNamed(new DtoField[]{StockTransactionComplete_.amount, StoreQuantityComplete_.amount}), m.getNode().getChildNamed(new DtoField[]{StockTransactionComplete_.amount, StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
            StockTransactionComplete transaction = (StockTransactionComplete)m.getNode().getValue(StockTransactionComplete.class);
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            List units = StoreToolkit.getPossibleUnits((BasicArticleLight)AnalysisOrderCorrectionsComponent.this.bac, null, (Timestamp)transaction.getDate(), (TransactionType)TransactionType.PURCHASE, (UserComplete)currentUser, null, null, (SystemSettingsComplete)settings);
            ViewNode un = new ViewNode("");
            for (UnitComplete u : units) {
                un.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)u, false, true), 0L);
            }
            this.quantity.setPossibleUnits((Node)un);
            this.add(this.date);
            this.add(this.type);
            this.add(this.quantity);
        }

        @Override
        public Object getObject4Column(int column) {
            return this.date.getText();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.date.setEnabled(isEnabled);
            this.type.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.date.kill();
            this.date = null;
            this.type.kill();
            this.type = null;
            this.quantity.kill();
            this.quantity = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return new ArrayList<Component>();
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TransactionTableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TransactionTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TransactionTableRowImpl.this.date.setLocation(TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TransactionTableRowImpl.this.date.setSize(w, (int)TransactionTableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TransactionTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TransactionTableRowImpl.this.type.setLocation(currentX + TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TransactionTableRowImpl.this.type.setSize(w - 2 * TransactionTableRowImpl.this.getCellPadding(), (int)TransactionTableRowImpl.this.type.getPreferredSize().getHeight());
                currentX += w;
                w = TransactionTableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TransactionTableRowImpl.this.quantity.setLocation(currentX + TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TransactionTableRowImpl.this.quantity.setSize(w - 2 * TransactionTableRowImpl.this.getCellPadding(), (int)TransactionTableRowImpl.this.quantity.getPreferredSize().getHeight());
            }
        }
    }

    private class BatchTableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel position;
        private InputComboBox2 quantity;

        public BatchTableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.position = m.getNode().getChildNamed(ArticleChargeBatchComplete_.position).getValue() != null ? new TextLabel(m.getNode().getChildNamed(ArticleChargeBatchComplete_.position), ConverterRegistry.getConverter(StorePositionShortNameConverter.class)) : new TextLabel(m.getNode().getChildNamed(ArticleChargeBatchComplete_.storeName));
            this.quantity = new InputComboBox2(m.getNode().getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.quantity, StoreQuantityComplete_.amount}), m.getNode().getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.quantity, StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
            ArticleChargeBatchComplete transaction = (ArticleChargeBatchComplete)m.getNode().getValue(ArticleChargeBatchComplete.class);
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            List units = StoreToolkit.getPossibleUnits((BasicArticleLight)AnalysisOrderCorrectionsComponent.this.bac, null, (Timestamp)transaction.getCharge().getCreationDate(), (TransactionType)TransactionType.PURCHASE, (UserComplete)currentUser, null, null, (SystemSettingsComplete)settings);
            ViewNode un = new ViewNode("");
            for (UnitComplete u : units) {
                un.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)u, false, true), 0L);
            }
            this.quantity.setPossibleUnits((Node)un);
            this.add(this.position);
            this.add(this.quantity);
        }

        @Override
        public void updateRow(Node<?> node) {
            this.position.updateString();
        }

        @Override
        public Object getObject4Column(int column) {
            return this.position.getText();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.position.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.position.kill();
            this.position = null;
            this.quantity.kill();
            this.quantity = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return new ArrayList<Component>();
        }

        private class InnerLayout
        extends TableRowLayout {
            private InnerLayout() {
            }

            @Override
            public List<JComponent> getComponentsOrder() {
                ArrayList<JComponent> list = new ArrayList<JComponent>();
                list.add(BatchTableRowImpl.this.position);
                list.add(BatchTableRowImpl.this.quantity);
                return list;
            }

            @Override
            public Table2RowPanel getTableRowPanel() {
                return BatchTableRowImpl.this;
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = AnalysisOrderCorrectionsComponent.this.getInheritedComponentsHeight();
            h += AnalysisOrderCorrectionsComponent.this.border;
            h = (int)((double)h + AnalysisOrderCorrectionsComponent.this.creationDateInfo.getPreferredSize().getHeight());
            h += AnalysisOrderCorrectionsComponent.this.border;
            h = (int)((double)h + AnalysisOrderCorrectionsComponent.this.purchaseInfo.getPreferredSize().getHeight());
            h += AnalysisOrderCorrectionsComponent.this.border;
            h = (int)((double)h + AnalysisOrderCorrectionsComponent.this.quantity.getPreferredSize().getHeight());
            h += AnalysisOrderCorrectionsComponent.this.border;
            h += 200;
            h += AnalysisOrderCorrectionsComponent.this.border;
            h += 200;
            return new Dimension(0, h += AnalysisOrderCorrectionsComponent.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = AnalysisOrderCorrectionsComponent.this.layoutInheritedComponents(parent);
            int w2tl = (parent.getWidth() - 3 * AnalysisOrderCorrectionsComponent.this.border) / 2;
            AnalysisOrderCorrectionsComponent.this.chargeSearch.setLocation(AnalysisOrderCorrectionsComponent.this.border, y += AnalysisOrderCorrectionsComponent.this.border);
            AnalysisOrderCorrectionsComponent.this.chargeSearch.setSize(w2tl, (int)AnalysisOrderCorrectionsComponent.this.chargeSearch.getPreferredSize().getHeight());
            AnalysisOrderCorrectionsComponent.this.creationDateInfo.setLocation(2 * AnalysisOrderCorrectionsComponent.this.border + w2tl, y);
            AnalysisOrderCorrectionsComponent.this.creationDateInfo.setSize(w2tl, (int)AnalysisOrderCorrectionsComponent.this.creationDateInfo.getPreferredSize().getHeight());
            AnalysisOrderCorrectionsComponent.this.purchaseInfo.setLocation(2 * AnalysisOrderCorrectionsComponent.this.border + w2tl, AnalysisOrderCorrectionsComponent.this.creationDateInfo.getY() + AnalysisOrderCorrectionsComponent.this.creationDateInfo.getHeight() + AnalysisOrderCorrectionsComponent.this.border);
            AnalysisOrderCorrectionsComponent.this.purchaseInfo.setSize(w2tl, (int)AnalysisOrderCorrectionsComponent.this.purchaseInfo.getPreferredSize().getHeight());
            AnalysisOrderCorrectionsComponent.this.quantity.setLocation(2 * AnalysisOrderCorrectionsComponent.this.border + w2tl, AnalysisOrderCorrectionsComponent.this.purchaseInfo.getY() + AnalysisOrderCorrectionsComponent.this.purchaseInfo.getHeight() + AnalysisOrderCorrectionsComponent.this.border);
            AnalysisOrderCorrectionsComponent.this.quantity.setSize(w2tl, (int)AnalysisOrderCorrectionsComponent.this.quantity.getPreferredSize().getHeight());
            AnalysisOrderCorrectionsComponent.this.batchesTable.setLocation(0, AnalysisOrderCorrectionsComponent.this.quantity.getY() + AnalysisOrderCorrectionsComponent.this.quantity.getHeight() + AnalysisOrderCorrectionsComponent.this.border);
            AnalysisOrderCorrectionsComponent.this.batchesTable.setSize(parent.getWidth(), 200);
            AnalysisOrderCorrectionsComponent.this.transactionTable.setLocation(0, AnalysisOrderCorrectionsComponent.this.batchesTable.getY() + AnalysisOrderCorrectionsComponent.this.batchesTable.getHeight() + AnalysisOrderCorrectionsComponent.this.border);
            AnalysisOrderCorrectionsComponent.this.transactionTable.setSize(parent.getWidth(), 200);
        }
    }
}

