/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.recipe.ean;

import ch.icit.pegasus.client.gui.submodules.analysis.recipe.ean.AnalysisRecipeEanSheetReport;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.RecipeReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.report.RecipeFactsheetConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

public class AnalysisRecipeEanSheetComponent
extends DefaultServerSideAnalysisComponent<RecipeComplete, RecipeReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> dueDate;

    public AnalysisRecipeEanSheetComponent(AnalysisRecipeEanSheetReport productListAnalysis) {
        super(productListAnalysis);
    }

    @Override
    public void addOptionItems() {
        Node n = new Node();
        n.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(n), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.dueDate, "dueDate"));
    }

    @Override
    public String getFileEnding() {
        return ".pdf";
    }

    @Override
    public RecipeReference createReference(RecipeComplete item) {
        return new RecipeReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        List references = this.loadItemReferences();
        RecipeFactsheetConfigurationComplete configuration = new RecipeFactsheetConfigurationComplete();
        Timestamp d = null;
        if (this.dueDate.getElement().getNode().getValue() instanceof Date) {
            d = new Timestamp(((Date)this.dueDate.getElement().getNode().getValue()).getTime());
        } else if (this.dueDate.getElement().getNode().getValue() instanceof Timestamp) {
            d = (Timestamp)this.dueDate.getElement().getNode().getValue();
        }
        configuration.setDueDate(d);
        PegasusFileComplete file = (PegasusFileComplete)((RecipeReportServiceManager)ServiceManagerRegistry.getService(RecipeReportServiceManager.class)).getRecipeEANSheet(new ListWrapper(references), configuration).getValue();
        return file;
    }
}

