/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.export.flightschedule;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.report.FlightScheduleReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;

public class ExportFlightScheduleComponent
extends DefaultScrollablePrintPopup2<FlightScheduleLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final Node<FlightScheduleLight> currentflightSchedule;
    protected TextLabel printOptionTitle;
    private TitledItem<DateChooser> dueDate;

    public ExportFlightScheduleComponent(Node<FlightScheduleLight> node) {
        super(false, false, false, false, ReportTypeE.PRODUCT);
        this.currentflightSchedule = node;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.printOptionTitle = new TextLabel(Words.OPTIONS);
        this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false));
        this.getViewContainer().add(this.printOptionTitle);
        this.getViewContainer().add(this.dueDate);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.printOptionTitle.setEnabled(isEnabled);
        this.dueDate.setEnabled(isEnabled);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean bl = Boolean.valueOf(v);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.MEALPLAN;
    }

    @Override
    public String getTitleValue() {
        return ((Integer)this.currentflightSchedule.getChildNamed(FlightScheduleLight_.number).getValue()).toString();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        this.printOptionTitle = null;
        this.dueDate = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.dueDate != null) {
            this.dueDate.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightScheduleReportConfiguration conf = new FlightScheduleReportConfiguration();
                conf.setDueDate(new Timestamp(((Date)((DateChooser)ExportFlightScheduleComponent.this.dueDate.getElement()).getNode().getValue()).getTime()));
                conf.setFlightScheduleNumber(((FlightScheduleLight)ExportFlightScheduleComponent.this.currentflightSchedule.getValue()).getNumber());
                conf.setReportFormatType(ReportingOutputFormatE.XLSX);
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).exportFlightScheduleSpecification((FlightScheduleReference)ExportFlightScheduleComponent.this.currentflightSchedule.getValue(), conf).getValue();
                ExportFlightScheduleComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportFlightScheduleComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightScheduleLight> getCurrentNode() {
        return this.currentflightSchedule;
    }

    @Override
    public BatchJob<FlightScheduleLight> createBatchJob(Node<FlightScheduleLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportFlightScheduleComponent.this.layoutInheritedComponents(parent);
            if (ExportFlightScheduleComponent.this.printOptionTitle != null) {
                ExportFlightScheduleComponent.this.printOptionTitle.setLocation(ExportFlightScheduleComponent.this.border, y + ExportFlightScheduleComponent.this.border);
                ExportFlightScheduleComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * ExportFlightScheduleComponent.this.border, (int)ExportFlightScheduleComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = ExportFlightScheduleComponent.this.printOptionTitle.getY() + ExportFlightScheduleComponent.this.printOptionTitle.getHeight() + ExportFlightScheduleComponent.this.border;
            }
            if (ExportFlightScheduleComponent.this.dueDate != null) {
                ExportFlightScheduleComponent.this.dueDate.setLocation(ExportFlightScheduleComponent.this.border, y + ExportFlightScheduleComponent.this.border);
                ExportFlightScheduleComponent.this.dueDate.setSize((int)ExportFlightScheduleComponent.this.dueDate.getPreferredSize().getWidth(), (int)ExportFlightScheduleComponent.this.dueDate.getPreferredSize().getHeight());
                y = ExportFlightScheduleComponent.this.dueDate.getY() + ExportFlightScheduleComponent.this.dueDate.getHeight() + ExportFlightScheduleComponent.this.border;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportFlightScheduleComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += ExportFlightScheduleComponent.this.border;
            if (ExportFlightScheduleComponent.this.printOptionTitle != null) {
                h = (int)((double)h + ExportFlightScheduleComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += ExportFlightScheduleComponent.this.border;
            }
            if (ExportFlightScheduleComponent.this.dueDate != null) {
                h = (int)((double)h + ExportFlightScheduleComponent.this.dueDate.getPreferredSize().getHeight());
                h += ExportFlightScheduleComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

