/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.popup.content;

import ch.icit.pegasus.client.gui.submodules.popup.SubModulePopupContent;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class OutputFormatContent
extends SubModulePopupContent {
    private TextLabel printFormatTitle = new TextLabel(this.getFormatText());
    private RadioButtonBox exportFormatSelectionBox = new RadioButtonBox();
    protected TitledItem<RadioButton> pdfRadioButton;
    protected TitledItem<RadioButton> excelRadioButton;

    public OutputFormatContent() {
        this(true, true);
    }

    public OutputFormatContent(boolean withPDF, boolean withXLS) {
        if (withPDF) {
            this.pdfRadioButton = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_AS_PDF, TitledItem.TitledItemOrientation.EAST);
            this.exportFormatSelectionBox.addBox(this.pdfRadioButton, this.pdfRadioButton.getElement());
            this.pdfRadioButton.getElement().setChecked(true);
        }
        if (withXLS) {
            this.excelRadioButton = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_AS_EXCEL, TitledItem.TitledItemOrientation.EAST);
            this.exportFormatSelectionBox.addBox(this.excelRadioButton, this.excelRadioButton.getElement());
            this.excelRadioButton.getElement().setChecked(!withPDF);
        }
        this.setLayout(new Layout());
        this.add(this.printFormatTitle);
        this.add(this.exportFormatSelectionBox);
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.exportFormatSelectionBox.getFocusComponents();
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.exportFormatSelectionBox.requestFocusInWindow();
    }

    public String getFormatText() {
        return "SELECT FORMAT TO EXPORT";
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)OutputFormatContent.this.printFormatTitle.getPreferredSize().getHeight();
            h += OutputFormatContent.this.border;
            h = (int)((double)h + OutputFormatContent.this.exportFormatSelectionBox.getPreferredSize().getHeight());
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            OutputFormatContent.this.printFormatTitle.setLocation(0, 0);
            OutputFormatContent.this.printFormatTitle.setSize(parent.getWidth(), (int)OutputFormatContent.this.printFormatTitle.getPreferredSize().getHeight());
            OutputFormatContent.this.exportFormatSelectionBox.setLocation(0, OutputFormatContent.this.printFormatTitle.getY() + OutputFormatContent.this.printFormatTitle.getHeight() + OutputFormatContent.this.border);
            OutputFormatContent.this.exportFormatSelectionBox.setSize(parent.getWidth(), (int)OutputFormatContent.this.exportFormatSelectionBox.getPreferredSize().getHeight());
        }
    }
}

