/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.article.factsheet;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;

public class PrintArticleFactComponent
extends DefaultScrollablePrintPopup2<BasicArticleLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node<BasicArticleLight> currentArticle;
    private TitledItem<DateChooser> dateChooser;

    public PrintArticleFactComponent(Node<BasicArticleLight> node) {
        super(false, false, ReportTypeE.ARTICLE_FACT_SHEET);
        this.currentArticle = node;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        Node dateNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.dateChooser = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dateChooser.getElement().setIsTimestamp(false);
        this.getViewContainer().add(this.dateChooser);
        this.createComponents();
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            if (!n.equals("dueDate")) continue;
            try {
                long l = Long.valueOf(v);
                this.dateChooser.getElement().getNode().setValue((Object)new Date(l), 0L);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("dueDate", "" + ((Date)this.dateChooser.getElement().getNode().getValue()).getTime());
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE;
    }

    @Override
    public String getTitleValue() {
        if (this.currentArticle.getChildNamed(BasicArticleLight_.number).getValue() == null) {
            return "-";
        }
        return "" + this.currentArticle.getChildNamed(BasicArticleLight_.number).getValue();
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.dateChooser.setVisible(false);
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.dateChooser.setVisible(true);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.dateChooser != null) {
            this.dateChooser.kill();
        }
        this.dateChooser = null;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintArticleFactComponent.this.getSelectedReport();
                Date dueDate = (Date)((DateChooser)PrintArticleFactComponent.this.dateChooser.getElement()).getNode().getValue();
                PegasusFileComplete t = (PegasusFileComplete)((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).getArticleFactSheet(new BasicArticleReference(((BasicArticleLight)PrintArticleFactComponent.this.currentArticle.getValue()).getId()), file, ReportingOutputFormatE.PDF, new DateWrapper(dueDate)).getValue();
                PrintArticleFactComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleFactComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<BasicArticleLight> getCurrentNode() {
        return this.currentArticle;
    }

    @Override
    public BatchJob<BasicArticleLight> createBatchJob(Node<BasicArticleLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintArticleFactComponent.this.layoutInheritedComponents(parent);
            if (PrintArticleFactComponent.this.dateChooser != null) {
                PrintArticleFactComponent.this.dateChooser.setLocation(PrintArticleFactComponent.this.border, y + PrintArticleFactComponent.this.border);
                PrintArticleFactComponent.this.dateChooser.setSize(PrintArticleFactComponent.this.dateChooser.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintArticleFactComponent.this.getInheritedComponentsHeight();
            h += PrintArticleFactComponent.this.border;
            if (PrintArticleFactComponent.this.animation != null) {
                h = (int)((double)h + PrintArticleFactComponent.this.animation.getPreferredSize().getHeight());
                return new Dimension((int)((double)(PrintArticleFactComponent.this.border * 2) + PrintArticleFactComponent.this.animation.getPreferredSize().getWidth()), h += PrintArticleFactComponent.this.border);
            }
            if (PrintArticleFactComponent.this.dateChooser != null) {
                h = (int)((double)h + PrintArticleFactComponent.this.dateChooser.getPreferredSize().getHeight());
                h += PrintArticleFactComponent.this.border;
            }
            return new Dimension(0, h);
        }
    }
}

