/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.requisition.changes;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderReference;
import ch.icit.pegasus.server.core.dtos.report.RequisitionOrderReportConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PrintRequisitionChangesComponent
extends DefaultScrollablePrintPopup2<RequisitionOrderLight> {
    private static final long serialVersionUID = 1L;
    private Node<RequisitionOrderLight> requisitionOrder;
    private RequisitionOrderComplete completeOrder;
    private Node allDepartments;
    private Node<RequisitionOrderReportConfiguration> configNode;
    private RowModel<RequisitionOrderLight> rowModel;
    private List<BasicArticleComplete> articles = new ArrayList<BasicArticleComplete>();

    public PrintRequisitionChangesComponent(Node<RequisitionOrderLight> node, RowModel<RequisitionOrderLight> rowModel) {
        super(false, false, ReportTypeE.REQUISITION_ORDER_CHANGES);
        this.requisitionOrder = node;
        this.rowModel = rowModel;
        RequisitionOrderReportConfiguration config = new RequisitionOrderReportConfiguration();
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
        this.loadBeforeShowing(() -> this.loadRequisitionData());
    }

    private void loadRequisitionData() {
        try {
            RequisitionOrderComplete requisition;
            HashSet<CostCenterComplete> usedCostCenters = new HashSet<CostCenterComplete>();
            ViewNode retNode = new ViewNode("");
            this.completeOrder = requisition = (RequisitionOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getRequisitionOrderByReference(new RequisitionOrderReference(((RequisitionOrderLight)this.requisitionOrder.getValue()).getId())).getValue();
            for (RequisitionOrderPositionComplete o : requisition.getOrderPositions()) {
                BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(o.getArticle().getId())).getValue();
                this.articles.add(artC);
                if (artC.getDefaultRequisitionDeliverDepartment() == null) continue;
                usedCostCenters.add(artC.getDefaultRequisitionDeliverDepartment());
            }
            for (CostCenterComplete cc : usedCostCenters) {
                Node nc = INodeCreator.getDefaultImpl().getNode4DTO((Object)cc, false, true);
                retNode.addChild(nc, 0L);
            }
            this.allDepartments = retNode;
        }
        catch (ClientServerCallException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean bl = Boolean.valueOf(v);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.ORDER_NO;
    }

    @Override
    public String getTitleValue() {
        return "" + this.requisitionOrder.getChildNamed(RequisitionOrderLight_.number).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        super.enterPressed(isOK);
        this.rowModel.getView().repaint(32L);
        this.rowModel.getView().revalidate();
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintRequisitionChangesComponent.this.getSelectedReport();
                PrintRequisitionChangesComponent.this.configNode.commit();
                RequisitionOrderReportConfiguration config = (RequisitionOrderReportConfiguration)PrintRequisitionChangesComponent.this.configNode.getValue();
                config.setStylesheet(file);
                config.setDto((IDTO)PrintRequisitionChangesComponent.this.requisitionOrder.getValue());
                PegasusFileComplete t = null;
                t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createRequisitionOrderChanges(config).getValue();
                PrintRequisitionChangesComponent.this.processFile(t);
                ViewNode ret = new ViewNode("batchReturn");
                ret.setValue((Object)true, 0L);
                PrintRequisitionChangesComponent.this.rowModel.getView().repaint(32L);
                PrintRequisitionChangesComponent.this.rowModel.getView().revalidate();
                return ret;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintRequisitionChangesComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<RequisitionOrderLight> getCurrentNode() {
        return this.requisitionOrder;
    }

    @Override
    public BatchJob<RequisitionOrderLight> createBatchJob(Node<RequisitionOrderLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintRequisitionChangesComponent.this.layoutInheritedComponents(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintRequisitionChangesComponent.this.getInheritedComponentsHeight();
            int w = 250;
            return new Dimension(w, h += PrintRequisitionChangesComponent.this.border);
        }
    }
}

