/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.shared.labels;

import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.impl.FlightPrintBatch;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.IFlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.report.StowingListReportConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public abstract class PrintLabelComponent<T extends IFlightReference>
extends DefaultScrollablePrintPopup2<T> {
    private static final long serialVersionUID = 1L;
    protected TextLabel printOptionTitle;
    protected TitledItem<CheckBox> includeRegularLabels;
    protected TitledItem<CheckBox> includeSPMLLabels;
    protected TitledItem<CheckBox> differentOnly;
    protected TitledItem<CheckBox> withContentOnly;
    protected TitledItem<ComboBox> department;
    protected TitledItem<ComboBox> colors;
    private static final String REGULAR_CONFIG_NAME = "regular";
    private static final String SPML_CONFIG_NAME = "spml";
    private static final String DIFF_ONLY_CONFIG_NAME = "diffOnly";
    private static final String WITH_CONTENT_ONLY = "withContentOnly";

    public PrintLabelComponent() {
        super(true, true, false, false, null);
        Runnable r = () -> {
            try {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        };
        this.loadBeforeShowing(r);
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.includeRegularLabels);
        CheckedListAdder.addToList(focusList, this.includeSPMLLabels);
        CheckedListAdder.addToList(focusList, this.differentOnly);
        CheckedListAdder.addToList(focusList, this.withContentOnly);
        CheckedListAdder.addToList(focusList, this.department);
        CheckedListAdder.addToList(focusList, this.colors);
        return focusList;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.printOptionTitle = new TextLabel(Words.OPTIONS);
        this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        this.department = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(CostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class), true, true), WordsToolkit.toCapitalLetter((String)Words.DEPARTMENT), TitledItem.TitledItemOrientation.NORTH);
        this.colors = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(ColorComplete.class), ConverterRegistry.getConverter(ColorConverter.class), true, true), WordsToolkit.toCapitalLetter((String)Words.LABEL_COLOR), TitledItem.TitledItemOrientation.NORTH);
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.department.getTitle().setForeground(fb);
        this.department.getTitle().setFont(f);
        this.colors.getTitle().setForeground(fb);
        this.colors.getTitle().setFont(f);
        this.includeRegularLabels = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_REGULAR_LABELS, TitledItem.TitledItemOrientation.EAST);
        this.includeRegularLabels.getTitle().setForeground(fb);
        this.includeRegularLabels.getTitle().setFont(f);
        this.includeRegularLabels.getElement().setChecked(true);
        this.includeSPMLLabels = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SPML_LABELS, TitledItem.TitledItemOrientation.EAST);
        this.includeSPMLLabels.getTitle().setForeground(fb);
        this.includeSPMLLabels.getTitle().setFont(f);
        this.differentOnly = new TitledItem<CheckBox>(new CheckBox(), Words.DIFFERENT_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.differentOnly.getTitle().setFont(f);
        this.differentOnly.getTitle().setForeground(fb);
        this.withContentOnly = new TitledItem<CheckBox>(new CheckBox(), Words.HIDE_EMPTY_LABELS, TitledItem.TitledItemOrientation.EAST);
        this.withContentOnly.getTitle().setFont(f);
        this.withContentOnly.getTitle().setForeground(fb);
        this.getViewContainer().add(this.printOptionTitle);
        this.getViewContainer().add(this.department);
        this.getViewContainer().add(this.colors);
        this.getViewContainer().add(this.includeRegularLabels);
        this.getViewContainer().add(this.includeSPMLLabels);
        this.getViewContainer().add(this.differentOnly);
        this.getViewContainer().add(this.withContentOnly);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "regular": {
                    this.includeRegularLabels.getElement().setChecked(b);
                    break;
                }
                case "spml": {
                    this.includeSPMLLabels.getElement().setChecked(b);
                    break;
                }
                case "diffOnly": {
                    this.differentOnly.getElement().setChecked(b);
                    break;
                }
                case "withContentOnly": {
                    this.withContentOnly.getElement().setChecked(b);
                }
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty(REGULAR_CONFIG_NAME, "" + this.includeRegularLabels.getElement().isChecked());
        conf.addProperty(SPML_CONFIG_NAME, "" + this.includeSPMLLabels.getElement().isChecked());
        conf.addProperty(DIFF_ONLY_CONFIG_NAME, "" + this.differentOnly.getElement().isChecked());
        conf.addProperty(WITH_CONTENT_ONLY, "" + this.withContentOnly.getElement().isChecked());
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.LABELS;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[2];
        o[1] = this.getCurrentNode();
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        Component currentC;
        boolean b = super.isInnerComponent(c);
        if (b) {
            return b;
        }
        if (this.department != null && this.department.getElement().getCurrentPopUp() != null) {
            for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.department.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        if (this.colors != null && this.colors.getElement().getCurrentPopUp() != null) {
            for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.colors.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.department != null) {
            this.department.kill();
        }
        if (this.colors != null) {
            this.colors.kill();
        }
        if (this.includeRegularLabels != null) {
            this.includeRegularLabels.kill();
        }
        if (this.includeSPMLLabels != null) {
            this.includeSPMLLabels.kill();
        }
        if (this.differentOnly != null) {
            this.differentOnly.kill();
        }
        if (this.withContentOnly != null) {
            this.withContentOnly.kill();
        }
        this.department = null;
        this.colors = null;
        this.printOptionTitle = null;
        this.includeRegularLabels = null;
        this.includeSPMLLabels = null;
        this.differentOnly = null;
        this.withContentOnly = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.printOptionTitle == null) {
            return;
        }
        this.printOptionTitle.setVisible(true);
        this.department.setVisible(true);
        this.colors.setVisible(true);
        this.includeRegularLabels.setVisible(true);
        this.includeSPMLLabels.setVisible(true);
        this.differentOnly.setVisible(true);
        this.withContentOnly.setVisible(true);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.printOptionTitle == null) {
            return;
        }
        this.printOptionTitle.setVisible(false);
        this.department.setVisible(false);
        this.colors.setVisible(false);
        this.includeRegularLabels.setVisible(false);
        this.includeSPMLLabels.setVisible(false);
        this.differentOnly.setVisible(false);
        this.withContentOnly.setVisible(false);
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> a;
        ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
        if (!this.includeRegularLabels.getElement().isChecked() && !this.includeSPMLLabels.getElement().isChecked()) {
            l.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.ENSURE_LABEL_TYPE));
        }
        if ((a = super.validateBeforePrint()) != null) {
            l.addAll(a);
        }
        return l;
    }

    public void getConfig(StowingListReportConfiguration config) {
        if (this.department.getElement().getSelectedItem() instanceof Node) {
            Node d = (Node)this.department.getElement().getSelectedItem();
            config.setDepartment((CostCenterComplete)d.getValue());
        } else {
            config.setDepartment(null);
        }
        if (this.colors.getElement().getSelectedItem() instanceof Node) {
            Node c = (Node)this.colors.getElement().getSelectedItem();
            config.setLabelColor((ColorComplete)c.getValue());
        } else {
            config.setLabelColor(null);
        }
        if (this.includeRegularLabels.getElement().isChecked()) {
            config.setRegularLabel(Boolean.valueOf(true));
        } else {
            config.setRegularLabel(Boolean.valueOf(false));
        }
        if (this.includeSPMLLabels.getElement().isChecked()) {
            config.setSpmlLabel(Boolean.valueOf(true));
        } else {
            config.setSpmlLabel(Boolean.valueOf(false));
        }
        if (this.differentOnly.getElement().isChecked()) {
            config.setDifferentOnly(Boolean.valueOf(true));
        } else {
            config.setDifferentOnly(Boolean.valueOf(false));
        }
        if (this.withContentOnly.getElement().isChecked()) {
            config.setLabelWithContents(Boolean.valueOf(true));
        } else {
            config.setLabelWithContents(Boolean.valueOf(false));
        }
    }

    @Override
    public BatchJob<T> createBatchJob(Node<T> value, ThreadSafeExecutable job) {
        return new FlightPrintBatch<T>(job, value, this.getPrintProcessor(), false);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintLabelComponent.this.layoutInheritedComponents(parent);
            if (PrintLabelComponent.this.printOptionTitle != null) {
                PrintLabelComponent.this.printOptionTitle.setLocation(PrintLabelComponent.this.border, y + PrintLabelComponent.this.border);
                PrintLabelComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * PrintLabelComponent.this.border, (int)PrintLabelComponent.this.printOptionTitle.getPreferredSize().getHeight());
                PrintLabelComponent.this.includeRegularLabels.setLocation(PrintLabelComponent.this.border, PrintLabelComponent.this.printOptionTitle.getY() + PrintLabelComponent.this.printOptionTitle.getHeight() + PrintLabelComponent.this.border / 2);
                PrintLabelComponent.this.includeRegularLabels.setSize(parent.getWidth() - 2 * PrintLabelComponent.this.border, (int)PrintLabelComponent.this.includeRegularLabels.getPreferredSize().getHeight());
                PrintLabelComponent.this.includeSPMLLabels.setLocation(PrintLabelComponent.this.border, PrintLabelComponent.this.includeRegularLabels.getY() + PrintLabelComponent.this.includeRegularLabels.getHeight() + PrintLabelComponent.this.border / 2);
                PrintLabelComponent.this.includeSPMLLabels.setSize(parent.getWidth() - 2 * PrintLabelComponent.this.border, (int)PrintLabelComponent.this.includeSPMLLabels.getPreferredSize().getHeight());
                PrintLabelComponent.this.differentOnly.setLocation(PrintLabelComponent.this.border, PrintLabelComponent.this.includeSPMLLabels.getY() + PrintLabelComponent.this.includeSPMLLabels.getHeight() + PrintLabelComponent.this.border / 2);
                PrintLabelComponent.this.differentOnly.setSize(parent.getWidth() - 2 * PrintLabelComponent.this.differentOnly.getX(), (int)PrintLabelComponent.this.differentOnly.getPreferredSize().getHeight());
                PrintLabelComponent.this.withContentOnly.setLocation(PrintLabelComponent.this.border, PrintLabelComponent.this.differentOnly.getY() + PrintLabelComponent.this.differentOnly.getHeight() + PrintLabelComponent.this.border / 2);
                PrintLabelComponent.this.withContentOnly.setSize(parent.getWidth() - 2 * PrintLabelComponent.this.withContentOnly.getX(), (int)PrintLabelComponent.this.withContentOnly.getPreferredSize().getHeight());
                PrintLabelComponent.this.department.setLocation(PrintLabelComponent.this.border, PrintLabelComponent.this.withContentOnly.getY() + PrintLabelComponent.this.withContentOnly.getHeight() + PrintLabelComponent.this.border);
                PrintLabelComponent.this.department.setSize(parent.getWidth() - 2 * PrintLabelComponent.this.border, (int)PrintLabelComponent.this.department.getPreferredSize().getHeight());
                PrintLabelComponent.this.colors.setLocation(PrintLabelComponent.this.border, PrintLabelComponent.this.department.getY() + PrintLabelComponent.this.department.getHeight() + PrintLabelComponent.this.border / 2);
                PrintLabelComponent.this.colors.setSize(parent.getWidth() - 2 * PrintLabelComponent.this.border, (int)PrintLabelComponent.this.colors.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintLabelComponent.this.getInheritedComponentsHeight();
            if (PrintLabelComponent.this.printOptionTitle != null) {
                h += PrintLabelComponent.this.border;
                h = (int)((double)h + PrintLabelComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += PrintLabelComponent.this.border / 2;
                h = (int)((double)h + PrintLabelComponent.this.includeRegularLabels.getPreferredSize().getHeight());
                h += PrintLabelComponent.this.border / 2;
                h = (int)((double)h + PrintLabelComponent.this.includeSPMLLabels.getPreferredSize().getHeight());
                h += PrintLabelComponent.this.border / 2;
                h = (int)((double)h + PrintLabelComponent.this.differentOnly.getPreferredSize().getHeight());
                h += PrintLabelComponent.this.border / 2;
                h = (int)((double)h + PrintLabelComponent.this.withContentOnly.getPreferredSize().getHeight());
                h += PrintLabelComponent.this.border;
                h = (int)((double)h + PrintLabelComponent.this.department.getPreferredSize().getHeight());
                h += PrintLabelComponent.this.border / 2;
                h = (int)((double)h + PrintLabelComponent.this.colors.getPreferredSize().getHeight());
                h += PrintLabelComponent.this.border;
            }
            return new Dimension(2 * PrintLabelComponent.this.border, h);
        }
    }
}

