/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.store.inventory;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.StockReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.StockReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;

public class PrintInventoryWorksheetComponent
extends DefaultScrollablePrintPopup2<StoreLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> bonded;
    private Node<StoreLight> node;
    private TitledItem<CheckBox> printCustomerNo;
    private TitledItem<SearchTextField2<CustomerLight>> customerSearchField;
    private TitledItem<ComboBox> sortBy;
    private TitledItem<CheckBox> includeAmount;
    private TitledItem<CheckBox> includeZeroStockItems;
    private TitledItem<CheckBox> includeArticleConversion;
    private TitledItem<CheckBox> includeCustomerArticleNumber;
    private Node<StockReportConfiguration> configNode;

    public PrintInventoryWorksheetComponent(Node<StoreLight> node) {
        super(false, true, true, ReportTypeE.INVENTORY_WORKSHEETS);
        this.node = node;
        StockReportConfiguration config = new StockReportConfiguration();
        config.setFormat(ReportingOutputFormatE.PDF);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            if (n.equals("print_as_excel")) {
                ((RadioButton)this.asXLS.getElement()).loadState(v, "print_as_excel");
                continue;
            }
            if (n.equals("include_amount")) {
                this.includeAmount.getElement().loadState(v, "include_amount");
                continue;
            }
            if (n.equals("include_zero_stock_items")) {
                this.includeZeroStockItems.getElement().loadState(v, "include_zero_stock_items");
                continue;
            }
            if (n.equals("include_conversion")) {
                this.includeArticleConversion.getElement().loadState(v, "include_conversion");
                continue;
            }
            if (!n.equals("include_customer_article_number")) continue;
            this.includeCustomerArticleNumber.getElement().loadState(v, "include_customer_article_number");
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("print_as_excel", "" + ((RadioButton)this.asXLS.getElement()).isChecked());
        conf.addProperty("include_amount", "" + this.includeAmount.getElement().isChecked());
        conf.addProperty("include_zero_stock_items", "" + this.includeZeroStockItems.getElement().isChecked());
        conf.addProperty("include_conversion", "" + this.includeArticleConversion.getElement().isChecked());
        conf.addProperty("include_customer_article_number", "" + this.includeCustomerArticleNumber.getElement().isChecked());
        return conf;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.bonded.setEnabled(isEnabled);
        this.printCustomerNo.setEnabled(false);
        this.customerSearchField.setEnabled(isEnabled);
        this.sortBy.setEnabled(isEnabled);
        this.includeAmount.setEnabled(isEnabled);
        this.includeZeroStockItems.setEnabled(isEnabled);
        this.includeArticleConversion.setEnabled(isEnabled);
        this.includeCustomerArticleNumber.setEnabled(isEnabled);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.bonded.setVisible(false);
        this.printCustomerNo.setVisible(false);
        this.customerSearchField.setVisible(false);
        this.sortBy.setVisible(false);
        this.includeAmount.setVisible(false);
        this.includeZeroStockItems.setVisible(false);
        this.includeArticleConversion.setVisible(false);
        this.includeCustomerArticleNumber.setVisible(false);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.bonded != null) {
            this.bonded.kill();
        }
        if (this.printCustomerNo != null) {
            this.printCustomerNo.kill();
        }
        if (this.customerSearchField != null) {
            this.customerSearchField.kill();
        }
        if (this.sortBy != null) {
            this.sortBy.kill();
        }
        if (this.includeAmount != null) {
            this.includeAmount.kill();
        }
        if (this.includeZeroStockItems != null) {
            this.includeZeroStockItems.kill();
        }
        if (this.includeArticleConversion != null) {
            this.includeArticleConversion.kill();
        }
        if (this.includeCustomerArticleNumber != null) {
            this.includeCustomerArticleNumber.kill();
        }
        this.includeArticleConversion = null;
        this.bonded = null;
        this.printCustomerNo = null;
        this.customerSearchField = null;
        this.sortBy = null;
        this.includeZeroStockItems = null;
        this.includeCustomerArticleNumber = null;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.printCustomerNo = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(StockReportConfiguration_.includeCustomerData)), Words.INCLUDE_CUSTOMER_DATA, TitledItem.TitledItemOrientation.EAST);
        this.printCustomerNo.getElement().setChecked(true);
        this.bonded = new TitledItem<ComboBox>(new ComboBox(this.configNode.getChildNamed(StockReportConfiguration_.bonded), NodeToolkit.getAffixList(BondedStateE.class), ConverterRegistry.getConverter(BondedStateEConverter.class)), Words.BONDED, TitledItem.TitledItemOrientation.NORTH);
        this.customerSearchField = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, this.configNode.getChildNamed(StockReportConfiguration_.customer)), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.customerSearchField.setProgress(1.0f);
        this.sortBy = new TitledItem<ComboBox>(new ComboBox(), Words.SORT_BY, TitledItem.TitledItemOrientation.WEST);
        this.sortBy.getElement().addItem(Words.ARTICLE_NUMBER);
        this.sortBy.getElement().addItem(Words.ARTICLE_NAME);
        this.sortBy.getElement().addItem(Words.CUSTOMER_ARTICLE_NUMBER);
        this.sortBy.setIgnorePrefWidth(true);
        this.includeAmount = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(StockReportConfiguration_.includeAmount)), Words.INCLUDE_AMOUNT_COLUMN, TitledItem.TitledItemOrientation.EAST);
        this.includeZeroStockItems = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(StockReportConfiguration_.includeZeroStockItems)), Words.INCLUDE_ZERO_STOCK_ITEMS, TitledItem.TitledItemOrientation.EAST);
        this.includeArticleConversion = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(StockReportConfiguration_.includeArticleConversion)), Words.INCLUDE_ARTICLE_CONVERSION, TitledItem.TitledItemOrientation.EAST);
        this.includeCustomerArticleNumber = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(StockReportConfiguration_.includeCustomerArticleNumber)), Words.INCLUDE_CUSTOMER_ARTICLE_NUMBER, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.printCustomerNo);
        this.getViewContainer().add(this.bonded);
        this.getViewContainer().add(this.customerSearchField);
        this.getViewContainer().add(this.sortBy);
        this.getViewContainer().add(this.includeAmount);
        this.getViewContainer().add(this.includeZeroStockItems);
        this.getViewContainer().add(this.includeArticleConversion);
        this.getViewContainer().add(this.includeCustomerArticleNumber);
        this.setEnabled(this.isEnabled());
    }

    @Override
    public String getTitleString() {
        return Words.STORE;
    }

    @Override
    public String getTitleValue() {
        return ((StoreLight)this.node.getValue()).getName();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintInventoryWorksheetComponent.this.getSelectedReport();
                PrintInventoryWorksheetComponent.this.configNode.commit();
                StockReportConfiguration config = (StockReportConfiguration)PrintInventoryWorksheetComponent.this.configNode.getValue();
                config.getIncludedStores().add(new StoreReference(((StoreLight)PrintInventoryWorksheetComponent.this.node.getValue()).getId()));
                config.setStylesheet(file);
                config.setTitle2(Words.INVENTORY_WORK_SHEET);
                if (PrintInventoryWorksheetComponent.this.asXLS != null && ((RadioButton)PrintInventoryWorksheetComponent.this.asXLS.getElement()).isChecked()) {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                } else {
                    config.setFormat(ReportingOutputFormatE.PDF);
                }
                if (((ComboBox)PrintInventoryWorksheetComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.ARTICLE_NAME)) {
                    config.setSortByArticleName(Boolean.valueOf(true));
                    config.setSortByArticleNumber(Boolean.valueOf(false));
                    config.setSortByCustomerNumber(Boolean.valueOf(false));
                } else if (((ComboBox)PrintInventoryWorksheetComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.ARTICLE_NUMBER)) {
                    config.setSortByArticleName(Boolean.valueOf(false));
                    config.setSortByArticleNumber(Boolean.valueOf(true));
                    config.setSortByCustomerNumber(Boolean.valueOf(false));
                } else if (((ComboBox)PrintInventoryWorksheetComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.CUSTOMER_ARTICLE_NUMBER)) {
                    config.setSortByArticleName(Boolean.valueOf(false));
                    config.setSortByArticleNumber(Boolean.valueOf(false));
                    config.setSortByCustomerNumber(Boolean.valueOf(true));
                }
                PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createInventoryWorkSheet(config).getValue();
                PrintInventoryWorksheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintInventoryWorksheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<StoreLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<StoreLight> createBatchJob(Node<StoreLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintInventoryWorksheetComponent.this.layoutInheritedComponents(parent) + PrintInventoryWorksheetComponent.this.border;
            if (PrintInventoryWorksheetComponent.this.bonded != null) {
                PrintInventoryWorksheetComponent.this.bonded.setLocation(PrintInventoryWorksheetComponent.this.border, y);
                PrintInventoryWorksheetComponent.this.bonded.setSize(150, (int)PrintInventoryWorksheetComponent.this.bonded.getPreferredSize().getHeight());
                PrintInventoryWorksheetComponent.this.printCustomerNo.setLocation(PrintInventoryWorksheetComponent.this.border, PrintInventoryWorksheetComponent.this.bonded.getY() + PrintInventoryWorksheetComponent.this.bonded.getHeight() + PrintInventoryWorksheetComponent.this.border);
                PrintInventoryWorksheetComponent.this.printCustomerNo.setSize(PrintInventoryWorksheetComponent.this.printCustomerNo.getPreferredSize());
                PrintInventoryWorksheetComponent.this.sortBy.setLocation(PrintInventoryWorksheetComponent.this.border, PrintInventoryWorksheetComponent.this.printCustomerNo.getY() + PrintInventoryWorksheetComponent.this.printCustomerNo.getHeight() + PrintInventoryWorksheetComponent.this.border / 2);
                PrintInventoryWorksheetComponent.this.sortBy.setSize(parent.getWidth() - 2 * PrintInventoryWorksheetComponent.this.border, (int)PrintInventoryWorksheetComponent.this.sortBy.getPreferredSize().getHeight());
                PrintInventoryWorksheetComponent.this.customerSearchField.setLocation(PrintInventoryWorksheetComponent.this.border, PrintInventoryWorksheetComponent.this.sortBy.getY() + PrintInventoryWorksheetComponent.this.sortBy.getHeight() + PrintInventoryWorksheetComponent.this.border);
                PrintInventoryWorksheetComponent.this.customerSearchField.setSize(parent.getWidth() - 2 * PrintInventoryWorksheetComponent.this.border, (int)PrintInventoryWorksheetComponent.this.customerSearchField.getPreferredSize().getHeight());
                PrintInventoryWorksheetComponent.this.includeAmount.setLocation(PrintInventoryWorksheetComponent.this.border, PrintInventoryWorksheetComponent.this.customerSearchField.getY() + PrintInventoryWorksheetComponent.this.customerSearchField.getHeight() + PrintInventoryWorksheetComponent.this.border);
                PrintInventoryWorksheetComponent.this.includeAmount.setSize(PrintInventoryWorksheetComponent.this.includeAmount.getPreferredSize());
                PrintInventoryWorksheetComponent.this.includeZeroStockItems.setLocation(PrintInventoryWorksheetComponent.this.border, PrintInventoryWorksheetComponent.this.includeAmount.getY() + PrintInventoryWorksheetComponent.this.includeAmount.getHeight() + PrintInventoryWorksheetComponent.this.border);
                PrintInventoryWorksheetComponent.this.includeZeroStockItems.setSize(PrintInventoryWorksheetComponent.this.includeZeroStockItems.getPreferredSize());
                PrintInventoryWorksheetComponent.this.includeArticleConversion.setLocation(PrintInventoryWorksheetComponent.this.border, PrintInventoryWorksheetComponent.this.includeZeroStockItems.getY() + PrintInventoryWorksheetComponent.this.includeZeroStockItems.getHeight() + PrintInventoryWorksheetComponent.this.border);
                PrintInventoryWorksheetComponent.this.includeArticleConversion.setSize(PrintInventoryWorksheetComponent.this.includeArticleConversion.getPreferredSize());
                PrintInventoryWorksheetComponent.this.includeCustomerArticleNumber.setLocation(PrintInventoryWorksheetComponent.this.border, PrintInventoryWorksheetComponent.this.includeArticleConversion.getY() + PrintInventoryWorksheetComponent.this.includeArticleConversion.getHeight() + PrintInventoryWorksheetComponent.this.border);
                PrintInventoryWorksheetComponent.this.includeCustomerArticleNumber.setSize(PrintInventoryWorksheetComponent.this.includeCustomerArticleNumber.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintInventoryWorksheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (PrintInventoryWorksheetComponent.this.bonded != null) {
                h += PrintInventoryWorksheetComponent.this.border;
                h = (int)((double)h + PrintInventoryWorksheetComponent.this.bonded.getPreferredSize().getHeight());
                h += PrintInventoryWorksheetComponent.this.border;
                h = (int)((double)h + PrintInventoryWorksheetComponent.this.printCustomerNo.getPreferredSize().getHeight());
                h += PrintInventoryWorksheetComponent.this.border / 2;
                h = (int)((double)h + PrintInventoryWorksheetComponent.this.sortBy.getPreferredSize().getHeight());
                h += PrintInventoryWorksheetComponent.this.border;
                h = (int)((double)h + PrintInventoryWorksheetComponent.this.customerSearchField.getPreferredSize().getHeight());
                h += PrintInventoryWorksheetComponent.this.border;
                h = (int)((double)h + PrintInventoryWorksheetComponent.this.includeAmount.getPreferredSize().getHeight());
                h += PrintInventoryWorksheetComponent.this.border;
                h = (int)((double)h + PrintInventoryWorksheetComponent.this.includeZeroStockItems.getPreferredSize().getHeight());
                h += PrintInventoryWorksheetComponent.this.border;
                h = (int)((double)h + PrintInventoryWorksheetComponent.this.includeArticleConversion.getPreferredSize().getHeight());
                h += PrintInventoryWorksheetComponent.this.border;
                h = (int)((double)h + PrintInventoryWorksheetComponent.this.includeCustomerArticleNumber.getPreferredSize().getHeight());
                h += PrintInventoryWorksheetComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

