/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbComponentTable;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.ReturnsBreadCrumbTable;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.ReturnsCountDrawerBasedSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils.ContentTableTitleConverter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel2Rows;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.textfield.AbstractTextField;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountDeliverySpaceComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountProductComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountProductComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.product.ReturnsCountTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class ContentTable
extends BreadCrumbComponentTable {
    private static final long serialVersionUID = 1L;
    private boolean isRevisedOnly;

    public ContentTable(IDataHandler dataHandler, BreadCrumbPanel master) {
        super(dataHandler, master, null, "", null, null);
        this.disableTitle();
        this.table.setComparator(new Comparator<Table2RowPanel>(){

            @Override
            public int compare(Table2RowPanel o1, Table2RowPanel o2) {
                switch (((ReturnsBreadCrumbTable)ContentTable.this.master).getManager().isManualSales()) {
                    case MANUAL_SALES: {
                        ReturnsCountProductComplete p1 = (ReturnsCountProductComplete)o1.getModel().getNode().getValue();
                        ReturnsCountProductComplete p2 = (ReturnsCountProductComplete)o2.getModel().getNode().getValue();
                        Integer i1 = p1.getProduct().getNumber();
                        Integer i2 = p2.getProduct().getNumber();
                        int ret = i1.compareTo(i2);
                        return ret;
                    }
                    case RC_AND_MANUAL_SALES: 
                    case RETURNS_COUNT_TRAY_BASED: {
                        ReturnsCountProductComplete p1 = (ReturnsCountProductComplete)o1.getModel().getNode().getValue();
                        ReturnsCountProductComplete p2 = (ReturnsCountProductComplete)o2.getModel().getNode().getValue();
                        String t = p1.getDeliverySpace().getDeliverySpace().getSpaceName();
                        String t2 = p2.getDeliverySpace().getDeliverySpace().getSpaceName();
                        Integer i1 = null;
                        Integer i2 = null;
                        Pattern p = Pattern.compile("\\d+");
                        Matcher m = p.matcher(t);
                        if (m.find()) {
                            try {
                                i1 = Integer.valueOf(m.group());
                            }
                            catch (NumberFormatException e) {
                                i1 = null;
                            }
                        }
                        if ((m = p.matcher(t2)).find()) {
                            try {
                                i2 = Integer.valueOf(m.group());
                            }
                            catch (NumberFormatException e) {
                                i2 = null;
                            }
                        }
                        if (i1 == null) {
                            return i2 == null ? 0 : 1;
                        }
                        if (i2 == null) {
                            return i1 == null ? 0 : -1;
                        }
                        int ret = i1.compareTo(i2);
                        if (ret == 0) {
                            i1 = p1.getProduct().getNumber();
                            i2 = p2.getProduct().getNumber();
                            ret = i1.compareTo(i2);
                        }
                        return ret;
                    }
                    case RETURNS_COUNT_EQUIMENT_BASED: {
                        ReturnsCountProductComplete p1 = (ReturnsCountProductComplete)o1.getModel().getNode().getValue();
                        ReturnsCountProductComplete p2 = (ReturnsCountProductComplete)o2.getModel().getNode().getValue();
                        Integer i1 = p1.getProduct().getNumber();
                        Integer i2 = p2.getProduct().getNumber();
                        int ret = i1.compareTo(i2);
                        return ret;
                    }
                }
                return 0;
            }
        });
        switch (((ReturnsBreadCrumbTable)this.master).getManager().isManualSales()) {
            case MANUAL_SALES: {
                this.table.getFatLines().add(2);
                break;
            }
            case RC_AND_MANUAL_SALES: {
                this.table.getFatLines().add(3);
                this.table.getFatLines().add(7);
                this.table.getFatLines().add(10);
                break;
            }
            case RETURNS_COUNT_EQUIMENT_BASED: {
                this.table.getFatLines().add(2);
                this.table.getFatLines().add(5);
                break;
            }
            case RETURNS_COUNT_TRAY_BASED: {
                this.table.getFatLines().add(4);
                this.table.getFatLines().add(7);
                break;
            }
        }
        this.createFocusCycle();
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
        this.table.updateOrder();
    }

    @Override
    public int getSortingIndex() {
        return 0;
    }

    @Override
    public boolean hasAddButton() {
        return false;
    }

    @Override
    public void setTotalCostAlgorithm() {
    }

    @Override
    public Table2HeaderPanel getHeaderRow(Table2RowModel model) {
        return new Table2HeaderPanel2Rows(model, 7);
    }

    @Override
    public Table2RowPanel getComponentTableRow(Table2RowModel model, boolean isHeader) {
        ComponentRow p = new ComponentRow(model);
        return p;
    }

    @Override
    public void addButtonPressed(int x, int y) {
    }

    @Override
    public void childRemoved() {
    }

    private void selectUpper(ComponentRow row, int column) {
        for (int index = this.table.getRowIndex(row); index > 0; --index) {
            ComponentRow r = (ComponentRow)this.table.getRowAt(index - 1);
            if (!r.isEditing(column)) continue;
            r.takeFocusAt(column);
            return;
        }
    }

    private void selectLower(ComponentRow row, int column) {
        for (int index = this.table.getRowIndex(row); index < this.table.getRowCount() - 1; ++index) {
            ComponentRow r = (ComponentRow)this.table.getRowAt(index + 1);
            if (!r.isEditing(column)) continue;
            r.takeFocusAt(column);
            return;
        }
    }

    public ArrayList<TableColumnInfo> getColumns(Node node) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        this.isRevisedOnly = ((ReturnsBreadCrumbTable)this.master).getReviseOnly();
        int defaultCountColumnWidth = 100;
        columns.add(new TableColumnInfo(Words.PRODUCT_NUMBER, null, null, null, "", 100));
        columns.add(new TableColumnInfo(Words.PRODUCT_NAME, null, null, null, "", 100));
        switch (((ReturnsBreadCrumbTable)this.master).getManager().isManualSales()) {
            case MANUAL_SALES: {
                columns.add(new TableColumnInfo(Words.QTY_PORTION, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.DEVICE_SALES_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.COMPLEMENTARY_SALES_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.CREW_SALES_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.DISCOUNT_SALES_LEVEL, null, null, null, "", defaultCountColumnWidth));
                break;
            }
            case RC_AND_MANUAL_SALES: {
                columns.add(new TableColumnInfo(Words.DRAWER, null, null, null, "", 150));
                columns.add(new TableColumnInfo(Words.REVISE_STOCK_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.DEVICE_SALES_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.COMPLEMENTARY_SALES_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.CREW_SALES_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.DISCOUNT_SALES_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.CONSUMED_STOCK_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.WASTE_STOCK_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.MISSING_STOCK_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(((ReturnsBreadCrumbTable)this.master).getManager().getCountColumnName(), null, null, null, "", defaultCountColumnWidth));
                break;
            }
            case RETURNS_COUNT_TRAY_BASED: {
                columns.add(new TableColumnInfo(Words.DRAWER, null, null, null, "", 150));
                columns.add(new TableColumnInfo(Words.LOAD_STOCK_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.REVISE_STOCK_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.CONSUMED_STOCK_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.WASTE_STOCK_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.MISSING_STOCK_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(((ReturnsBreadCrumbTable)this.master).getManager().getCountColumnName(), null, null, null, "", defaultCountColumnWidth));
                break;
            }
            case RETURNS_COUNT_EQUIMENT_BASED: {
                columns.add(new TableColumnInfo(Words.LOAD_STOCK_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.CONSUMED_STOCK_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.WASTE_STOCK_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(Words.MISSING_STOCK_LEVEL, null, null, null, "", defaultCountColumnWidth));
                columns.add(new TableColumnInfo(((ReturnsBreadCrumbTable)this.master).getManager().getCountColumnName(), null, null, null, "", defaultCountColumnWidth));
                break;
            }
        }
        switch (((ReturnsBreadCrumbTable)this.master).getManager().isManualSales()) {
            case MANUAL_SALES: {
                columns.get(0).setxExpand(0.0);
                columns.get(1).setxExpand(1.0);
                columns.get(2).setxExpand(0.0);
                columns.get(3).setxExpand(0.0);
                columns.get(4).setxExpand(0.0);
                columns.get(5).setxExpand(0.0);
                columns.get(6).setxExpand(0.0);
                break;
            }
            case RC_AND_MANUAL_SALES: {
                columns.get(0).setxExpand(0.0);
                columns.get(1).setxExpand(1.0);
                columns.get(2).setxExpand(0.0);
                columns.get(3).setxExpand(0.0);
                columns.get(4).setxExpand(0.0);
                columns.get(5).setxExpand(0.0);
                columns.get(6).setxExpand(0.0);
                columns.get(7).setxExpand(0.0);
                columns.get(8).setxExpand(0.0);
                columns.get(9).setxExpand(0.0);
                columns.get(10).setxExpand(0.0);
                columns.get(11).setxExpand(0.0);
                break;
            }
            case RETURNS_COUNT_TRAY_BASED: {
                columns.get(0).setxExpand(0.0);
                columns.get(1).setxExpand(1.0);
                columns.get(2).setxExpand(0.0);
                columns.get(3).setxExpand(0.0);
                columns.get(4).setxExpand(0.0);
                columns.get(5).setxExpand(0.0);
                columns.get(6).setxExpand(0.0);
                columns.get(7).setxExpand(0.0);
                columns.get(8).setxExpand(0.0);
                break;
            }
            case RETURNS_COUNT_EQUIMENT_BASED: {
                columns.get(0).setxExpand(0.0);
                columns.get(1).setxExpand(1.0);
                columns.get(2).setxExpand(0.0);
                columns.get(3).setxExpand(0.0);
                columns.get(4).setxExpand(0.0);
                columns.get(5).setxExpand(0.0);
                columns.get(6).setxExpand(0.0);
                break;
            }
        }
        return columns;
    }

    @Override
    public Converter getTotalConverter() {
        return null;
    }

    public Converter getTitleConverter() {
        return ConverterRegistry.getConverter(ContentTableTitleConverter.class);
    }

    private class ComponentRow
    extends Table2RowPanel
    implements TextFieldListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        private TextLabel prodNo;
        private TextLabel prodName;
        private TextLabel eqName;
        private TextLabel tray;
        private JComponent loadedStockAmount;
        private CheckBox enableRevisedAmount;
        private JComponent revisedStockAmount;
        private TextLabel deviceStockAmount;
        private JComponent deviceSalesAmount;
        private JComponent complementarySalesAmount;
        private JComponent crewSalesAmount;
        private JComponent discountSalesAmount;
        private JComponent soldStockAmount;
        private JComponent wasteStockAmount;
        private JComponent missingStockAmount;
        private JComponent returnedStockAmount;

        public ComponentRow(Table2RowModel m) {
            super(m);
            this.setLayout(new TableRowLayout());
            Node currentVariant = m.getNode().getChildNamed(ReturnsCountProductComplete_.product).getChildNamed(ProductComplete_.currentVariant);
            this.prodNo = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.product).getChildNamed(ProductComplete_.number), ConverterRegistry.getConverter(IntegerConverter.class));
            this.prodName = new TextLabel(currentVariant.getChildNamed(ProductVariantLight_.name), ConverterRegistry.getConverter(StringConverter.class));
            this.add(this.prodNo);
            this.add(this.prodName);
            switch (((ReturnsBreadCrumbTable)ContentTable.this.master).getManager().isManualSales()) {
                case MANUAL_SALES: {
                    ReturnsCountProductComplete rc = (ReturnsCountProductComplete)m.getNode().getValue();
                    this.eqName = new TextLabel("" + rc.getConversionFactor());
                    if (ContentTable.this.isRevisedOnly) {
                        this.deviceSalesAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.machineSalesAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                        this.complementarySalesAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.complementarySalesAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                        if (Boolean.TRUE.equals(rc.getCrewPrice())) {
                            this.crewSalesAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.crewSalesAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                        }
                        this.discountSalesAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.discountAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                    } else {
                        this.deviceSalesAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.machineSalesAmount), TextFieldType.INT);
                        ((NumberTextField)this.deviceSalesAmount).addTextFieldListener(this);
                        ((NumberTextField)this.deviceSalesAmount).getTextField().addKeyListener(this);
                        this.complementarySalesAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.complementarySalesAmount), TextFieldType.INT);
                        ((NumberTextField)this.complementarySalesAmount).addTextFieldListener(this);
                        ((NumberTextField)this.complementarySalesAmount).getTextField().addKeyListener(this);
                        if (Boolean.TRUE.equals(rc.getCrewPrice())) {
                            this.crewSalesAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.crewSalesAmount), TextFieldType.INT);
                            ((NumberTextField)this.crewSalesAmount).addTextFieldListener(this);
                            ((NumberTextField)this.crewSalesAmount).getTextField().addKeyListener(this);
                        }
                        this.discountSalesAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.discountAmount), TextFieldType.INT);
                        ((NumberTextField)this.discountSalesAmount).addTextFieldListener(this);
                        ((NumberTextField)this.discountSalesAmount).getTextField().addKeyListener(this);
                    }
                    this.add(this.eqName);
                    this.add(this.deviceSalesAmount);
                    this.add(this.complementarySalesAmount);
                    if (Boolean.TRUE.equals(rc.getCrewPrice())) {
                        this.add(this.crewSalesAmount);
                    }
                    this.add(this.discountSalesAmount);
                    break;
                }
                case RC_AND_MANUAL_SALES: {
                    this.tray = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ReturnsCountProductComplete_.deliverySpace, ReturnsCountDeliverySpaceComplete_.deliverySpace, DeliverySpaceComplete_.spaceName}));
                    ReturnsCountProductComplete p = (ReturnsCountProductComplete)m.getNode().getValue();
                    if (p.getProduct().getReturnsCountType() == ReturnsCountTypeE.NONE) {
                        this.revisedStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.revisedDeliveredAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                        this.enableRevisedAmount = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ReturnsCountProductComplete_.useRevisedDeliveredAmount));
                    } else {
                        this.revisedStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.revisedDeliveredAmount), TextFieldType.INT);
                        ((NumberTextField)this.revisedStockAmount).getTextField().addKeyListener(this);
                        this.enableRevisedAmount = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ReturnsCountProductComplete_.useRevisedDeliveredAmount));
                    }
                    this.enableRevisedAmount.addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
                    this.add(this.tray);
                    this.add(this.enableRevisedAmount);
                    this.add(this.revisedStockAmount);
                    ReturnsCountProductComplete product = (ReturnsCountProductComplete)m.getNode().getValue();
                    if (Boolean.TRUE.equals(product.getProduct().getSalesOnBoard())) {
                        if (ContentTable.this.isRevisedOnly) {
                            this.deviceSalesAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.machineSalesAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                            this.complementarySalesAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.complementarySalesAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                            if (Boolean.TRUE.equals(product.getCrewPrice())) {
                                this.crewSalesAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.crewSalesAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                            }
                            this.discountSalesAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.discountAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                        } else {
                            this.deviceSalesAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.machineSalesAmount), TextFieldType.INT);
                            ((NumberTextField)this.deviceSalesAmount).addTextFieldListener(this);
                            ((NumberTextField)this.deviceSalesAmount).getTextField().addKeyListener(this);
                            this.complementarySalesAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.complementarySalesAmount), TextFieldType.INT);
                            ((NumberTextField)this.complementarySalesAmount).addTextFieldListener(this);
                            ((NumberTextField)this.complementarySalesAmount).getTextField().addKeyListener(this);
                            if (Boolean.TRUE.equals(product.getCrewPrice())) {
                                this.crewSalesAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.crewSalesAmount), TextFieldType.INT);
                                ((NumberTextField)this.crewSalesAmount).addTextFieldListener(this);
                                ((NumberTextField)this.crewSalesAmount).getTextField().addKeyListener(this);
                            }
                            this.discountSalesAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.discountAmount), TextFieldType.INT);
                            ((NumberTextField)this.discountSalesAmount).addTextFieldListener(this);
                            ((NumberTextField)this.discountSalesAmount).getTextField().addKeyListener(this);
                        }
                        this.add(this.deviceSalesAmount);
                        this.add(this.complementarySalesAmount);
                        if (Boolean.TRUE.equals(product.getCrewPrice())) {
                            this.add(this.crewSalesAmount);
                        }
                        this.add(this.discountSalesAmount);
                    }
                    if (product.getProduct().getReturnsCountType() != ReturnsCountTypeE.RETURN && product.getProduct().getReturnsCountType() != ReturnsCountTypeE.UPLIFT) break;
                    boolean isDutyFreeStyle = Boolean.TRUE.equals(m.getNode().getChildNamed(new DtoField[]{ReturnsCountProductComplete_.product, ProductComplete_.salesOnBoard}).getValue());
                    if (isDutyFreeStyle) {
                        if (ContentTable.this.isRevisedOnly) {
                            this.returnedStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                            this.wasteStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.wasteAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                            this.soldStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                            this.missingStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.missingAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                        } else {
                            this.returnedStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount), TextFieldType.INT);
                            ((NumberTextField)this.returnedStockAmount).addTextFieldListener(this);
                            ((NumberTextField)this.returnedStockAmount).getTextField().addKeyListener(this);
                            this.wasteStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.wasteAmount), TextFieldType.INT);
                            ((NumberTextField)this.wasteStockAmount).addTextFieldListener(this);
                            ((NumberTextField)this.wasteStockAmount).getTextField().addKeyListener(this);
                            this.soldStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount), TextFieldType.INT);
                            ((NumberTextField)this.soldStockAmount).addTextFieldListener(this);
                            ((NumberTextField)this.soldStockAmount).getTextField().addKeyListener(this);
                            this.missingStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.missingAmount), TextFieldType.INT);
                            ((NumberTextField)this.missingStockAmount).addTextFieldListener(this);
                            ((NumberTextField)this.missingStockAmount).getTextField().addKeyListener(this);
                        }
                        this.add(this.returnedStockAmount);
                        this.add(this.wasteStockAmount);
                        this.add(this.soldStockAmount);
                        this.add(this.missingStockAmount);
                        break;
                    }
                    this.soldStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                    if (ContentTable.this.isRevisedOnly) {
                        this.returnedStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                    } else {
                        this.returnedStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount), TextFieldType.INT);
                        ((NumberTextField)this.returnedStockAmount).addTextFieldListener(this);
                        ((NumberTextField)this.returnedStockAmount).getTextField().addKeyListener(this);
                    }
                    this.add(this.soldStockAmount);
                    this.add(this.returnedStockAmount);
                    break;
                }
                case RETURNS_COUNT_TRAY_BASED: {
                    ReturnsCountProductComplete product = (ReturnsCountProductComplete)m.getNode().getValue();
                    this.tray = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ReturnsCountProductComplete_.deliverySpace, ReturnsCountDeliverySpaceComplete_.deliverySpace, DeliverySpaceComplete_.spaceName}));
                    this.loadedStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.calculatedDeliveredAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                    if (product.getProduct().getReturnsCountType() == ReturnsCountTypeE.NONE) {
                        this.revisedStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.revisedDeliveredAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                        this.enableRevisedAmount = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ReturnsCountProductComplete_.useRevisedDeliveredAmount));
                    } else {
                        this.revisedStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.revisedDeliveredAmount), TextFieldType.INT);
                        ((NumberTextField)this.revisedStockAmount).addTextFieldListener(this);
                        ((NumberTextField)this.revisedStockAmount).getTextField().addKeyListener(this);
                        this.enableRevisedAmount = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ReturnsCountProductComplete_.useRevisedDeliveredAmount));
                    }
                    this.enableRevisedAmount.addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
                    this.add(this.tray);
                    this.add(this.loadedStockAmount);
                    this.add(this.enableRevisedAmount);
                    this.add(this.revisedStockAmount);
                    boolean isDutyFreeStyle = Boolean.TRUE.equals(m.getNode().getChildNamed(new DtoField[]{ReturnsCountProductComplete_.product, ProductComplete_.salesOnBoard}).getValue());
                    if (isDutyFreeStyle) {
                        if (ContentTable.this.isRevisedOnly) {
                            this.returnedStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                            this.wasteStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.wasteAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                            this.soldStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                            this.missingStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.missingAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                        } else {
                            this.returnedStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount), TextFieldType.INT);
                            ((NumberTextField)this.returnedStockAmount).addTextFieldListener(this);
                            ((NumberTextField)this.returnedStockAmount).getTextField().addKeyListener(this);
                            this.wasteStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.wasteAmount), TextFieldType.INT);
                            ((NumberTextField)this.wasteStockAmount).addTextFieldListener(this);
                            ((NumberTextField)this.wasteStockAmount).getTextField().addKeyListener(this);
                            this.soldStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount), TextFieldType.INT);
                            ((NumberTextField)this.soldStockAmount).addTextFieldListener(this);
                            ((NumberTextField)this.soldStockAmount).getTextField().addKeyListener(this);
                            this.missingStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.missingAmount), TextFieldType.INT);
                            ((NumberTextField)this.missingStockAmount).addTextFieldListener(this);
                            ((NumberTextField)this.missingStockAmount).getTextField().addKeyListener(this);
                        }
                        this.add(this.returnedStockAmount);
                        this.add(this.wasteStockAmount);
                        this.add(this.soldStockAmount);
                        this.add(this.missingStockAmount);
                        break;
                    }
                    this.soldStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                    if (ContentTable.this.isRevisedOnly) {
                        this.returnedStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                    } else {
                        this.returnedStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount), TextFieldType.INT);
                        ((NumberTextField)this.returnedStockAmount).addTextFieldListener(this);
                        ((NumberTextField)this.returnedStockAmount).getTextField().addKeyListener(this);
                    }
                    this.add(this.soldStockAmount);
                    this.add(this.returnedStockAmount);
                    break;
                }
                case RETURNS_COUNT_EQUIMENT_BASED: {
                    this.loadedStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.calculatedDeliveredAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                    this.add(this.loadedStockAmount);
                    boolean isDutyFreeStyle = Boolean.TRUE.equals(m.getNode().getChildNamed(new DtoField[]{ReturnsCountProductComplete_.product, ProductComplete_.salesOnBoard}).getValue());
                    if (isDutyFreeStyle) {
                        if (ContentTable.this.isRevisedOnly) {
                            this.returnedStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                            this.wasteStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.wasteAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                            this.soldStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                            this.missingStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.missingAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                        } else {
                            this.returnedStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount), TextFieldType.INT);
                            ((NumberTextField)this.returnedStockAmount).addTextFieldListener(this);
                            ((NumberTextField)this.returnedStockAmount).getTextField().addKeyListener(this);
                            this.wasteStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.wasteAmount), TextFieldType.INT);
                            ((NumberTextField)this.wasteStockAmount).addTextFieldListener(this);
                            ((NumberTextField)this.wasteStockAmount).getTextField().addKeyListener(this);
                            this.soldStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount), TextFieldType.INT);
                            ((NumberTextField)this.soldStockAmount).addTextFieldListener(this);
                            ((NumberTextField)this.soldStockAmount).getTextField().addKeyListener(this);
                            this.missingStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.missingAmount), TextFieldType.INT);
                            ((NumberTextField)this.missingStockAmount).addTextFieldListener(this);
                            ((NumberTextField)this.missingStockAmount).getTextField().addKeyListener(this);
                        }
                        this.add(this.returnedStockAmount);
                        this.add(this.wasteStockAmount);
                        this.add(this.soldStockAmount);
                        this.add(this.missingStockAmount);
                        break;
                    }
                    this.soldStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                    if (ContentTable.this.isRevisedOnly) {
                        this.returnedStockAmount = new TextLabel(m.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount), ConverterRegistry.getConverter(IntegerConverter.class));
                    } else {
                        this.returnedStockAmount = new NumberTextField(m.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount), TextFieldType.INT);
                        ((NumberTextField)this.returnedStockAmount).addTextFieldListener(this);
                        ((NumberTextField)this.returnedStockAmount).getTextField().addKeyListener(this);
                    }
                    this.add(this.soldStockAmount);
                    this.add(this.returnedStockAmount);
                    break;
                }
            }
            this.validateRowState();
        }

        @Override
        public Component getFocusDelegationComponent() {
            if (this.returnedStockAmount instanceof TextField) {
                List<Component> a = ((TextField)this.returnedStockAmount).getFocusComponents();
                if (a.isEmpty()) {
                    return null;
                }
                return a.get(0);
            }
            return null;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.returnedStockAmount instanceof TextField) {
                ((TextField)this.returnedStockAmount).requestFocusInWindowNow();
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            if (this.deviceSalesAmount instanceof Focusable) {
                CheckedListAdder.addToList(a, (Focusable)((Object)this.deviceSalesAmount));
            }
            if (this.complementarySalesAmount instanceof Focusable) {
                CheckedListAdder.addToList(a, (Focusable)((Object)this.complementarySalesAmount));
            }
            if (this.crewSalesAmount instanceof Focusable) {
                CheckedListAdder.addToList(a, (Focusable)((Object)this.crewSalesAmount));
            }
            if (this.discountSalesAmount instanceof Focusable) {
                CheckedListAdder.addToList(a, (Focusable)((Object)this.discountSalesAmount));
            }
            if (this.soldStockAmount instanceof Focusable) {
                CheckedListAdder.addToList(a, (Focusable)((Object)this.soldStockAmount));
            }
            if (this.wasteStockAmount != null && this.wasteStockAmount instanceof Focusable) {
                CheckedListAdder.addToList(a, (Focusable)((Object)this.wasteStockAmount));
            }
            if (this.missingStockAmount != null && this.missingStockAmount instanceof Focusable) {
                CheckedListAdder.addToList(a, (Focusable)((Object)this.missingStockAmount));
            }
            if (this.returnedStockAmount != null && this.returnedStockAmount instanceof Focusable) {
                CheckedListAdder.addToList(a, (Focusable)((Object)this.returnedStockAmount));
            }
            return a;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.prodNo.setEnabled(isEnabled);
            this.prodName.setEnabled(isEnabled);
            if (this.eqName != null) {
                this.eqName.setEnabled(isEnabled);
            }
            if (this.loadedStockAmount != null) {
                this.loadedStockAmount.setEnabled(isEnabled);
            }
            if (this.deviceStockAmount != null) {
                this.deviceStockAmount.setEnabled(isEnabled);
            }
            if (this.returnedStockAmount != null) {
                this.returnedStockAmount.setEnabled(isEnabled);
            }
            if (this.revisedStockAmount != null) {
                boolean e = isEnabled;
                if (this.enableRevisedAmount != null) {
                    e = this.enableRevisedAmount.isChecked() ? isEnabled : false;
                }
                this.revisedStockAmount.setEnabled(e);
            }
            if (this.enableRevisedAmount != null) {
                this.enableRevisedAmount.setEnabled(isEnabled);
            }
            if (this.deviceSalesAmount != null) {
                this.deviceSalesAmount.setEnabled(isEnabled);
            }
            if (this.complementarySalesAmount != null) {
                this.complementarySalesAmount.setEnabled(isEnabled);
            }
            if (this.crewSalesAmount != null) {
                this.crewSalesAmount.setEnabled(isEnabled);
            }
            if (this.discountSalesAmount != null) {
                this.discountSalesAmount.setEnabled(isEnabled);
            }
            if (this.soldStockAmount != null) {
                this.soldStockAmount.setEnabled(isEnabled);
            }
            if (this.wasteStockAmount != null) {
                this.wasteStockAmount.setEnabled(isEnabled);
            }
            if (this.missingStockAmount != null) {
                this.missingStockAmount.setEnabled(isEnabled);
            }
            if (this.tray != null) {
                this.tray.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.prodNo.kill();
            this.prodName.kill();
            if (this.eqName != null) {
                this.eqName.kill();
            }
            if (this.tray != null) {
                this.tray.kill();
            }
            if (this.deviceStockAmount != null) {
                this.deviceStockAmount.kill();
            }
            if (this.loadedStockAmount instanceof Killable) {
                ((Killable)((Object)this.loadedStockAmount)).kill();
            }
            if (this.returnedStockAmount instanceof Killable) {
                ((Killable)((Object)this.returnedStockAmount)).kill();
            }
            if (this.soldStockAmount != null && this.soldStockAmount instanceof Killable) {
                ((Killable)((Object)this.soldStockAmount)).kill();
            }
            if (this.wasteStockAmount != null && this.wasteStockAmount instanceof Killable) {
                ((Killable)((Object)this.wasteStockAmount)).kill();
            }
            if (this.revisedStockAmount instanceof Killable) {
                ((Killable)((Object)this.revisedStockAmount)).kill();
            }
            if (this.enableRevisedAmount instanceof Killable) {
                this.enableRevisedAmount.kill();
            }
            if (this.missingStockAmount instanceof Killable) {
                ((Killable)((Object)this.missingStockAmount)).kill();
            }
            if (this.deviceSalesAmount instanceof Killable) {
                ((Killable)((Object)this.deviceSalesAmount)).kill();
            }
            if (this.complementarySalesAmount instanceof Killable) {
                ((Killable)((Object)this.complementarySalesAmount)).kill();
            }
            if (this.crewSalesAmount instanceof Killable) {
                ((Killable)((Object)this.crewSalesAmount)).kill();
            }
            if (this.discountSalesAmount instanceof Killable) {
                ((Killable)((Object)this.discountSalesAmount)).kill();
            }
            this.prodNo = null;
            this.prodName = null;
            this.deviceStockAmount = null;
            this.eqName = null;
            this.deviceSalesAmount = null;
            this.complementarySalesAmount = null;
            this.crewSalesAmount = null;
            this.discountSalesAmount = null;
            this.loadedStockAmount = null;
            this.returnedStockAmount = null;
            this.soldStockAmount = null;
            this.wasteStockAmount = null;
            this.tray = null;
            this.revisedStockAmount = null;
            this.enableRevisedAmount = null;
            this.missingStockAmount = null;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private void validateRowState() {
            boolean isDutyFreeStyle = Boolean.TRUE.equals(this.model.getNode().getChildNamed(new DtoField[]{ReturnsCountProductComplete_.product, ProductComplete_.salesOnBoard}).getValue());
            ReturnsCountDrawerBasedSubModule.EditorType isManualSales = ((ReturnsBreadCrumbTable)ContentTable.this.master).getManager().isManualSales();
            boolean isRowValid = true;
            switch (isManualSales) {
                case MANUAL_SALES: {
                    int deviceSales = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.machineSalesAmount).getValue();
                    int crew = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.crewSalesAmount).getValue();
                    int complementary = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.complementarySalesAmount).getValue();
                    int discount = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.discountAmount).getValue();
                    if (deviceSales >= crew + complementary + discount) {
                        isRowValid = isRowValid;
                        break;
                    }
                    isRowValid = false;
                    break;
                }
                case RC_AND_MANUAL_SALES: {
                    int counted;
                    int deviceSales = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.machineSalesAmount).getValue();
                    int crew = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.crewSalesAmount).getValue();
                    int complementary = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.complementarySalesAmount).getValue();
                    int discount = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.discountAmount).getValue();
                    isRowValid = deviceSales >= crew + complementary + discount ? isRowValid : false;
                    if (isDutyFreeStyle) {
                        boolean invoiced = false;
                        int waste = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.wasteAmount).getValue();
                        int sold = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount).getValue();
                        int missing = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.missingAmount).getValue();
                        int loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.calculatedDeliveredAmount).getValue();
                        if (Boolean.TRUE.equals(this.model.getNode().getChildNamed(ReturnsCountProductComplete_.useRevisedDeliveredAmount).getValue())) {
                            loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.revisedDeliveredAmount).getValue();
                        }
                        if (sold + waste + missing > loaded) {
                            isRowValid = false;
                            break;
                        }
                        isRowValid = isRowValid;
                        break;
                    }
                    int loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.calculatedDeliveredAmount).getValue();
                    if (Boolean.TRUE.equals(this.model.getNode().getChildNamed(ReturnsCountProductComplete_.useRevisedDeliveredAmount).getValue())) {
                        loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.revisedDeliveredAmount).getValue();
                    }
                    if ((counted = ((Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount).getValue()).intValue()) > loaded) {
                        isRowValid = false;
                        break;
                    }
                    isRowValid = isRowValid;
                    break;
                }
                case RETURNS_COUNT_TRAY_BASED: 
                case RETURNS_COUNT_EQUIMENT_BASED: {
                    int counted;
                    if (isDutyFreeStyle) {
                        boolean invoiced = false;
                        int waste = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.wasteAmount).getValue();
                        int sold = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount).getValue();
                        int missing = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.missingAmount).getValue();
                        int loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.calculatedDeliveredAmount).getValue();
                        if (Boolean.TRUE.equals(this.model.getNode().getChildNamed(ReturnsCountProductComplete_.useRevisedDeliveredAmount).getValue())) {
                            loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.revisedDeliveredAmount).getValue();
                        }
                        if (sold + waste + missing > loaded) {
                            isRowValid = false;
                            break;
                        }
                        isRowValid = isRowValid;
                        break;
                    }
                    int loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.calculatedDeliveredAmount).getValue();
                    if (Boolean.TRUE.equals(this.model.getNode().getChildNamed(ReturnsCountProductComplete_.useRevisedDeliveredAmount).getValue())) {
                        loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.revisedDeliveredAmount).getValue();
                    }
                    if ((counted = ((Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount).getValue()).intValue()) > loaded) {
                        isRowValid = false;
                        break;
                    }
                    isRowValid = isRowValid;
                    break;
                }
            }
            if (isRowValid) {
                this.setRowValid();
            } else {
                this.setRowInvalid();
            }
        }

        @Override
        public void valueChanged(AbstractTextField field) {
            if (field.getText().isEmpty()) {
                return;
            }
            if (field == this.revisedStockAmount) {
                this.model.getNode().getChildNamed(ReturnsCountProductComplete_.useRevisedDeliveredAmount).setValue((Object)true, 0L);
            }
            boolean isDutyFreeStyle = Boolean.TRUE.equals(this.model.getNode().getChildNamed(new DtoField[]{ReturnsCountProductComplete_.product, ProductComplete_.salesOnBoard}).getValue());
            ReturnsCountDrawerBasedSubModule.EditorType isManualSales = ((ReturnsBreadCrumbTable)ContentTable.this.master).getManager().isManualSales();
            boolean isRowValid = true;
            block0 : switch (isManualSales) {
                case MANUAL_SALES: {
                    isRowValid = isRowValid && this.autoUpdateManualSales(isRowValid);
                    break;
                }
                case RC_AND_MANUAL_SALES: {
                    int deviceSales;
                    ReturnsCountProductComplete p;
                    switch (((ReturnsBreadCrumbTable)ContentTable.this.master).getManager().getCurrentEditorStyle()) {
                        case NONE: {
                            if (field == this.returnedStockAmount || field == this.soldStockAmount || field == this.wasteStockAmount || field == this.missingStockAmount) {
                                boolean bl = isRowValid = isRowValid && this.autoUpdateRC(field, isDutyFreeStyle, isRowValid);
                            }
                            if (field != this.deviceSalesAmount && field != this.crewSalesAmount && field != this.complementarySalesAmount && field != this.discountSalesAmount) break;
                            isRowValid = isRowValid && this.autoUpdateManualSales(isRowValid);
                            break;
                        }
                        case SALES: {
                            if (field == this.returnedStockAmount || field == this.soldStockAmount || field == this.wasteStockAmount || field == this.missingStockAmount) {
                                boolean bl = isRowValid = isRowValid && this.autoUpdateRC(field, isDutyFreeStyle, isRowValid);
                                if (isRowValid && Boolean.TRUE.equals((p = (ReturnsCountProductComplete)this.model.getNode().getValue()).getProduct().getSalesOnBoard())) {
                                    int waste = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.wasteAmount).getValue();
                                    int sold = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount).getValue();
                                    int missing = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.missingAmount).getValue();
                                    deviceSales = waste + sold + missing;
                                    int factor = ((ReturnsCountProductComplete)this.model.getNode().getValue()).getConversionFactor();
                                    if (factor <= 0) {
                                        factor = 1;
                                    }
                                    this.model.getNode().getChildNamed(ReturnsCountProductComplete_.machineSalesAmount).setValue((Object)(deviceSales *= factor), 0L);
                                    boolean bl2 = isRowValid = isRowValid && this.autoUpdateManualSales(isRowValid);
                                }
                            }
                            if (field != this.deviceSalesAmount && field != this.crewSalesAmount && field != this.complementarySalesAmount && field != this.discountSalesAmount) break;
                            isRowValid = isRowValid && this.autoUpdateManualSales(isRowValid);
                            break;
                        }
                        case RETURNS: {
                            if (field == this.deviceSalesAmount || field == this.crewSalesAmount || field == this.complementarySalesAmount || field == this.discountSalesAmount) {
                                boolean bl = isRowValid = isRowValid && this.autoUpdateManualSales(isRowValid);
                                if (isRowValid && (p = (ReturnsCountProductComplete)this.model.getNode().getValue()).getProduct().getReturnsCountType() != null && p.getProduct().getReturnsCountType().isCounted().booleanValue()) {
                                    deviceSales = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.machineSalesAmount).getValue();
                                    int factor = ((ReturnsCountProductComplete)this.model.getNode().getValue()).getConversionFactor();
                                    if (factor <= 0) {
                                        factor = 1;
                                    }
                                    deviceSales = (int)(((double)(deviceSales + (factor - 1)) + 0.5) / (double)factor);
                                    this.model.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount).setValue((Object)deviceSales, 0L);
                                    boolean bl3 = isRowValid = isRowValid && this.autoUpdateRC(field, isDutyFreeStyle, isRowValid);
                                }
                            }
                            if (field != this.returnedStockAmount && field != this.soldStockAmount && field != this.wasteStockAmount && field != this.missingStockAmount) break;
                            isRowValid = isRowValid && this.autoUpdateRC(field, isDutyFreeStyle, isRowValid);
                            break;
                        }
                    }
                    deviceSales = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.machineSalesAmount).getValue();
                    Integer crew = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.crewSalesAmount).getValue();
                    Integer complementary = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.complementarySalesAmount).getValue();
                    Integer discount = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.discountAmount).getValue();
                    p = (ReturnsCountProductComplete)this.model.getNode().getValue();
                    if (Boolean.TRUE.equals(p.getProduct().getSalesOnBoard())) {
                        int loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.calculatedDeliveredAmount).getValue();
                        if (Boolean.TRUE.equals(this.model.getNode().getChildNamed(ReturnsCountProductComplete_.useRevisedDeliveredAmount).getValue())) {
                            int nds;
                            loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.revisedDeliveredAmount).getValue();
                            int factor = ((ReturnsCountProductComplete)this.model.getNode().getValue()).getConversionFactor();
                            if (factor <= 0) {
                                factor = 1;
                            }
                            if ((nds = (int)(((double)(deviceSales + (factor - 1)) + 0.5) / (double)factor)) > loaded) {
                                isRowValid = false;
                            }
                        }
                    }
                    if (deviceSales >= crew + complementary + discount) {
                        isRowValid = isRowValid;
                        break;
                    }
                    isRowValid = false;
                    break;
                }
                case RETURNS_COUNT_TRAY_BASED: {
                    isRowValid = isRowValid && this.autoUpdateRC(field, isDutyFreeStyle, isRowValid);
                    switch (((ReturnsBreadCrumbTable)ContentTable.this.master).getManager().getCurrentEditorStyle()) {
                        case NONE: {
                            break block0;
                        }
                        case RETURNS: {
                            break block0;
                        }
                        case SALES: {
                            ReturnsCountProductComplete p = (ReturnsCountProductComplete)this.model.getNode().getValue();
                            if (!Boolean.TRUE.equals(p.getProduct().getSalesOnBoard())) break block0;
                            int waste = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.wasteAmount).getValue();
                            int sold = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount).getValue();
                            int missing = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.missingAmount).getValue();
                            int deviceSales = waste + sold + missing;
                            int factor = ((ReturnsCountProductComplete)this.model.getNode().getValue()).getConversionFactor();
                            if (factor <= 0) {
                                factor = 1;
                            }
                            this.model.getNode().getChildNamed(ReturnsCountProductComplete_.machineSalesAmount).setValue((Object)(deviceSales *= factor), 0L);
                            break block0;
                        }
                    }
                    break;
                }
                case RETURNS_COUNT_EQUIMENT_BASED: {
                    boolean bl = isRowValid = isRowValid && this.autoUpdateRC(field, isDutyFreeStyle, isRowValid);
                }
            }
            if (isRowValid) {
                this.setRowValid();
            } else {
                this.setRowInvalid();
            }
        }

        private boolean autoUpdateManualSales(boolean isRowValid) {
            int discount;
            int complementary;
            int crew;
            int deviceSales = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.machineSalesAmount).getValue();
            if (deviceSales < (crew = ((Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.crewSalesAmount).getValue()).intValue()) + (complementary = ((Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.complementarySalesAmount).getValue()).intValue()) + (discount = ((Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.discountAmount).getValue()).intValue())) {
                isRowValid = false;
            }
            return isRowValid;
        }

        private boolean autoUpdateRC(AbstractTextField field, boolean isDutyFreeStyle, boolean isRowValid) {
            if (isDutyFreeStyle) {
                boolean invoiced = false;
                int waste = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.wasteAmount).getValue();
                int sold = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount).getValue();
                int missing = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.missingAmount).getValue();
                int returned = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount).getValue();
                int loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.calculatedDeliveredAmount).getValue();
                if (Boolean.TRUE.equals(this.model.getNode().getChildNamed(ReturnsCountProductComplete_.useRevisedDeliveredAmount).getValue())) {
                    loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.revisedDeliveredAmount).getValue();
                }
                if (field != this.returnedStockAmount) {
                    returned = loaded - (waste + sold + missing);
                } else {
                    sold = loaded - (waste + returned + missing);
                }
                isRowValid = sold + waste + missing > loaded ? false : (sold >= 0 && waste >= 0 && missing >= 0 && returned >= 0 ? isRowValid : false);
                if (field == this.returnedStockAmount) {
                    this.model.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount).setValueSilent((Object)returned, true, 0L, null);
                } else {
                    this.model.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount).setValue((Object)returned, 0L);
                }
                if (field == this.soldStockAmount) {
                    this.model.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount).setValueSilent((Object)sold, true, 0L, null);
                } else {
                    this.model.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount).setValue((Object)sold, 0L);
                }
                if (field == this.wasteStockAmount) {
                    this.model.getNode().getChildNamed(ReturnsCountProductComplete_.wasteAmount).setValueSilent((Object)waste, true, 0L, null);
                } else {
                    this.model.getNode().getChildNamed(ReturnsCountProductComplete_.wasteAmount).setValue((Object)waste, 0L);
                }
                if (field == this.missingStockAmount) {
                    this.model.getNode().getChildNamed(ReturnsCountProductComplete_.missingAmount).setValueSilent((Object)missing, true, 0L, null);
                } else {
                    this.model.getNode().getChildNamed(ReturnsCountProductComplete_.missingAmount).setValue((Object)missing, 0L);
                }
            } else {
                int loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.calculatedDeliveredAmount).getValue();
                if (Boolean.TRUE.equals(this.model.getNode().getChildNamed(ReturnsCountProductComplete_.useRevisedDeliveredAmount).getValue())) {
                    loaded = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.revisedDeliveredAmount).getValue();
                }
                int counted = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount).getValue();
                int sold = (Integer)this.model.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount).getValue();
                sold = loaded - counted;
                if (sold < 0) {
                    sold = 0;
                }
                isRowValid = counted > loaded ? false : isRowValid;
                this.model.getNode().getChildNamed(ReturnsCountProductComplete_.soldAmount).setValue((Object)sold, 0L);
                if (field == this.returnedStockAmount) {
                    this.model.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount).setValueSilent((Object)counted, true, 0L, null);
                } else {
                    this.model.getNode().getChildNamed(ReturnsCountProductComplete_.countedAmount).setValue((Object)counted, 0L);
                }
            }
            return isRowValid;
        }

        private void setRowInvalid() {
            this.prodNo.setInvalid();
            this.prodName.setInvalid();
            if (this.eqName != null) {
                this.eqName.setInvalid();
            }
            if (this.tray != null) {
                this.tray.setInvalid();
            }
            if (this.loadedStockAmount instanceof Validatable) {
                ((Validatable)((Object)this.loadedStockAmount)).setInvalid();
            }
            if (this.revisedStockAmount instanceof Validatable) {
                ((Validatable)((Object)this.revisedStockAmount)).setInvalid();
            }
            if (this.soldStockAmount instanceof Validatable) {
                ((Validatable)((Object)this.soldStockAmount)).setInvalid();
            }
            if (this.wasteStockAmount instanceof Validatable) {
                ((Validatable)((Object)this.wasteStockAmount)).setInvalid();
            }
            if (this.returnedStockAmount instanceof Validatable) {
                ((Validatable)((Object)this.returnedStockAmount)).setInvalid();
            }
            if (this.missingStockAmount instanceof Validatable) {
                ((Validatable)((Object)this.missingStockAmount)).setInvalid();
            }
            if (this.deviceStockAmount != null) {
                this.deviceStockAmount.setInvalid();
            }
        }

        private void setRowValid() {
            this.prodNo.setValid();
            this.prodName.setValid();
            if (this.eqName != null) {
                this.eqName.setValid();
            }
            if (this.tray != null) {
                this.tray.setValid();
            }
            if (this.deviceStockAmount != null) {
                this.deviceStockAmount.setValid();
            }
            if (this.loadedStockAmount instanceof Validatable) {
                ((Validatable)((Object)this.loadedStockAmount)).setValid();
            }
            if (this.revisedStockAmount instanceof Validatable) {
                ((Validatable)((Object)this.revisedStockAmount)).setValid();
            }
            if (this.soldStockAmount instanceof Validatable) {
                ((Validatable)((Object)this.soldStockAmount)).setValid();
            }
            if (this.wasteStockAmount instanceof Validatable) {
                ((Validatable)((Object)this.wasteStockAmount)).setValid();
            }
            if (this.returnedStockAmount instanceof Validatable) {
                ((Validatable)((Object)this.returnedStockAmount)).setValid();
            }
            if (this.missingStockAmount instanceof Validatable) {
                ((Validatable)((Object)this.missingStockAmount)).setValid();
            }
        }

        private int getColumn4TextField(JTextField field) {
            ReturnsCountDrawerBasedSubModule.EditorType isManualSales = ((ReturnsBreadCrumbTable)ContentTable.this.master).getManager().isManualSales();
            switch (isManualSales) {
                case MANUAL_SALES: {
                    if (this.deviceSalesAmount instanceof TextField && ((TextField)this.deviceSalesAmount).getTextField().equals(field)) {
                        return 1;
                    }
                    if (this.complementarySalesAmount instanceof TextField && ((TextField)this.complementarySalesAmount).getTextField().equals(field)) {
                        return 2;
                    }
                    if (this.crewSalesAmount instanceof TextField && ((TextField)this.crewSalesAmount).getTextField().equals(field)) {
                        return 3;
                    }
                    if (!(this.discountSalesAmount instanceof TextField) || !((TextField)this.discountSalesAmount).getTextField().equals(field)) break;
                    return 4;
                }
                case RC_AND_MANUAL_SALES: {
                    if (this.revisedStockAmount instanceof TextField && ((TextField)this.revisedStockAmount).getTextField().equals(field)) {
                        return 1;
                    }
                    if (this.deviceSalesAmount instanceof TextField && ((TextField)this.deviceSalesAmount).getTextField().equals(field)) {
                        return 2;
                    }
                    if (this.complementarySalesAmount instanceof TextField && ((TextField)this.complementarySalesAmount).getTextField().equals(field)) {
                        return 3;
                    }
                    if (this.crewSalesAmount instanceof TextField && ((TextField)this.crewSalesAmount).getTextField().equals(field)) {
                        return 4;
                    }
                    if (this.discountSalesAmount instanceof TextField && ((TextField)this.discountSalesAmount).getTextField().equals(field)) {
                        return 5;
                    }
                    if (this.soldStockAmount instanceof TextField && ((TextField)this.soldStockAmount).getTextField().equals(field)) {
                        return 6;
                    }
                    if (this.wasteStockAmount instanceof TextField && ((TextField)this.wasteStockAmount).getTextField().equals(field)) {
                        return 7;
                    }
                    if (this.missingStockAmount instanceof TextField && ((TextField)this.missingStockAmount).getTextField().equals(field)) {
                        return 8;
                    }
                    if (!(this.returnedStockAmount instanceof TextField) || !((TextField)this.returnedStockAmount).getTextField().equals(field)) break;
                    return 9;
                }
                case RETURNS_COUNT_TRAY_BASED: 
                case RETURNS_COUNT_EQUIMENT_BASED: {
                    if (this.revisedStockAmount != null && this.revisedStockAmount instanceof TextField && ((TextField)this.revisedStockAmount).getTextField().equals(field)) {
                        return 1;
                    }
                    if (this.soldStockAmount instanceof TextField && ((TextField)this.soldStockAmount).getTextField().equals(field)) {
                        return 2;
                    }
                    if (this.wasteStockAmount instanceof TextField && ((TextField)this.wasteStockAmount).getTextField().equals(field)) {
                        return 3;
                    }
                    if (this.missingStockAmount instanceof TextField && ((TextField)this.missingStockAmount).getTextField().equals(field)) {
                        return 4;
                    }
                    if (!(this.returnedStockAmount instanceof TextField) || !((TextField)this.returnedStockAmount).getTextField().equals(field)) break;
                    return 5;
                }
            }
            return 0;
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 40) {
                ContentTable.this.selectLower(this, this.getColumn4TextField((JTextField)event.getSource()));
            } else if (event.getKeyCode() == 38) {
                ContentTable.this.selectUpper(this, this.getColumn4TextField((JTextField)event.getSource()));
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        protected boolean isEditing(int column) {
            ReturnsCountDrawerBasedSubModule.EditorType isManualSales = ((ReturnsBreadCrumbTable)ContentTable.this.master).getManager().isManualSales();
            switch (isManualSales) {
                case MANUAL_SALES: {
                    switch (column) {
                        case 1: {
                            if (!(this.deviceSalesAmount instanceof TextField)) break;
                            return true;
                        }
                        case 2: {
                            if (!(this.complementarySalesAmount instanceof TextField)) break;
                            return true;
                        }
                        case 3: {
                            if (!(this.crewSalesAmount instanceof TextField)) break;
                            return true;
                        }
                        case 4: {
                            if (!(this.discountSalesAmount instanceof TextField)) break;
                            return true;
                        }
                    }
                    break;
                }
                case RC_AND_MANUAL_SALES: {
                    switch (column) {
                        case 1: {
                            if (!(this.revisedStockAmount instanceof TextField)) break;
                            return true;
                        }
                        case 2: {
                            if (!(this.deviceSalesAmount instanceof TextField)) break;
                            return true;
                        }
                        case 3: {
                            if (!(this.complementarySalesAmount instanceof TextField)) break;
                            return true;
                        }
                        case 4: {
                            if (!(this.crewSalesAmount instanceof TextField)) break;
                            return true;
                        }
                        case 5: {
                            if (!(this.discountSalesAmount instanceof TextField)) break;
                            return true;
                        }
                        case 6: {
                            if (!(this.soldStockAmount instanceof TextField)) break;
                            return true;
                        }
                        case 7: {
                            if (!(this.wasteStockAmount instanceof TextField)) break;
                            return true;
                        }
                        case 8: {
                            if (!(this.missingStockAmount instanceof TextField)) break;
                            return true;
                        }
                        case 9: {
                            if (!(this.returnedStockAmount instanceof TextField)) break;
                            return true;
                        }
                    }
                    break;
                }
                case RETURNS_COUNT_TRAY_BASED: {
                    switch (column) {
                        case 1: {
                            if (!(this.revisedStockAmount instanceof TextField)) break;
                            return true;
                        }
                        case 2: {
                            if (!(this.soldStockAmount instanceof TextField)) break;
                            return true;
                        }
                        case 3: {
                            if (!(this.wasteStockAmount instanceof TextField)) break;
                            return true;
                        }
                        case 4: {
                            if (!(this.missingStockAmount instanceof TextField)) break;
                            return true;
                        }
                        case 5: {
                            if (!(this.returnedStockAmount instanceof TextField)) break;
                            return true;
                        }
                    }
                    break;
                }
                case RETURNS_COUNT_EQUIMENT_BASED: {
                    switch (column) {
                        case 1: {
                            if (!(this.revisedStockAmount instanceof TextField)) break;
                            return true;
                        }
                        case 2: {
                            if (!(this.soldStockAmount instanceof TextField)) break;
                            return true;
                        }
                        case 3: {
                            if (!(this.wasteStockAmount instanceof TextField)) break;
                            return true;
                        }
                        case 4: {
                            if (!(this.missingStockAmount instanceof TextField)) break;
                            return true;
                        }
                        case 5: {
                            if (!(this.returnedStockAmount instanceof TextField)) break;
                            return true;
                        }
                    }
                    break;
                }
            }
            return false;
        }

        public void takeFocusAt(int column) {
            ReturnsCountDrawerBasedSubModule.EditorType isManualSales = ((ReturnsBreadCrumbTable)ContentTable.this.master).getManager().isManualSales();
            switch (isManualSales) {
                case MANUAL_SALES: {
                    switch (column) {
                        case 1: {
                            if (!(this.deviceSalesAmount instanceof TextField)) break;
                            ((TextField)this.deviceSalesAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 2: {
                            if (!(this.complementarySalesAmount instanceof TextField)) break;
                            ((TextField)this.complementarySalesAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 3: {
                            if (!(this.crewSalesAmount instanceof TextField)) break;
                            ((TextField)this.crewSalesAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 4: {
                            if (!(this.discountSalesAmount instanceof TextField)) break;
                            ((TextField)this.discountSalesAmount).requestFocusInWindowNow();
                        }
                    }
                    break;
                }
                case RC_AND_MANUAL_SALES: {
                    switch (column) {
                        case 1: {
                            if (!(this.revisedStockAmount instanceof TextField)) break;
                            ((TextField)this.revisedStockAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 2: {
                            if (!(this.deviceSalesAmount instanceof TextField)) break;
                            ((TextField)this.deviceSalesAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 3: {
                            if (!(this.complementarySalesAmount instanceof TextField)) break;
                            ((TextField)this.complementarySalesAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 4: {
                            if (!(this.crewSalesAmount instanceof TextField)) break;
                            ((TextField)this.crewSalesAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 5: {
                            if (!(this.discountSalesAmount instanceof TextField)) break;
                            ((TextField)this.discountSalesAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 6: {
                            if (!(this.soldStockAmount instanceof TextField)) break;
                            ((TextField)this.soldStockAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 7: {
                            if (!(this.wasteStockAmount instanceof TextField)) break;
                            ((TextField)this.wasteStockAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 8: {
                            if (!(this.missingStockAmount instanceof TextField)) break;
                            ((TextField)this.missingStockAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 9: {
                            if (!(this.returnedStockAmount instanceof TextField)) break;
                            ((TextField)this.returnedStockAmount).requestFocusInWindowNow();
                        }
                    }
                    break;
                }
                case RETURNS_COUNT_TRAY_BASED: {
                    switch (column) {
                        case 1: {
                            if (!(this.revisedStockAmount instanceof TextField)) break;
                            ((TextField)this.revisedStockAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 2: {
                            if (!(this.soldStockAmount instanceof TextField)) break;
                            ((TextField)this.soldStockAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 3: {
                            if (!(this.wasteStockAmount instanceof TextField)) break;
                            ((TextField)this.wasteStockAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 4: {
                            if (!(this.missingStockAmount instanceof TextField)) break;
                            ((TextField)this.missingStockAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 5: {
                            if (!(this.returnedStockAmount instanceof TextField)) break;
                            ((TextField)this.returnedStockAmount).requestFocusInWindowNow();
                        }
                    }
                    break;
                }
                case RETURNS_COUNT_EQUIMENT_BASED: {
                    switch (column) {
                        case 1: {
                            if (!(this.revisedStockAmount instanceof TextField)) break;
                            ((TextField)this.revisedStockAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 2: {
                            if (!(this.soldStockAmount instanceof TextField)) break;
                            ((TextField)this.soldStockAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 3: {
                            if (!(this.wasteStockAmount instanceof TextField)) break;
                            ((TextField)this.wasteStockAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 4: {
                            if (!(this.missingStockAmount instanceof TextField)) break;
                            ((TextField)this.missingStockAmount).requestFocusInWindowNow();
                            break;
                        }
                        case 5: {
                            if (!(this.returnedStockAmount instanceof TextField)) break;
                            ((TextField)this.returnedStockAmount).requestFocusInWindowNow();
                        }
                    }
                    break;
                }
            }
        }

        private class TableRowLayout
        extends DefaultLayout {
            private TableRowLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = ComponentRow.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                ComponentRow.this.prodNo.setLocation(currentX + ComponentRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.prodNo.getPreferredSize().getHeight()) / 2.0));
                ComponentRow.this.prodNo.setSize(w - 2 * ComponentRow.this.getCellPadding(), (int)ComponentRow.this.prodNo.getPreferredSize().getHeight());
                currentX += w;
                w = ComponentRow.this.getModel().getParentModel().getColumnWidth(1);
                ComponentRow.this.prodName.setLocation(currentX + ComponentRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.prodName.getPreferredSize().getHeight()) / 2.0));
                ComponentRow.this.prodName.setSize(w - 2 * ComponentRow.this.getCellPadding(), (int)ComponentRow.this.prodName.getPreferredSize().getHeight());
                int labelOffset = 9;
                switch (((ReturnsBreadCrumbTable)ContentTable.this.master).getManager().isManualSales()) {
                    case MANUAL_SALES: {
                        int cx;
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(2);
                        if (ComponentRow.this.eqName != null) {
                            ComponentRow.this.eqName.setLocation(currentX + ComponentRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.eqName.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.eqName.setSize(w - 2 * ComponentRow.this.getCellPadding(), (int)ComponentRow.this.eqName.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(3);
                        if (ComponentRow.this.deviceSalesAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.deviceSalesAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.deviceSalesAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.deviceSalesAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.deviceSalesAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.deviceSalesAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(4);
                        if (ComponentRow.this.complementarySalesAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.complementarySalesAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.complementarySalesAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.complementarySalesAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.complementarySalesAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.complementarySalesAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(5);
                        if (ComponentRow.this.crewSalesAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.crewSalesAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.crewSalesAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.crewSalesAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.crewSalesAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.crewSalesAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(6);
                        if (ComponentRow.this.discountSalesAmount == null) break;
                        cx = currentX + ComponentRow.this.getCellPadding();
                        if (ComponentRow.this.discountSalesAmount instanceof TextLabel) {
                            cx += labelOffset;
                        }
                        ComponentRow.this.discountSalesAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.discountSalesAmount.getPreferredSize().getHeight()) / 2.0));
                        ComponentRow.this.discountSalesAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.discountSalesAmount.getPreferredSize().getHeight());
                        break;
                    }
                    case RC_AND_MANUAL_SALES: {
                        int cx;
                        int i = 2;
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.tray != null) {
                            ComponentRow.this.tray.setLocation(currentX + ComponentRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.tray.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.tray.setSize(w - 2 * ComponentRow.this.getCellPadding(), (int)ComponentRow.this.tray.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.revisedStockAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.enableRevisedAmount != null) {
                                ComponentRow.this.enableRevisedAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.enableRevisedAmount.getPreferredSize().getHeight()) / 2.0));
                                ComponentRow.this.enableRevisedAmount.setSize(ComponentRow.this.enableRevisedAmount.getPreferredSize());
                                cx = (int)((double)cx + (ComponentRow.this.enableRevisedAmount.getPreferredSize().getWidth() + (double)ComponentRow.this.getInnerCellPadding()));
                            }
                            if (ComponentRow.this.revisedStockAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.revisedStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.revisedStockAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.revisedStockAmount.setSize(w - (labelOffset + ComponentRow.this.getInnerCellPadding() + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.revisedStockAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.deviceSalesAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.deviceSalesAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.deviceSalesAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.deviceSalesAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.deviceSalesAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.deviceSalesAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.complementarySalesAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.complementarySalesAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.complementarySalesAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.complementarySalesAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.complementarySalesAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.complementarySalesAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.crewSalesAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.crewSalesAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.crewSalesAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.crewSalesAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.crewSalesAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.crewSalesAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.discountSalesAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.discountSalesAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.discountSalesAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.discountSalesAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.discountSalesAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.discountSalesAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.soldStockAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.soldStockAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.soldStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.soldStockAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.soldStockAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.soldStockAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.wasteStockAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.wasteStockAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.wasteStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.wasteStockAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.wasteStockAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.wasteStockAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.missingStockAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.missingStockAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.missingStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.missingStockAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.missingStockAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.missingStockAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.returnedStockAmount == null) break;
                        cx = currentX + ComponentRow.this.getCellPadding();
                        if (ComponentRow.this.returnedStockAmount instanceof TextLabel) {
                            cx += labelOffset;
                        }
                        ComponentRow.this.returnedStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.returnedStockAmount.getPreferredSize().getHeight()) / 2.0));
                        ComponentRow.this.returnedStockAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.returnedStockAmount.getPreferredSize().getHeight());
                        break;
                    }
                    case RETURNS_COUNT_TRAY_BASED: {
                        int cx;
                        int i = 2;
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.tray != null) {
                            ComponentRow.this.tray.setLocation(currentX + ComponentRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.tray.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.tray.setSize(w - 2 * ComponentRow.this.getCellPadding(), (int)ComponentRow.this.tray.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.loadedStockAmount != null) {
                            ComponentRow.this.loadedStockAmount.setLocation(currentX + ComponentRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.loadedStockAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.loadedStockAmount.setSize(w - 2 * ComponentRow.this.getCellPadding(), (int)ComponentRow.this.loadedStockAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        int checkSpace = 0;
                        if (ComponentRow.this.enableRevisedAmount != null) {
                            ComponentRow.this.enableRevisedAmount.setLocation(currentX + ComponentRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.enableRevisedAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.enableRevisedAmount.setSize(ComponentRow.this.enableRevisedAmount.getPreferredSize());
                            checkSpace = ComponentRow.this.enableRevisedAmount.getWidth() + ComponentRow.this.getInnerCellPadding();
                        }
                        if (ComponentRow.this.revisedStockAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding() + ComponentRow.this.enableRevisedAmount.getWidth() + ComponentRow.this.getInnerCellPadding();
                            ComponentRow.this.revisedStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.revisedStockAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.revisedStockAmount.setSize(w - (2 * ComponentRow.this.getCellPadding() + checkSpace), (int)ComponentRow.this.revisedStockAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.soldStockAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.soldStockAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.soldStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.soldStockAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.soldStockAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.soldStockAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.wasteStockAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.wasteStockAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.wasteStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.wasteStockAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.wasteStockAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.wasteStockAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.missingStockAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.missingStockAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.missingStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.missingStockAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.missingStockAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.missingStockAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.returnedStockAmount == null) break;
                        cx = currentX + ComponentRow.this.getCellPadding();
                        if (ComponentRow.this.returnedStockAmount instanceof TextLabel) {
                            cx += labelOffset;
                        }
                        ComponentRow.this.returnedStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.returnedStockAmount.getPreferredSize().getHeight()) / 2.0));
                        ComponentRow.this.returnedStockAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.returnedStockAmount.getPreferredSize().getHeight());
                        break;
                    }
                    case RETURNS_COUNT_EQUIMENT_BASED: {
                        int cx;
                        int i = 2;
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.loadedStockAmount != null) {
                            ComponentRow.this.loadedStockAmount.setLocation(currentX + ComponentRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ComponentRow.this.loadedStockAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.loadedStockAmount.setSize(w - 2 * ComponentRow.this.getCellPadding(), (int)ComponentRow.this.loadedStockAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.soldStockAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.soldStockAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.soldStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.soldStockAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.soldStockAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.soldStockAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.wasteStockAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.wasteStockAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.wasteStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.wasteStockAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.wasteStockAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.wasteStockAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.missingStockAmount != null) {
                            cx = currentX + ComponentRow.this.getCellPadding();
                            if (ComponentRow.this.missingStockAmount instanceof TextLabel) {
                                cx += labelOffset;
                            }
                            ComponentRow.this.missingStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.missingStockAmount.getPreferredSize().getHeight()) / 2.0));
                            ComponentRow.this.missingStockAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.missingStockAmount.getPreferredSize().getHeight());
                        }
                        currentX += w;
                        w = ComponentRow.this.getModel().getParentModel().getColumnWidth(i++);
                        if (ComponentRow.this.returnedStockAmount == null) break;
                        cx = currentX + ComponentRow.this.getCellPadding();
                        if (ComponentRow.this.returnedStockAmount instanceof TextLabel) {
                            cx += labelOffset;
                        }
                        ComponentRow.this.returnedStockAmount.setLocation(cx, (int)(((double)parent.getHeight() - ComponentRow.this.returnedStockAmount.getPreferredSize().getHeight()) / 2.0));
                        ComponentRow.this.returnedStockAmount.setSize(w - (labelOffset + 2 * ComponentRow.this.getCellPadding()), (int)ComponentRow.this.returnedStockAmount.getPreferredSize().getHeight());
                        break;
                    }
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, ComponentRow.this.getDefaultRowHeight());
            }
        }
    }
}

