/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbGroupTable;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.ReturnsBreadCrumbTable;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils.NavigationConverter;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils.SealRegisterPopup2;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel2Rows;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.StockTransactionRemarkButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.EnterMessagePopupInsert;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountEquipmentComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetTypeE;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryLight;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class EquipementTable
extends BreadCrumbGroupTable {
    private static final long serialVersionUID = 1L;
    private boolean isFlightDispatched;

    public EquipementTable(IDataHandler dataHandler, BreadCrumbPanel master) {
        super(dataHandler, master, "", null);
        this.disableTitle();
    }

    public void setFlightDispatched(boolean isFlightDispatched) {
        this.isFlightDispatched = isFlightDispatched;
    }

    @Override
    public Table2HeaderPanel getHeaderRow(Table2RowModel model) {
        return new Table2HeaderPanel2Rows(model, 7);
    }

    @Override
    public int getSortingIndex() {
        return 0;
    }

    @Override
    public boolean hasAddButton() {
        return false;
    }

    public ArrayList<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        String columnName = "";
        switch (((ReturnsBreadCrumbTable)this.master).getManager().isManualSales()) {
            case MANUAL_SALES: {
                columnName = Words.CATEGORY;
                break;
            }
            case RC_AND_MANUAL_SALES: 
            case RETURNS_COUNT_TRAY_BASED: 
            case RETURNS_COUNT_EQUIMENT_BASED: {
                columnName = Words.EQUIPMENT;
                break;
            }
        }
        columns.add(new TableColumnInfo(columnName, null, null, null, "", 130, 130, 180));
        int i = StockTransactionRemarkButton.getPreferredWidth() + 2 * this.table.getCellPadding() + this.table.getInnerCellPadding() + EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", i, i, i));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        return columns;
    }

    @Override
    public Table2RowPanel getGroupTableRow(Table2RowModel model, boolean isHeader) {
        return new GroupTableRow(model);
    }

    @Override
    public Comparator<?> getGroupComparator() {
        return null;
    }

    public Converter getTitleConverter() {
        return ConverterRegistry.getConverter(NavigationConverter.class);
    }

    @Override
    public void addButtonPressed() {
    }

    @Override
    public void childRemoved() {
    }

    private class GroupTableRow
    extends Table2RowPanel
    implements ButtonListener,
    InnerPopUpListener2 {
        private static final long serialVersionUID = 1L;
        private TextLabel name;
        private EditButton sealButton;
        private StockTransactionRemarkButton remark;

        public GroupTableRow(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.TWO);
            this.setSelectable(true);
            this.setLayout(new MasterRowPanelLayout());
            if (m.getNode().getValue() instanceof ReturnsCountEquipmentComplete) {
                GalleyEquipmentSetTypeE type;
                Node nn = INodeCreator.getDefaultImpl().getNode4DTO(m.getNode().getValue(), false, false);
                Node n = nn.getChildNamed(ReturnsCountEquipmentComplete_.equipment);
                String n1 = (String)n.getChildNamed(GalleyEquipmentComplete_.equipmentName).getValue();
                if (n1 == null || n1.isEmpty()) {
                    n1 = (String)n.getChildNamed(GalleyEquipmentComplete_.positionCode).getValue();
                }
                if ((type = (GalleyEquipmentSetTypeE)n.getChildNamed(GalleyEquipmentComplete_.equipmentSetType).getValue()) == GalleyEquipmentSetTypeE.CABINE) {
                    n1 = n1 + " (CABIN)";
                } else if (type == GalleyEquipmentSetTypeE.HOLD) {
                    n1 = n1 + " (HOLD)";
                }
                this.name = new TextLabel(n1);
                this.sealButton = new EditButton();
                this.sealButton.addButtonListener(this);
                this.remark = new StockTransactionRemarkButton(false, null);
                this.remark.addButtonListener(this);
                this.add(this.remark);
                this.add(this.sealButton);
            } else if (m.getNode().getValue() instanceof ProductCategoryLight) {
                Node nn = INodeCreator.getDefaultImpl().getNode4DTO(m.getNode().getValue(), false, false);
                String n1 = (String)nn.getChildNamed(ProductCategoryLight_.name).getValue();
                this.name = new TextLabel(n1);
            } else {
                this.name = new TextLabel("All");
            }
            this.add(this.name);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.name.getText();
                }
                case 1: {
                    return "";
                }
            }
            return null;
        }

        @Override
        public Component getFocusDelegationComponent() {
            if (this.name == null) {
                return null;
            }
            return null;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.sealButton != null) {
                this.sealButton.requestFocusInWindowNow();
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.remark != null) {
                this.remark.kill();
            }
            this.remark = null;
            this.name.kill();
            this.name = null;
            if (this.sealButton != null) {
                this.sealButton.kill();
            }
            this.sealButton = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.name.setEnabled(isEnabled);
            boolean remarkEditable = EquipementTable.this.isFlightDispatched;
            boolean sealEditable = true;
            if (this.remark != null) {
                this.remark.setEnabled(isEnabled && remarkEditable);
            }
            if (this.sealButton != null) {
                this.sealButton.setEnabled(isEnabled && sealEditable);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.sealButton);
            CheckedListAdder.addToList(a, this.remark);
            return a;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.remark) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, "Remark");
                popUp.setView(new EnterMessagePopupInsert(this.model.getNode().getChildNamed(new String[]{"returnsCountRemark"})));
                popUp.showPopUp(x, y, 450, (int)popUp.getView().getPreferredSize().getHeight(), this, source, PopupType.NORMAL);
            } else if (source == this.sealButton) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, "Config");
                popUp.setView(new SealRegisterPopup2((Node<ReturnsCountEquipmentComplete>)this.model.getNode()));
                popUp.showPopUp(x, y, 550, (int)popUp.getView().getPreferredSize().getHeight(), this, source, PopupType.NORMAL);
            }
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        }

        private class MasterRowPanelLayout
        extends DefaultLayout {
            private MasterRowPanelLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = GroupTableRow.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                GroupTableRow.this.name.setLocation(GroupTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - GroupTableRow.this.name.getPreferredSize().getHeight()) / 2.0));
                GroupTableRow.this.name.setSize(w - 2 * GroupTableRow.this.getCellPadding(), (int)GroupTableRow.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = GroupTableRow.this.getModel().getParentModel().getColumnWidth(1);
                GroupTableRow.this.setControlsX(currentX);
                int cx = 0;
                if (GroupTableRow.this.sealButton != null) {
                    GroupTableRow.this.sealButton.setLocation(currentX + GroupTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - GroupTableRow.this.sealButton.getPreferredSize().getHeight()) / 2.0));
                    GroupTableRow.this.sealButton.setSize(GroupTableRow.this.sealButton.getPreferredSize());
                    cx = GroupTableRow.this.sealButton.getX() + GroupTableRow.this.sealButton.getWidth();
                }
                if (GroupTableRow.this.remark != null) {
                    GroupTableRow.this.remark.setLocation(cx + GroupTableRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - GroupTableRow.this.remark.getPreferredSize().getHeight()) / 2.0));
                    GroupTableRow.this.remark.setSize(GroupTableRow.this.remark.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, GroupTableRow.this.getDefaultRowHeight());
            }
        }
    }
}

