/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.utils.animators.Movable;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.animators.Resizable;
import ch.icit.pegasus.client.gui.utils.animators.Resizer;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;

public abstract class AbstractGalleyBoxEditor
extends JPanelFadable
implements Movable,
Resizable {
    private static final long serialVersionUID = 1L;
    public static final int STATE_EDITLABEL = 3;
    public static final int STATE_JOIN = 5;
    public static final int STATE_SPLIT = 7;
    public static final int STATE_NONE = 11;
    protected Button currentIcon;
    protected Mover<AbstractGalleyBoxEditor> mover;
    protected Resizer<AbstractGalleyBoxEditor> resizer;
    protected boolean isSplitUse;
    protected boolean isUpperSelect;
    protected Area substractArea;
    private int innerOffset;
    protected PegasusSubModule pegasus;
    protected boolean isSubGalley;

    public abstract int getXOffset();

    public abstract int getYOffset();

    public abstract void setState(int var1);

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.currentIcon != null) {
            this.currentIcon.kill();
        }
        this.currentIcon = null;
        this.mover.deregister();
        this.mover = null;
        this.resizer.deregister();
        this.resizer = null;
        this.substractArea = null;
        this.pegasus = null;
    }

    public PegasusSubModule getPegasus() {
        return this.pegasus;
    }

    public int getHalfIconWidth() {
        return 0;
    }

    protected void setInnerOffset(int off) {
        this.innerOffset = off;
    }

    public void setSubGalley(boolean isSubGalley) {
        this.isSubGalley = isSubGalley;
    }

    public void setSubstractArea(Area substractArea) {
        this.substractArea = substractArea;
    }

    public void setSplitUse(boolean isSplitUse) {
        this.isSplitUse = isSplitUse;
    }

    public void setUpperSelect(boolean isUpperSelect) {
        this.isUpperSelect = isUpperSelect;
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize((int)d.getWidth(), (int)d.getHeight());
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        int dw = this.getXOffset();
        int dh = this.getYOffset();
        Shape backShape = g2.getClip();
        if (this.substractArea != null) {
            Area a = new Area(g2.getClip());
            a.subtract(this.substractArea);
            a.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, dw, dh));
            g2.setClip(a);
        }
        g2.setColor(Color.WHITE);
        if (this.isSplitUse) {
            if (this.isUpperSelect) {
                g2.drawLine(dw, dh, this.getWidth() - (dw + 1), dh);
                g2.drawLine(this.getWidth() - (dw + 1), dh, dw, this.getHeight() - (dh + 1));
                g2.drawLine(dw, this.getHeight() - (dh + 1), dw, dh);
            } else {
                g2.drawLine(this.getWidth() - (dw + 1), dh, this.getWidth() - (dw + 1), this.getHeight() - (dh + 1));
                g2.drawLine(this.getWidth() - (dw + 1), this.getHeight() - (dh + 1), dw, this.getHeight() - (dh + 1));
                g2.drawLine(dw, this.getHeight() - (dh + 1), this.getWidth() - (dw + 1), dh);
            }
        } else {
            int cw = this.getWidth() - (2 * dw + 1 + this.getXEndOffset());
            int ch = this.getHeight() - (2 * dh + 1 + this.getYEndOffset());
            if (this.isSubGalley) {
                cw = this.getWidth() - (dw + 1) - this.getXEndOffset();
                ch = this.getHeight() - (dh + 1) - this.innerOffset - this.getYEndOffset();
            }
            g2.drawRect(dw, dh, cw, ch);
        }
        if (this.substractArea != null) {
            g2.setClip(backShape);
        }
        this.paintChildren(g2);
    }

    public void setLabelActive(Boolean value) {
    }

    public int getXEndOffset() {
        return 0;
    }

    public int getYEndOffset() {
        return 0;
    }
}

