/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.GalleyEquipmentInsertTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusGalleyModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.equipmentconf.GalleyEquipmentModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.Galley;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyGridPanel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GridSpace;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.FadeInOutPanel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.SelectableItem;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.TopLevelRepainter;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.logic.ClassConverter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.FadebleShape;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.EquipmentMarkerSkin;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.StowagePositionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentInsertComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentReservedSpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.Color3DComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Dimension3dComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StowagePositionTypeComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.util.Iterator;
import javax.swing.Timer;

public class GalleyBox
extends FadeInOutPanel
implements MouseMotionListener,
SelectableItem,
NodeListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private Node<?> theNode;
    private Node<Double> theXSizeNode;
    private Node<Double> theYSizeNode;
    private Node<Double> theZSizeNode;
    private Node<Double> theXCoord;
    private Node<Double> theYCoord;
    private Node<Double> theZCoord;
    private Node<String> theNameNode;
    private Node<String> theSecondName;
    private Node<?> typeNode;
    private Node<Boolean> hasLabel;
    private Point theBackupPoint;
    private boolean isDragging = false;
    private int isSelected = 7;
    private boolean isDraggable = true;
    private boolean isSpecialState = false;
    private GalleyGridPanel theGalley;
    private Point theDragStartPoint;
    private boolean isShadowExpansion;
    private PegasusSubModule pegasus;
    private Skin1Field stowedSkin;
    private boolean isResizable;
    private FadebleShape serviceInsertShape;
    private GridSpace dragingGridSpace;
    private boolean isSecondTrolley;
    private GalleyBox theBehindBox;
    private GalleyBox theFrontBox;
    private TextField nameEnterField;
    private boolean useAlternatives;
    private Node<?> alternativesNode;
    private Node<?> defaultNode;
    private Node<?> altNameA;
    private Node<?> altNameB;
    private TextField altNameAEnterField;
    private TextField altNameBEnterField;
    private TextLabel altNameALabel;
    private TextLabel altNameBLabel;
    private TextLabel nameLabel;
    private TextLabel nameLabel2;
    private boolean isHighLight;
    private boolean isUpperBoxSelected;
    private int useInset = 0;
    private boolean hasEditor = false;
    private boolean isServiceSpace;
    private int isResizeState = 0;
    private Mover<GalleyBox> mover;
    private boolean isValid = true;
    private Color backgroundColor;
    private boolean isLose;

    public GalleyBox(PegasusSubModule pegasus, Node<?> node, GalleyGridPanel g, boolean isLose) {
        super(false);
        this.isLose = isLose;
        this.pegasus = pegasus;
        this.theNode = node;
        this.theGalley = g;
        this.lafAttributeChanged("All attribues changed");
        this.install();
    }

    public GalleyBox(PegasusSubModule pegasus, Node<?> node, GalleyGridPanel g) {
        this(pegasus, node, g, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean isNameEnterFieldAction = false;
        if (this.nameEnterField != null && e.getSource() == this.nameEnterField.getTextField()) {
            isNameEnterFieldAction = true;
        } else if (this.altNameAEnterField != null && e.getSource() == this.altNameAEnterField.getTextField()) {
            isNameEnterFieldAction = true;
        } else if (this.altNameBEnterField != null && e.getSource() == this.altNameBEnterField.getTextField()) {
            isNameEnterFieldAction = true;
        }
        if (isNameEnterFieldAction) {
            this.enableNameEdit(false, true);
        } else {
            super.actionPerformed(e);
        }
    }

    public void useInset(int u) {
        if (this.useInset != u) {
            this.useInset = u;
            this.setSize(this.getWidth(), this.getHeight());
        }
    }

    public void setEditorEnabled(boolean hasEditor) {
        this.hasEditor = hasEditor;
    }

    public void setBehindBox(GalleyBox bb) {
        this.theBehindBox = bb;
    }

    protected boolean ensureFocusOnNameEnterField(int x, int y) {
        if (this.nameLabel != null && this.nameLabel.getBounds().contains(x, y)) {
            if (this.nameEnterField == null) {
                this.enableNameEdit(true, false);
                this.nameEnterField.requestFocusInWindowNow();
                return true;
            }
        } else if (this.altNameALabel != null && this.altNameALabel.getBounds().contains(x, y)) {
            if (this.altNameAEnterField == null) {
                this.ensureAlternatives(true, 1);
                if (this.altNameAEnterField != null) {
                    this.altNameAEnterField.requestFocusInWindowNow();
                }
                return true;
            }
        } else if (this.altNameBLabel != null && this.altNameBLabel.getBounds().contains(x, y) && this.altNameBEnterField == null) {
            this.ensureAlternatives(true, 2);
            if (this.altNameAEnterField != null) {
                this.altNameBEnterField.requestFocusInWindowNow();
            }
            return true;
        }
        return false;
    }

    public boolean isUseAlternatives() {
        return this.useAlternatives;
    }

    public void enableNameEdit(boolean b, boolean doEnsure) {
        if (b) {
            if (this.nameEnterField == null) {
                this.nameEnterField = new TextField(this.theNameNode);
                this.nameEnterField.addActionListener(this);
                this.nameEnterField.getTextField().setHorizontalAlignment(0);
                this.nameEnterField.setSize(this.getWidth() - 10, 0);
                this.nameEnterField.setLocation((this.getWidth() - this.nameEnterField.getWidth()) / 2, (this.getHeight() - this.nameEnterField.getHeight()) / 2);
                if (this.getBoxNode().getValue() instanceof GalleyEquipmentInsertComplete) {
                    this.nameEnterField.setPaintTexture(false);
                } else {
                    this.nameEnterField.setPaintTexture(true);
                }
                this.add(this.nameEnterField);
                this.nameEnterField.getTextField().addFocusListener(this);
                if (doEnsure) {
                    this.ensureAlternatives(true, 0);
                }
            }
            if (this.nameLabel != null) {
                this.nameLabel.setVisible(false);
            }
        } else {
            if (this.nameEnterField != null) {
                this.nameEnterField.fadeOut(true);
                this.nameEnterField.removeActionListener(this);
                this.nameEnterField.getTextField().removeFocusListener(this);
                this.nameEnterField = null;
            }
            if (this.altNameAEnterField != null) {
                this.altNameAEnterField.fadeOut(true);
                this.altNameAEnterField.getTextField().removeFocusListener(this);
                this.altNameAEnterField = null;
            }
            if (this.altNameBEnterField != null) {
                this.altNameBEnterField.fadeOut(true);
                this.altNameBEnterField.getTextField().removeFocusListener(this);
                this.altNameBEnterField = null;
            }
            if (this.altNameALabel != null) {
                this.altNameALabel.setVisible(true);
            }
            if (this.altNameBLabel != null) {
                this.altNameBLabel.setVisible(true);
            }
            if (!this.useAlternatives || this.theGalley.getModel().getPegasusState() == 3) {
                int ay;
                int aWidth;
                if (this.theGalley.isSubGrid()) {
                    // empty if block
                }
                if (this.nameLabel == null && this.theNameNode != null) {
                    this.nameLabel = new TextLabel(this.theNameNode);
                    if (this.theGalley.getModel().getPegasusState() == 7) {
                        this.nameLabel.setDelegateComponent(this);
                    }
                    if (this.theGalley.isSubGrid()) {
                        this.nameLabel.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("stw_tray_name_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
                    }
                    this.nameLabel.setAlignment(0);
                    aWidth = (int)this.nameLabel.getPreferredSize().getWidth();
                    aWidth = this.getWidth() - 8;
                    this.nameLabel.setSize(aWidth, (int)this.nameLabel.getPreferredSize().getHeight());
                    ay = (this.getHeight() - this.nameLabel.getHeight()) / 2;
                    if (this.theGalley.isSubGrid() && this.theSecondName != null) {
                        ay = (int)((double)((this.getHeight() - this.nameLabel.getHeight()) / 2) - this.nameLabel.getPreferredSize().getHeight() / 2.0);
                    }
                    this.nameLabel.setLocation((this.getWidth() - this.nameLabel.getWidth()) / 2, ay);
                    this.add((Component)this.nameLabel, 0);
                    this.nameLabel.setProgress(1.0f);
                    this.nameLabel.setVisible(true);
                } else if (this.nameLabel != null) {
                    aWidth = (int)this.nameLabel.getPreferredSize().getWidth();
                    this.nameLabel.setNode((Node)this.theNameNode);
                    aWidth = this.getWidth() - 8;
                    this.nameLabel.setSize(aWidth, (int)this.nameLabel.getPreferredSize().getHeight());
                    ay = (this.getHeight() - this.nameLabel.getHeight()) / 2;
                    if (this.theGalley.isSubGrid() && this.theSecondName != null) {
                        ay = (int)((double)((this.getHeight() - this.nameLabel.getHeight()) / 2) - this.nameLabel.getPreferredSize().getHeight() / 2.0);
                    }
                    this.nameLabel.setLocation((this.getWidth() - this.nameLabel.getWidth()) / 2, ay);
                    this.nameLabel.setVisible(true);
                }
                if (this.theGalley != null && this.theGalley.isSubGrid()) {
                    if (this.nameLabel2 == null && this.theSecondName != null) {
                        this.nameLabel2 = new TextLabel(this.theSecondName, ConverterRegistry.getConverter(GalleyEquipmentInsertTypeConverter.class));
                        if (this.theGalley.getModel().getPegasusState() == 7) {
                            this.nameLabel2.setDelegateComponent(this);
                        }
                        this.nameLabel2.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("stw_tray_name_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
                        this.nameLabel2.setAlignment(0);
                        aWidth = (int)this.nameLabel2.getPreferredSize().getWidth();
                        aWidth = this.getWidth() - 8;
                        this.nameLabel2.setSize(aWidth, (int)this.nameLabel2.getPreferredSize().getHeight());
                        ay = (int)((double)((this.getHeight() - this.nameLabel2.getHeight()) / 2) + this.nameLabel2.getPreferredSize().getHeight() / 2.0);
                        this.nameLabel2.setLocation((this.getWidth() - this.nameLabel2.getWidth()) / 2, ay);
                        this.add((Component)this.nameLabel2, 0);
                        this.nameLabel2.setProgress(1.0f);
                        this.nameLabel2.setVisible(true);
                    } else if (this.nameLabel2 != null) {
                        aWidth = (int)this.nameLabel2.getPreferredSize().getWidth();
                        this.nameLabel2.setNode((Node)this.theSecondName);
                        aWidth = this.getWidth() - 8;
                        this.nameLabel2.setSize(aWidth, (int)this.nameLabel2.getPreferredSize().getHeight());
                        ay = (int)((double)((this.getHeight() - this.nameLabel2.getHeight()) / 2) + this.nameLabel2.getPreferredSize().getHeight() / 2.0);
                        this.nameLabel2.setLocation((this.getWidth() - this.nameLabel2.getWidth()) / 2, ay);
                        this.nameLabel2.setVisible(true);
                    }
                }
            }
        }
    }

    public void setFrontBox(GalleyBox fb) {
        this.theFrontBox = fb;
    }

    public boolean isSpecialState() {
        return this.isSpecialState;
    }

    public void setSpecialState(boolean iSpecialState) {
        this.isSpecialState = iSpecialState;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        if (this.theGalley.theSelectedBox == this) {
            this.theGalley.theSelectedBox = null;
        }
        if (this.theNode != null) {
            this.theNode.removeAllListenersRecursivley();
            this.theNode.removeNodeListenerRecursively((NodeListener)this);
        }
        this.theNode = null;
        if (this.theXSizeNode != null) {
            this.theXSizeNode.removeNodeListener((NodeListener)this);
        }
        this.theXSizeNode = null;
        if (this.theYSizeNode != null) {
            this.theYSizeNode.removeNodeListener((NodeListener)this);
        }
        this.theYSizeNode = null;
        if (this.theZSizeNode != null) {
            this.theZSizeNode.removeNodeListener((NodeListener)this);
        }
        this.theZSizeNode = null;
        if (this.theXCoord != null) {
            this.theXCoord.removeNodeListener((NodeListener)this);
        }
        this.theXCoord = null;
        if (this.theYCoord != null) {
            this.theYCoord.removeNodeListener((NodeListener)this);
        }
        this.theYCoord = null;
        if (this.theZCoord != null) {
            this.theZCoord.removeNodeListener((NodeListener)this);
        }
        this.theZCoord = null;
        if (this.theNameNode != null) {
            this.theNameNode.removeNodeListener((NodeListener)this);
        }
        this.theNameNode = null;
        if (this.typeNode != null) {
            this.typeNode.removeNodeListener((NodeListener)this);
        }
        this.typeNode = null;
        if (this.hasLabel != null) {
            this.hasLabel.removeNodeListener((NodeListener)this);
        }
        this.hasLabel = null;
        this.theBackupPoint = null;
        this.theGalley = null;
        this.theDragStartPoint = null;
        if (this.serviceInsertShape != null) {
            this.serviceInsertShape.kill();
        }
        this.serviceInsertShape = null;
        this.dragingGridSpace = null;
        if (this.theBehindBox != null) {
            this.theBehindBox.kill();
        }
        this.theBehindBox = null;
        if (this.theFrontBox != null) {
            this.theFrontBox.kill();
        }
        this.theFrontBox = null;
        if (this.nameEnterField != null) {
            this.nameEnterField.getTextField().removeFocusListener(this);
            this.nameEnterField.kill();
        }
        this.nameEnterField = null;
        if (this.alternativesNode != null) {
            this.alternativesNode.removeNodeListener((NodeListener)this);
        }
        this.alternativesNode = null;
        if (this.defaultNode != null) {
            this.defaultNode.removeNodeListener((NodeListener)this);
        }
        this.defaultNode = null;
        if (this.altNameA != null) {
            this.altNameA.removeNodeListener((NodeListener)this);
        }
        this.altNameA = null;
        if (this.altNameB != null) {
            this.altNameB.removeNodeListener((NodeListener)this);
        }
        this.altNameB = null;
        if (this.altNameAEnterField != null) {
            this.altNameAEnterField.getTextField().removeFocusListener(this);
            this.altNameAEnterField.kill();
        }
        this.altNameAEnterField = null;
        if (this.altNameBEnterField != null) {
            this.altNameBEnterField.getTextField().removeFocusListener(this);
            this.altNameBEnterField.kill();
        }
        this.altNameBEnterField = null;
        if (this.altNameALabel != null) {
            this.altNameALabel.kill();
        }
        this.altNameALabel = null;
        if (this.altNameBLabel != null) {
            this.altNameBLabel.kill();
        }
        this.altNameBLabel = null;
        if (this.nameLabel != null) {
            this.nameLabel.kill();
        }
        this.nameLabel = null;
        if (this.nameLabel2 != null) {
            this.nameLabel2.kill();
        }
        this.nameLabel2 = null;
        this.mover.deregister();
        this.mover = null;
        super.kill();
    }

    public void setResizeState(int state) {
        this.isResizeState = state;
    }

    private void loadSizes() {
        if (this.theXSizeNode != null) {
            this.theXSizeNode.removeNodeListener((NodeListener)this);
        }
        if (this.theYSizeNode != null) {
            this.theYSizeNode.removeNodeListener((NodeListener)this);
        }
        if (this.theZSizeNode != null) {
            this.theZSizeNode.removeNodeListener((NodeListener)this);
        }
        StowagePositionTypeComplete t = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getLooseStowageType();
        GalleyEquipmentTypeComplete t2 = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getLooseEquipmentType();
        if (t != null && t.equals(this.typeNode.getValue())) {
            this.isResizable = true;
            if (this.theNode.getChildNamed(new String[]{"dimension"}).getValue() == null) {
                Dimension3dComplete d = new Dimension3dComplete();
                d.setWidth(t.getSize().getWidth());
                d.setHeight(t.getSize().getHeight());
                d.setDepth(t.getSize().getDepth());
                this.theNode.getChildNamed(new String[]{"dimension"}).setValue((Object)d, System.currentTimeMillis());
            }
        } else if (t2 != null && t2.equals(this.typeNode.getValue())) {
            this.isResizable = true;
            if (this.typeNode.getParent().getChildNamed(new String[]{"dimension"}).getValue() == null) {
                Dimension3dComplete d = new Dimension3dComplete();
                d.setWidth(t2.getSize().getWidth());
                d.setHeight(t2.getSize().getHeight());
                d.setDepth(t2.getSize().getDepth());
                this.typeNode.getParent().getChildNamed(new String[]{"dimension"}).setValue((Object)d, System.currentTimeMillis());
            }
        } else {
            this.isResizable = false;
        }
        if (this.theGalley.getModel().getPegasusState() == 3) {
            if (this.isResizable) {
                this.theXSizeNode = this.theNode.getChildNamed(new String[]{"dimension-width"});
                this.theYSizeNode = this.theNode.getChildNamed(new String[]{"dimension-height"});
                this.theZSizeNode = this.theNode.getChildNamed(new String[]{"dimension-depth"});
            } else {
                this.theXSizeNode = this.typeNode.getChildNamed(new String[]{"size-width"});
                this.theYSizeNode = this.typeNode.getChildNamed(new String[]{"size-height"});
                this.theZSizeNode = this.typeNode.getChildNamed(new String[]{"size-depth"});
            }
            this.theXSizeNode.addNodeListener((NodeListener)this);
            this.theYSizeNode.addNodeListener((NodeListener)this);
            this.theZSizeNode.addNodeListener((NodeListener)this);
        } else if (this.theGalley.isSubGrid()) {
            if (this.theNode.getValue() instanceof GalleyEquipmentReservedSpaceComplete) {
                this.theXSizeNode = this.theNode.getChildNamed(new String[]{"dimension-width"});
                this.theYSizeNode = this.theNode.getChildNamed(new String[]{"dimension-height"});
                this.theZSizeNode = this.theNode.getChildNamed(new String[]{"dimension-depth"});
            } else {
                this.theXSizeNode = this.typeNode.getChildNamed(new String[]{"dimension-width"});
                this.theYSizeNode = this.typeNode.getChildNamed(new String[]{"dimension-height"});
                this.theZSizeNode = this.typeNode.getChildNamed(new String[]{"dimension-depth"});
            }
        } else if (this.isResizable) {
            this.theXSizeNode = this.typeNode.getParent().getChildNamed(new String[]{"dimension-width"});
            this.theYSizeNode = this.typeNode.getParent().getChildNamed(new String[]{"dimension-height"});
            this.theZSizeNode = this.typeNode.getParent().getChildNamed(new String[]{"dimension-depth"});
        } else {
            this.theXSizeNode = this.typeNode.getChildNamed(new String[]{"size-width"});
            this.theYSizeNode = this.typeNode.getChildNamed(new String[]{"size-height"});
            this.theZSizeNode = this.typeNode.getChildNamed(new String[]{"size-depth"});
        }
    }

    private void ensureAlternatives(boolean isAlt, int isFirst) {
        if (this.alternativesNode != null) {
            boolean useIt = false;
            useIt = this.theGalley.getModel().getPegasusState() == 3 ? this.alternativesNode.getChildCount() > 0 : isAlt;
            if (useIt) {
                if (this.nameLabel != null && this.theGalley.getModel().getPegasusState() != 3) {
                    this.nameLabel.setVisible(false);
                }
                if (this.nameLabel2 != null && this.theGalley.getModel().getPegasusState() != 3) {
                    this.nameLabel2.setVisible(false);
                }
                this.useAlternatives = true;
                Iterator it = this.alternativesNode.getChilds();
                boolean i = false;
                while (it.hasNext()) {
                    double coordZ;
                    Node altStow = (Node)it.next();
                    if (this.theGalley.getModel().getPegasusState() == 7 && ((GalleyEquipmentComplete)altStow.getValue()).getEquipmentSetType() == GalleyEquipmentSetTypeE.HOLD) continue;
                    String childName = "positionCode";
                    if (this.theGalley.getModel().getPegasusState() == 3) {
                        childName = "code";
                    }
                    i = this.theGalley.getModel().getPegasusState() == 3 ? (coordZ = ((Double)altStow.getChildNamed(new String[]{"location-z"}).getValue()).doubleValue()) != 0.0 : altStow == null || altStow.getValue(GalleyEquipmentComplete.class) == null || ((GalleyEquipmentComplete)altStow.getValue(GalleyEquipmentComplete.class)).getLocation().getZ() == null || ((GalleyEquipmentComplete)altStow.getValue(GalleyEquipmentComplete.class)).getLocation().getZ() != 0.0;
                    if (!i) {
                        this.altNameA = altStow.getChildNamed(new String[]{childName});
                        assert (this.altNameA != null);
                        continue;
                    }
                    this.altNameB = altStow.getChildNamed(new String[]{childName});
                    assert (this.altNameB != null);
                }
                if (isFirst == 0 || isFirst == 1) {
                    if (this.altNameAEnterField != null) {
                        this.altNameAEnterField.setNode((Node)this.altNameA);
                        this.altNameALabel.setNode((Node)this.altNameA);
                        this.altNameALabel.setVisible(false);
                    } else {
                        this.altNameAEnterField = new TextField(this.altNameA);
                        this.altNameAEnterField.addActionListener(this);
                        this.altNameAEnterField.getTextField().addFocusListener(this);
                        this.add(this.altNameAEnterField);
                        if (this.altNameALabel != null) {
                            this.altNameALabel.setVisible(false);
                        } else {
                            this.altNameALabel = new TextLabel(this.altNameA);
                            this.altNameALabel.setVisible(false);
                            this.add((Component)this.altNameALabel, -1);
                        }
                    }
                } else if (isFirst == -1) {
                    if (this.altNameALabel != null) {
                        this.altNameALabel.setVisible(true);
                    } else {
                        this.altNameALabel = new TextLabel(this.altNameA);
                        this.altNameALabel.setVisible(true);
                        this.add((Component)this.altNameALabel, -1);
                    }
                }
                if (isFirst == 0 || isFirst == 2) {
                    if (this.altNameBEnterField != null) {
                        this.altNameBEnterField.setNode((Node)this.altNameB);
                        this.altNameBLabel.setNode((Node)this.altNameB);
                        this.altNameBLabel.setVisible(false);
                    } else {
                        this.altNameBEnterField = new TextField(this.altNameB);
                        this.altNameBEnterField.getTextField().setHorizontalAlignment(11);
                        this.altNameBEnterField.addActionListener(this);
                        this.altNameBEnterField.getTextField().addFocusListener(this);
                        this.add(this.altNameBEnterField);
                        if (this.altNameBLabel != null) {
                            this.altNameBLabel.setVisible(false);
                        } else {
                            this.altNameBLabel = new TextLabel(this.altNameB);
                            this.altNameBLabel.setVisible(false);
                            this.add((Component)this.altNameBLabel, -1);
                        }
                    }
                } else if (isFirst == -1) {
                    if (this.altNameBLabel != null) {
                        this.altNameBLabel.setVisible(true);
                    } else {
                        this.altNameBLabel = new TextLabel(this.altNameB);
                        this.altNameBLabel.setVisible(true);
                        this.add((Component)this.altNameBLabel, -1);
                    }
                }
                if (this.theGalley.getModel().getPegasusState() == 3) {
                    ((Galley)this.theGalley).updateEditor(5);
                }
            } else {
                if (this.nameLabel != null) {
                    this.getBoxNode().getValue();
                    if (this.theNameNode.getParent().getParent().getName().equals("alternativeEquipment")) {
                        Node n = this.theNameNode.getParent().getParent().getParent().getChildNamed(new String[]{"alternativeEquipment"});
                        Iterator it = n.getFailSafeChildIterator();
                        while (it.hasNext()) {
                            Node box = (Node)it.next();
                            if (!((GalleyEquipmentSetTypeE)box.getChildNamed(GalleyEquipmentComplete_.equipmentSetType).getValue()).equals((Object)this.getGalley().getCurrentEquipmentType())) continue;
                            this.theNameNode = box.getChildNamed(GalleyEquipmentComplete_.positionCode);
                        }
                    } else {
                        Node n = this.theNameNode.getParent().getParent().getParent().getChildNamed(new String[]{"usedGalleyEquipment"});
                        if (n != null) {
                            Iterator it = n.getFailSafeChildIterator();
                            while (it.hasNext()) {
                                Node box = (Node)it.next();
                                if (!((GalleyEquipmentSetTypeE)box.getChildNamed(GalleyEquipmentComplete_.equipmentSetType).getValue()).equals((Object)this.getGalley().getCurrentEquipmentType())) continue;
                                this.theNameNode = box.getChildNamed(GalleyEquipmentComplete_.positionCode);
                            }
                        }
                    }
                    this.nameLabel.setNode((Node)this.theNameNode);
                    this.nameLabel.setVisible(true);
                }
                this.useAlternatives = false;
                this.altNameA = null;
                this.altNameB = null;
                if (this.altNameAEnterField != null) {
                    this.altNameAEnterField.kill();
                    this.altNameAEnterField = null;
                }
                if (this.altNameBEnterField != null) {
                    this.altNameBEnterField.kill();
                    this.altNameBEnterField = null;
                }
                if (this.altNameALabel != null) {
                    this.altNameALabel.kill();
                    this.altNameALabel = null;
                }
                if (this.altNameBLabel != null) {
                    this.altNameBLabel.kill();
                    this.altNameBLabel = null;
                }
                ((Galley)this.theGalley).updateEditor(-1);
            }
            this.repaint(32L);
        }
    }

    private void install() {
        this.setLayout(null);
        Node type = null;
        this.isServiceSpace = false;
        if (this.theGalley.getModel().getPegasusState() == 3) {
            this.defaultNode = this.theNode.getChildNamed(new String[]{"defaultPositions"});
            Node node = this.defaultNode.getChildAt(0);
            type = node.getChildNamed(new String[]{"type"});
            this.theXCoord = node.getChildNamed(new String[]{"location-x"});
            this.theYCoord = node.getChildNamed(new String[]{"location-y"});
            this.theZCoord = node.getChildNamed(new String[]{"location-z"});
            this.theNameNode = this.theNode.getChildNamed(new String[]{"code"});
            this.alternativesNode = this.theNode.getChildNamed(new String[]{"alternativePositions"});
            this.alternativesNode.removeNodeListener((NodeListener)this);
            this.alternativesNode.addNodeListener((NodeListener)this);
            this.theNode = node;
            this.ensureAlternatives(true, 0);
        } else {
            if (this.theGalley.isSubGrid()) {
                if (this.theNode.getValue() instanceof GalleyEquipmentReservedSpaceComplete) {
                    this.isServiceSpace = true;
                    type = this.theNode.getChildNamed(new String[]{"containedInsertType"});
                    this.theYCoord = this.theNode.getChildNamed(new String[]{"coordinates-y"});
                    this.theZCoord = this.theNode.getChildNamed(new String[]{"coordinates-z"});
                    this.backgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("fill_flight_service_space_background"));
                } else {
                    type = this.theNode.getChildNamed(new String[]{"type"});
                    this.theYCoord = this.theNode.getChildNamed(new String[]{"coordinates-y"});
                    this.theZCoord = this.theNode.getChildNamed(new String[]{"coordinates-z"});
                    Node n = type.getChildNamed(new String[]{"displayColor"});
                    this.backgroundColor = n != null && n.getValue() != null ? new Color(((Color3DComplete)n.getValue()).getRed().floatValue(), ((Color3DComplete)n.getValue()).getGreen().floatValue(), ((Color3DComplete)n.getValue()).getBlue().floatValue()) : Color.orange;
                }
            } else {
                this.stowedSkin = SkinRegistry.getSkin(EquipmentMarkerSkin.class);
                this.alternativesNode = this.theNode.getChildNamed(new String[]{"usedGalleyEquipment"});
                this.alternativesNode.removeNodeListener((NodeListener)this);
                this.alternativesNode.addNodeListener((NodeListener)this);
                Node usedGalleys = this.theNode.getChildNamed(new String[]{"usedGalleyEquipment"});
                if (usedGalleys.getChildCount() > 0) {
                    Iterator it = usedGalleys.getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node box = (Node)it.next();
                        if (!((GalleyEquipmentComplete)box.getValue()).getEquipmentSetType().equals((Object)this.getGalley().getCurrentEquipmentType())) continue;
                        Node defaultBox = box;
                        type = defaultBox.getChildNamed(new String[]{"equipmentType"});
                        this.theNameNode = defaultBox.getChildNamed(new String[]{"positionCode"});
                        this.theXCoord = defaultBox.getChildNamed(new String[]{"location-x"});
                        this.theYCoord = defaultBox.getChildNamed(new String[]{"location-y"});
                        this.theZCoord = defaultBox.getChildNamed(new String[]{"location-z"});
                        this.alternativesNode.getAllChildAddEventsFor((NodeListener)this, new String[0]);
                        this.ensureAlternatives(this.hasAlternatives(), -1);
                    }
                }
            }
            this.hasLabel = this.theNode.getChildNamed(new String[]{"labelConfiguration-display"});
            if (this.hasLabel != null) {
                this.hasLabel.removeNodeListener((NodeListener)this);
                this.hasLabel.addNodeListener((NodeListener)this);
            }
        }
        this.typeNode = type;
        if (this.typeNode != null) {
            this.typeNode.removeNodeListener((NodeListener)this);
            this.typeNode.addNodeListener((NodeListener)this);
        }
        this.mover = new Mover<GalleyBox>(this);
        this.loadSizes();
        if (this.theNameNode == null) {
            if (this.theNode.getValue() instanceof GalleyEquipmentReservedSpaceComplete) {
                this.theNameNode = this.theNode.getChildNamed(new String[]{"spaceName"});
                this.theSecondName = this.theNode.getChildNamed(new String[]{"containedInsertType"});
            } else {
                this.theNameNode = this.theNode.getValue() instanceof StowagePositionComplete ? this.theNode.getChildNamed(new String[]{"code"}) : this.theNode.getChildNamed(new String[]{"spaceName"});
            }
        }
        if (!this.isLose) {
            if (this.theXCoord != null) {
                this.theXCoord.removeNodeListener((NodeListener)this);
                this.theXCoord.addNodeListener((NodeListener)this);
            }
            this.theYCoord.removeNodeListener((NodeListener)this);
            this.theZCoord.removeNodeListener((NodeListener)this);
            this.theYCoord.addNodeListener((NodeListener)this);
            this.theZCoord.addNodeListener((NodeListener)this);
        }
        if (this.theNameNode != null) {
            this.theNameNode.removeNodeListener((NodeListener)this);
            this.theNameNode.addNodeListener((NodeListener)this);
        }
        this.enableNameEdit(false, true);
        this.addMouseMotionListener(this);
        this.theNode.removeNodeListener((NodeListener)this);
        this.theNode.addNodeListener((NodeListener)this);
        this.isDraggable = this.theGalley.getModel().getPegasusState() == 3 ? true : this.theGalley.isSubGrid();
    }

    public boolean isServiceSpace() {
        return this.isServiceSpace;
    }

    public boolean hasLabel() {
        return this.hasLabel != null && this.hasLabel.getValue() != null && (Boolean)this.hasLabel.getValue() != false;
    }

    public void expandShadowSize(boolean ex) {
        if (ex) {
            this.isShadowExpansion = true;
            this.setSize(this.getWidth() + this.theSkin.getImage32(Button.ButtonState.UP).getWidth(), this.getHeight() + this.theSkin.getImage23(Button.ButtonState.UP).getHeight());
        } else {
            this.isShadowExpansion = false;
            this.setSize(this.getWidth() - this.theSkin.getImage32(Button.ButtonState.UP).getWidth(), this.getHeight() - this.theSkin.getImage23(Button.ButtonState.UP).getHeight());
        }
    }

    public boolean isHighLight() {
        return this.isHighLight;
    }

    public void setHighLight(boolean isHighLight) {
        if (isHighLight != this.isHighLight) {
            this.isHighLight = isHighLight;
            this.repaint(32L);
        }
    }

    public int getDragOffsetX() {
        return (int)this.theBackupPoint.getX();
    }

    public int getDragOffsetY() {
        return (int)this.theBackupPoint.getY();
    }

    public double getDX() {
        if (this.theXCoord == null || this.theXCoord.getValue() == null) {
            return 0.0;
        }
        return (Double)this.theXCoord.getValue();
    }

    public double getDY() {
        if (this.theYCoord == null || this.theYCoord.getValue() == null) {
            return 0.0;
        }
        return (Double)this.theYCoord.getValue();
    }

    public double getDZ() {
        if (this.theZCoord == null || this.theZCoord.getValue() == null) {
            return 0.0;
        }
        return (Double)this.theZCoord.getValue();
    }

    public Node getNode() {
        if (this.theNode != null && this.theNode.getParent() != null) {
            return this.theNode.getParent().getParent();
        }
        return null;
    }

    public Node getBoxNode() {
        return this.theNode;
    }

    public double getDWidth() {
        if (this.theXSizeNode == null || this.theXSizeNode.getValue() == null) {
            return 1.0;
        }
        return (Double)this.theXSizeNode.getValue();
    }

    public double getDHeight() {
        if (this.theYSizeNode == null || this.theYSizeNode.getValue() == null) {
            return 1.0;
        }
        return (Double)this.theYSizeNode.getValue();
    }

    public double getDDepth() {
        if (this.theZSizeNode == null || this.theZSizeNode.getValue() == null) {
            return 1.0;
        }
        return (Double)this.theZSizeNode.getValue();
    }

    public GalleyGridPanel getGalley() {
        return this.theGalley;
    }

    public void setDragStartPoint(int x, int y) {
        this.theDragStartPoint = new Point(x, y);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float compo = this.lookUpComposite();
        g2.setComposite(AlphaComposite.getInstance(3, compo));
        int aWidth = this.getWidth();
        int aHeight = this.getHeight();
        if (this.isShadowExpansion) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            if (!this.isServiceSpace) {
                this.theSkin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
            }
            aWidth = this.getWidth() - this.theSkin.getImage32(Button.ButtonState.UP).getWidth();
            aHeight = this.getHeight() - this.theSkin.getImage23(Button.ButtonState.UP).getHeight();
            if (this.backgroundColor != null) {
                g2.setColor(this.backgroundColor);
            } else {
                g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            }
            g2.fillRect(0, 0, aWidth, aHeight);
        } else if (this.isResizeState != 0) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        int selectType = 7;
        if (this.theGalley.getSelectedBox() == this) {
            selectType = this.theGalley.getGlobalSelectionContoller().getMainSelection() == this ? 2 : 3;
        }
        if (this.isHighLight) {
            selectType = 2;
        }
        switch (selectType) {
            case 2: {
                g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_main_selection_color")));
                g2.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_selected_font_type")));
                break;
            }
            case 3: {
                g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_main_selection_color")));
                g2.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_selected_font_type")));
                break;
            }
            case 7: {
                g2.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("gc_galley_box_font_type")));
                if (!this.isInUse()) {
                    g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_box_notused_background")));
                    break;
                }
                g2.setColor(ClassConverter.getClassColor(this.theNode));
            }
        }
        int[] xCoordsU = new int[3];
        int[] yCoordsU = new int[3];
        int[] xCoordsL = new int[3];
        int[] yCoordsL = new int[3];
        xCoordsU[0] = 0;
        xCoordsU[1] = aWidth;
        xCoordsU[2] = 0;
        yCoordsU[0] = 0;
        yCoordsU[1] = 0;
        yCoordsU[2] = aHeight;
        xCoordsL[0] = aWidth;
        xCoordsL[1] = 0;
        xCoordsL[2] = aWidth;
        yCoordsL[0] = 0;
        yCoordsL[1] = aHeight;
        yCoordsL[2] = aHeight;
        if (this.theGalley.getModel().getPegasusState() == 7) {
            if (this.useAlternatives) {
                if (selectType == 3 || selectType == 2) {
                    if (this.isUpperBoxSelected) {
                        g2.fillPolygon(xCoordsU, yCoordsU, 3);
                    } else {
                        g2.fillPolygon(xCoordsL, yCoordsL, 3);
                    }
                } else if (this.theGalley.getModel() instanceof GalleyEquipmentModel) {
                    g2.fillRect(0, 0, aWidth, aHeight);
                } else if (this.theGalley.getModel() instanceof PegasusGalleyModel) {
                    Node inU;
                    Node fN = this.getFrontBox();
                    Node rN = this.getRearBox();
                    if (fN != null) {
                        inU = fN.getChildNamed(new String[]{"inUse"});
                        if (((Boolean)inU.getValue()).booleanValue()) {
                            g2.setColor(ClassConverter.getClassColor(this.theNode));
                        } else {
                            g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_box_notused_background")));
                        }
                        g2.fillPolygon(xCoordsU, yCoordsU, 3);
                    }
                    if (rN != null) {
                        inU = rN.getChildNamed(new String[]{"inUse"});
                        if (((Boolean)inU.getValue()).booleanValue()) {
                            g2.setColor(ClassConverter.getClassColor(this.theNode));
                        } else {
                            g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_box_notused_background")));
                        }
                        g2.fillPolygon(xCoordsL, yCoordsL, 3);
                    }
                }
            } else {
                if (this.theGalley.isSubGrid() && (selectType == 3 || selectType == 2)) {
                    g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_main_selection_color")));
                } else if (this.backgroundColor != null) {
                    g2.setColor(this.backgroundColor);
                }
                g2.fillRect(0, 0, aWidth, aHeight);
                if (this.isServiceSpace && !this.isShadowExpansion && this.isResizeState == 0) {
                    this.serviceInsertShape.paint(g2);
                }
            }
        } else {
            if (this.backgroundColor != null) {
                g2.setColor(this.backgroundColor);
            }
            g2.fillRect(0, 0, aWidth, aHeight);
        }
        if (this.theGalley.isSubGrid()) {
            g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_box_sub_outlinecolor")));
        } else {
            g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_box_line_color")));
        }
        g2.drawRect(0, 0, aWidth - 1, aHeight - 1);
        if (this.useAlternatives) {
            Shape backClip = g2.getClip();
            Shape newShape = g2.getClip();
            Area a = new Area(newShape);
            if (this.theGalley.getModel().getPegasusState() == 3 && !this.isSplittlineContiuous()) {
                if (this.nameEnterField != null) {
                    a.subtract(new Area(this.nameEnterField.getBounds()));
                } else if (this.nameLabel != null) {
                    a.subtract(new Area(this.nameLabel.getBounds()));
                } else {
                    a.subtract(new Area(new Rectangle(0, (aHeight - g2.getFont().getSize()) / 2, this.getWidth() - 2, g2.getFont().getSize() + 3)));
                }
            }
            g2.setClip(a);
            g2.drawLine(aWidth - 1, 0, 0, aHeight - 1);
            g2.setClip(backClip);
        }
        if (selectType == 2) {
            if (this.isHighLight) {
                g2.setColor(new Color(255, 255, 255));
            }
            g2.drawRect(1, 1, aWidth - 3, aHeight - 3);
        }
        switch (selectType) {
            default: 
        }
        if (this.theGalley.getModel().getPegasusState() == 7 && !this.theGalley.isSubGrid()) {
            Node n;
            if (this.useAlternatives) {
                if (this.altNameA != null && this.isCharged(this.altNameA.getParent())) {
                    this.stowedSkin.paint(g2, 0, 0, Button.ButtonState.LEFT);
                }
                if (this.altNameB != null && this.isCharged(this.altNameB.getParent())) {
                    this.stowedSkin.paint(g2, this.getWidth() - (this.stowedSkin.getImage(Button.ButtonState.RIGHT).getWidth() + 1), this.getHeight() - (this.stowedSkin.getImage(Button.ButtonState.RIGHT).getHeight() + 1), Button.ButtonState.RIGHT);
                } else {
                    n = this.getBoxNode().getChildNamed(new String[]{"usedGalleyEquipment"}).getChildAt(0);
                    if (((GalleyEquipmentComplete)n.getValue()).getEquipmentSetType() != this.theGalley.getCurrentEquipmentType() && this.getBoxNode().getChildNamed(new String[]{"usedGalleyEquipment"}).getChildCount() > 1) {
                        n = this.getBoxNode().getChildNamed(new String[]{"usedGalleyEquipment"}).getChildAt(1);
                    }
                    if (this.isCharged(n)) {
                        int i = 1;
                        if (selectType == 2) {
                            i = 2;
                        }
                        this.stowedSkin.paint(g2, i, i, Button.ButtonState.LEFT);
                    }
                }
            } else if (this.getBoxNode().getChildNamed(new String[]{"usedGalleyEquipment"}).getChildCount() > 0) {
                n = this.getBoxNode().getChildNamed(new String[]{"usedGalleyEquipment"}).getChildAt(0);
                if (((GalleyEquipmentComplete)n.getValue(GalleyEquipmentComplete.class)).getEquipmentSetType() != this.theGalley.getCurrentEquipmentType() && this.getBoxNode().getChildNamed(new String[]{"usedGalleyEquipment"}).getChildCount() > 1 && (n = this.getBoxNode().getChildNamed(new String[]{"usedGalleyEquipment"})) != null) {
                    n = n.getChildAt(1);
                }
                if (this.isCharged(n)) {
                    int i = 1;
                    if (selectType == 2) {
                        i = 2;
                    }
                    this.stowedSkin.paint(g2, i, i, Button.ButtonState.LEFT);
                }
            }
        }
        this.paintChildren(g2);
    }

    private boolean isCharged(Node n) {
        return n == null || n.getChildNamed(new String[]{"deliverySpaces"}).getChildCount() != 0;
    }

    private boolean isSplittlineContiuous() {
        if (!this.useAlternatives && this.theGalley.getModel().getPegasusState() == 7) {
            return true;
        }
        return this.theNameNode == null || this.theNameNode.getValue() == null || ((String)this.theNameNode.getValue()).equals("");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.theBackupPoint = new Point(e.getX(), e.getY());
        if (this.theGalley.getModel().getPegasusState() == 7) {
            if (this.isInUse()) {
                this.requestFocusInWindow();
            }
        } else {
            this.requestFocusInWindow();
        }
    }

    public void initResizing() {
        if (this.theGalley != null) {
            if (this.theGalley.getDragController() != null) {
                this.theGalley.getDragController().startDragging(this, true);
            }
            if (this.theGalley.getGrid() != null) {
                this.theGalley.getGrid().showGrid(true);
            }
        }
    }

    public void stopResizing() {
        this.isDragging = false;
        if (this.dragingGridSpace != null && this.theGalley.isEmptyField((int)this.dragingGridSpace.getX(), (int)this.dragingGridSpace.getY(), this.dragingGridSpace.getW(), this.dragingGridSpace.getH(), this.dragingGridSpace.getW()) > 0 && this.dragingGridSpace.getW() > 0.0 && this.dragingGridSpace.getH() > 0.0) {
            double dx = this.theGalley.getGrid().getDiscretIndexX((int)this.dragingGridSpace.getX(), this.dragingGridSpace.getW());
            double dy = this.theGalley.getGrid().getDiscretIndexY((int)this.dragingGridSpace.getY(), this.dragingGridSpace.getH());
            long currentUndoId = System.currentTimeMillis();
            if (this.theZCoord instanceof Node) {
                this.theZCoord.setValue((Object)dx, currentUndoId);
            }
            if (this.theYCoord instanceof Node) {
                this.theYCoord.setValue((Object)dy, currentUndoId);
            }
            if (this.theZSizeNode instanceof Node) {
                this.theZSizeNode.setValue((Object)this.dragingGridSpace.getW(), currentUndoId);
            }
            if (this.theYSizeNode instanceof Node) {
                this.theYSizeNode.setValue((Object)this.dragingGridSpace.getH(), currentUndoId);
            }
        }
        this.isResizeState = 0;
        this.theGalley.getGrid().showGrid(false);
        this.theGalley.addBox(this);
    }

    public boolean processDragging(Dimension backupDimension, Point backupPoint, Point backupPosition, Dimension offset, MouseEvent e) {
        double minH = 0.0;
        double minW = 0.0;
        int aMinimalHeight = 10;
        int aMinimalWidth = 10;
        Node boxNode = this.getBoxNode();
        if (boxNode != null) {
            Node tray = boxNode.getChildNamed(new String[]{"containedInsertType"});
            minH = (Double)tray.getChildNamed(new String[]{"dimension-height"}).getValue();
            minW = (Double)tray.getChildNamed(new String[]{"dimension-depth"}).getValue();
        }
        if (minH < 1.0) {
            minH = 1.0;
        }
        if (minW < 1.0) {
            minW = 1.0;
        }
        switch (this.isResizeState) {
            case 1: {
                double dy = backupPoint.getY() - (double)e.getY();
                int currentH = this.getHeight();
                int ny = (int)((double)this.getY() - dy);
                if ((double)currentH + dy < (double)aMinimalHeight) {
                    return false;
                }
                this.setLocation(this.getX(), ny);
                this.setSize((int)backupDimension.getWidth(), (int)((double)currentH + dy));
                ny = (int)(backupPosition.getY() - dy);
                backupPosition.setLocation(backupPosition.getX(), (double)ny);
                double discretY = this.theGalley.getGrid().getDiscretIndexY(ny, minH);
                double newHeight = this.getHeight() / this.theGalley.getGrid().getGridSizeY();
                double newWidth = this.getWidth() / this.theGalley.getGrid().getGridSizeX();
                int ap = ny + this.getHeight();
                double discretY2 = this.theGalley.getGrid().getDiscretIndexY(ap, minH);
                if (discretY + newHeight != discretY2) {
                    newHeight += 1.0;
                }
                if (minH > 0.0) {
                    while (newHeight % minH != 0.0) {
                        newHeight += 1.0;
                    }
                }
                if (this.dragingGridSpace == null) {
                    this.dragingGridSpace = new GridSpace(backupPosition.getX() + 1.0, ny, this.getWidth(), this.getHeight());
                } else {
                    this.dragingGridSpace.setX(backupPosition.getX() + 1.0);
                    this.dragingGridSpace.setY(ny);
                    this.dragingGridSpace.setW(newWidth);
                    this.dragingGridSpace.setH(newHeight);
                }
                this.theGalley.setMultiplier(newWidth, newHeight, newWidth);
                this.theGalley.highlightGrid((int)backupPosition.getX(), (int)backupPosition.getY());
                break;
            }
            case 5: {
                double dy = backupPoint.getY() - (double)e.getY();
                if ((double)this.getHeight() - dy < (double)aMinimalHeight) {
                    return false;
                }
                this.setSize((int)backupDimension.getWidth(), (int)((double)this.getHeight() - dy));
                int h = this.getHeight();
                int w = this.getWidth();
                double newHeight = (int)((double)h / (double)this.theGalley.getGrid().getGridSizeY());
                double newWidth = w / this.theGalley.getGrid().getGridSizeX();
                newHeight += 1.0;
                if (minH > 0.0) {
                    while (newHeight % minH != 0.0) {
                        newHeight += 1.0;
                    }
                }
                if (this.dragingGridSpace == null) {
                    this.dragingGridSpace = new GridSpace(backupPosition.getX() + 1.0, backupPosition.getY(), newWidth, newHeight);
                } else {
                    this.dragingGridSpace.setX(backupPosition.getX() + 1.0);
                    this.dragingGridSpace.setY(backupPosition.getY());
                    this.dragingGridSpace.setW(newWidth);
                    this.dragingGridSpace.setH(newHeight);
                }
                if (h > 0) {
                    this.theGalley.setMultiplier(newWidth, newHeight, newWidth);
                    this.theGalley.highlightGrid((int)backupPosition.getX(), (int)backupPosition.getY());
                    break;
                }
                this.theGalley.highlightGrid(-1, -1);
                break;
            }
            case 7: {
                double dw = backupPoint.getX() - (double)e.getX();
                int w = this.getWidth();
                int nx = (int)((double)this.getX() - dw);
                if ((double)this.getWidth() + dw < (double)aMinimalWidth) {
                    return false;
                }
                this.setLocation(nx, this.getY());
                this.setSize((int)((double)this.getWidth() + dw), (int)backupDimension.getHeight());
                nx = (int)(backupPosition.getX() - dw);
                backupPosition.setLocation((double)nx, backupPosition.getY());
                double discretX = this.theGalley.getGrid().getDiscretIndexX(nx, minW);
                double newHeight = this.getHeight() / this.theGalley.getGrid().getGridSizeY();
                double newWidth = this.getWidth() / this.theGalley.getGrid().getGridSizeX();
                newWidth = this.theGalley.getGrid().getGridCountX() - discretX;
                if (this.dragingGridSpace == null) {
                    this.dragingGridSpace = new GridSpace(backupPosition.getX(), backupPosition.getY(), newWidth, newHeight);
                } else {
                    this.dragingGridSpace.setX(backupPosition.getX());
                    this.dragingGridSpace.setY(backupPosition.getY());
                    this.dragingGridSpace.setW(newWidth);
                    this.dragingGridSpace.setH(newHeight);
                }
                this.theGalley.setMultiplier(newWidth, newHeight, minW);
                this.theGalley.highlightGrid((int)backupPosition.getX(), (int)backupPosition.getY());
                break;
            }
            case 3: {
                double dw = backupPoint.getX() - (double)e.getX();
                int w = this.getWidth();
                int nw = (int)((double)this.getWidth() - dw);
                if (nw < aMinimalWidth) {
                    return false;
                }
                this.setLocation(this.getX(), this.getY());
                this.setSize(nw, (int)backupDimension.getHeight());
                double discretX = this.theGalley.getGrid().getDiscretIndexX((int)(backupPosition.getX() + (double)this.getWidth()), minW);
                double newWidth = this.theGalley.getGrid().getGridCountX();
                double newHeight = this.getHeight() / this.theGalley.getGrid().getGridSizeY();
                newWidth = discretX;
                if (this.dragingGridSpace == null) {
                    this.dragingGridSpace = new GridSpace(backupPosition.getX() + 1.0, backupPosition.getY(), newWidth, newHeight);
                } else {
                    this.dragingGridSpace.setX(backupPosition.getX() + 1.0);
                    this.dragingGridSpace.setY(backupPosition.getY());
                    this.dragingGridSpace.setW(newWidth);
                    this.dragingGridSpace.setH(newHeight);
                }
                this.theGalley.setMultiplier(newWidth, newHeight, newWidth);
                this.theGalley.highlightGrid((int)backupPosition.getX(), (int)backupPosition.getY());
            }
        }
        return true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isDragging) {
            boolean takePos = this.theGalley.getDragController().checkUnderground(this);
            this.theGalley.getDragController().stopDragging(this);
            this.isDragging = false;
            this.isResizeState = 0;
            if (!takePos) {
                final long aStartTime = System.currentTimeMillis();
                final double aStartX = this.theDragStartPoint != null ? this.theDragStartPoint.getX() : 0.0;
                final double aStartY = this.theDragStartPoint != null ? this.theDragStartPoint.getY() : 0.0;
                final double aEndX = this.getX();
                final double aEndY = this.getY();
                final GalleyBox aBox = this;
                Timer aTimer = new Timer(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("animationRate")), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (GalleyBox.this.theGalley == null) {
                            return;
                        }
                        long cTime = System.currentTimeMillis();
                        long dt = cTime - aStartTime;
                        if (dt > (long)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("animationTime")).intValue()) {
                            ((Timer)e.getSource()).stop();
                            GalleyBox.this.expandShadowSize(false);
                            GalleyBox.this.isDragging = false;
                            if (GalleyBox.this.isSpecialState) {
                                GalleyBox.this.theGalley.addSpecialBox(aBox);
                            } else {
                                GalleyBox.this.theGalley.addBox(aBox);
                            }
                        } else {
                            double p = (double)dt / (double)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("animationTime")).intValue();
                            p = Math.sin(0.7853981633974483 + 0.7853981633974483 * p);
                            double dx = aEndX - aStartX;
                            double dy = aEndY - aStartY;
                            GalleyBox.this.setLocation((int)(aEndX - (dx *= p)), (int)(aEndY - (dy *= p)));
                            TopLevelRepainter.repaintAll(aBox, 32L);
                        }
                    }
                });
                aTimer.start();
            } else {
                this.isDragging = false;
            }
        } else {
            if (this.theGalley.getModel().getPegasusState() == 7 && !this.theGalley.isSubGrid() && this.isInUse()) {
                this.selectAlternative(e.getX(), e.getY());
            }
            if (this.theGalley.getModel().getPegasusState() == 7 && !this.theGalley.isSubGrid() && !this.isInUse()) {
                if (this.useAlternatives && this.selectAlternative(e.getX(), e.getY(), true)) {
                    this.theGalley.selectBox(this, e.getX(), e.getY());
                }
            } else {
                this.theGalley.selectBox(this, e.getX(), e.getY());
            }
        }
    }

    private void selectAlternative(int x, int y) {
        this.selectAlternative(x, y, false);
    }

    private boolean selectAlternative(int x, int y, boolean checkAlts) {
        if (this.useAlternatives) {
            Node fN;
            ((Galley)this.theGalley).getGalleyEditor().setSplitUse(true);
            double my = x;
            double mx = y;
            double fy = 1.0 - my / (double)this.getHeight();
            double cx = (double)this.getWidth() * fy;
            if (mx <= cx) {
                Node iU;
                if (checkAlts && (fN = this.getFrontBox()) != null && !((Boolean)(iU = fN.getChildNamed(new String[]{"inUse"})).getValue()).booleanValue()) {
                    ((Galley)this.theGalley).getGalleyEditor().setSplitUse(false);
                    return false;
                }
                this.isUpperBoxSelected = true;
            } else {
                Node iU;
                if (checkAlts && (fN = this.getRearBox()) != null && !((Boolean)(iU = fN.getChildNamed(new String[]{"inUse"})).getValue()).booleanValue()) {
                    ((Galley)this.theGalley).getGalleyEditor().setSplitUse(false);
                    return false;
                }
                this.isUpperBoxSelected = false;
            }
            Area a = null;
            a = this.nameEnterField != null ? new Area(this.nameEnterField.getBounds()) : new Area(new Rectangle(1, (this.getHeight() - this.getFont().getSize()) / 2, this.getWidth() - 2, this.getFont().getSize() + 3));
            if (!this.isSplittlineContiuous()) {
                if (this.theGalley.getModel().getPegasusState() == 7) {
                    ((Galley)this.theGalley).getGalleyEditor().setSubstractArea(null);
                } else {
                    ((Galley)this.theGalley).getGalleyEditor().setSubstractArea(a);
                }
            } else {
                ((Galley)this.theGalley).getGalleyEditor().setSubstractArea(null);
            }
            ((Galley)this.theGalley).getGalleyEditor().setUpperSelect(this.isUpperBoxSelected);
            if (this.theGalley.getModel().getPegasusState() == 7) {
                if (this.isUpperBoxSelected) {
                    this.altNameALabel.setLocation(this.altNameALabel.getX() + 10, this.altNameALabel.getY());
                } else {
                    this.altNameBLabel.setLocation(this.altNameBLabel.getX() - 10, this.altNameBLabel.getY());
                }
            }
        } else {
            ((Galley)this.theGalley).getGalleyEditor().setSubstractArea(null);
            ((Galley)this.theGalley).getGalleyEditor().setSplitUse(false);
        }
        return true;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isDraggable) {
            return;
        }
        if (this.pegasus.isLocked()) {
            return;
        }
        if (this.theBackupPoint == null) {
            return;
        }
        if (!this.isDragging && (Math.abs(this.theBackupPoint.getX() - (double)e.getX()) > (double)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("gc_minimal_drag_distance")).intValue() || Math.abs(this.theBackupPoint.getY() - (double)e.getY()) > (double)AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("gc_minimal_drag_distance")).intValue())) {
            if (this.isSecondTrolley) {
                this.theBehindBox.setFrontBox(null);
                this.setBehindBox(null);
                this.setSecondTrolley(false);
            } else if (this.theFrontBox != null) {
                this.theFrontBox.setBehindBox(null);
                this.theFrontBox.setSecondTrolley(false);
                this.setFrontBox(null);
            }
            this.theGalley.deactivateEditor();
            this.theGalley.getDragController().startDragging(this, false);
            this.isDragging = true;
        } else if (this.isDragging) {
            double dx = this.theBackupPoint.getX() - (double)e.getX();
            double dy = this.theBackupPoint.getY() - (double)e.getY();
            this.theGalley.getDragController().moveBox(this.getX() - (int)dx, this.getY() - (int)dy, this);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize((int)d.getWidth(), (int)d.getHeight());
    }

    @Override
    public void setSize(int w, int h) {
        int aWidth;
        if (this.isServiceSpace) {
            int nw = w;
            int nh = h;
            if (this.isShadowExpansion) {
                nw -= this.theSkin.getImage32(Button.ButtonState.UP).getWidth();
                nh -= this.theSkin.getImage23(Button.ButtonState.UP).getHeight();
            }
            Shape s = DrawToolkit.createHatchTexture(nw, nh, 0.5235987755982988, 8);
            Rectangle clip = new Rectangle(0, 0, nw, nh);
            if (this.serviceInsertShape == null) {
                this.serviceInsertShape = new FadebleShape(s, false);
                this.serviceInsertShape.setOutLineColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_box_service_hatch_color")));
                this.serviceInsertShape.setProgress(1.0f);
            }
            this.serviceInsertShape.setSize(nw, nh);
            this.serviceInsertShape.setShape(s);
            this.serviceInsertShape.setClipingArea(clip);
        }
        if (this.nameLabel != null) {
            aWidth = 0;
            if (this.nameLabel2 != null) {
                aWidth = (int)this.nameLabel2.getPreferredSize().getWidth();
            }
            int aHeight = h;
            aWidth = w;
            if (this.isShadowExpansion) {
                aWidth -= this.theSkin.getImage32(Button.ButtonState.UP).getWidth();
                aHeight -= this.theSkin.getImage23(Button.ButtonState.UP).getHeight();
            }
            boolean b = false;
            if (this.nameLabel2 != null) {
                b = true;
                this.nameLabel2.setSize(aWidth - 8, (int)this.nameLabel2.getPreferredSize().getHeight());
                this.nameLabel2.setLocation((aWidth - this.nameLabel2.getWidth()) / 2, (int)((double)((aHeight - this.nameLabel2.getHeight()) / 2) + this.nameLabel2.getPreferredSize().getHeight() / 2.0));
            }
            aWidth = (int)this.nameLabel.getPreferredSize().getWidth();
            aWidth = w;
            if (this.isShadowExpansion) {
                aWidth -= this.theSkin.getImage32(Button.ButtonState.UP).getWidth();
                aHeight -= this.theSkin.getImage23(Button.ButtonState.UP).getHeight();
            }
            this.nameLabel.setSize(aWidth - 8, (int)this.nameLabel.getPreferredSize().getHeight());
            if (b) {
                this.nameLabel.setLocation((aWidth - this.nameLabel.getWidth()) / 2, (int)((double)((aHeight - this.nameLabel.getHeight()) / 2) - this.nameLabel.getPreferredSize().getHeight() / 2.0));
            } else {
                this.nameLabel.setLocation((aWidth - this.nameLabel.getWidth()) / 2, (aHeight - this.nameLabel.getHeight()) / 2);
            }
        }
        if (this.altNameAEnterField != null) {
            this.altNameAEnterField.setLocation(5, 5);
            this.altNameAEnterField.setSize(w / 2, (int)this.altNameAEnterField.getPreferredSize().getHeight());
        }
        if (this.altNameBEnterField != null) {
            this.altNameBEnterField.setLocation(w / 2 - 4, (int)((double)this.getHeight() - (this.altNameBEnterField.getPreferredSize().getHeight() + 5.0)));
            this.altNameBEnterField.setSize(w / 2, (int)this.altNameBEnterField.getPreferredSize().getHeight());
        }
        if (this.altNameALabel != null) {
            aWidth = (int)this.altNameALabel.getPreferredSize().getWidth();
            if (aWidth > w - 12) {
                aWidth = w - 12;
            }
            this.altNameALabel.setSize(aWidth, (int)this.altNameALabel.getPreferredSize().getHeight());
            if (this.theGalley.getSelectedBox() == this && this.theGalley.getGlobalSelectionContoller().getMainSelection() == this && this.isUpperBoxSelected) {
                this.altNameALabel.setLocation(17, 1);
            } else if (this.useInset == 3) {
                this.altNameALabel.setLocation(17, 1);
            } else {
                this.altNameALabel.setLocation(7, 1);
            }
        }
        if (this.altNameBLabel != null) {
            aWidth = (int)this.altNameBLabel.getPreferredSize().getWidth();
            if (aWidth > w - 12) {
                aWidth = w - 12;
            }
            int tWidth = w;
            int aHeight = h;
            if (this.isShadowExpansion) {
                aHeight -= this.theSkin.getImage23(Button.ButtonState.UP).getHeight();
                tWidth -= this.theSkin.getImage32(Button.ButtonState.UP).getWidth();
            }
            this.altNameBLabel.setSize(aWidth, (int)this.altNameBLabel.getPreferredSize().getHeight());
            if (this.theGalley.getSelectedBox() == this && this.theGalley.getGlobalSelectionContoller().getMainSelection() == this && !this.isUpperBoxSelected) {
                if (this.theGalley.getModel().getPegasusState() == 7) {
                    this.altNameBLabel.setLocation(tWidth - (5 + this.altNameBLabel.getWidth() + 10), aHeight - (1 + this.altNameBLabel.getHeight()));
                } else {
                    this.altNameBLabel.setLocation(tWidth - (5 + this.altNameBLabel.getWidth()), aHeight - (1 + this.altNameBLabel.getHeight()));
                }
            } else if (this.useInset == 5) {
                this.altNameBLabel.setLocation(tWidth - (5 + this.altNameBLabel.getWidth() + 10), aHeight - (1 + this.altNameBLabel.getHeight()));
            } else {
                this.altNameBLabel.setLocation(tWidth - (5 + this.altNameBLabel.getWidth()), aHeight - (1 + this.altNameBLabel.getHeight()));
            }
        }
        super.setSize(w, h);
    }

    @Override
    public void layoutPanel(int w, int h, boolean isSub) {
        if (isSub) {
            int nw = (int)((double)w * (Double)this.theZSizeNode.getValue()) + 1;
            int nh = (int)((double)h * (Double)this.theYSizeNode.getValue()) + 1;
            this.setSize(nw, nh);
        } else {
            if (this.isSecondTrolley) {
                this.setLocation(this.getX(), this.getY() + 10);
                this.setSize((int)((double)w * (Double)this.theXSizeNode.getValue()), (int)((double)h * (Double)this.theYSizeNode.getValue()) - 10);
            } else if (this.theXSizeNode != null && this.theYSizeNode != null && this.theXSizeNode.getValue() != null && this.theYSizeNode.getValue() != null) {
                this.setSize((int)((double)w * (Double)this.theXSizeNode.getValue()) + 1, (int)((double)h * (Double)this.theYSizeNode.getValue()) + 1);
            } else {
                this.setSize(w + 1, h + 1);
            }
            if (this.nameEnterField != null) {
                this.nameEnterField.setLocation((this.getWidth() - this.nameEnterField.getWidth()) / 2, (this.getHeight() - this.nameEnterField.getHeight()) / 2);
            }
        }
    }

    @Override
    public void setSelected(int level) {
        this.isSelected = level;
    }

    @Override
    public int isSelected() {
        return this.isSelected;
    }

    @Override
    public void movePanel(int x, int y, boolean smooth) {
        if (smooth && this.mover != null) {
            this.mover.setLocationSmooth(x, y);
            return;
        }
        this.setLocation(x, y);
    }

    public void setGalley(GalleyGridPanel galley) {
        this.theGalley = galley;
    }

    @Override
    public Component getTopParent() {
        return this.theGalley;
    }

    public void setSecondTrolley(boolean b) {
        this.isSecondTrolley = b;
    }

    public void resetBackground() {
    }

    private boolean hasAlternatives() {
        Iterator it = this.alternativesNode.getChilds();
        int count = 0;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (this.theGalley.getModel().getPegasusState() != 7 || ((GalleyEquipmentComplete)n.getValue(GalleyEquipmentComplete.class)).getEquipmentSetType() != this.theGalley.getCurrentEquipmentType()) continue;
            ++count;
        }
        return count >= 2;
    }

    public void childAdded(Node<?> source, Node<?> child) {
        if (source == this.alternativesNode) {
            this.ensureAlternatives(this.hasAlternatives(), -1);
        }
        if (this.theNode == source && child.getName().equals("stowageContainerType")) {
            if (this.typeNode != null) {
                this.typeNode.removeNodeListener((NodeListener)this);
            }
            this.typeNode = this.theNode.getChildNamed(new String[]{"stowageContainerType"});
            this.loadSizes();
            this.layoutPanel(this.theGalley.getGrid().getGridSizeX(), this.theGalley.getGrid().getGridSizeY(), false);
        }
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        if (source == this.alternativesNode) {
            this.ensureAlternatives(this.hasAlternatives(), 0);
        }
    }

    public void valueChanged(Node<?> node) {
        if (this.isKilled()) {
            if (node != null) {
                node.removeNodeListener((NodeListener)this);
            }
            return;
        }
        if (node == this.theNameNode) {
            this.repaint(32L);
        } else if (node.getName().equals("useAlternatives")) {
            Node<?> alts = node;
            if (this.theGalley.getModel().getPegasusState() == 7) {
                this.ensureAlternatives((Boolean)alts.getValue(), -1);
                this.enableNameEdit(false, true);
            } else {
                this.ensureAlternatives((Boolean)alts.getValue(), 0);
            }
            this.selectAlternative(0, 0);
        } else if (node == this.hasLabel) {
            if (this.theGalley.getSelectedBox() == this && this.hasEditor) {
                this.theGalley.getEditor().setLabelActive(this.hasLabel());
            }
        } else if (node == this.typeNode) {
            this.revalidateTypeState();
            this.loadSizes();
            this.theGalley.getGrid().layoutBoxes(true);
        } else if (node.getName().equals("type")) {
            StowagePositionTypeComplete t = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getLooseStowageType();
            if (t.equals(node.getValue())) {
                this.isResizable = true;
                if (this.theNode.getChildNamed(new String[]{"dimension"}).getValue() == null) {
                    Dimension3dComplete d = new Dimension3dComplete();
                    d.setWidth(t.getSize().getWidth());
                    d.setHeight(t.getSize().getHeight());
                    d.setDepth(t.getSize().getDepth());
                    this.theNode.getChildNamed(new String[]{"dimension"}).setValue((Object)d, System.currentTimeMillis());
                }
            } else {
                this.isResizable = false;
            }
            this.loadSizes();
        } else if (this.theGalley.getGrid() != null) {
            this.theGalley.getGrid().layoutBoxes(true);
        }
    }

    public boolean isBoxValid() {
        return this.isValid;
    }

    public void setBoxValid(boolean valid) {
        this.isValid = valid;
    }

    private Node getFrontBox() {
        Node nodes = this.theNode.getChildNamed(new String[]{"usedGalleyEquipment"});
        Iterator it = nodes.getChilds();
        while (it.hasNext()) {
            Node zPos;
            Node equ = (Node)it.next();
            Node eqType = equ.getChildNamed(new String[]{"equipmentSetType"});
            if (eqType.getValue() != this.theGalley.getCurrentEquipmentType() || (zPos = equ.getChildNamed(new String[]{"location-z"})) == null || zPos.getValue() == null || (Double)zPos.getValue() != 0.0) continue;
            return equ;
        }
        return null;
    }

    private Node getRearBox() {
        Node nodes = this.theNode.getChildNamed(new String[]{"usedGalleyEquipment"});
        Iterator it = nodes.getChilds();
        while (it.hasNext()) {
            Node zPos;
            Node equ = (Node)it.next();
            Node eqType = equ.getChildNamed(new String[]{"equipmentSetType"});
            if (eqType.getValue() != this.theGalley.getCurrentEquipmentType() || (zPos = equ.getChildNamed(new String[]{"location-z"})) == null || zPos.getValue() == null || !((Double)zPos.getValue() > 0.0)) continue;
            return equ;
        }
        return null;
    }

    private Node getCabinBox() {
        if (this.theNode == null) {
            return null;
        }
        Node nodes = this.theNode.getChildNamed(new String[]{"usedGalleyEquipment"});
        if (nodes == null) {
            return null;
        }
        Iterator it = nodes.getChilds();
        while (it.hasNext()) {
            Node equ = (Node)it.next();
            Node eqType = equ.getChildNamed(new String[]{"equipmentSetType"});
            if (eqType.getValue() != this.theGalley.getCurrentEquipmentType()) continue;
            return equ;
        }
        return null;
    }

    private boolean isInUse() {
        if (this.theGalley.getModel().isDefinition()) {
            return true;
        }
        Node cabinBox = this.getCabinBox();
        if (cabinBox != null) {
            return (Boolean)cabinBox.getChildNamed(new String[]{"inUse"}).getValue();
        }
        return true;
    }

    public Node getEffectedNode() {
        Node nodes = this.theNode.getChildNamed(new String[]{"usedGalleyEquipment"});
        if (this.useAlternatives) {
            if (this.isUpperBoxSelected) {
                Node frontBox = this.getFrontBox();
                return frontBox;
            }
            Node rearBox = this.getRearBox();
            return rearBox;
        }
        Node cabinBox = this.getCabinBox();
        return cabinBox;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.enableNameEdit(false, true);
    }

    public void revalidateTypeState() {
        Node type = null;
        if (this.theGalley.isSubGrid()) {
            if (this.theNode.getValue() instanceof GalleyEquipmentReservedSpaceComplete) {
                this.isServiceSpace = true;
                type = this.theNode.getChildNamed(new String[]{"containedInsertType"});
                this.theYCoord = this.theNode.getChildNamed(new String[]{"coordinate3d-y"});
                this.theZCoord = this.theNode.getChildNamed(new String[]{"coordinate3d-z"});
                this.backgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("fill_flight_service_space_background"));
            } else {
                type = this.theNode.getChildNamed(new String[]{"type"});
                this.theYCoord = this.theNode.getChildNamed(new String[]{"coordinates-y"});
                this.theZCoord = this.theNode.getChildNamed(new String[]{"coordinates-z"});
                Node n = type.getChildNamed(new String[]{"displayColor"});
                this.backgroundColor = new Color(((Color3DComplete)n.getValue()).getRed().floatValue(), ((Color3DComplete)n.getValue()).getGreen().floatValue(), ((Color3DComplete)n.getValue()).getBlue().floatValue());
                if (this.typeNode != null) {
                    this.typeNode.removeNodeListener((NodeListener)this);
                }
                this.typeNode = type;
                if (this.typeNode != null) {
                    this.typeNode.addNodeListener((NodeListener)this);
                }
            }
        }
        this.loadSizes();
        this.theGalley.getGrid().layoutBoxes();
        this.theGalley.activateEditor4Box(this);
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public boolean stillAlive() {
        return true;
    }

    public boolean isResizable() {
        return this.isResizable;
    }

    public boolean isSwingOnly() {
        return true;
    }
}

