/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.AbstractGalleyBoxEditor;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.DragController;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBox;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyGrid;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GridSpace;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.FadeInOutPanel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.GlobalSelectionController;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.FadebleShape;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.LoadingStateComponent;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public abstract class GalleyGridPanel
extends FadeInOutPanel
implements LoadingStateComponent {
    private static final long serialVersionUID = 1L;
    protected GalleyGrid theGrid;
    protected GalleyBox theSelectedBox;
    protected DragController theDragController;
    protected GlobalSelectionController theGlobalSeletionController;
    protected GalleyModel theModel;
    protected FadebleShape notSelectedShape;
    protected boolean isNullSelection;
    protected FadebleShape selectionShape;
    protected PegasusSubModule pegasus;
    private long unDoId;

    public GalleyGridPanel(PegasusSubModule pegasus, boolean hasTitle) {
        super(hasTitle);
        this.pegasus = pegasus;
        this.unDoId = System.currentTimeMillis();
        this.lafAttributeChanged("All attribues changed");
    }

    public GalleyGridPanel(PegasusSubModule pegasus) {
        this(pegasus, false);
    }

    public GalleyEquipmentSetTypeE getCurrentEquipmentType() {
        return null;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.theGrid.kill();
        this.theGrid = null;
        this.theSelectedBox = null;
        this.theDragController = null;
        this.theGlobalSeletionController = null;
        this.theModel.kill();
        this.theModel = null;
        if (this.notSelectedShape != null) {
            this.notSelectedShape.kill();
        }
        this.notSelectedShape = null;
        if (this.selectionShape != null) {
            this.selectionShape.kill();
        }
        this.selectionShape = null;
    }

    public abstract AbstractGalleyBoxEditor getEditor();

    public GridSpace getMaxSpace(int x, int y) {
        int currentY;
        double currentDepth = 0.5;
        double currentHeight = 1.0;
        int currentX = x;
        boolean unableToHighLight = false;
        boolean found = false;
        for (currentY = y; this.isEmptyField(currentX, currentY, currentDepth, currentHeight, currentDepth) == 1 && currentY > 0; currentY -= this.theGrid.getGridSizeY()) {
            found = true;
        }
        if (found) {
            currentY += this.theGrid.getGridSizeY();
            found = false;
            while (this.isEmptyField(currentX, currentY, currentDepth, currentHeight, currentDepth) == 1 && currentX > 0) {
                found = true;
                currentX -= this.theGrid.getGridSizeX() / 2;
            }
            if (found) {
                currentX += this.theGrid.getGridSizeX() / 2;
                found = false;
                while (this.isEmptyField(currentX, currentY, currentDepth, currentHeight, currentDepth) == 1 && currentDepth <= this.theGrid.getGridCountX()) {
                    found = true;
                    currentDepth += 0.5;
                }
                if (found) {
                    currentDepth -= 0.5;
                    found = false;
                    while (this.isEmptyField(currentX, currentY, currentDepth, currentHeight, currentDepth) == 1 && currentHeight <= this.theGrid.getGridCountY()) {
                        found = true;
                        currentHeight += 1.0;
                    }
                    if (found) {
                        currentHeight -= 1.0;
                    } else {
                        unableToHighLight = true;
                    }
                } else {
                    unableToHighLight = true;
                }
            } else {
                unableToHighLight = true;
            }
        } else {
            unableToHighLight = true;
        }
        if (unableToHighLight) {
            return null;
        }
        double cX = this.theGrid.getDiscretIndexX(currentX, currentDepth);
        double cY = this.theGrid.getDiscretIndexY(currentY, currentHeight);
        return new GridSpace(cX, cY, currentDepth, currentHeight);
    }

    public boolean highlightMaxSpace(double x, double y) {
        int currentY;
        double currentDepth = 0.5;
        double currentHeight = 1.0;
        int currentX = (int)x;
        boolean unableToHighLight = false;
        boolean found = false;
        for (currentY = (int)y; this.isEmptyField(currentX, currentY, currentDepth, currentHeight, currentDepth) == 1 && currentY > 0; currentY -= this.theGrid.getGridSizeY()) {
            found = true;
        }
        if (found) {
            currentY += this.theGrid.getGridSizeY();
            found = false;
            while (this.isEmptyField(currentX, currentY, currentDepth, currentHeight, currentDepth) == 1 && currentX > 0) {
                found = true;
                currentX -= this.theGrid.getGridSizeX() / 2;
            }
            if (found) {
                currentX += this.theGrid.getGridSizeX() / 2;
                found = false;
                while (this.isEmptyField(currentX, currentY, currentDepth, currentHeight, currentDepth) == 1 && currentDepth <= this.theGrid.getGridCountX()) {
                    found = true;
                    currentDepth += 0.5;
                }
                if (found) {
                    currentDepth -= 0.5;
                    found = false;
                    while (this.isEmptyField(currentX, currentY, currentDepth, currentHeight, currentDepth) == 1 && currentHeight <= this.theGrid.getGridCountY()) {
                        found = true;
                        currentHeight += 1.0;
                    }
                    if (found) {
                        currentHeight -= 1.0;
                    } else {
                        unableToHighLight = true;
                    }
                } else {
                    unableToHighLight = true;
                }
            } else {
                unableToHighLight = true;
            }
        } else {
            unableToHighLight = true;
        }
        if (!unableToHighLight) {
            if (this.isEmptyField(currentX, currentY, currentDepth, currentHeight, currentDepth) == 1) {
                this.theGrid.setMultiplier(currentDepth, currentHeight, currentDepth);
                this.theGrid.highlightPoint(currentX, currentY);
                this.createHighLightShape();
            }
        } else {
            this.theGrid.highlightPoint(-1, -1);
            if (this.selectionShape != null) {
                this.selectionShape.setProgress(0.0f);
            }
        }
        this.repaint(32L);
        return !unableToHighLight;
    }

    public void ensureGridSize(double w, double h, boolean doitAnyway) {
        this.theGrid.ensureGridSize(w, h, doitAnyway);
    }

    public boolean isNullSelection() {
        return this.isNullSelection;
    }

    public void deactivateEditorIfDeleted(GalleyBox b) {
    }

    protected void deactivateEditor() {
    }

    public void setNullSelection(boolean isNullSelection) {
        if (this.isNullSelection != isNullSelection) {
            if (this.notSelectedShape == null) {
                this.generateShape(this.getWidth(), this.getHeight());
                this.notSelectedShape.setUseAddHeight(true);
                this.add((Component)this.notSelectedShape, 0);
            }
            if (isNullSelection) {
                this.setComponentZOrder(this.notSelectedShape, 0);
                this.notSelectedShape.setProgress(1.0f);
                this.remove(this.theGrid);
                if (this.selectionShape != null) {
                    this.selectionShape.setProgress(0.0f);
                }
            } else {
                this.notSelectedShape.setProgress(0.0f);
                this.add((Component)this.theGrid, 0);
                this.theGrid.setProgress(1.0f);
                if (this.selectionShape != null) {
                    this.setComponentZOrder(this.selectionShape, 0);
                }
            }
            this.isNullSelection = isNullSelection;
            this.repaint(32L);
        }
    }

    protected void generateShape(int w, int h) {
        GeneralPath path = new GeneralPath();
        path.moveTo(2.0f, this.getTitleHeight());
        path.lineTo(this.getWidth() - 2, this.getHeight() - 2);
        path.moveTo(this.getWidth() - 2, this.getTitleHeight());
        path.lineTo(2.0f, this.getHeight() - 2);
        if (this.notSelectedShape == null) {
            this.notSelectedShape = new FadebleShape(path, false);
            this.notSelectedShape.setText(Words.NO_EQUIPMENT_IS_SELECTED);
            float[] dash = new float[]{AttributesConverter.getFloat4String(AttributeLoader.getAttributeLoader().getAttribute("table_detailsparagraph_shape_dash")).floatValue()};
            this.notSelectedShape.setShapeStroke(new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f));
            this.notSelectedShape.setOutLineColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_line_color")));
            this.notSelectedShape.setProgress(1.0f);
            this.notSelectedShape.setSize(w, h);
        } else {
            this.notSelectedShape.setShape(path);
            this.notSelectedShape.setSize(w, h);
        }
        this.notSelectedShape.getFader().setPermanent(true);
    }

    @Override
    public void activateDataLoadingAnimation(String t, Integer a, Integer b) {
        this.setEnabled(false);
    }

    @Override
    public void deactivateDataLoadingAnimation() {
        this.setEnabled(true);
    }

    public void insertSelectivGalley(Node v) {
    }

    public void removeSelectivGalley(Node v) {
    }

    public void setSelectedGalley(Node galleyNode) {
    }

    public void selectFirstGalley() {
    }

    public Node getSelectedGalley() {
        return null;
    }

    public GalleyBox getBox4Node(Node node) {
        return this.theGrid.getBox4Node(node);
    }

    public GalleyBox getBox4Coordinates(double x, double y) {
        return this.theGrid.getBox4Coordinate(x, y);
    }

    public GalleyBox getBox4ConcretCoordinates(double x, double y) {
        int tx = (int)x;
        int ty = (int)y;
        if (this.theGrid.intersectsBox(tx, ty)) {
            return this.theGrid.getIntersectingBox(tx, ty);
        }
        return null;
    }

    public void setSelectedBox(GalleyBox box, int level) {
        if (box != this.theSelectedBox) {
            if (this.theSelectedBox != null) {
                this.theSelectedBox.setSelected(7);
            }
            this.theSelectedBox = box;
            if (this.theSelectedBox != null) {
                box.setSelected(level);
            }
            this.repaint(32L);
        }
    }

    public void selectBox(GalleyBox box, int x, int y) {
        if (this.theSelectedBox == null && box == null) {
            return;
        }
        Node node = null;
        node = box == null ? null : (box.getBoxNode().getValue() instanceof GalleyEquipmentComplete ? box.getNode() : box.getBoxNode());
        this.theSelectedBox = box;
        this.theGlobalSeletionController.newNodeSelected(node, box, -1, box);
    }

    public void activateEditor4Box(GalleyBox box) {
    }

    public void selectNode(Node<?> parent, int level) {
        this.theGrid.selectNode(parent, level);
        this.repaint(32L);
    }

    public void highlightGrid(int x, int y) {
        if (this.isEmptyField(x, y, this.theGrid.getMultiplierX(), this.theGrid.getMultiplierY(), this.theGrid.getMultiplierZ()) > 0 && (this.theGrid.getMultiplierX() != 0.0 || this.theGrid.getMultiplierZ() != 0.0)) {
            this.theGrid.highlightPoint(x, y);
            this.createHighLightShape();
        } else {
            this.theGrid.highlightPoint(-1, -1);
            if (this.selectionShape != null) {
                this.selectionShape.setProgress(0.0f);
            }
        }
    }

    protected void createHighLightShape() {
        if (this.theGrid.getDragPoint() != null) {
            int aX = (int)this.theGrid.getDragPoint().getX();
            int aY = (int)this.theGrid.getDragPoint().getY();
            double cX = this.theGrid.getDiscretIndexX(aX, this.theGrid.getMultiplierX());
            double cY = this.theGrid.getDiscretIndexY(aY, this.theGrid.getMultiplierY());
            int aRectX = (int)(cX * (double)this.theGrid.getGridSizeX());
            int aRectY = (int)(cY * (double)this.theGrid.getGridSizeY());
            aRectX += this.theGrid.getGridOffsetX() + this.theGrid.getX();
            aRectY += this.theGrid.getGridOffsetY() + this.theGrid.getY();
            int sw = (int)((double)this.theGrid.getGridSizeX() * this.theGrid.getMultiplierX()) + 2 * this.theGrid.getSelectionOverHead();
            int sh = (int)((double)this.theGrid.getGridSizeY() * this.theGrid.getMultiplierY()) + 2 * this.theGrid.getSelectionOverHead();
            Shape s = DrawToolkit.createHatchTexture(sw, sh, 0.5235987755982988, 5);
            if (this.selectionShape == null) {
                this.selectionShape = new FadebleShape(s, false);
                this.selectionShape.setSurround(true);
                this.selectionShape.setClipingArea(new Rectangle2D.Double(0.0, 0.0, sw, sh));
                this.selectionShape.setClipFillColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_highlight_fill_color")));
                this.selectionShape.setOutLineColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_highlight_color")));
                this.selectionShape.setSurroundColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_highlight_outline_color")));
                this.selectionShape.setProgress(1.0f);
                this.selectionShape.setLocation(aRectX, aRectY);
                this.selectionShape.setSize(sw + 1, sh + 1);
                this.add((Component)this.selectionShape, 0);
            } else {
                this.selectionShape.setShape(s);
                this.selectionShape.setLocation(aRectX, aRectY);
                this.selectionShape.setClipingArea(new Rectangle2D.Double(0.0, 0.0, sw, sh));
                this.selectionShape.setSize(sw + 1, sh + 1);
                this.selectionShape.setProgress(1.0f);
            }
        }
    }

    public int isEmptyField(int x, int y, double xdSize, double ydSize, double zdSize) {
        return this.theGrid.isEmptyField(x, y, xdSize, ydSize, zdSize);
    }

    public int isDiscretEmptyField(double x, double y, double xSize, double ydSize) {
        return this.theGrid.isDiscretEmptyField(x, y, xSize, ydSize);
    }

    public void setMultiplier(double xm, double ym, double zm) {
        this.theGrid.setMultiplier(xm, ym, zm);
    }

    public boolean isBoxDraggable(Node<Integer> type) {
        return this.theGrid.isDraggableBox(type);
    }

    public boolean isBoxSelectabe(Node<Integer> type) {
        return this.theGrid.isBoxSelectable(type);
    }

    public void removeBox(GalleyBox galleyBox) {
        this.theGrid.removeBox(galleyBox);
    }

    public GalleyBox insertBox(Node<String> boxNode) {
        GalleyBox aBox = new GalleyBox(this.pegasus, boxNode, this);
        this.theGrid.addBox(aBox);
        aBox.fadeIn();
        aBox.setProgress(0.0f);
        return aBox;
    }

    public void addSpecialBox(GalleyBox box) {
        this.theGrid.addSpecialBox(box);
    }

    public void addSpecialBox(int x, int y, GalleyBox aBox) {
        double aX = this.theGrid.getDiscretIndexX(x, aBox.getDWidth());
        aX = this.isSubGrid() ? this.theGrid.getDiscretIndexX(x, aBox.getDDepth()) : this.theGrid.getDiscretIndexX(x, aBox.getDWidth());
        double aY = this.theGrid.getDiscretIndexY(y, aBox.getDHeight());
        GalleyBox underBox = this.theGrid.getIntersectingBox(x, y, true);
        Node v = aBox.getNode().getParent();
        v.setValue(underBox.getNode().getValue(), this.unDoId);
        Node yPos = aBox.getNode().getChildNamed(new String[]{"YCoord"});
        if (this.isSubGrid()) {
            Node zPos = aBox.getNode().getChildNamed(new String[]{"ZCoord"});
            if (zPos == null) {
                zPos = new Node();
                zPos.setName("XCoord");
                aBox.getNode().addChild(zPos, this.unDoId);
            }
            if (zPos instanceof Node) {
                zPos.setValue((Object)aX, this.unDoId);
            }
        } else {
            Node xPos = aBox.getNode().getChildNamed(new String[]{"XCoord"});
            if (xPos instanceof Node) {
                xPos.setValue((Object)aX, this.unDoId);
            }
        }
        if (yPos instanceof Node) {
            yPos.setValue((Object)aY, this.unDoId);
        }
        aBox.setGalley(this);
        this.addSpecialBox(aBox);
    }

    public void addBox(GalleyBox box) {
        this.theGrid.addBox(box);
    }

    public GalleyBox addBox(int x, int y, Node boxNode) {
        return this.addBox(x, y, boxNode, null);
    }

    public GalleyBox addBox(int x, int y, Node clone, String newValue) {
        return this.insertBox((Node<String>)clone);
    }

    public void addBox(int x, int y, GalleyBox aBox) {
        double aX = 0.0;
        aX = this.isSubGrid() ? this.theGrid.getDiscretIndexX(x, aBox.getDDepth()) : this.theGrid.getDiscretIndexX(x, aBox.getDWidth());
        double aY = this.theGrid.getDiscretIndexY(y, aBox.getDHeight());
        if (this.theModel.getPegasusState() == 3) {
            Node yPos = aBox.getBoxNode().getChildNamed(new String[]{"location-y"});
            Node xPos = aBox.getBoxNode().getChildNamed(new String[]{"location-x"});
            if (yPos instanceof Node) {
                yPos.setValue((Object)aY, this.unDoId);
            }
            if (xPos instanceof Node) {
                xPos.setValue((Object)aX, this.unDoId);
            }
            Node alternatives = aBox.getBoxNode().getParent().getParent().getChildNamed(new String[]{"alternativePositions"});
            Iterator it = alternatives.getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                n.getChildNamed(new String[]{"location-y"}).setValue((Object)aY, this.unDoId);
                n.getChildNamed(new String[]{"location-x"}).setValue((Object)aX, this.unDoId);
            }
        } else {
            Node yPos = aBox.getBoxNode().getChildNamed(new String[]{"coordinates-y"});
            if (this.isSubGrid()) {
                Node zPos = aBox.getBoxNode().getChildNamed(new String[]{"coordinates-z"});
                if (zPos instanceof Node) {
                    zPos.setValue((Object)aX, this.unDoId);
                }
            } else {
                Node xPos = aBox.getBoxNode().getChildNamed(new String[]{"coordinates-x"});
                if (xPos instanceof Node) {
                    xPos.setValue((Object)aX, this.unDoId);
                }
            }
            if (yPos instanceof Node) {
                yPos.setValue((Object)aY, this.unDoId);
            }
        }
        aBox.setGalley(this);
        this.theGrid.addBox(aBox);
    }

    public boolean containsBox(GalleyBox box) {
        return this.theGrid.containsBox(box);
    }

    public void startDragging() {
        if (this.theModel.getNode() != null) {
            this.theGrid.showGrid(true);
        }
    }

    public void stopDragging() {
        this.theGrid.showGrid(false);
    }

    public boolean isGridActiv() {
        return this.theGrid.isShowGrid();
    }

    public boolean isSubGrid() {
        return this.theGrid.isSubGrid();
    }

    public GalleyGrid getGrid() {
        return this.theGrid;
    }

    public Dimension getGridSize() {
        return this.theGrid.getGridSize();
    }

    public Node getSelectedNode() {
        if (this.theSelectedBox == null) {
            return null;
        }
        return this.theSelectedBox.getNode();
    }

    public GalleyBox getSelectedBox() {
        return this.theSelectedBox;
    }

    public Rectangle getGridRectangle() {
        Rectangle aRect = new Rectangle();
        aRect.setSize(this.theGrid.getWidth(), this.theGrid.getHeight());
        aRect.setLocation(this.theModel.getTranslatedPoint());
        return aRect;
    }

    public void setGlobalSelectionController(GlobalSelectionController cont) {
        this.theGlobalSeletionController = cont;
    }

    public GlobalSelectionController getGlobalSelectionContoller() {
        return this.theGlobalSeletionController;
    }

    public void setDragController(DragController c) {
        this.theDragController = c;
    }

    public DragController getDragController() {
        return this.theDragController;
    }

    public void setMode(GalleyModel model) {
        this.theModel = model;
    }

    public GalleyModel getModel() {
        return this.theModel;
    }

    public void gridResized(double theGridCountX, double theGridCountY) {
    }
}

