/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.label;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.converter.GalleyEquipmentInsertPosNameConverter;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.converter.GalleyEquipmentPosNameConverter;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.label.utils.LabelComparator;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.label.utils.LabelRemarkPopupInsert;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.label.utils.LabelTableRow;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.FadeInOutPanel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.TabbedBackButton;
import ch.icit.pegasus.client.gui.utils.buttons.TabbedBackButtonContainer;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.ViewNodeDataChangeHandler;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.toolkits.LabelToolkit;
import ch.icit.pegasus.client.util.toolkits.LogicToolkit;
import ch.icit.pegasus.client.util.toolkits.MealPlanToolkit;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.EquipmentTemplateDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.EquipmentTemplateDeliverableComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ProductDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.SPMLMealTypeDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ServiceDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliveryInstructionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.EquipmentDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.IStowingListComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.LabelConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.label.CustomLabelEntryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Label
extends FadeInOutPanel
implements ButtonListener,
NodeListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private Node node;
    private Table2 table;
    private boolean isEquipment;
    private TabbedBackButtonContainer buttons;
    private TabbedBackButton closeLabel;
    private TitledItem<ComboBox> colorSelection;
    private TextButton previewButton;
    private TextButton remarkButton;
    private TitledItem<CheckBox> ignoreUncheckedOnCheckerSheet;
    private TitledItem<CheckBox> checkAll;
    private PegasusSubModule pegasus;

    public Label(boolean b, PegasusSubModule peg) {
        super(true);
        this.pegasus = peg;
        this.closeLabel = new TabbedBackButton(LafLoader.getLafLoader().getAttribute("smartscreen_return_backbutton_up"), TabbedBackButton.ViewState.Single);
        this.previewButton = new TextButton(Words.SHOW_LABEL);
        this.remarkButton = new TextButton("Remark");
        this.setTitleString(Words.LABEL_VIEWER);
        this.ignoreUncheckedOnCheckerSheet = new TitledItem<CheckBox>(new CheckBox(), Words.HIDE_UNCHECKED_ON_CHECKER_SHEET, TitledItem.TitledItemOrientation.NORTH);
        this.checkAll = new TitledItem<CheckBox>(new CheckBox(), "Check all", TitledItem.TitledItemOrientation.EAST);
        this.checkAll.getElement().addButtonListener(this);
        this.closeLabel.addButtonListener(this);
        this.previewButton.addButtonListener(this);
        this.remarkButton.addButtonListener(this);
        this.buttons = new TabbedBackButtonContainer();
        this.buttons.addButton(this.closeLabel);
        Node allColors = NodeToolkit.getAffixList(ColorComplete.class);
        ColorConverter viewConverter = (ColorConverter)ConverterRegistry.getConverter(ColorConverter.class);
        this.colorSelection = new TitledItem<ComboBox>(new ComboBox(null, allColors, (Converter)viewConverter, true), Words.COLOR_CODE, TitledItem.TitledItemOrientation.NORTH);
        this.lafAttributeChanged("All attribues changed");
        this.table = new Table2(true, Words.ADD_COMMENT, false);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                Label.this.table.writeNumber("labelSequenceNumber", 0);
                Label.this.checkAddButtonState();
                Label.this.table.updateOrder();
                Label.this.table.validate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                Node<CustomLabelEntryComplete> entry = LogicToolkit.getNewCustomerLabelEntry(Label.this.node, Words.ENTER_A_COMMENT_TO_THIS_LABEL, System.currentTimeMillis());
                Label.this.table.writeNumber("labelSequenceNumber", 0);
                Label.this.checkAddButtonState();
                Label.this.table.updateOrder();
                Label.this.table.validate();
            }
        });
        this.table.setComparator(ComparatorRegistry.getComparator(LabelComparator.class));
        this.table.enableAdditionalComponent(this.checkAll);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int ww = this.table.getCellPadding() * 4 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) * 3;
        int w1 = this.table.getCellPadding() * 2 + CheckBox.getPreferredWidth();
        columns.add(new TableColumnInfo("", "", String.class, null, "", w1, w1, w1));
        columns.add(new TableColumnInfo(Words.DESCRIPTION, "", String.class, null, "", new int[0]));
        columns.add(new TableColumnInfo("", "", String.class, null, "", ww, ww, ww));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> {
            if (model.getNode().getValue() instanceof EquipmentDistributionRuleComplete) {
                return new TableRowImplEQUIP(model, this);
            }
            if (model.getNode().getValue() instanceof DeliverySpaceDistributionRuleComplete) {
                return new TableRowImplInsert(model, this);
            }
            if (model.getNode().getValue() instanceof CustomLabelEntryComplete) {
                return new TableRowImplCustomEntry(model, this);
            }
            if (model.getNode() instanceof ViewNode) {
                return new TableRowImplEQUIP(model, this);
            }
            return null;
        }));
        this.table.getModel().allInitiated();
        this.add(this.table);
        this.add(this.previewButton);
        this.add(this.remarkButton);
        this.add(this.buttons);
        this.add(this.colorSelection);
        this.add(this.ignoreUncheckedOnCheckerSheet);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enable = isEnabled && !this.pegasus.isLocked();
        this.closeLabel.setEnabled(isEnabled);
        this.colorSelection.setEnabled(isEnabled);
        this.colorSelection.setEnabled(enable);
        this.ignoreUncheckedOnCheckerSheet.setEnabled(enable);
        this.checkAll.setEnabled(enable);
        this.table.setEditable(enable);
        this.table.setEnabled(isEnabled);
        this.table.enableAddButton(enable);
    }

    public void moveElementUp(Table2RowPanel p) {
        int currentIndex = this.table.getRowIndex(p);
        if (currentIndex == 0) {
            return;
        }
        int newIndex = currentIndex;
        --newIndex;
        Table2RowPanel p1 = null;
        boolean finished = false;
        while (newIndex >= 0 && !finished) {
            p1 = this.table.getRowAt(newIndex);
            finished = true;
        }
        if (p1 != null) {
            long id = System.currentTimeMillis();
            int i = (Integer)p.getModel().getNode().getChildNamed(new String[]{"labelSequenceNumber"}).getValue();
            int i1 = (Integer)p1.getModel().getNode().getChildNamed(new String[]{"labelSequenceNumber"}).getValue();
            Node seq = p.getModel().getNode().getChildNamed(new String[]{"labelSequenceNumber"});
            if (seq instanceof Node) {
                seq.setValue((Object)i1, id);
            }
            if ((seq = p1.getModel().getNode().getChildNamed(new String[]{"labelSequenceNumber"})) instanceof Node) {
                seq.setValue((Object)i, id);
            }
            this.table.updateOrder();
            this.table.relayoutRequested();
        }
    }

    public PegasusSubModule getPegasus() {
        return this.pegasus;
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.node != null) {
            this.node.removeNodeListenerRecursively((NodeListener)this);
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = null;
        this.table.kill();
        this.table = null;
        this.buttons.kill();
        this.buttons = null;
        this.colorSelection.kill();
        this.colorSelection = null;
        this.previewButton.kill();
        this.previewButton = null;
        this.remarkButton.kill();
        this.remarkButton = null;
        this.ignoreUncheckedOnCheckerSheet.kill();
        this.ignoreUncheckedOnCheckerSheet = null;
        this.pegasus = null;
    }

    public void moveElementDown(Table2RowPanel p) {
        int currentIndex = this.table.getRowIndex(p);
        if (currentIndex == this.table.getRowCount() - 1) {
            return;
        }
        int newIndex = currentIndex;
        ++newIndex;
        Table2RowPanel p1 = null;
        boolean finished = false;
        while (newIndex <= this.table.getRowCount() - 1 && !finished) {
            p1 = this.table.getRowAt(newIndex);
            finished = true;
        }
        if (p1 != null) {
            long id = System.currentTimeMillis();
            int i = (Integer)p.getModel().getNode().getChildNamed(new String[]{"labelSequenceNumber"}).getValue();
            int i1 = (Integer)p1.getModel().getNode().getChildNamed(new String[]{"labelSequenceNumber"}).getValue();
            Node seq = p.getModel().getNode().getChildNamed(new String[]{"labelSequenceNumber"});
            if (seq instanceof Node) {
                seq.setValue((Object)i1, id);
            }
            if ((seq = p1.getModel().getNode().getChildNamed(new String[]{"labelSequenceNumber"})) instanceof Node) {
                seq.setValue((Object)i, id);
            }
            this.table.updateOrder();
            this.table.relayoutRequested();
        }
    }

    private void rewriteOrder() {
        int index = 0;
        long id = System.currentTimeMillis();
        for (Table2RowPanel p : this.table.getRows()) {
            Node seq = p.getModel().getNode().getChildNamed(new String[]{"labelSequenceNumber"});
            if (!(seq instanceof Node)) continue;
            seq.setValue((Object)index++, id);
        }
    }

    public int getMaxSequenceNumber() {
        int i = -1;
        for (Table2RowPanel p : this.table.getRows()) {
            int cv = (Integer)p.getModel().getNode().getChildNamed(new String[]{"labelSequenceNumber"}).getValue();
            if (cv <= i) continue;
            i = cv;
        }
        return i;
    }

    public int getRowCount() {
        int i = 0;
        for (Table2RowPanel p : this.table.getRows()) {
            LabelTableRow p1 = (LabelTableRow)p;
            if (!p1.isOnLabel()) continue;
            ++i;
        }
        return i;
    }

    public boolean isEquipment() {
        return this.isEquipment;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.previewButton) {
            LabelToolkit.showLabelPreview(this.pegasus, x, y, this.node, source, this, this.pegasus.getStowingList());
        } else if (source == this.closeLabel) {
            this.pegasus.showLabel(false, null);
        } else if (source == this.remarkButton) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(this.remarkButton, true, true, "Label Remark");
            popUp.setView(new LabelRemarkPopupInsert(this.node.getChildNamed(new String[]{"labelConfiguration-remark"}), this.pegasus.isLocked()));
            popUp.showPopUp(x, y, (int)popUp.getView().getPreferredSize().getWidth(), (int)popUp.getView().getPreferredSize().getHeight(), this, this.remarkButton, PopupType.NORMAL);
        } else if (source == this.checkAll.getElement()) {
            this.checkAll(this.checkAll.getElement().isChecked());
        }
    }

    private void checkAll(boolean check) {
        ArrayList<Table2RowPanel> ps = new ArrayList<Table2RowPanel>();
        ps.addAll(this.table.getRows());
        for (Table2RowPanel p : ps) {
            if (p instanceof TableRowImplCustomEntry) continue;
            if (p instanceof TableRowImplEQUIP) {
                ((TableRowImplEQUIP)p).setChecked(check);
                continue;
            }
            if (!(p instanceof TableRowImplInsert)) continue;
            ((TableRowImplInsert)p).setChecked(check);
        }
    }

    public void unCheckAll() {
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize((int)d.getWidth(), (int)d.getHeight());
    }

    @Override
    public void setSize(int w, int h) {
        this.layoutPanel(w, h, false);
        super.setSize(w, h);
    }

    @Override
    public void layoutPanel(int w, int h, boolean resize) {
        int titleHeight = 0;
        this.layoutTitle(this);
        titleHeight = this.getTitleHeight();
        if (this.isExpanded()) {
            this.buttons.setVisible(true);
            int mainBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("gc_label_mainborder"));
            int innerBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("gc_label_innerborder"));
            this.buttons.setLocation(mainBorder, titleHeight + mainBorder);
            this.buttons.setSize(this.buttons.getPreferredSize());
            int bb = innerBorder + 10;
            this.remarkButton.setLocation(mainBorder + 2, this.buttons.getY() + this.buttons.getHeight() + bb * 2);
            this.remarkButton.setSize(this.previewButton.getWidth(), (int)this.remarkButton.getPreferredSize().getHeight());
            this.previewButton.setLocation(this.remarkButton.getX(), this.remarkButton.getY() + this.remarkButton.getHeight() + mainBorder);
            this.previewButton.setSize((int)this.previewButton.getPreferredSize().getWidth(), (int)this.previewButton.getPreferredSize().getHeight());
            this.ignoreUncheckedOnCheckerSheet.setLocation(this.remarkButton.getX(), this.previewButton.getY() + this.previewButton.getHeight() + mainBorder);
            this.ignoreUncheckedOnCheckerSheet.setSize(this.ignoreUncheckedOnCheckerSheet.getPreferredSize());
            this.colorSelection.setLocation(mainBorder + 2, (int)((double)h - (this.colorSelection.getPreferredSize().getHeight() + (double)mainBorder)));
            this.colorSelection.setSize(this.previewButton.getWidth(), (int)this.colorSelection.getPreferredSize().getHeight());
            this.table.setLocation(this.ignoreUncheckedOnCheckerSheet.getX() + this.ignoreUncheckedOnCheckerSheet.getWidth() + mainBorder, titleHeight);
            this.table.setSize(w - (this.table.getX() + 1), h - (titleHeight + 2));
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(g2);
        g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_line_color")));
        g2.drawLine(this.table.getX() - 1, this.skin.getImage21(Button.ButtonState.UP).getHeight(), this.table.getX() - 1, this.getHeight() - 2);
    }

    @Override
    public void movePanel(int x, int y, boolean smooth) {
    }

    public void childAdded(Node<?> source, Node<?> child) {
        ProxyNode prox;
        if (child instanceof ProxyNode && (prox = (ProxyNode)child).getRefNode() == null && prox.getSource() != null) {
            prox.setRefNode(INodeCreator.getDefaultImpl().getNodeDirectly(prox.getSource()));
        }
        this.table.getModel().getNode().addChild(child, 0L);
        this.checkAddButtonState();
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        this.table.getModel().getNode().removeChild(child, 0L);
        this.rewriteOrder();
        this.checkAddButtonState();
    }

    protected void checkAddButtonState() {
        if (this.table != null) {
            this.table.enableAddButton(true);
        }
    }

    public void valueChanged(Node<?> node) {
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node n) {
        if (this.node != null) {
            this.node.removeNodeListenerRecursively((NodeListener)this);
        }
        this.node = n;
        String t = Words.LABEL_VIEWER;
        t = t + " - ";
        if (this.node != null) {
            Node galleyName;
            Converter c;
            Node labelC;
            ViewNode oldView = (ViewNode)this.table.getModel().getNode();
            if (oldView != null) {
                oldView.kill();
            }
            ViewNode viewNode = new ViewNode("view");
            this.table.getModel().setNode((Node)viewNode);
            if (this.node.getValue(GalleyEquipmentComplete.class) instanceof GalleyEquipmentComplete) {
                this.isEquipment = true;
                this.node.getChildNamed(new String[]{"equipmentDistributionRules"}).addNodeListener((NodeListener)this);
                this.node.getChildNamed(new String[]{"equipmentDistributionRules"}).getAllChildAddEventsFor((NodeListener)this, new String[0]);
                if (this.node.getChildNamed(new String[]{"labelConfiguration"}).getValue() != null) {
                    this.node.getChildNamed(new String[]{"labelConfiguration-customEntries"}).addNodeListener((NodeListener)this);
                    this.node.getChildNamed(new String[]{"labelConfiguration-customEntries"}).getAllChildAddEventsFor((NodeListener)this, new String[0]);
                    labelC = this.node.getChildNamed(new String[]{"labelConfiguration-labelColor"});
                    labelC.addNodeListener((NodeListener)this);
                    this.colorSelection.getElement().setNode(labelC);
                    this.ignoreUncheckedOnCheckerSheet.getElement().setNode(this.node.getChildNamed(new DtoField[]{GalleyEquipmentComplete_.labelConfiguration, LabelConfigurationComplete_.ignoreUncheckedEntriesOnCheckerSheet}));
                }
                c = ConverterRegistry.getConverter(GalleyEquipmentPosNameConverter.class);
                t = t + c.convert(this.node.getValue(GalleyEquipmentComplete.class), this.node, new Object[0]);
            } else {
                this.isEquipment = false;
                this.node.getChildNamed(new String[]{"distributionRules"}).addNodeListener((NodeListener)this);
                this.node.getChildNamed(new String[]{"distributionRules"}).getAllChildAddEventsFor((NodeListener)this, new String[0]);
                if (this.node.getValue() instanceof DeliverySpaceComplete && this.node.getChildNamed(new String[]{"labelConfiguration"}).getValue() != null) {
                    this.node.getChildNamed(new String[]{"labelConfiguration-customEntries"}).addNodeListener((NodeListener)this);
                    this.node.getChildNamed(new String[]{"labelConfiguration-customEntries"}).getAllChildAddEventsFor((NodeListener)this, new String[0]);
                    labelC = this.node.getChildNamed(new String[]{"labelConfiguration-labelColor"});
                    labelC.addNodeListener((NodeListener)this);
                    this.colorSelection.getElement().setNode(labelC);
                    this.ignoreUncheckedOnCheckerSheet.getElement().setNode(this.node.getChildNamed(new DtoField[]{DeliverySpaceComplete_.labelConfiguration, LabelConfigurationComplete_.ignoreUncheckedEntriesOnCheckerSheet}));
                }
                c = ConverterRegistry.getConverter(GalleyEquipmentInsertPosNameConverter.class);
                t = t + c.convert(this.node.getValue(), this.node, new Object[0]);
            }
            this.setTitleString(t);
            if (this.isEquipment) {
                galleyName = this.node.getParent().getParent().getChildNamed(new String[]{"galleyCode"});
                if (galleyName == null) {
                    galleyName = this.node.getParent().getParent().getParent().getParent().getChildNamed(new String[]{"galleyCode"});
                }
            } else {
                galleyName = null;
                try {
                    this.node.getParent().getParent().getParent().getParent().getChildNamed(new String[]{"galleyCode"});
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (galleyName == null) {
                    try {
                        galleyName = this.node.getParent().getParent().getParent().getParent().getParent().getParent().getChildNamed(new String[]{"galleyCode"});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    Node boxPos = this.node.getParent().getParent().getChildNamed(new String[]{"stowagePosition-code"});
                    if (boxPos == null) {
                        boxPos = this.node.getParent().getParent().getParent().getParent().getChildNamed(new String[]{"stowagePosition-code"});
                    }
                    this.layoutPanel(this.getWidth(), this.getHeight(), false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.setEnabled(true);
    }

    public void updateLabelColors() {
        Node allColors = NodeToolkit.getAffixList(ColorComplete.class);
        this.colorSelection.getElement().refreshPossibleValues(allColors);
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class TableRowImplCustomEntry
    extends LabelTableRow
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextField enterField;
        private TextField amountField;
        private TextLabel unitRo;

        public TableRowImplCustomEntry(Table2RowModel m, Label ref) {
            super(m, true, ref);
            this.enterField = new TextField(m.getNode().getChildNamed(new String[]{"descriptionText"}));
            this.amountField = new NumberTextField(m.getNode().getChildNamed(new String[]{"amount"}), TextFieldType.INT_NULLABLE);
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            this.unitRo = new TextLabel(settings.getPieceUnit().getShortName());
            this.setLayout(new Layout());
            this.add(this.enterField);
            this.add(this.amountField);
            this.add(this.unitRo);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            boolean isDelete = false;
            if (source == this.deleteButton) {
                isDelete = true;
            }
            super.buttonPressed(source, x, y);
            if (isDelete) {
                Label.this.node.commitThis();
            }
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.enterField != null) {
                this.enterField.requestFocusInWindowNow();
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean enable = isEnabled && !Label.this.pegasus.isLocked();
            super.setEnabled(enable);
            this.enterField.setEnabled(enable);
            this.amountField.setEnabled(enable);
            this.unitRo.setEnabled(isEnabled);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.enterField.getFocusComponents());
            a.addAll(this.amountField.getFocusComponents());
            List<Component> b = super.getFocusComponents();
            if (b != null) {
                a.addAll(b);
            }
            return a;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.enterField.kill();
            this.enterField = null;
            this.amountField.kill();
            this.amountField = null;
            this.unitRo.kill();
            this.unitRo = null;
        }

        @Override
        public boolean isOnLabel() {
            return true;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w;
                int currentX = w = TableRowImplCustomEntry.this.model.getParentModel().getColumnWidth(0);
                w = TableRowImplCustomEntry.this.model.getParentModel().getColumnWidth(1);
                TableRowImplCustomEntry.this.enterField.setLocation(currentX + Label.this.table.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplCustomEntry.this.enterField.getPreferredSize().getHeight()) / 2.0));
                TableRowImplCustomEntry.this.enterField.setSize((int)((double)w - ((double)(2 * TableRowImplCustomEntry.this.getCellPadding() + TableRowImplCustomEntry.this.getInnerCellPadding() + 55) + TableRowImplCustomEntry.this.unitRo.getPreferredSize().getWidth())), (int)TableRowImplCustomEntry.this.enterField.getPreferredSize().getHeight());
                TableRowImplCustomEntry.this.amountField.setLocation(TableRowImplCustomEntry.this.enterField.getX() + TableRowImplCustomEntry.this.enterField.getWidth() + TableRowImplCustomEntry.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImplCustomEntry.this.amountField.getPreferredSize().getHeight()) / 2.0));
                TableRowImplCustomEntry.this.amountField.setSize(50, (int)TableRowImplCustomEntry.this.amountField.getPreferredSize().getHeight());
                TableRowImplCustomEntry.this.unitRo.setLocation(TableRowImplCustomEntry.this.amountField.getX() + TableRowImplCustomEntry.this.amountField.getWidth() + 5, (int)(((double)parent.getHeight() - TableRowImplCustomEntry.this.unitRo.getPreferredSize().getHeight()) / 2.0));
                TableRowImplCustomEntry.this.unitRo.setSize(TableRowImplCustomEntry.this.unitRo.getPreferredSize());
                TableRowImplCustomEntry.this.layoutSortButtons(currentX += w, parent.getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImplCustomEntry.this.getDefaultRowHeight());
            }
        }
    }

    private class TableRowImplInsert
    extends LabelTableRow
    implements NodeListener {
        private static final long serialVersionUID = 1L;
        private TextLabel labelText;
        private TextLabel totalAmount;
        private CheckBox checkOnLabel;
        private boolean showOnLabel;
        private boolean isInit;

        public TableRowImplInsert(Table2RowModel m, Label ref) {
            super(m, true, ref);
            this.showOnLabel = false;
            this.isInit = true;
            this.disableDeleteButton();
            this.isInit = true;
            Node<IStowingListComplete> stw = LogicToolkit.getStowingList();
            Node<DeliveryInstructionComplete> dis = LogicToolkit.getDeliveryInstruction4InsertDistributionRule((Node<DeliverySpaceDistributionRuleComplete>)m.getNode(), (Node<List<DeliverableComplete>>)stw.getChildNamed(new String[]{"deliverables"}));
            String labelTextS = "";
            if (dis != null) {
                Node item = dis.getParent();
                if (item.getValue() instanceof ProductDeliverableComplete) {
                    ProductDeliverableComplete l = (ProductDeliverableComplete)item.getValue();
                    labelTextS = l.getProduct().getCurrentVariant().getLabelName();
                    if (labelTextS == null || labelTextS.isEmpty()) {
                        labelTextS = l.getProduct().getCurrentVariant().getName();
                    }
                    this.labelText = new TextLabel(labelTextS);
                } else if (item.getValue() instanceof ServiceDeliverableComplete) {
                    labelTextS = MealPlanToolkit.createServicePartString(item.getChildNamed(new String[]{"loadingGroup"}), false);
                    this.labelText = new TextLabel(labelTextS);
                } else if (item.getValue() instanceof ArticleDeliverableLight || item.getValue() instanceof ArticleDeliverableComplete) {
                    labelTextS = (String)item.getChildNamed(new String[]{"article-labelName"}).getValue();
                    if (labelTextS == null || labelTextS.isEmpty()) {
                        labelTextS = (String)item.getChildNamed(new String[]{"article-name"}).getValue();
                    }
                    this.labelText = new TextLabel(labelTextS);
                } else if (item.getValue() instanceof EquipmentTemplateDeliverableComplete) {
                    labelTextS = "Label Entries loaded from Template " + (String)item.getChildNamed(new DtoField[]{EquipmentTemplateDeliverableComplete_.equipment, EquipmentTemplateComplete_.currentVariant, EquipmentTemplateVariantLight_.name}).getValue();
                    this.labelText = new TextLabel(labelTextS);
                } else if (item.getValue() instanceof SPMLMealTypeDeliverableComplete) {
                    labelTextS = MealPlanToolkit.createReplacePartString((Node<DeliverableComplete>)item);
                    this.labelText = new TextLabel(labelTextS);
                }
            } else {
                this.labelText = new TextLabel("unable to load data");
            }
            Converter viewConverter = ConverterRegistry.getConverter(IntegerConverter.class);
            this.totalAmount = new TextLabel(m.getNode().getChildNamed(new String[]{"quantity"}), viewConverter);
            this.totalAmount.setAlignment(3);
            this.checkOnLabel = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(new String[]{"showOnLabel"}));
            this.setLayout(new Layout());
            if (this.model.getNode().getChildNamed(new String[]{"showOnLabel"}).getValue() == null) {
                Node show = this.model.getNode().getChildNamed(new String[]{"showOnLabel"});
                if (show instanceof Node) {
                    show.setValue((Object)true, System.currentTimeMillis());
                }
            } else {
                this.valueChanged(this.model.getNode().getChildNamed(new String[]{"showOnLabel"}));
            }
            this.model.getNode().getChildNamed(new String[]{"showOnLabel"}).addNodeListener((NodeListener)this);
            this.add(this.labelText);
            this.add(this.totalAmount);
            this.add(this.checkOnLabel);
            this.isInit = false;
        }

        public void setChecked(boolean checked) {
            this.model.getNode().getChildNamed(new String[]{"showOnLabel"}).setValue((Object)checked, 0L);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean enable = isEnabled && !Label.this.pegasus.isLocked();
            super.setEnabled(enable);
            this.labelText.setEnabled(isEnabled);
            this.totalAmount.setEnabled(isEnabled);
            this.checkOnLabel.setEnabled(enable);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.add(this.checkOnLabel);
            a.add(this.totalAmount);
            a.addAll(super.getFocusComponents());
            return a;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.labelText instanceof Killable) {
                this.labelText.kill();
            }
            this.totalAmount.kill();
            this.checkOnLabel.kill();
            this.labelText = null;
            this.totalAmount = null;
            this.checkOnLabel = null;
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void valueChanged(Node<?> node) {
            Boolean b;
            if (node.getName().equals("showOnLabel") && !new Boolean(this.showOnLabel).equals(b = (Boolean)node.getValue())) {
                this.showOnLabel = b;
                if (!this.isInit && Label.this.table != null) {
                    Label.this.checkAddButtonState();
                    Label.this.table.updateOrder();
                    Label.this.table.relayoutRequested();
                }
            }
        }

        @Override
        public boolean isOnLabel() {
            return this.showOnLabel;
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImplInsert.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                int amountWidth = 50;
                TableRowImplInsert.this.checkOnLabel.setLocation(Label.this.table.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplInsert.this.checkOnLabel.getPreferredSize().getHeight()) / 2.0));
                TableRowImplInsert.this.checkOnLabel.setSize(TableRowImplInsert.this.checkOnLabel.getPreferredSize());
                currentX = w;
                w = TableRowImplInsert.this.model.getParentModel().getColumnWidth(1);
                TableRowImplInsert.this.labelText.setLocation(currentX + Label.this.table.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplInsert.this.labelText.getPreferredSize().getHeight()) / 2.0));
                TableRowImplInsert.this.labelText.setSize(w - (3 * Label.this.table.getCellPadding() + amountWidth), (int)TableRowImplInsert.this.labelText.getPreferredSize().getHeight());
                currentX += w;
                TableRowImplInsert.this.totalAmount.setLocation((currentX -= amountWidth + 2 * TableRowImplInsert.this.getCellPadding()) + Label.this.table.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplInsert.this.totalAmount.getPreferredSize().getHeight()) / 2.0));
                TableRowImplInsert.this.totalAmount.setSize(amountWidth, (int)TableRowImplInsert.this.totalAmount.getPreferredSize().getHeight());
                w = TableRowImplInsert.this.model.getParentModel().getColumnWidth(2);
                TableRowImplInsert.this.layoutSortButtons(currentX += amountWidth + 2 * TableRowImplInsert.this.getCellPadding(), parent.getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImplInsert.this.getDefaultRowHeight());
            }
        }
    }

    private class TableRowImplEQUIP
    extends LabelTableRow
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private TextLabel labelText;
        private TextField spmlField;
        private TextLabel totalAmount;
        private ViewNode<String> totalNode;
        private Node batchesList;
        private boolean isInit;
        private boolean showOnLabel;
        private CheckBox checkToShowOnLabel;

        public TableRowImplEQUIP(Table2RowModel m, Label ref) {
            super(m, true, ref);
            this.isInit = true;
            this.showOnLabel = false;
            this.disableDeleteButton();
            Node<IStowingListComplete> stwl = LogicToolkit.getStowingList();
            Node<DeliveryInstructionComplete> dis = LogicToolkit.getDeliveryInstruction4EquipmentDistributionRule((Node<EquipmentDistributionRuleComplete>)m.getNode(), (Node<List<DeliverableComplete>>)stwl.getChildNamed(new String[]{"deliverables"}));
            if (dis == null || m.getNode() == null) {
                return;
            }
            Node bb = m.getNode().getChildNamed(new String[]{"showSPMLOnLabel"});
            if (bb != null && bb.getValue() != null && ((Boolean)bb.getValue()).booleanValue()) {
                this.spmlField = new TextField(dis.getChildNamed(new String[]{"spmlLabelText"}));
            }
            String labelTextS = "";
            Node item = dis.getParent();
            if (item.getValue() instanceof ProductDeliverableComplete) {
                ProductDeliverableComplete l = (ProductDeliverableComplete)item.getValue();
                labelTextS = l.getProduct().getCurrentVariant().getLabelName();
                if (labelTextS == null || labelTextS.isEmpty()) {
                    labelTextS = l.getProduct().getCurrentVariant().getName();
                }
                this.labelText = new TextLabel(labelTextS);
            } else if (item.getValue() instanceof ServiceDeliverableComplete) {
                labelTextS = MealPlanToolkit.createServicePartString(item.getChildNamed(new String[]{"loadingGroup"}), false);
                this.labelText = new TextLabel(labelTextS);
            } else if (item.getValue() instanceof SPMLMealTypeDeliverableComplete) {
                labelTextS = MealPlanToolkit.createReplacePartString((Node<DeliverableComplete>)item);
                this.labelText = new TextLabel(labelTextS);
            } else if (item.getValue() instanceof ArticleDeliverableLight || item.getValue() instanceof ArticleDeliverableComplete) {
                labelTextS = (String)item.getChildNamed(new String[]{"article-labelName"}).getValue();
                if (labelTextS == null || labelTextS.isEmpty()) {
                    labelTextS = (String)item.getChildNamed(new String[]{"article-name"}).getValue();
                }
                this.labelText = new TextLabel(labelTextS);
            } else if (item.getValue() instanceof EquipmentTemplateDeliverableComplete) {
                labelTextS = "Label Entries loaded from Template " + (String)item.getChildNamed(new DtoField[]{EquipmentTemplateDeliverableComplete_.equipment, EquipmentTemplateComplete_.currentVariant, EquipmentTemplateVariantLight_.name}).getValue();
                this.labelText = new TextLabel(labelTextS);
            }
            this.totalNode = new ViewNode("TotalAmount");
            this.totalNode.setChangeHandler((ViewNodeDataChangeHandler)new ViewNodeDataChangeHandler<String>(){
                private boolean isRunning = false;

                public String calculateNewValue(ViewNode node) {
                    if (this.isRunning) {
                        return TableRowImplEQUIP.this.totalAmount != null ? TableRowImplEQUIP.this.totalAmount.getText() : "...";
                    }
                    this.isRunning = true;
                    Iterator it = node.getAllChildsNamed("quantity");
                    long amount = 0L;
                    while (it.hasNext()) {
                        Node i = (Node)it.next();
                        Long a = TransactionToolkit.getLongValue(i);
                        amount += a.longValue();
                    }
                    if (TableRowImplEQUIP.this.model.getNode() != null) {
                        try {
                            Node<DeliveryInstructionComplete> instr;
                            Node stowing = TableRowImplEQUIP.this.model.getNode().getParent().getParent().getParent().getParent().getParent().getParent();
                            if (!(stowing.getValue() instanceof StowingListComplete) && !(stowing.getValue() instanceof StowingListTemplateComplete)) {
                                stowing = stowing.getParent().getParent();
                            }
                            Node dis2 = stowing.getChildNamed(new String[]{"deliverables"});
                            String unit = "";
                            if (dis2 != null && (instr = LogicToolkit.getDeliveryInstruction4EquipmentDistributionRule((Node<EquipmentDistributionRuleComplete>)TableRowImplEQUIP.this.model.getNode(), (Node<List<DeliverableComplete>>)dis2)) != null) {
                                Node uN = instr.getParent().getChildNamed(new String[]{"unit"});
                                if (uN != null && uN.getValue() != null) {
                                    unit = " " + ((UnitComplete)instr.getParent().getChildNamed(new String[]{"unit"}).getValue()).getShortName();
                                } else {
                                    SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                                    unit = " " + settings.getPieceUnit().getShortName();
                                }
                            }
                            this.isRunning = false;
                            return "" + amount + unit;
                        }
                        catch (Exception e) {
                            return "";
                        }
                    }
                    this.isRunning = false;
                    return "-";
                }
            });
            this.totalAmount = new TextLabel((Node)this.totalNode);
            this.totalAmount.setAlignment(3);
            this.batchesList = m.getNode().getChildNamed(new String[]{"insertDistributionRule"});
            this.batchesList.addNodeListener((NodeListener)this);
            this.batchesList.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            this.totalNode.updateValue();
            this.checkToShowOnLabel = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(new String[]{"showOnLabel"}));
            this.setLayout(new Layout());
            this.model.getNode().getChildNamed(new String[]{"showOnLabel"}).addNodeListener((NodeListener)this);
            if (this.model.getNode().getChildNamed(new String[]{"showOnLabel"}).getValue() == null) {
                Node show = this.model.getNode().getChildNamed(new String[]{"showOnLabel"});
                if (show instanceof Node) {
                    show.setValue((Object)true, System.currentTimeMillis());
                }
            } else {
                this.valueChanged(this.model.getNode().getChildNamed(new String[]{"showOnLabel"}));
            }
            this.isInit = false;
            if (this.spmlField != null) {
                this.add(this.spmlField);
            }
            this.add(this.labelText);
            this.add(this.totalAmount);
            this.add(this.checkToShowOnLabel);
        }

        public void setChecked(boolean checked) {
            this.model.getNode().getChildNamed(new String[]{"showOnLabel"}).setValue((Object)checked, 0L);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean enable = isEnabled && !Label.this.pegasus.isLocked();
            super.setEnabled(enable);
            if (this.spmlField != null) {
                this.spmlField.setEnabled(enable);
            }
            if (this.labelText == null) {
                return;
            }
            this.labelText.setEnabled(isEnabled);
            this.totalAmount.setEnabled(isEnabled);
            this.checkToShowOnLabel.setEnabled(enable);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.add(this.checkToShowOnLabel);
            if (this.spmlField != null) {
                CheckedListAdder.addToList(a, this.spmlField);
            }
            a.add(this.totalAmount);
            List<Component> v = super.getFocusComponents();
            if (v != null) {
                a.addAll(v);
            }
            return a;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.labelText == null) {
                return;
            }
            if (this.labelText instanceof Killable) {
                this.labelText.kill();
            }
            if (this.spmlField != null) {
                this.spmlField.kill();
            }
            this.totalAmount.kill();
            this.checkToShowOnLabel.kill();
            this.totalNode.kill();
            this.batchesList.removeNodeListener((NodeListener)this);
            this.spmlField = null;
            this.labelText = null;
            this.totalAmount = null;
            this.checkToShowOnLabel = null;
            this.totalNode = null;
            this.batchesList = null;
        }

        public void childAdded(Node<?> source, Node<?> child) {
            if (source == this.batchesList) {
                Node n = child.getChildNamed(new String[]{"quantity"});
                this.totalNode.addChild(n, 0L);
                n.addNodeListener(this.totalNode);
                if (!this.isInit) {
                    this.totalNode.updateValue();
                }
            }
        }

        public void childRemoved(Node<?> source, Node<?> child) {
            if (source == this.batchesList) {
                Iterator it = this.totalNode.getChilds();
                boolean found = false;
                while (it.hasNext() && !found) {
                    Node n = (Node)it.next();
                    if (n.getParent() != child) continue;
                    n.removeNodeListener(this.totalNode);
                    it.remove();
                    found = true;
                }
                if (found) {
                    this.totalNode.updateValue();
                }
            }
        }

        public void valueChanged(Node<?> node) {
            boolean b;
            if (node.getName().equals("showOnLabel") && (b = Boolean.TRUE.equals(node.getValue())) != this.showOnLabel) {
                this.showOnLabel = b;
                if (!this.isInit && Label.this.table != null) {
                    Label.this.checkAddButtonState();
                    Label.this.table.updateOrder();
                    Label.this.table.relayoutRequested();
                }
                this.updateRowOrder();
            }
        }

        @Override
        public boolean isOnLabel() {
            return this.showOnLabel;
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImplEQUIP.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                int amountWidth = 50;
                int h = TableRowImplEQUIP.this.getDefaultRowHeight();
                if (TableRowImplEQUIP.this.checkToShowOnLabel == null) {
                    return;
                }
                TableRowImplEQUIP.this.checkToShowOnLabel.setLocation(Label.this.table.getCellPadding(), (int)(((double)h - TableRowImplEQUIP.this.checkToShowOnLabel.getPreferredSize().getHeight()) / 2.0));
                TableRowImplEQUIP.this.checkToShowOnLabel.setSize(TableRowImplEQUIP.this.checkToShowOnLabel.getPreferredSize());
                currentX = w;
                w = TableRowImplEQUIP.this.model.getParentModel().getColumnWidth(1);
                TableRowImplEQUIP.this.labelText.setLocation(currentX + Label.this.table.getCellPadding(), (int)(((double)h - TableRowImplEQUIP.this.labelText.getPreferredSize().getHeight()) / 2.0));
                TableRowImplEQUIP.this.labelText.setSize(w - (3 * Label.this.table.getCellPadding() + amountWidth), (int)TableRowImplEQUIP.this.labelText.getPreferredSize().getHeight());
                if (TableRowImplEQUIP.this.spmlField != null) {
                    TableRowImplEQUIP.this.spmlField.setLocation(currentX + Label.this.table.getCellPadding(), h + (int)(((double)h - TableRowImplEQUIP.this.spmlField.getPreferredSize().getHeight()) / 2.0));
                    TableRowImplEQUIP.this.spmlField.setSize(w - (3 * Label.this.table.getCellPadding() + amountWidth), (int)TableRowImplEQUIP.this.spmlField.getPreferredSize().getHeight());
                }
                currentX += w;
                TableRowImplEQUIP.this.totalAmount.setLocation((currentX -= amountWidth + 2 * TableRowImplEQUIP.this.getCellPadding()) + Label.this.table.getCellPadding(), (int)(((double)h - TableRowImplEQUIP.this.totalAmount.getPreferredSize().getHeight()) / 2.0));
                TableRowImplEQUIP.this.totalAmount.setSize(amountWidth, (int)TableRowImplEQUIP.this.totalAmount.getPreferredSize().getHeight());
                w = TableRowImplEQUIP.this.model.getParentModel().getColumnWidth(2);
                TableRowImplEQUIP.this.layoutSortButtons(currentX += amountWidth + 2 * TableRowImplEQUIP.this.getCellPadding(), h);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                if (TableRowImplEQUIP.this.spmlField != null) {
                    return new Dimension(0, 2 * TableRowImplEQUIP.this.getDefaultRowHeight());
                }
                return new Dimension(0, TableRowImplEQUIP.this.getDefaultRowHeight());
            }
        }
    }
}

