/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.CateringRotationConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.RotationNavigationConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details.utils.PeriodConfigurationComparator;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.FixPeriodRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixPeriodRotationStrategyComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.PeriodRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.PeriodRotationComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class StrategyTableDetailsPanel
extends DefaultDetailsPanel {
    private static final long serialVersionUID = 1L;
    private boolean used;
    private Table2 table;
    private Node<CateringServiceScheduleVariantComplete> currentNode;

    public StrategyTableDetailsPanel(RowEditor editor) {
        super(editor, null);
        this.setTitleText("Period Configuration");
        this.table = new Table2(true, Words.ADD, false, false);
        this.table.setComparator(ComparatorRegistry.getComparator(PeriodConfigurationComparator.class));
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                StrategyTableDetailsPanel.this.editor.validate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                PeriodRotationComplete rot = new PeriodRotationComplete();
                rot.setClientOId(Long.valueOf(ADTO.getNextId()));
                long startTime = System.currentTimeMillis() + 86400000L;
                long endTime = System.currentTimeMillis();
                if (StrategyTableDetailsPanel.this.table.getRowCount() > 0) {
                    TableRowImpl p = (TableRowImpl)StrategyTableDetailsPanel.this.table.getRowAt(StrategyTableDetailsPanel.this.table.getRowCount() - 1);
                    Date ed = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{PeriodRotationComplete_.period, PeriodComplete_.endDate}).getValue();
                    startTime = ed.getTime() + 86400000L;
                    endTime = startTime + 604800000L;
                }
                rot.setPeriod(new PeriodComplete(new Date(startTime), new Date(endTime)));
                StrategyTableDetailsPanel.this.table.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)rot, true, false), System.currentTimeMillis());
                StrategyTableDetailsPanel.this.editor.validate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.START_DATE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo("", null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.END_DATE, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.CYCLE, null, null, null, "", 100, 100, 100));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.table);
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean shouldEnable = isEnabled;
        MealPlanLight mp = (MealPlanLight)this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.mealplan).getValue();
        if (mp != null) {
            shouldEnable = mp.getState() == ModificationStateE.DRAFT && shouldEnable;
        }
        super.setEnabled(shouldEnable);
        this.table.setEnabled(shouldEnable && this.used);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        if (this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).getValue() instanceof FixPeriodRotationStrategyComplete) {
            if (this.table.getRowCount() == 0) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Define at least one rotation period."));
            }
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowImpl i = (TableRowImpl)p;
                List<ScreenValidationObject> r = i.validateRow();
                if (r == null) continue;
                o.addAll(r);
            }
        }
        return o;
    }

    public void setNode(Node node) {
        super.setNode(node);
        this.currentNode = node;
        if (this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).getValue() instanceof FixPeriodRotationStrategyComplete) {
            this.setUsed(true);
        } else {
            this.setUsed(false);
        }
    }

    public void setUsed(boolean b) {
        this.used = b;
        if (this.used && this.currentNode != null) {
            this.table.getModel().setNode(this.currentNode.getChildNamed(new DtoField[]{CateringServiceScheduleVariantComplete_.rotationStrategy, FixPeriodRotationStrategyComplete_.periods}));
        } else {
            this.table.getModel().setNode(null);
        }
        this.setEnabled(this.used);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private DateChooser startDate;
        private ArrowConnectorIcon connector;
        private DateChooser endDate;
        private DeleteButton delete;
        private ComboBox rotationChooser;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.startDate = new DateChooser(m.getNode().getChildNamed(new DtoField[]{PeriodRotationComplete_.period, PeriodComplete_.startDate}));
            this.connector = new ArrowConnectorIcon();
            this.endDate = new DateChooser(m.getNode().getChildNamed(new DtoField[]{PeriodRotationComplete_.period, PeriodComplete_.endDate}));
            this.delete = new DeleteButton();
            m.getNode().getChildNamed(PeriodRotationComplete_.rotation).setConverter(CateringRotationConverter.class);
            this.rotationChooser = new ComboBox(m.getNode().getChildNamed(PeriodRotationComplete_.rotation), StrategyTableDetailsPanel.this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotations), ConverterRegistry.getConverter(RotationNavigationConverter.class), false, true);
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.startDate);
            this.add(this.connector);
            this.add(this.endDate);
            this.add(this.rotationChooser);
            this.add(this.delete);
        }

        public List<ScreenValidationObject> validateRow() {
            ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
            if (this.rotationChooser.getNode().getValue() == null) {
                this.rotationChooser.setInvalid();
                DateConverter f = (DateConverter)ConverterRegistry.getConverter(DateConverter.class);
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Period Configuration from " + f.convert(this.startDate.getNode().getValue(), this.startDate.getNode(), new Object[0]) + " to " + f.convert(this.endDate.getNode().getValue(), this.endDate.getNode(), new Object[0]) + " has no Cycle set"));
            }
            Date d1 = (Date)this.startDate.getNode().getValue();
            Date d2 = (Date)this.endDate.getNode().getValue();
            if (d1.getTime() > d2.getTime()) {
                this.startDate.setInvalid();
                this.endDate.setInvalid();
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Start Date is before End Date"));
            }
            return o;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.startDate.kill();
            this.connector.kill();
            this.endDate.kill();
            this.rotationChooser.kill();
            this.delete.kill();
            this.startDate = null;
            this.connector = null;
            this.endDate = null;
            this.rotationChooser = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.startDate.getFocusComponents());
            a.addAll(this.endDate.getFocusComponents());
            a.addAll(this.rotationChooser.getFocusComponents());
            a.addAll(this.delete.getFocusComponents());
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.startDate.getNode().getValue();
                }
                case 2: {
                    return this.endDate.getNode().getValue();
                }
                case 3: {
                    return this.rotationChooser.getSelectedItem();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.startDate.setEnabled(isEnabled);
            this.connector.setEnabled(isEnabled);
            this.endDate.setEnabled(isEnabled);
            this.rotationChooser.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.startDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.startDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.startDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.startDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.connector.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.connector.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.connector.setSize(TableRowImpl.this.connector.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.endDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.endDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.endDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.endDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.rotationChooser.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.rotationChooser.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.rotationChooser.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.rotationChooser.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                TableRowImpl.this.setControlsX(currentX);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)StrategyTableDetailsPanel.this.table.getPreferredSize().getHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            StrategyTableDetailsPanel.this.table.setLocation(0, 0);
            StrategyTableDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight() - 1);
        }
    }
}

