/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.requisition.deliver.tableui.chargebased;

import ch.icit.pegasus.client.gui.submodules.tool.requisition.deliver.tableui.chargebased.RequisitionDeliveryScreenCBSubModule;
import ch.icit.pegasus.client.gui.table2.FootablePanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CustomsButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RequisitionFooterPanel
extends FootablePanel
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TextButton selectAll;
    private BackgroundFadeSkin skin;
    private RequisitionDeliveryScreenCBSubModule porcm;
    private VerticalSeparator sep1;
    private CustomsButton customs;

    public RequisitionFooterPanel(RequisitionDeliveryScreenCBSubModule inv) {
        this.porcm = inv;
        this.setOpaque(false);
        this.skin = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.customs = new CustomsButton();
        this.customs.setToolTipText(Words.CUSTOMS);
        this.customs.addButtonListener(this);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.setLayout(new Layout());
        this.add(this.customs);
        if (Boolean.TRUE.equals(settings.getShowSelectAllInRequisitionSubModules())) {
            this.selectAll = new TextButton(Words.SELECT_ALL);
            this.sep1 = new VerticalSeparator();
            this.add(this.selectAll);
            this.add(this.sep1);
        }
    }

    public TextButton getSelectAllButton() {
        return this.selectAll;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, this.getHeight() - this.skin.getImage(11).getHeight(), this.getWidth(), 11);
        g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_textfield_selected_text_color")));
        g2.drawLine(0, 0, this.getWidth(), 0);
        this.paintChildren(g2);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.selectAll != null) {
            this.selectAll.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        this.customs.kill();
        this.sep1 = null;
        this.customs = null;
        this.selectAll = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean canAddDoc = true;
        if (this.selectAll != null) {
            this.selectAll.setEnabled(isEnabled);
        }
        if (this.sep1 != null) {
            this.sep1.setEnabled(isEnabled);
        }
        this.customs.setEnabled(isEnabled && canAddDoc);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.selectAll != null) {
            a.addAll(this.selectAll.getFocusComponents());
        }
        CheckedListAdder.addToList(a, this.customs);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        if (this.selectAll != null) {
            this.selectAll.setVisibleContainer(pane);
        }
        this.customs.setVisibleContainer(pane);
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.customs.requestFocusInWindowNow();
    }

    public boolean validateDocuments() {
        Iterator it = this.porcm.getCustomsNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            String value = (String)node.getChildNamed(CustomsDocumentComplete_.customsDocumentId).getValue();
            if (StringUtil.isBlank((String)value)) {
                this.customs.setInvalid();
                return false;
            }
            try {
                Integer integer = Integer.valueOf(value);
                if (integer != 0) continue;
                this.customs.setInvalid();
                return false;
            }
            catch (Exception exception) {
            }
        }
        return true;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.customs) {
            InnerPopupFactory.showCustomsDocumentsEditPopup(source, this.porcm.getCustomsNode(), null, true, x, y);
        }
    }

    @Override
    public void setNode(Node<?> node) {
    }

    @Override
    public Node<?> getNode() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, RequisitionFooterPanel.this.skin.getImage(11).getHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            int x = parent.getWidth();
            if (RequisitionFooterPanel.this.selectAll != null) {
                RequisitionFooterPanel.this.selectAll.setLocation((int)((double)parent.getWidth() - ((double)border + RequisitionFooterPanel.this.selectAll.getPreferredSize().getWidth())), (parent.getHeight() - RequisitionFooterPanel.this.selectAll.getHeight()) / 2);
                RequisitionFooterPanel.this.selectAll.setSize(RequisitionFooterPanel.this.selectAll.getPreferredSize());
                RequisitionFooterPanel.this.sep1.setLocation(RequisitionFooterPanel.this.selectAll.getX() - border / 2, 1);
                RequisitionFooterPanel.this.sep1.setSize((int)RequisitionFooterPanel.this.sep1.getPreferredSize().getWidth(), parent.getHeight() - 2);
                x = RequisitionFooterPanel.this.sep1.getX();
            }
            RequisitionFooterPanel.this.customs.setLocation((int)((double)x - (RequisitionFooterPanel.this.customs.getPreferredSize().getWidth() + (double)border)), (int)(((double)parent.getHeight() - RequisitionFooterPanel.this.customs.getPreferredSize().getHeight()) / 2.0));
            RequisitionFooterPanel.this.customs.setSize(RequisitionFooterPanel.this.customs.getPreferredSize());
        }
    }
}

