/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.requisition.receive.tableui;

import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.RequisitionPositionNameConverter;
import ch.icit.pegasus.client.gui.submodules.tool.requisition.receive.tableui.RequisitionReceivingSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.requisition.receive.tableui.TableRowPanelImpl;
import ch.icit.pegasus.client.gui.table.renderer.CellViewOrderStateRenderer;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.UnitSelectionUtil;
import ch.icit.pegasus.client.gui.utils.buttons.AddButton;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.StockTransactionRemarkButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.image.ImagePanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.calculator.IBasicArticle;
import ch.icit.pegasus.server.core.calculator.IQuantity;
import ch.icit.pegasus.server.core.calculator.IUnit;
import ch.icit.pegasus.server.core.calculator.UnitCalculator;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderPositionBatchComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderPositionBatchTypeE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderRecipientTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderRejectionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionReceivingRemarkComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionRejectionRemarkComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ARequisitionOrderAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RequisitionOrderAccess;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionTypeE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class TableRowPanelImplPrep
extends TableRowPanelImpl
implements InnerPopUpListener2,
NodeListener {
    private static final long serialVersionUID = 1L;
    private CellViewOrderStateRenderer orderState;
    private TextLabel articleName;
    private QuantityRenderer ordered;
    private TextLabel ready;
    private InputComboBox2 receive;
    private StockTransactionRemarkButton<OrderPositionReceivingRemarkComplete> rec_remark;
    private TextLabel receivingStore;
    private InputComboBox2 reject;
    private StockTransactionRemarkButton<OrderPositionRejectionRemarkComplete> rej_remark;
    private CheckBox checkIt;
    private ArticleInfoButton packTable;
    private EditButton editStore;
    private StorePositionLight backupPos;
    private RequisitionReceivingSubModule screen;
    private final RDProvider provider;
    private ImagePanel imagePanel;
    private Button addRemoveButton;
    private boolean isFirst = false;
    private boolean hasPrepared;
    private Node<UnitComplete> targetUnit;
    private UserComplete currentUser;
    private SystemSettingsComplete settings;

    public TableRowPanelImplPrep(Table2RowModel m, RequisitionReceivingSubModule screen, RDProvider provider) {
        super(m, screen);
        StoreLight store;
        this.screen = screen;
        this.provider = provider;
        this.currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.isFirst = !(m.getNode() instanceof ProxyNode);
        this.rec_remark = new StockTransactionRemarkButton<OrderPositionReceivingRemarkComplete>((Node<OrderPositionReceivingRemarkComplete>)new DTOProxyNode(), OrderPositionReceivingRemarkComplete.class);
        this.rej_remark = new StockTransactionRemarkButton<OrderPositionRejectionRemarkComplete>((Node<OrderPositionRejectionRemarkComplete>)new DTOProxyNode(), OrderPositionRejectionRemarkComplete.class);
        this.rec_remark.setProgress(1.0f);
        this.rej_remark.setProgress(1.0f);
        BasicArticleComplete artC = (BasicArticleComplete)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
        StoreQuantityComplete q3 = new StoreQuantityComplete();
        q3.setAmount(((StoreQuantityComplete)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.preparedAmount).getValue()).getAmount());
        q3.setUnit((UnitComplete)m.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.preparedAmount, StoreQuantityComplete_.unit}).getValue());
        StorePositionLight sp = (StorePositionLight)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.receivingStore).getValue();
        StoreLight storeLight = store = sp != null ? sp.getStore() : null;
        if (Boolean.TRUE.equals(screen.getCurrentOrder().getRedirectOrder()) && Boolean.TRUE.equals(this.settings.getRequisitionReceiveStoreDefaultIgnored())) {
            boolean isDefault = false;
            for (StoreConditionComplete storeCondition : artC.getStoreConditions()) {
                if (storeCondition.getType() != StoreConditionTypeE.PURCHASE_CHECKIN || storeCondition.getPosition() == null || !storeCondition.getPosition().getStore().equals((Object)store)) continue;
                isDefault = true;
            }
            if (isDefault) {
                sp = null;
            }
        }
        if (this.isFirst) {
            RequisitionOrderPositionComplete position = (RequisitionOrderPositionComplete)m.getNode().getValue();
            this.orderState = new CellViewOrderStateRenderer((OrderStateE)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.receiveState).getValue(), position);
            this.articleName = new TextLabel(m.getNode(), ConverterRegistry.getConverter(RequisitionPositionNameConverter.class));
            this.ordered = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.quantity));
            this.addRemoveButton = new AddButton();
            this.packTable = new ArticleInfoButton((Node<BasicArticleReference>)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article), (Node<Date>)m.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.order, RequisitionOrderComplete_.requiredOn}), 11);
            this.ready = new QuantityRenderer((Node<?>)INodeCreator.getDefaultImpl().getNode4DTO((Object)q3, false, false));
            if (Boolean.TRUE.equals(this.settings.getShowImageOnRequisitionWorkTools())) {
                this.imagePanel = new ImagePanel();
                this.imagePanel.setFixSize(60);
                this.updateImage(store);
            }
        } else {
            this.addRemoveButton = new DeleteButton();
        }
        this.editStore = new EditButton();
        this.editStore.addButtonListener(this);
        this.addRemoveButton.addButtonListener(this);
        StoreQuantityComplete q = new StoreQuantityComplete();
        q.setAmount(q3.getAmount());
        q.setUnit((UnitComplete)m.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.preparedAmount, StoreQuantityComplete_.unit}).getValue());
        double v = UnitConversionToolkit.convertUnit((UnitComplete)q.getUnit(), (UnitComplete)artC.getFloatStoreUnit(), (double)q3.getAmount().longValue(), (BasicArticleLight)artC, (Timestamp)this.getValidityDate());
        List articleConversion = UnitCalculator.getArticlePackagingQuantities((IBasicArticle)artC, (Timestamp)this.getValidityDate());
        StoreQuantityComplete converted = (StoreQuantityComplete)UnitCalculator.convert((IBasicArticle)artC, (List)articleConversion, (IQuantity)new QuantityComplete(Double.valueOf(v), artC.getFloatStoreUnit()));
        Node nStoreQuant = INodeCreator.getDefaultImpl().getNode4DTO((Object)new QuantityComplete(Double.valueOf(converted.getAmount().doubleValue()), converted.getUnit()), false, false);
        this.receive = new InputComboBox2(nStoreQuant.getChildNamed(QuantityComplete_.quantity), nStoreQuant.getChildNamed(QuantityComplete_.unit), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
        DTOProxyNode np = new DTOProxyNode((Object)sp);
        this.receivingStore = new TextLabel((Node)np, ConverterRegistry.getConverter(StorePositionShortNameConverter.class));
        List units = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)this.getValidityDate(), (TransactionType)TransactionType.REQUISITION_RECEIVE, (UserComplete)this.currentUser, null, (StoreLight)store, (SystemSettingsComplete)this.settings);
        this.receive.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
        this.receive.getUnitNode().addNodeListener((NodeListener)this);
        if (units.isEmpty()) {
            this.receive.clearSelectedUnit();
        } else if (units.contains(((QuantityComplete)nStoreQuant.getValue()).getUnit())) {
            this.receive.setSelectedUnit(((QuantityComplete)nStoreQuant.getValue()).getUnit());
        } else {
            this.receive.setSelectedUnit((UnitComplete)units.get(0));
        }
        this.hasPrepared = q.getAmount() != null && q.getAmount() > 0L;
        StoreQuantityComplete q1 = new StoreQuantityComplete();
        q1.setAmount(Long.valueOf(0L));
        q1.setUnit((UnitComplete)m.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).getValue());
        Node nStoreQuant1 = INodeCreator.getDefaultImpl().getNode4DTO((Object)q1, false, false);
        this.reject = new InputComboBox2(nStoreQuant1.getChildNamed(StoreQuantityComplete_.amount), nStoreQuant1.getChildNamed(StoreQuantityComplete_.unit), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
        this.reject.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
        this.checkIt = new CheckBox();
        this.checkIt.setChecked(false);
        this.setLayout(new Layout());
        this.setOpaque(false);
        if (this.isFirst) {
            this.articleName.setProgress(1.0f);
            this.ordered.setProgress(1.0f);
            this.ready.setProgress(1.0f);
            this.packTable.setProgress(1.0f);
        }
        this.receive.setProgress(1.0f);
        this.receivingStore.setProgress(1.0f);
        this.reject.setProgress(1.0f);
        this.checkIt.setProgress(1.0f);
        this.editStore.setProgress(1.0f);
        this.checkIt.addButtonListener(this);
        this.changeUnit();
        if (this.isFirst) {
            this.add(this.orderState);
            this.add(this.articleName);
            this.add(this.ordered);
            this.add(this.ready);
            this.add(this.packTable);
            if (this.imagePanel != null) {
                this.add(this.imagePanel);
            }
        }
        this.add(this.receive);
        this.add(this.rec_remark);
        this.add(this.receivingStore);
        this.add(this.reject);
        this.add(this.rej_remark);
        this.add(this.checkIt);
        this.add(this.editStore);
        this.add(this.addRemoveButton);
    }

    @Override
    public void stopDownload(boolean stop) {
        if (this.imagePanel != null) {
            this.imagePanel.setStopDownload(stop);
        }
    }

    private void updateOrderConversionState() {
        if (this.ordered != null) {
            if (this.isUnitOrderConvertible()) {
                this.ordered.setValid();
            } else {
                this.ordered.setInvalid();
            }
        }
    }

    private boolean isUnitOrderConvertible() {
        return Boolean.TRUE.equals(this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.orderUnitConversionValidity).getValue());
    }

    private void changeUnit() {
        BasicArticleComplete articleComplete = (BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
        this.targetUnit = this.receive.getUnitNode();
        if (this.ordered == null || this.ordered.getNode() != null) {
            // empty if block
        }
        if (this.ready != null && this.ready.getNode() != null) {
            this.updateReadyQuantityNode(this.ready.getNode(), articleComplete, this.targetUnit);
        }
        if (this.reject != null && this.reject.getUnitNode().getParent() != null) {
            Node parent = this.reject.getUnitNode().getParent();
            this.updateQuantityNode(parent, articleComplete, this.targetUnit);
            this.reject.setNode(parent.getChildNamed(QuantityComplete_.quantity), parent.getChildNamed(QuantityComplete_.unit));
        }
    }

    private void updateReadyQuantityNode(Node qtyNode, BasicArticleComplete articleComplete, Node<UnitComplete> targetUnit) {
        RequisitionOrderPositionComplete requisitionOrderPosition = (RequisitionOrderPositionComplete)this.model.getNode().getValue(RequisitionOrderPositionComplete.class);
        StoreQuantityComplete qty = (StoreQuantityComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.preparedAmount).getValue();
        QuantityComplete totalQuantity = new QuantityComplete(Double.valueOf(qty.getAmount().doubleValue()), qty.getUnit());
        PackagingQuantityBaseComplete packingQuantity = UnitConversionToolkit.getPackingQuantity((BasicArticleLight)articleComplete, (Timestamp)new Timestamp(requisitionOrderPosition.getOrder().getRequiredOn().getTime()));
        totalQuantity = UnitConversionToolkit.convertToTargetUnitIfPossibleElseToBaseUnit((QuantityComplete)totalQuantity, (UnitComplete)((UnitComplete)targetUnit.getValue()), (BasicArticleLight)articleComplete, (List)packingQuantity.getPackingQuantities());
        qtyNode.setValue((Object)totalQuantity, 0L);
        qtyNode.updateNode();
    }

    private void updateQuantityNode(Node qtyNode, BasicArticleComplete articleComplete, Node<UnitComplete> targetUnit) {
        Date date = (Date)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.order, RequisitionOrderComplete_.requiredOn}).getValue();
        Timestamp validity = new Timestamp(date.getTime());
        if (qtyNode.getValue() instanceof StoreQuantityComplete) {
            StoreQuantityComplete availableQty = (StoreQuantityComplete)qtyNode.getValue();
            double convertedAmount = UnitConversionToolkit.convertUnit((UnitComplete)availableQty.getUnit(), (UnitComplete)((UnitComplete)targetUnit.getValue()), (double)availableQty.getAmount().longValue(), (BasicArticleLight)articleComplete, (Timestamp)validity);
            QuantityComplete nq = new QuantityComplete(Double.valueOf(convertedAmount), (UnitComplete)targetUnit.getValue());
            qtyNode.setValue((Object)nq, 0L);
            qtyNode.updateNode();
        } else if (qtyNode.getValue() instanceof QuantityComplete) {
            QuantityComplete availableQty = (QuantityComplete)qtyNode.getValue();
            double convertedAmount = UnitConversionToolkit.convertUnit((UnitComplete)availableQty.getUnit(), (UnitComplete)((UnitComplete)targetUnit.getValue()), (double)availableQty.getQuantity(), (BasicArticleLight)articleComplete, (Timestamp)validity);
            QuantityComplete nq = new QuantityComplete(Double.valueOf(convertedAmount), (UnitComplete)targetUnit.getValue());
            qtyNode.setValue((Object)nq, 0L);
            qtyNode.updateNode();
        }
    }

    @Override
    public Object getObject4Column(int column) {
        return null;
    }

    public List<RequisitionOrderRecipientTransactionComplete> getTransactions() throws ClientServerCallException {
        if (this.checkIt.isChecked()) {
            double receiveAmount;
            double batchAmount;
            Node assBatches;
            QuantityComplete quantity;
            Object value;
            ArrayList<RequisitionOrderRecipientTransactionComplete> transactions = new ArrayList<RequisitionOrderRecipientTransactionComplete>();
            BasicArticleComplete artC = (BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
            double received = this.receive.getValueNode().getValue() instanceof Long ? (double)((Long)this.receive.getValueNode().getValue()).longValue() : (Double)this.receive.getValueNode().getValue();
            received = UnitCalculator.roundWithDoublePrecision((double)received, (IUnit)((IUnit)this.receive.getUnitNode().getValue()));
            double rejected = this.reject.getValueNode().getValue() instanceof Long ? (double)((Long)this.reject.getValueNode().getValue()).longValue() : (Double)this.reject.getValueNode().getValue();
            rejected = UnitCalculator.roundWithDoublePrecision((double)rejected, (IUnit)((IUnit)this.reject.getUnitNode().getValue()));
            if (received > 0.0) {
                value = this.receive.getValueNode().getParent().getValue();
                if (value instanceof StoreQuantityComplete) {
                    this.receive.getValueNode().setValue((Object)((long)received), 0L);
                } else {
                    this.receive.getValueNode().setValue((Object)received, 0L);
                }
                this.receive.getValueNode().getParent().commitThis();
                if (value instanceof StoreQuantityComplete) {
                    StoreQuantityComplete storeQ = (StoreQuantityComplete)value;
                    quantity = new QuantityComplete(Double.valueOf(storeQ.getAmount().doubleValue()), storeQ.getUnit());
                } else {
                    quantity = (QuantityComplete)value;
                }
                assBatches = this.model.getNode().getChildNamed(new String[]{"associatedBatches"});
                for (OrderPositionBatchComplete opbc : (List)assBatches.getValue()) {
                    if (opbc.getType() != OrderPositionBatchTypeE.PREPARED || !(quantity.getQuantity() > 0.0)) continue;
                    UnitComplete targetUnit = artC.getBaseUnit();
                    ArticleChargeComplete charge = (ArticleChargeComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getCharge(new ArticleChargeReference(opbc.getCharge().getId())).getValue();
                    List packingQuantities = charge.getPackingQuantities();
                    while (targetUnit.getSubUnit() != null) {
                        targetUnit = targetUnit.getSubUnit();
                    }
                    if (quantity.getUnit().equals((Object)opbc.getQuantity().getUnit())) {
                        batchAmount = opbc.getQuantity().getAmount().longValue();
                        receiveAmount = quantity.getQuantity();
                    } else {
                        batchAmount = UnitConversionToolkit.convertUnit((UnitComplete)opbc.getQuantity().getUnit(), (UnitComplete)targetUnit, (double)opbc.getQuantity().getAmount().doubleValue(), (BasicArticleLight)artC, (List)packingQuantities);
                        receiveAmount = UnitConversionToolkit.convertUnit((UnitComplete)quantity.getUnit(), (UnitComplete)targetUnit, (double)quantity.getQuantity(), (BasicArticleLight)artC, (List)packingQuantities);
                        quantity.setUnit(targetUnit);
                        quantity.setQuantity(Double.valueOf(receiveAmount));
                    }
                    double usedAmount = 0.0;
                    usedAmount = batchAmount >= receiveAmount ? receiveAmount : batchAmount;
                    quantity.setQuantity(Double.valueOf(quantity.getQuantity() - usedAmount));
                    RequisitionOrderAcceptationComplete t = new RequisitionOrderAcceptationComplete();
                    t.setDestinationPosition((StorePositionLight)this.receivingStore.getNode().getValue());
                    double amt = UnitConversionToolkit.convertUnit((UnitComplete)quantity.getUnit(), (UnitComplete)targetUnit, (double)usedAmount, (BasicArticleLight)artC, (List)packingQuantities);
                    List articleConversion = UnitCalculator.getArticlePackagingQuantities((IBasicArticle)artC, (Timestamp)this.getValidityDate());
                    StoreQuantityComplete storeQ = (StoreQuantityComplete)UnitCalculator.convert((IBasicArticle)artC, (List)articleConversion, (IQuantity)new QuantityComplete(Double.valueOf(amt), targetUnit));
                    t.setAmount(storeQ);
                    t.setDestinationPosition((StorePositionLight)this.receivingStore.getNode().getValue());
                    t.setOrderPosition((RequisitionOrderPositionComplete)this.model.getNode().getValue());
                    if (this.rec_remark.getNode().getValue() != null) {
                        t.setRemark((OrderPositionReceivingRemarkComplete)this.rec_remark.getNode().getValue());
                    }
                    t.setBatch(opbc);
                    transactions.add((RequisitionOrderRecipientTransactionComplete)t);
                }
            }
            if (rejected > 0.0) {
                value = this.reject.getValueNode().getParent().getValue();
                if (value instanceof StoreQuantityComplete) {
                    this.reject.getValueNode().setValue((Object)((long)received), 0L);
                } else {
                    this.reject.getValueNode().setValue((Object)received, 0L);
                }
                this.reject.getValueNode().commit();
                quantity = new QuantityComplete(Double.valueOf(rejected), (UnitComplete)this.reject.getUnitNode().getValue());
                assBatches = this.model.getNode().getChildNamed(new String[]{"associatedBatches"});
                for (OrderPositionBatchComplete opbc : (List)assBatches.getValue()) {
                    if (opbc.getType() != OrderPositionBatchTypeE.PREPARED || !(quantity.getQuantity() > 0.0)) continue;
                    batchAmount = UnitConversionToolkit.convertUnit((UnitComplete)opbc.getQuantity().getUnit(), (UnitComplete)artC.getBaseUnit(), (double)opbc.getQuantity().getAmount().doubleValue(), (BasicArticleLight)artC, (Timestamp)opbc.getCharge().getCreationDate());
                    receiveAmount = UnitConversionToolkit.convertUnit((UnitComplete)quantity.getUnit(), (UnitComplete)artC.getBaseUnit(), (double)quantity.getQuantity(), (BasicArticleLight)artC, (Timestamp)new Timestamp(opbc.getOrderPosition().getOrder().getRequiredOn().getTime()));
                    double usedAmount = 0.0;
                    usedAmount = batchAmount >= receiveAmount ? receiveAmount : batchAmount;
                    quantity.setQuantity(Double.valueOf(batchAmount - usedAmount));
                    quantity.setUnit(artC.getBaseUnit());
                    RequisitionOrderRejectionComplete t = new RequisitionOrderRejectionComplete();
                    StoreQuantityComplete storeQuantity = UnitConversionToolkit.convertToStoreQuantity((QuantityComplete)new QuantityComplete(Double.valueOf(usedAmount), artC.getBaseUnit()), (BasicArticleLight)artC, (Timestamp)new Timestamp(opbc.getOrderPosition().getOrder().getRequiredOn().getTime()));
                    t.setAmount(storeQuantity);
                    t.setOrderPosition((RequisitionOrderPositionComplete)this.model.getNode().getValue());
                    t.setRemark((OrderPositionRejectionRemarkComplete)this.rej_remark.getNode().getValue());
                    t.setBatch(opbc);
                    transactions.add((RequisitionOrderRecipientTransactionComplete)t);
                }
            }
            return transactions;
        }
        return null;
    }

    private Timestamp getValidityDate() {
        Date date = (Date)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.order, RequisitionOrderComplete_.requiredOn}).getValue();
        Timestamp validity = new Timestamp(date.getTime());
        return validity;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.checkIt) {
            if (this.checkIt.isChecked()) {
                if (this.validateInput()) {
                    if (this.isFirst) {
                        this.orderState.setEnabled(false);
                        this.articleName.setEnabled(false);
                        this.ordered.setEnabled(false);
                        this.ready.setEnabled(false);
                        this.packTable.setEnabled(false);
                        if (this.imagePanel != null) {
                            this.imagePanel.setEnabled(false);
                        }
                    }
                    this.receive.setEnabled(false);
                    this.rec_remark.setEnabled(false);
                    this.receivingStore.setEnabled(false);
                    this.reject.setEnabled(false);
                    this.rej_remark.setEnabled(false);
                    this.editStore.setEnabled(false);
                    this.addRemoveButton.setEnabled(false);
                } else {
                    this.checkIt.setChecked(!this.checkIt.isChecked());
                }
            } else {
                if (this.isFirst) {
                    this.orderState.setEnabled(this.hasPrepared);
                    this.articleName.setEnabled(this.hasPrepared);
                    this.ordered.setEnabled(this.hasPrepared);
                    this.ready.setEnabled(this.hasPrepared);
                    this.packTable.setEnabled(this.hasPrepared);
                    if (this.imagePanel != null) {
                        this.imagePanel.setEnabled(this.hasPrepared);
                    }
                }
                this.receive.setEnabled(this.hasPrepared);
                this.rec_remark.setEnabled(this.hasPrepared);
                this.receivingStore.setEnabled(this.hasPrepared);
                this.reject.setEnabled(this.hasPrepared);
                this.rej_remark.setEnabled(this.hasPrepared);
                this.editStore.setEnabled(this.hasPrepared);
                this.addRemoveButton.setEnabled(this.hasPrepared);
            }
            this.screen.createFocusCycle();
        } else if (source == this.editStore) {
            this.backupPos = (StorePositionLight)this.receivingStore.getNode().getValue();
            boolean restrictions = Boolean.TRUE.equals(this.settings.getUseStoreEntryTypeRestrictionForManualTransactions()) && !this.provider.isWritable(ARequisitionOrderAccess.MOVE_FROM_TO_ANY_STORE);
            InnerPopupFactory.showStoreChangePopup(x, y, null, this.receivingStore.getNode(), this.editStore, this, TransactionType.REQUISITION_RECEIVE, restrictions);
        } else if (source == this.addRemoveButton) {
            if (source instanceof AddButton) {
                DTOProxyNode n = new DTOProxyNode(this.model.getNode());
                this.model.getNode().getParent().addChild((Node)n, 0L);
            } else if (source instanceof DeleteButton) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
            this.screen.getTable().revalidate();
        }
        this.screen.ensureButtonState();
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean isEnabled = enabled && this.isUnitOrderConvertible();
        this.updateOrderConversionState();
        super.setEnabled(isEnabled && this.hasPrepared);
        if (this.isFirst) {
            this.articleName.setEnabled(isEnabled && this.hasPrepared);
            this.ordered.setEnabled(isEnabled && this.hasPrepared);
            this.ready.setEnabled(isEnabled && this.hasPrepared);
            this.packTable.setEnabled(isEnabled && this.hasPrepared);
            if (this.imagePanel != null) {
                this.imagePanel.setEnabled(isEnabled && this.hasPrepared);
            }
        }
        this.receive.setEnabled(isEnabled && this.hasPrepared);
        this.receivingStore.setEnabled(isEnabled && this.hasPrepared);
        this.reject.setEnabled(isEnabled && this.hasPrepared);
        this.checkIt.setEnabled(isEnabled && this.hasPrepared);
        this.editStore.setEnabled(isEnabled && this.hasPrepared);
        this.addRemoveButton.setEnabled(isEnabled && this.hasPrepared);
        this.rec_remark.setEnabled(isEnabled && this.hasPrepared);
        this.rej_remark.setEnabled(isEnabled && this.hasPrepared);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isFirst) {
            this.articleName.kill();
            this.ordered.kill();
            this.ready.kill();
            this.packTable.kill();
            if (this.imagePanel != null) {
                this.imagePanel.kill();
            }
        }
        this.receive.getUnitNode().removeNodeListener((NodeListener)this);
        this.receive.kill();
        this.receivingStore.kill();
        this.reject.kill();
        this.checkIt.kill();
        this.rec_remark.kill();
        this.rej_remark.kill();
        this.editStore.kill();
        this.addRemoveButton.kill();
        this.articleName = null;
        this.ordered = null;
        this.ready = null;
        this.receive = null;
        this.receivingStore = null;
        this.reject = null;
        this.checkIt = null;
        this.rec_remark = null;
        this.rej_remark = null;
        this.packTable = null;
        this.editStore = null;
        this.addRemoveButton = null;
        this.imagePanel = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        if (!this.checkIt.isChecked()) {
            focusList.addAll(this.receive.getFocusComponents());
            focusList.addAll(this.editStore.getFocusComponents());
            focusList.addAll(this.reject.getFocusComponents());
            focusList.addAll(this.addRemoveButton.getFocusComponents());
        }
        focusList.add(this.checkIt);
        return focusList;
    }

    private boolean validateInput() {
        boolean canOverrideThreshold = HUDToolkit.hasAccess(RequisitionOrderAccess.MODULE_REQUISITION, RequisitionOrderAccess.CAN_OVERRIDE_RECEIVE_THRESHOLD, this.currentUser);
        double ready = this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.preparedAmount).getValue() instanceof StoreQuantityComplete ? (double)((StoreQuantityComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.preparedAmount).getValue()).getAmount().longValue() : ((QuantityComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.preparedAmount).getValue()).getQuantity();
        double received = this.receive.getValueNode().getValue() instanceof Long ? (double)((Long)this.receive.getValueNode().getValue()).longValue() : (Double)this.receive.getValueNode().getValue();
        received = UnitCalculator.roundWithDoublePrecision((double)received);
        double rejected = this.reject.getValueNode().getValue() instanceof Long ? (double)((Long)this.reject.getValueNode().getValue()).longValue() : (Double)this.reject.getValueNode().getValue();
        rejected = UnitCalculator.roundWithDoublePrecision((double)rejected);
        BasicArticleComplete artC = (BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
        UnitComplete readyUnit = ((StoreQuantityComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.preparedAmount).getValue()).getUnit();
        UnitComplete receivedUnit = (UnitComplete)this.receive.getUnitNode().getValue();
        UnitComplete rejectedUnit = (UnitComplete)this.reject.getUnitNode().getValue();
        double rrec = UnitConversionToolkit.convertUnit((UnitComplete)receivedUnit, (UnitComplete)readyUnit, (double)received, (BasicArticleLight)artC, (Timestamp)this.getValidityDate());
        double rrej = UnitConversionToolkit.convertUnit((UnitComplete)rejectedUnit, (UnitComplete)readyUnit, (double)rejected, (BasicArticleLight)artC, (Timestamp)this.getValidityDate());
        rrec = UnitCalculator.roundWithDoublePrecision((double)rrec);
        rrej = UnitCalculator.roundWithDoublePrecision((double)rrej);
        boolean readyValid = true;
        boolean receiveValid = true;
        boolean rejectValid = true;
        boolean rejectRemarkValid = true;
        boolean isValid = true;
        if (received > 0.0) {
            if (rrec > ready) {
                readyValid = false;
                receiveValid = false;
                isValid = false;
            } else if (Boolean.TRUE.equals(this.settings.getUseRequisitionReceiveThreshold()) && !canOverrideThreshold && rrec < ready) {
                double underflow = rrec / ready;
                underflow = 1.0 - underflow;
                underflow *= 100.0;
                if (this.settings.getRequisitionReceiveThreshold() < underflow) {
                    isValid = false;
                    receiveValid = false;
                } else {
                    isValid = true;
                    receiveValid = true;
                }
            }
        } else if (rejected == 0.0) {
            receiveValid = false;
            isValid = false;
        }
        if (rejected > 0.0) {
            if (this.rej_remark.getNode().getValue() == null) {
                isValid = false;
                rejectRemarkValid = false;
            }
            if (rrej > ready) {
                rejectValid = false;
                readyValid = false;
            }
            if (rrec + rrej > ready) {
                readyValid = false;
                receiveValid = false;
                rejectValid = false;
                isValid = false;
            }
        }
        if (this.receivingStore.getNode().getValue() != null) {
            StorePositionLight l = (StorePositionLight)this.receivingStore.getNode().getValue();
            if (l.getStore().getBlockedByInventory().booleanValue()) {
                this.receivingStore.setErrorString(Words.INVENTORY_IN_PROGRESS_ON_THIS_STORE);
                this.receivingStore.setInvalid();
                isValid = false;
            }
            if (Boolean.TRUE.equals(this.settings.getUseStoreEntryTypeRestrictionForManualTransactions()) && !Boolean.TRUE.equals(l.getStore().getRequisitionAllowed())) {
                this.receivingStore.setErrorString(Words.STORE_IS_NOT_ALLOWED_TO_RECEIVE_REQUISITIONS);
                this.receivingStore.setInvalid();
                isValid = false;
            }
        } else {
            this.receivingStore.setErrorString(Words.NO_STORE_POSITION_SELECTED);
            this.receivingStore.setInvalid();
            isValid = false;
        }
        if (this.ready != null) {
            if (!readyValid) {
                this.ready.setInvalid();
            } else {
                this.ready.setValid();
            }
        }
        if (!receiveValid) {
            this.receive.setInvalid();
        } else {
            this.receive.setValid();
        }
        if (!rejectValid) {
            this.reject.setInvalid();
        } else {
            this.reject.setValid();
        }
        if (!rejectRemarkValid) {
            this.rej_remark.setInvalid();
        } else {
            this.rej_remark.setValid();
        }
        return isValid;
    }

    public void valueChanged(Node<?> node) {
        this.changeUnit();
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs == null) {
            this.receivingStore.getNode().setValue((Object)this.backupPos, System.currentTimeMillis());
        } else {
            BasicArticleComplete artC = (BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
            StorePositionLight storePosition = (StorePositionLight)this.receivingStore.getNode().getValue();
            if (storePosition != null) {
                this.updateImage(storePosition.getStore());
                List units = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)this.getValidityDate(), (TransactionType)TransactionType.REQUISITION_RECEIVE, (UserComplete)this.currentUser, null, (StoreLight)storePosition.getStore(), (SystemSettingsComplete)this.settings);
                this.receive.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
                this.receive.getUnitNode().addNodeListener((NodeListener)this);
                UnitSelectionUtil.selectUnit(units, this.receive, (BasicArticleLight)artC);
                this.changeUnit();
            }
        }
    }

    private void updateImage(StoreLight store) {
        if (this.model.getNode() == null || this.imagePanel == null) {
            return;
        }
        Node articleNode = this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article);
        if (articleNode == null) {
            return;
        }
        if (store == null) {
            this.imagePanel.setNode(articleNode.getChildNamed(BasicArticleLight_.floatStoreUnitImage));
        } else if (Boolean.TRUE.equals(store.getMainStore())) {
            this.imagePanel.setNode(articleNode.getChildNamed(BasicArticleLight_.mainStoreUnitImage));
        } else {
            this.imagePanel.setNode(articleNode.getChildNamed(BasicArticleLight_.floatStoreUnitImage));
        }
    }

    @Override
    public boolean isChecked() {
        return this.checkIt.isChecked();
    }

    @Override
    public void setChecked(boolean select) {
        if (select != this.isChecked()) {
            this.checkIt.setChecked(select);
            this.buttonPressed(this.checkIt, 0, 0);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentX = 0;
            int w = TableRowPanelImplPrep.this.model.getParentModel().getColumnWidth(0);
            if (TableRowPanelImplPrep.this.isFirst) {
                TableRowPanelImplPrep.this.orderState.setLocation(currentX + TableRowPanelImplPrep.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.orderState.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImplPrep.this.orderState.setSize(w - 2 * TableRowPanelImplPrep.this.getCellPadding(), (int)TableRowPanelImplPrep.this.orderState.getPreferredSize().getHeight());
            }
            currentX += w;
            w = TableRowPanelImplPrep.this.model.getParentModel().getColumnWidth(1);
            if (TableRowPanelImplPrep.this.isFirst) {
                TableRowPanelImplPrep.this.articleName.setLocation(currentX + TableRowPanelImplPrep.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.articleName.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImplPrep.this.articleName.setSize((int)((double)w - ((double)(2 * TableRowPanelImplPrep.this.getCellPadding() + TableRowPanelImplPrep.this.getInnerCellPadding()) + TableRowPanelImplPrep.this.packTable.getPreferredSize().getWidth())), (int)TableRowPanelImplPrep.this.articleName.getPreferredSize().getHeight());
                TableRowPanelImplPrep.this.packTable.setLocation(TableRowPanelImplPrep.this.articleName.getX() + TableRowPanelImplPrep.this.articleName.getWidth() + TableRowPanelImplPrep.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.packTable.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImplPrep.this.packTable.setSize(TableRowPanelImplPrep.this.packTable.getPreferredSize());
            }
            int index = 2;
            if (TableRowPanelImplPrep.this.isFirst) {
                if (TableRowPanelImplPrep.this.imagePanel != null) {
                    currentX += w;
                    w = TableRowPanelImplPrep.this.model.getParentModel().getColumnWidth(index++);
                    TableRowPanelImplPrep.this.imagePanel.setLocation(currentX + TableRowPanelImplPrep.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.imagePanel.getPreferredSize().getHeight()) / 2.0));
                    TableRowPanelImplPrep.this.imagePanel.setSize(w - 2 * TableRowPanelImplPrep.this.getCellPadding(), (int)TableRowPanelImplPrep.this.imagePanel.getPreferredSize().getHeight());
                }
            } else if (Boolean.TRUE.equals(TableRowPanelImplPrep.this.settings.getShowImageOnRequisitionWorkTools())) {
                currentX += w;
                w = TableRowPanelImplPrep.this.model.getParentModel().getColumnWidth(index++);
            }
            currentX += w;
            w = TableRowPanelImplPrep.this.model.getParentModel().getColumnWidth(index++);
            if (TableRowPanelImplPrep.this.isFirst) {
                TableRowPanelImplPrep.this.ordered.setLocation(currentX + TableRowPanelImplPrep.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.ordered.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImplPrep.this.ordered.setSize(w - 2 * TableRowPanelImplPrep.this.getCellPadding(), (int)TableRowPanelImplPrep.this.ordered.getPreferredSize().getHeight());
            }
            currentX += w;
            w = TableRowPanelImplPrep.this.model.getParentModel().getColumnWidth(index++);
            if (TableRowPanelImplPrep.this.isFirst) {
                TableRowPanelImplPrep.this.ready.setLocation(currentX + TableRowPanelImplPrep.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.ready.getPreferredSize().getHeight()) / 2.0));
                TableRowPanelImplPrep.this.ready.setSize(w - 2 * TableRowPanelImplPrep.this.getCellPadding(), (int)TableRowPanelImplPrep.this.ready.getPreferredSize().getHeight());
            }
            currentX += w;
            w = TableRowPanelImplPrep.this.model.getParentModel().getColumnWidth(index++);
            TableRowPanelImplPrep.this.receive.setLocation(currentX + TableRowPanelImplPrep.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.receive.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImplPrep.this.receive.setSize((int)TableRowPanelImplPrep.this.receive.getPreferredSize().getWidth(), (int)TableRowPanelImplPrep.this.receive.getPreferredSize().getHeight());
            TableRowPanelImplPrep.this.rec_remark.setLocation(TableRowPanelImplPrep.this.receive.getX() + TableRowPanelImplPrep.this.receive.getWidth() + TableRowPanelImplPrep.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.rec_remark.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImplPrep.this.rec_remark.setSize(TableRowPanelImplPrep.this.rec_remark.getPreferredSize());
            currentX += w;
            w = TableRowPanelImplPrep.this.model.getParentModel().getColumnWidth(index++);
            TableRowPanelImplPrep.this.receivingStore.setLocation(currentX + TableRowPanelImplPrep.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.receivingStore.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImplPrep.this.receivingStore.setSize((int)((double)w - ((double)(2 * TableRowPanelImplPrep.this.getCellPadding() + TableRowPanelImplPrep.this.getInnerCellPadding()) + TableRowPanelImplPrep.this.editStore.getPreferredSize().getWidth())), (int)TableRowPanelImplPrep.this.receivingStore.getPreferredSize().getHeight());
            TableRowPanelImplPrep.this.editStore.setLocation(TableRowPanelImplPrep.this.receivingStore.getX() + TableRowPanelImplPrep.this.receivingStore.getWidth() + TableRowPanelImplPrep.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.editStore.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImplPrep.this.editStore.setSize(TableRowPanelImplPrep.this.editStore.getPreferredSize());
            currentX += w;
            w = TableRowPanelImplPrep.this.model.getParentModel().getColumnWidth(index++);
            TableRowPanelImplPrep.this.reject.setLocation(currentX + TableRowPanelImplPrep.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.reject.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImplPrep.this.reject.setSize((int)TableRowPanelImplPrep.this.reject.getPreferredSize().getWidth(), (int)TableRowPanelImplPrep.this.reject.getPreferredSize().getHeight());
            TableRowPanelImplPrep.this.rej_remark.setLocation(TableRowPanelImplPrep.this.reject.getX() + TableRowPanelImplPrep.this.reject.getWidth() + TableRowPanelImplPrep.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.rej_remark.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImplPrep.this.rej_remark.setSize(TableRowPanelImplPrep.this.rej_remark.getPreferredSize());
            currentX += w;
            w = TableRowPanelImplPrep.this.model.getParentModel().getColumnWidth(index++);
            TableRowPanelImplPrep.this.setControlsX(currentX);
            TableRowPanelImplPrep.this.addRemoveButton.setLocation(currentX + TableRowPanelImplPrep.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.addRemoveButton.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImplPrep.this.addRemoveButton.setSize(TableRowPanelImplPrep.this.addRemoveButton.getPreferredSize());
            TableRowPanelImplPrep.this.checkIt.setLocation(TableRowPanelImplPrep.this.addRemoveButton.getX() + TableRowPanelImplPrep.this.addRemoveButton.getWidth() + TableRowPanelImplPrep.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowPanelImplPrep.this.checkIt.getPreferredSize().getHeight()) / 2.0));
            TableRowPanelImplPrep.this.checkIt.setSize(TableRowPanelImplPrep.this.checkIt.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (Boolean.TRUE.equals(TableRowPanelImplPrep.this.settings.getShowImageOnRequisitionWorkTools())) {
                return new Dimension(0, 70);
            }
            return new Dimension(0, TableRowPanelImplPrep.this.getDefaultRowHeight());
        }
    }
}

