/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DeletedBooleanConverter;
import ch.icit.pegasus.client.converter.InUseBooleanConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StorePositionConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.InventoryCBSubModuleNEW;
import ch.icit.pegasus.client.gui.table.renderer.CellViewBooleanRenderer;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.UnitSelectionUtil;
import ch.icit.pegasus.client.gui.utils.buttons.AddButton;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.StockTransactionRemarkButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.image.ImagePanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.searcher.searchfieldimpls.StorePositionSearchFieldRemoteSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryCheckinComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryCheckinComplete_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryRemarkComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionContentComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.IStockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TableRowImplNEW
extends Table2RowPanel
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private InventoryCBSubModuleNEW inventoryScreen;
    private TextLabel artNumber;
    private TextLabel customerArticleNumber;
    private TextLabel artName;
    private SearchComboBox positionSearch;
    private TextLabel chargeName;
    private TextLabel lastInventory;
    private CellViewBooleanRenderer inUseCol;
    private CellViewBooleanRenderer deletedCol;
    private QuantityRenderer inStock;
    private InputComboBox2 count;
    private StockTransactionRemarkButton attButton;
    private InfoButton packTable;
    private ArrowConnectorIcon connector;
    private Button button;
    private boolean blocked;
    private boolean upperTable;
    private Node<QuantityComplete> countedQuantity;
    private ImagePanel imagePanel;
    private SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();

    public TableRowImplNEW(Table2RowModel m, InventoryCBSubModuleNEW screen, boolean upperTable) {
        super(m);
        QuantityComplete q;
        InventoryCheckinComplete a;
        this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        this.upperTable = upperTable;
        this.inventoryScreen = screen;
        this.artNumber = new TextLabel(this.getArticleNode().getChildNamed(BasicArticleLight_.number), ConverterRegistry.getConverter(IntegerConverter.class));
        this.customerArticleNumber = new TextLabel(this.getArticleNode().getChildNamed(BasicArticleLight_.customerArticleNumber), ConverterRegistry.getConverter(StringConverter.class));
        this.artName = new TextLabel(this.getArticleNode().getChildNamed(BasicArticleLight_.name), ConverterRegistry.getConverter(StringConverter.class));
        this.positionSearch = new SearchComboBox(true);
        this.positionSearch.setDefaultViewConverter(ConverterRegistry.getConverter(StorePositionConverter.class));
        this.positionSearch.setDefaultEntryConverter(ConverterRegistry.getConverter(StorePositionConverter.class));
        this.positionSearch.setSearchAlgorithm(new StorePositionSearchFieldRemoteSearchAlgorithm());
        this.positionSearch.setAdditionalSearchField(screen.getStore());
        this.positionSearch.setNode(this.getPositionNode());
        this.chargeName = new TextLabel(this.getChargeNameNode());
        this.inStock = new QuantityRenderer(this.getInStockNode());
        this.inStock.setProgress(1.0f);
        this.lastInventory = new TextLabel(this.getLastInventoryNode(), ConverterRegistry.getConverter(DateConverter.class));
        this.lastInventory.setProgress(1.0f);
        this.inUseCol = new CellViewBooleanRenderer((Boolean)this.getArticleNode().getChildNamed(BasicArticleLight_.isInUse).getValue(), false);
        this.inUseCol.setToolTipText(((InUseBooleanConverter)ConverterRegistry.getConverter(InUseBooleanConverter.class)).convert((Boolean)this.getArticleNode().getChildNamed(BasicArticleLight_.isInUse).getValue(), null, new Object[0]));
        this.deletedCol = new CellViewBooleanRenderer((Boolean)this.getArticleNode().getChildNamed(BasicArticleLight_.isDeleted).getValue() == false, false);
        this.deletedCol.setToolTipText(((DeletedBooleanConverter)ConverterRegistry.getConverter(DeletedBooleanConverter.class)).convert((Boolean)this.getArticleNode().getChildNamed(BasicArticleLight_.isDeleted).getValue(), null, new Object[0]));
        this.packTable = new ArticleInfoButton((Node<BasicArticleReference>)this.getArticle(), this.getValidityNode(), 3003);
        this.countedQuantity = m.getNode().getChildNamed(new String[]{"count"});
        BasicArticleComplete artC = (BasicArticleComplete)this.getArticleNode().getValue(BasicArticleComplete.class);
        if (artC == null) {
            BasicArticleLight artL = (BasicArticleLight)this.getArticleNode().getValue(BasicArticleLight.class);
            try {
                artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(artL.getId())).getValue();
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog("Unable to load Full Article Data", (Component)this);
            }
        }
        Object value = this.model.getNode().getValue();
        StorePositionLight position = null;
        if (value instanceof ArticleChargeBatchComplete) {
            ArticleChargeBatchComplete batch = (ArticleChargeBatchComplete)value;
            position = batch.getPosition();
        }
        if (value instanceof StorePositionContentComplete) {
            StorePositionContentComplete content = (StorePositionContentComplete)value;
            position = content.getStorePosition();
        }
        StoreLight store = position != null ? position.getStore() : null;
        StoreQuantityComplete storeQuantityComplete = null;
        if (upperTable) {
            QuantityComplete q2 = new QuantityComplete((QuantityComplete)this.inStock.getNode().getValue());
            q2.setQuantity(Double.valueOf(0.0));
            if (Boolean.TRUE.equals(store.getMainStore())) {
                q2.setUnit(artC.getMainStoreUnit());
            } else {
                q2.setUnit(artC.getFloatStoreUnit());
            }
            this.countedQuantity = INodeCreator.getDefaultImpl().getNode4DTO((Object)q2, false, false);
            this.countedQuantity.setName("count");
            this.model.getNode().addChild(this.countedQuantity, 0L);
            storeQuantityComplete = new StoreQuantityComplete(Long.valueOf(((QuantityComplete)this.countedQuantity.getValue()).getAmount().longValue()), ((QuantityComplete)this.countedQuantity.getValue()).getUnit());
        } else {
            if (value instanceof InventoryCheckinComplete) {
                a = (InventoryCheckinComplete)value;
                q = new QuantityComplete(Double.valueOf(a.getAmount().getAmount().longValue()), a.getAmount().getUnit());
                this.countedQuantity = INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false);
                this.countedQuantity.setName("count");
                this.model.getNode().addChild(this.countedQuantity, 0L);
            }
            storeQuantityComplete = UnitConversionToolkit.convertToStoreQuantity((QuantityComplete)((QuantityComplete)this.countedQuantity.getValue()), (BasicArticleLight)artC, (Timestamp)new Timestamp(System.currentTimeMillis()));
        }
        if (value instanceof InventoryCheckinComplete) {
            a = (InventoryCheckinComplete)value;
            q = new QuantityComplete(Double.valueOf(a.getAmount().getAmount().longValue()), a.getAmount().getUnit());
            this.countedQuantity = INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false);
            this.countedQuantity.setName("count");
            this.model.getNode().addChild(this.countedQuantity, 0L);
            storeQuantityComplete = UnitConversionToolkit.convertToStoreQuantity((QuantityComplete)((QuantityComplete)this.countedQuantity.getValue()), (BasicArticleLight)artC, (Timestamp)new Timestamp(System.currentTimeMillis()));
        }
        this.countedQuantity = INodeCreator.getDefaultImpl().getNode4DTO((Object)new QuantityComplete(storeQuantityComplete), false, false);
        this.count = new InputComboBox2(this.countedQuantity.getChildNamed(new String[]{"quantity"}), this.countedQuantity.getChildNamed(new String[]{"unit"}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
        this.count.setProgress(1.0f);
        Object fromDate = this.getValidityNode().getValue();
        Timestamp validity = fromDate == null ? new Timestamp(System.currentTimeMillis()) : (fromDate instanceof Timestamp ? (Timestamp)fromDate : new Timestamp(((Date)fromDate).getTime()));
        UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        List units = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)validity, (TransactionType)TransactionType.INVENTORY, (UserComplete)currentUser, (StoreLight)store, (StoreLight)store, (SystemSettingsComplete)settings);
        this.count.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
        UnitSelectionUtil.selectUnit(units, this.count, (BasicArticleLight)artC);
        if (Boolean.TRUE.equals(settings.getShowImageOnInventoryWorkTools())) {
            this.imagePanel = new ImagePanel();
            this.imagePanel.setFixSize(60);
            this.updateImage(position != null ? position.getStore() : null);
        }
        this.connector = new ArrowConnectorIcon();
        this.connector.setProgress(1.0f);
        DTOProxyNode a2 = new DTOProxyNode();
        a2.setName("currentRemark");
        m.getNode().addChildSilent((Node)a2, null, true, 0L);
        this.attButton = new StockTransactionRemarkButton<InventoryRemarkComplete>((Node<InventoryRemarkComplete>)a2, InventoryRemarkComplete.class);
        this.attButton.setProgress(1.0f);
        if (value instanceof InventoryCheckinComplete) {
            this.button = new DeleteButton();
            this.count.setEnabled(false);
        } else {
            this.button = upperTable ? new AddButton() : new DeleteButton();
        }
        this.button.addButtonListener(this);
        this.positionSearch.setProgress(1.0f);
        this.setLayout(new TableRowLayout());
        this.add(this.artNumber);
        this.add(this.customerArticleNumber);
        this.add(this.artName);
        this.add(this.positionSearch);
        if (this.inventoryScreen.isChargeBased()) {
            this.add(this.chargeName);
        }
        if (this.imagePanel != null) {
            this.add(this.imagePanel);
        }
        this.add(this.lastInventory);
        this.add(this.inUseCol);
        this.add(this.deletedCol);
        this.add(this.inStock);
        this.add(this.connector);
        this.add(this.count);
        this.add(this.attButton);
        this.add(this.packTable);
        this.add(this.button);
    }

    private void updateImage(StoreLight value) {
        if (value == null) {
            this.imagePanel.setNode(this.getArticleNode().getChildNamed(BasicArticleComplete_.floatStoreUnitImage));
        } else if (Boolean.TRUE.equals(value.getMainStore())) {
            this.imagePanel.setNode(this.getArticleNode().getChildNamed(BasicArticleComplete_.mainStoreUnitImage));
        } else {
            this.imagePanel.setNode(this.getArticleNode().getChildNamed(BasicArticleComplete_.floatStoreUnitImage));
        }
    }

    private Node getArticle() {
        if (this.inventoryScreen.isChargeBased() || this.model.getNode().getValue() instanceof InventoryCheckinComplete) {
            return this.getArticleNode();
        }
        return this.model.getNode().getChildNamed(new String[]{"batches"}).getChildAt(0).getChildNamed(new String[]{"charge-basicArticle"});
    }

    private Node<?> getChargeNameNode() {
        if (this.inventoryScreen.isChargeBased()) {
            if (this.model.getNode().getValue() instanceof ArticleChargeComplete) {
                return this.model.getNode().getChildNamed(new String[]{"number"});
            }
            if (this.model.getNode().getValue() instanceof InventoryCheckinComplete) {
                return null;
            }
            if (this.model.getNode().getValue() instanceof ArticleChargeBatchComplete) {
                return this.model.getNode().getChildNamed(new String[]{"charge-number"});
            }
        }
        return null;
    }

    private Node<Date> getValidityNode() {
        if (this.model.getNode().getValue() instanceof ArticleChargeBatchComplete) {
            return this.model.getNode().getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, ArticleChargeLight_.creationDate});
        }
        if (this.model.getNode().getValue() instanceof InventoryCheckinComplete) {
            return this.model.getNode().getChildNamed(InventoryCheckinComplete_.date);
        }
        if (!this.inventoryScreen.isChargeBased()) {
            return this.model.getNode().getChildNamed(new String[]{"batches"}).getChildAt(0).getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, ArticleChargeLight_.creationDate});
        }
        return this.model.getNode().getChildNamed(ArticleChargeLight_.creationDate);
    }

    private Node getArticleNode() {
        if (this.model.getNode().getValue() instanceof ArticleChargeBatchComplete) {
            return this.model.getNode().getChildNamed(new String[]{"charge-basicArticle"});
        }
        if (this.model.getNode().getValue() instanceof InventoryCheckinComplete) {
            return this.model.getNode().getChildNamed(new String[]{"article"});
        }
        if (this.inventoryScreen.isChargeBased()) {
            return this.model.getNode().getChildNamed(new String[]{"batches"}).getChildAt(0).getChildNamed(new String[]{"charge-basicArticle"});
        }
        return this.model.getNode().getChildNamed(new String[]{"article"});
    }

    private Node getPositionNode() {
        if (this.model.getNode().getValue() instanceof ArticleChargeBatchComplete) {
            return this.model.getNode().getChildNamed(new String[]{"position"});
        }
        if (this.model.getNode().getValue() instanceof InventoryCheckinComplete) {
            return this.model.getNode().getChildNamed(new String[]{"storePosition"});
        }
        if (this.inventoryScreen.isChargeBased()) {
            return this.model.getNode().getChildNamed(new String[]{"batches"}).getChildAt(0).getChildNamed(new String[]{"position"});
        }
        return this.model.getNode().getChildNamed(new String[]{"storePosition"});
    }

    private Node getLastInventoryNode() {
        if (this.model.getNode().getValue() instanceof ArticleChargeBatchComplete) {
            return this.model.getNode().getChildNamed(new String[]{"lastInventory"});
        }
        if (this.model.getNode().getValue() instanceof InventoryCheckinComplete) {
            return INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        }
        if (this.inventoryScreen.isChargeBased()) {
            Node ii = null;
            Iterator it = this.model.getNode().getChildNamed(new String[]{"batches"}).getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                Node i = n.getChildNamed(new String[]{"lastInventory"});
                if (ii == null) {
                    ii = i;
                    continue;
                }
                if (ii.getValue() == null) {
                    ii = i;
                    continue;
                }
                if (i.getValue() == null) continue;
                Timestamp i1 = (Timestamp)ii.getValue();
                Timestamp i2 = (Timestamp)i.getValue();
                if (i2.getTime() <= i1.getTime()) continue;
                ii = i;
            }
            return ii;
        }
        Node ii = null;
        Iterator it = this.model.getNode().getChildNamed(new String[]{"batches"}).getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            n.updateNode();
            Node i = n.getChildNamed(new String[]{"lastInventory"});
            if (i.getValue() == null) {
                n.updateNode();
            }
            if (ii == null) {
                ii = i;
                continue;
            }
            if (ii.getValue() == null) {
                ii = i;
                continue;
            }
            if (i.getValue() == null) continue;
            Timestamp i1 = (Timestamp)ii.getValue();
            Timestamp i2 = (Timestamp)i.getValue();
            if (i2.getTime() <= i1.getTime()) continue;
            ii = i;
        }
        return ii;
    }

    private Node<QuantityComplete> getInStockNode() {
        StorePositionContentComplete content;
        Timestamp validity;
        BasicArticleLight bal = null;
        BasicArticleComplete bac = null;
        StoreQuantityComplete oldQuantity = null;
        QuantityComplete newQuantity = null;
        if (this.model.getNode().getValue() instanceof ArticleChargeBatchComplete) {
            bac = (BasicArticleComplete)this.model.getNode().getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, ArticleChargeLight_.basicArticle}).getValue(BasicArticleComplete.class);
            ArticleChargeBatchComplete charge = (ArticleChargeBatchComplete)this.model.getNode().getValue();
            oldQuantity = charge.getQuantity();
            validity = charge.getCharge().getCreationDate();
        } else if (this.model.getNode().getValue() instanceof InventoryCheckinComplete) {
            bal = ((InventoryCheckinComplete)this.model.getNode().getValue()).getArticle();
            InventoryCheckinComplete transaction = (InventoryCheckinComplete)this.model.getNode().getValue();
            oldQuantity = transaction.getAmount();
            validity = transaction.getDate();
        } else if (this.model.getNode().getValue() instanceof StorePositionContentComplete) {
            bal = ((StorePositionContentComplete)this.model.getNode().getValue()).getArticle();
            oldQuantity = ((StorePositionContentComplete)this.model.getNode().getValue()).getStoreQuantity();
            validity = new Timestamp(System.currentTimeMillis());
        } else {
            validity = new Timestamp(System.currentTimeMillis());
        }
        if (bac == null) {
            try {
                bac = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)bal).getValue();
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog("Unable to load Article Data", (Component)this);
                return null;
            }
        }
        if (validity == null) {
            validity = new Timestamp(System.currentTimeMillis());
        }
        StoreLight store = null;
        if (this.model.getNode().getValue() instanceof ArticleChargeBatchComplete) {
            ArticleChargeBatchComplete batch = (ArticleChargeBatchComplete)this.model.getNode().getValue();
            store = batch.getPosition().getStore();
        } else if (this.model.getNode().getValue() instanceof StorePositionContentComplete) {
            content = (StorePositionContentComplete)this.model.getNode().getValue();
            store = content.getStorePosition().getStore();
        } else if (this.model.getNode().getValue() instanceof InventoryCheckinComplete) {
            content = (InventoryCheckinComplete)this.model.getNode().getValue();
            store = content.getStorePosition().getStore();
        } else {
            throw new IllegalStateException("Unknown Type found");
        }
        newQuantity = new QuantityComplete();
        UnitComplete targetUnit = store.getMainStore() != false ? bac.getMainStoreUnit() : bac.getFloatStoreUnit();
        if (oldQuantity != null) {
            double d = UnitConversionToolkit.convertUnit((UnitComplete)oldQuantity.getUnit(), (UnitComplete)targetUnit, (double)oldQuantity.getAmount().longValue(), (BasicArticleLight)bac, (Timestamp)validity);
            newQuantity.setQuantity(Double.valueOf(d));
            newQuantity.setUnit(targetUnit);
        }
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)newQuantity, false, false);
    }

    @Override
    public Object getObject4Column(int column) {
        return this.positionSearch.getText();
    }

    public IStockInventoryComplete getTransaction() {
        if (this.model.getNode().getValue() instanceof InventoryCheckinComplete) {
            return (InventoryCheckinComplete)this.model.getNode().getValue(InventoryCheckinComplete.class);
        }
        StockInventoryComplete scc = new StockInventoryComplete();
        if (this.inventoryScreen.isChargeBased()) {
            ArticleChargeLight charge = (ArticleChargeLight)this.model.getNode().getChildNamed(new String[]{"charge"}).getValue(ArticleChargeLight.class);
            scc.setCharge(charge);
        } else {
            scc.setCharge((ArticleChargeLight)this.model.getNode().getChildNamed(new String[]{"batches"}).getChildAt(0).getChildNamed(new String[]{"charge"}).getValue(ArticleChargeLight.class));
        }
        StoreQuantityComplete quant = new StoreQuantityComplete();
        quant.setAmount(TransactionToolkit.getLongValue(this.count.getValueNode()));
        quant.setUnit((UnitComplete)this.count.getUnitNode().getValue());
        scc.setAmount(quant);
        scc.setRemark((InventoryRemarkComplete)this.attButton.getNode().getValue());
        scc.setStorePosition((StorePositionLight)this.positionSearch.getNode().getValue());
        return scc;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.blocked) {
            isEnabled = false;
        }
        this.artNumber.setEnabled(isEnabled);
        this.customerArticleNumber.setEnabled(isEnabled);
        this.artName.setEnabled(isEnabled);
        this.positionSearch.setEnabled(isEnabled);
        if (this.chargeName != null) {
            this.chargeName.setEnabled(isEnabled);
        }
        if (this.lastInventory != null) {
            this.lastInventory.setEnabled(isEnabled);
        }
        if (this.inStock != null) {
            this.inStock.setEnabled(isEnabled);
        }
        if (this.connector != null) {
            this.connector.setEnabled(isEnabled);
        }
        this.count.setEnabled(isEnabled);
        this.attButton.setEnabled(isEnabled);
        this.button.setEnabled(isEnabled);
        if (this.imagePanel != null) {
            this.imagePanel.setEnabled(isEnabled);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if ((this.model.getNode().getValue() instanceof ArticleChargeBatchComplete || this.model.getNode().getValue() instanceof StorePositionContentComplete) && !this.blocked) {
            a.addAll(this.count.getFocusComponents());
        }
        a.addAll(this.button.getFocusComponents());
        return a;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.artNumber.kill();
        this.customerArticleNumber.kill();
        this.artName.kill();
        this.positionSearch.kill();
        if (this.chargeName != null) {
            this.chargeName.kill();
        }
        if (this.lastInventory != null) {
            this.lastInventory.kill();
        }
        if (this.inUseCol != null) {
            this.inUseCol.kill();
        }
        if (this.deletedCol != null) {
            this.deletedCol.kill();
        }
        if (this.inStock != null) {
            this.inStock.kill();
        }
        if (this.connector != null) {
            this.connector.kill();
        }
        this.count.kill();
        this.attButton.kill();
        this.button.kill();
        if (this.imagePanel != null) {
            this.imagePanel.kill();
        }
        this.imagePanel = null;
        this.artNumber = null;
        this.customerArticleNumber = null;
        this.artName = null;
        this.positionSearch = null;
        this.chargeName = null;
        this.lastInventory = null;
        this.inStock = null;
        this.connector = null;
        this.count = null;
        this.attButton = null;
        this.button = null;
    }

    public void removeAndAddToLowerTable() {
        if (this.upperTable) {
            Double d = TransactionToolkit.getDoubleValue(this.count.getValueNode());
            UnitComplete u = (UnitComplete)this.count.getUnitNode().getValue();
            this.count.getValueNode().commit();
            this.count.getUnitNode().commit();
            this.inventoryScreen.addToLowerTable(this.model, new QuantityComplete(d, u));
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (this.button instanceof AddButton) {
            this.removeAndAddToLowerTable();
            this.inventoryScreen.createFocusCycle();
            this.inventoryScreen.revalidate();
        } else if (this.button instanceof DeleteButton) {
            this.inventoryScreen.removeFromLowerTable(this);
        }
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
        this.setEnabled(true);
    }

    public boolean isWarningRow() {
        SystemSettingsComplete ss = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (ss.getInventoryThreshold() != null && ss.getInventoryThreshold() != 0.0) {
            BasicArticleComplete bac;
            if (this.getInStockNode() == null || this.count.getValueNode() == null || this.count.getUnitNode() == null || this.getArticle() == null) {
                return false;
            }
            QuantityComplete inStockQuantity = (QuantityComplete)this.getInStockNode().getValue();
            if (inStockQuantity == null) {
                return false;
            }
            Double doubleCount = null;
            if (this.count.getValueNode().getValue() instanceof Double) {
                doubleCount = (Double)this.count.getValueNode().getValue();
            } else if (this.count.getValueNode().getValue() instanceof Long) {
                doubleCount = ((Long)this.count.getValueNode().getValue()).doubleValue();
            }
            QuantityComplete counted = new QuantityComplete(doubleCount, (UnitComplete)this.count.getUnitNode().getValue());
            if (!(this.getArticle().getValue() instanceof BasicArticleComplete)) {
                try {
                    bac = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)this.getArticle().getValue()).getValue();
                }
                catch (ClientServerCallException e) {
                    InnerPopupFactory.showErrorDialog("Unable to load Article Data", (Component)this);
                    return false;
                }
            } else {
                bac = (BasicArticleComplete)this.getArticle().getValue(BasicArticleComplete.class);
            }
            double convertedCount = UnitConversionToolkit.convertUnit((UnitComplete)counted.getUnit(), (UnitComplete)inStockQuantity.getUnit(), (double)counted.getQuantity(), (BasicArticleLight)bac, (Timestamp)new Timestamp(System.currentTimeMillis()));
            double procentualChange = Math.abs(convertedCount / inStockQuantity.getQuantity() - 1.0) * 100.0;
            if (procentualChange > ss.getInventoryThreshold()) {
                this.count.setWarning();
                this.positionSearch.setWarning();
                this.inStock.setWarning();
                this.artNumber.setWarning();
                this.customerArticleNumber.setWarning();
                this.artName.setWarning();
                this.positionSearch.setWarning();
                this.chargeName.setWarning();
                this.lastInventory.setWarning();
                return false;
            }
        }
        return true;
    }

    public String getPositionName() {
        return this.positionSearch.getText();
    }

    public String getArticleName() {
        return this.artName.getText();
    }

    public Integer getArticleNumber() {
        return Integer.valueOf(this.artNumber.getText());
    }

    public String getArticleCustomerNumber() {
        return this.customerArticleNumber.getText();
    }

    private class TableRowLayout
    extends DefaultLayout {
        private TableRowLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = TableRowImplNEW.this.model.getParentModel().getColumnWidth(0);
            int currentX = 0;
            TableRowImplNEW.this.artNumber.setLocation(currentX + TableRowImplNEW.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.artNumber.getPreferredSize().getHeight()) / 2.0));
            TableRowImplNEW.this.artNumber.setSize(w - 2 * TableRowImplNEW.this.getCellPadding(), (int)TableRowImplNEW.this.artNumber.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImplNEW.this.model.getParentModel().getColumnWidth(1);
            TableRowImplNEW.this.customerArticleNumber.setLocation(currentX + TableRowImplNEW.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.customerArticleNumber.getPreferredSize().getHeight()) / 2.0));
            TableRowImplNEW.this.customerArticleNumber.setSize(w - 2 * TableRowImplNEW.this.getCellPadding(), (int)TableRowImplNEW.this.customerArticleNumber.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImplNEW.this.model.getParentModel().getColumnWidth(2);
            TableRowImplNEW.this.artName.setLocation(currentX + TableRowImplNEW.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.artName.getPreferredSize().getHeight()) / 2.0));
            TableRowImplNEW.this.artName.setSize(w - 2 * TableRowImplNEW.this.getCellPadding(), (int)TableRowImplNEW.this.artName.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImplNEW.this.model.getParentModel().getColumnWidth(3);
            int index = 4;
            if (TableRowImplNEW.this.imagePanel != null) {
                TableRowImplNEW.this.imagePanel.setLocation(currentX + TableRowImplNEW.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.imagePanel.getPreferredSize().getHeight()) / 2.0));
                TableRowImplNEW.this.imagePanel.setSize(w - 2 * TableRowImplNEW.this.getCellPadding(), (int)TableRowImplNEW.this.imagePanel.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplNEW.this.model.getParentModel().getColumnWidth(index++);
            }
            TableRowImplNEW.this.positionSearch.setLocation(currentX + TableRowImplNEW.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.positionSearch.getPreferredSize().getHeight()) / 2.0));
            TableRowImplNEW.this.positionSearch.setSize(w - 2 * TableRowImplNEW.this.getCellPadding(), (int)TableRowImplNEW.this.positionSearch.getPreferredSize().getHeight());
            currentX += w;
            w = TableRowImplNEW.this.model.getParentModel().getColumnWidth(index++);
            if (TableRowImplNEW.this.inUseCol != null) {
                TableRowImplNEW.this.inUseCol.setLocation(currentX + TableRowImplNEW.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.inUseCol.getPreferredSize().getHeight()) / 2.0));
                TableRowImplNEW.this.inUseCol.setSize(w - 2 * TableRowImplNEW.this.getCellPadding(), (int)TableRowImplNEW.this.inUseCol.getPreferredSize().getHeight());
            }
            currentX += w;
            w = TableRowImplNEW.this.model.getParentModel().getColumnWidth(index++);
            if (TableRowImplNEW.this.deletedCol != null) {
                TableRowImplNEW.this.deletedCol.setLocation(currentX + TableRowImplNEW.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.deletedCol.getPreferredSize().getHeight()) / 2.0));
                TableRowImplNEW.this.deletedCol.setSize(w - 2 * TableRowImplNEW.this.getCellPadding(), (int)TableRowImplNEW.this.deletedCol.getPreferredSize().getHeight());
            }
            currentX += w;
            w = TableRowImplNEW.this.model.getParentModel().getColumnWidth(index++);
            if (TableRowImplNEW.this.chargeName != null) {
                TableRowImplNEW.this.chargeName.setLocation(currentX + TableRowImplNEW.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.chargeName.getPreferredSize().getHeight()) / 2.0));
                TableRowImplNEW.this.chargeName.setSize(w - 2 * TableRowImplNEW.this.getCellPadding(), (int)TableRowImplNEW.this.chargeName.getPreferredSize().getHeight());
            }
            if (TableRowImplNEW.this.inventoryScreen.isChargeBased()) {
                currentX += w;
                w = TableRowImplNEW.this.model.getParentModel().getColumnWidth(index++);
            }
            if (TableRowImplNEW.this.lastInventory != null) {
                TableRowImplNEW.this.lastInventory.setLocation(currentX + TableRowImplNEW.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.lastInventory.getPreferredSize().getHeight()) / 2.0));
                TableRowImplNEW.this.lastInventory.setSize(w - 2 * TableRowImplNEW.this.getCellPadding(), (int)TableRowImplNEW.this.lastInventory.getPreferredSize().getHeight());
            }
            currentX += w;
            w = TableRowImplNEW.this.model.getParentModel().getColumnWidth(index++);
            if (TableRowImplNEW.this.inStock != null) {
                TableRowImplNEW.this.inStock.setLocation(currentX + TableRowImplNEW.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.inStock.getPreferredSize().getHeight()) / 2.0));
                TableRowImplNEW.this.inStock.setSize(w - 2 * TableRowImplNEW.this.getCellPadding(), (int)TableRowImplNEW.this.inStock.getPreferredSize().getHeight());
            }
            currentX += w;
            w = TableRowImplNEW.this.model.getParentModel().getColumnWidth(index++);
            if (TableRowImplNEW.this.connector != null) {
                TableRowImplNEW.this.connector.setLocation(currentX + TableRowImplNEW.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.connector.getPreferredSize().getHeight()) / 2.0));
                TableRowImplNEW.this.connector.setSize(TableRowImplNEW.this.connector.getPreferredSize());
            }
            currentX += w;
            w = TableRowImplNEW.this.model.getParentModel().getColumnWidth(index++);
            int xx = currentX + w;
            if (TableRowImplNEW.this.count != null) {
                TableRowImplNEW.this.count.setLocation(currentX + TableRowImplNEW.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImplNEW.this.count.setSize((int)TableRowImplNEW.this.count.getPreferredSize().getWidth(), (int)TableRowImplNEW.this.count.getPreferredSize().getHeight());
                xx = TableRowImplNEW.this.count.getX() + TableRowImplNEW.this.count.getWidth();
            }
            if (TableRowImplNEW.this.attButton != null) {
                TableRowImplNEW.this.attButton.setLocation(xx + TableRowImplNEW.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.attButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImplNEW.this.attButton.setSize(TableRowImplNEW.this.attButton.getPreferredSize());
                xx = TableRowImplNEW.this.attButton.getX() + TableRowImplNEW.this.attButton.getWidth();
            }
            if (TableRowImplNEW.this.packTable != null) {
                TableRowImplNEW.this.packTable.setLocation(xx + TableRowImplNEW.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.packTable.getPreferredSize().getHeight()) / 2.0));
                TableRowImplNEW.this.packTable.setSize(TableRowImplNEW.this.packTable.getPreferredSize());
            }
            currentX += w;
            w = TableRowImplNEW.this.model.getParentModel().getColumnWidth(index++);
            TableRowImplNEW.this.setControlsX(currentX);
            TableRowImplNEW.this.button.setLocation(currentX + TableRowImplNEW.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplNEW.this.button.getPreferredSize().getHeight()) / 2.0));
            TableRowImplNEW.this.button.setSize(TableRowImplNEW.this.button.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            if (Boolean.TRUE.equals(TableRowImplNEW.this.settings.getShowImageOnInventoryWorkTools())) {
                return new Dimension(0, 70);
            }
            return new Dimension(0, TableRowImplNEW.this.getDefaultRowHeight());
        }
    }
}

