/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.hud.ConnectionToOutside;
import ch.icit.pegasus.client.gui.screentemplates.ScreenLoader;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.SelectableItem;
import ch.icit.pegasus.client.gui.table.CellPanel;
import ch.icit.pegasus.client.gui.table.RowContentPanel;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.smartaccess.DoubleSmartScreenButton;
import ch.icit.pegasus.client.gui.table.smartaccess.SingleSmartScreenButton;
import ch.icit.pegasus.client.gui.table.smartaccess.SmartScreenPopupButton;
import ch.icit.pegasus.client.gui.table.smartaccess.popup.TableRowSmartScreenAccessPopupInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.animators.AnimationProvider;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.animators.Resizer;
import ch.icit.pegasus.client.gui.utils.animators.Scroller;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.ExpandIcon;
import ch.icit.pegasus.client.gui.utils.buttons.RestoreButton;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.BooleanStatesSkin9Field;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.ToggleSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.TableRowPanelSkin;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.DebugToolkit;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleTypeE;
import ch.icit.pegasus.server.core.general.IUniversal;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollBar;

public class RowPanel<T extends IUniversal>
extends JPanelFadable
implements LafListener,
MouseListener,
ActionListener,
MouseMotionListener,
ButtonListener,
SelectableItem,
ImageConsumer,
FocusListener {
    private static final long serialVersionUID = 1L;
    private ArrayList<CellPanel> cells = new ArrayList();
    protected RowModel<T> model;
    private static RowPanel currentOverPanel;
    private ExpandIcon expandIcon;
    private ToggleSkin1Field sortSkin;
    private boolean removed;
    private Mover<RowPanel<T>> mover;
    private boolean hasPosition;
    private boolean inMovement;
    protected Button.ButtonState state = Button.ButtonState.UP;
    private boolean isOver = false;
    private static boolean isInit;
    private BooleanStatesSkin9Field skin;
    public Skin9Field frameSkin;
    public static int MODE_CLICK;
    public static int MODE_EXPAND;
    private final int currentMode = MODE_EXPAND;
    private int pressedType = -1;
    private static final int SMARTSCREEN_TYPE_NONE = -1;
    private static final int SMARTSCREEN_TYPE_ONE = 2;
    private static final int SMARTSCREEN_TYPE_TWO = 3;
    private int smartScreenType = -1;
    private Button smartButton1;
    private Button smartButton2;
    private final ScreenLoader<T> screenLoader = new ScreenLoader<T>(){

        @Override
        public MainFrame getMainFrame() {
            if (this.getModel() != null && this.getModel().getParentModel() != null && this.getModel().getParentModel().getTable() != null && this.getModel().getParentModel().getTable().getOutSideConnection() != null) {
                return this.getModel().getParentModel().getTable().getOutSideConnection().getMainFrame();
            }
            return null;
        }

        @Override
        public RowModel<T> getModel() {
            return RowPanel.this.getModel();
        }

        @Override
        public InnerPopUp2 getPopup() {
            return RowPanel.this.popUp;
        }

        @Override
        public void clearPopup() {
            RowPanel.this.popUp = null;
        }

        @Override
        public ConnectionToOutside<T, ?> getConnectionToOutside() {
            return this.getModel().getParentModel().getTable().getOutSideConnection();
        }
    };
    private List<SubModuleAccessRightComplete> currentSmartScreens;
    private static Color lineColor_up;
    private static Color lineColor_over;
    private static Color lineColor_down;
    private static Color lineColor_selected;
    protected static Color overlayColor;
    protected static Color header_gradient_start;
    protected static Color header_gradient_end;
    protected RowContentPanel rowContentPanel;
    protected boolean isDisabled = false;
    private boolean isDisabledPermanent = false;
    private DeleteButton deleteButton;
    private RestoreButton restoreButton;
    private Scroller<RowPanel<T>, JScrollBar> scroller;
    private Resizer<RowPanel<T>> resizer;
    private long animationStartTime;
    protected boolean isAnimating = false;
    protected boolean isGrowing = false;
    private int calculatedHeight;
    protected boolean isExpanded;
    private long animationTimeOffset;
    private long lastTimeDiff = 0L;
    protected int draggedColumnIndex = -1;
    protected Point draggBackupPoint;
    private int cumulatedWidth = 0;
    private boolean isDragging = false;
    private int translateOffset;
    protected boolean isSelected;
    private boolean hasDeleteButton;
    private boolean isDraggable = false;
    private boolean isHidden = false;
    protected MouseListener mouseDispatcher;
    private int sortedRow = -1;
    private boolean isAscendent = false;
    private InnerPopUp2 popUp;
    private boolean isRemoteValidated = true;
    private boolean isDeleted;
    private int removeIndex;

    public RowPanel(boolean withListener) {
        this.sortSkin = (ToggleSkin1Field)DefaultSkins.TableSortIcon.createDynamicSkin();
        this.addFocusListener(this);
        this.setLayout(new RowPanelLayout());
        this.setFocusable(true);
        this.setOpaque(false);
        this.skin = SkinRegistry.getSkin(TableRowPanelSkin.class);
        this.frameSkin = (Skin9Field)DefaultSkins.TableRowBorder.createDynamicSkin();
        this.resizer = new Resizer<RowPanel>(this);
        this.mover = new Mover<RowPanel>(this);
        this.mouseDispatcher = this;
        if (!isInit) {
            isInit = true;
            this.lafAttributeChanged("All attribues changed");
        }
        if (withListener) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
    }

    public RowPanel() {
        this(true);
    }

    public boolean isHasPosition() {
        return this.hasPosition;
    }

    public void setHasPosition(boolean hasPosition) {
        this.hasPosition = hasPosition;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean isInMovement() {
        return this.inMovement;
    }

    public void setInMovement(boolean inMovement) {
        this.inMovement = inMovement;
    }

    protected void configureSmartButtons() {
        if (this.model.isAddRow()) {
            return;
        }
        ArrayList<SubModuleTypeE> ignoreTypes = new ArrayList<SubModuleTypeE>();
        ignoreTypes.add(SubModuleTypeE.ANALYSIS_EXPORT);
        ignoreTypes.add(SubModuleTypeE.ANALYSIS_EXPORT_SIMPLE);
        ignoreTypes.add(SubModuleTypeE.ANALYSIS_ACTION);
        ignoreTypes.add(SubModuleTypeE.ANALYSIS_INFO);
        ignoreTypes.add(SubModuleTypeE.ANALYSIS_PRINT);
        List<SubModuleAccessRightComplete> smartScreens = this.screenLoader.fillUpSmartAccessRights(ignoreTypes);
        if (smartScreens.size() > 0) {
            if (this.smartButton1 != null) {
                this.smartButton1.kill();
            }
            if (this.smartButton2 != null) {
                this.smartButton2.kill();
            }
            if (smartScreens.size() == 1) {
                this.smartScreenType = 2;
                this.smartButton1 = new SingleSmartScreenButton(HUDToolkit.getSmartScreenButtonIconClassForInvokerName(smartScreens.get(0).getModule().getInvokingName()), smartScreens.get(0).getModule().getDisplayName());
                this.smartButton1.setUserObject(smartScreens.get(0));
                this.smartButton1.setMouseActiv(false);
                this.smartButton1.delegateMouseEvents(this, this, 255);
                this.smartButton1.addButtonListener(this);
                this.add(this.smartButton1);
            } else {
                SubModuleAccessRightComplete psm = this.screenLoader.getPreferredSmartAccessRight(ignoreTypes);
                String titleName = smartScreens.get(0).getModule().getDisplayName();
                String preferredSubModuleInvoker = smartScreens.get(0).getModule().getInvokingName();
                if (psm != null) {
                    titleName = psm.getModule().getDisplayName();
                    preferredSubModuleInvoker = psm.getModule().getInvokingName();
                }
                if (preferredSubModuleInvoker == null) {
                    // empty if block
                }
                this.smartScreenType = 3;
                this.smartButton1 = new DoubleSmartScreenButton(HUDToolkit.getSmartScreenButtonIconClassForInvokerName(preferredSubModuleInvoker), titleName);
                this.smartButton1.addButtonListener(this);
                this.smartButton1.setMouseActiv(false);
                this.smartButton1.setUserObject(psm != null ? psm : smartScreens.get(0));
                this.smartButton1.delegateMouseEvents(this, this, 255);
                this.smartButton2 = new SmartScreenPopupButton();
                this.smartButton2.addButtonListener(this);
                this.smartButton2.setMouseActiv(false);
                this.smartButton2.setToolTipText(Words.EXPAND_OPTIONS);
                this.smartButton2.delegateMouseEvents(this, this, 255);
                this.add(this.smartButton1);
                this.add(this.smartButton2);
            }
        } else {
            this.smartScreenType = -1;
            if (this.smartButton1 != null) {
                this.smartButton1.kill();
            }
            if (this.smartButton2 != null) {
                this.smartButton2.kill();
            }
        }
        this.currentSmartScreens = smartScreens;
    }

    public RowModel<T> getModel() {
        return this.model;
    }

    public void setGradientColors(Color start, Color end) {
        header_gradient_start = start;
        header_gradient_end = end;
    }

    public void setHasDeleteButton(boolean hasDeleteButton) {
        if (!this.model.isHeader() && !this.model.isAddRow()) {
            if (this.hasDeleteButton != hasDeleteButton) {
                if (hasDeleteButton) {
                    this.deleteButton = new DeleteButton(SizedSkin1Field.SkinSize.MEDIUM);
                    this.deleteButton.addEnableValidator(this.model.getDeleteButtonValidator());
                    this.deleteButton.setUserObject(this.model.getNode());
                    this.deleteButton.setMouseActiv(false);
                    this.deleteButton.delegateMouseEvents(this, this, 255);
                    this.deleteButton.setProgress(1.0f);
                    this.deleteButton.addButtonListener(this);
                    this.isRemoteValidated = false;
                    this.add(this.deleteButton);
                    this.deleteButton.validateEnableState(new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            RowPanel.this.isRemoteValidated = (Boolean)node.getValue();
                            RowPanel.this.setEnabled(RowPanel.this.isEnabled());
                            RowPanel.this.validate();
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)RowPanel.this);
                        }
                    });
                    this.setEnabled(this.isEnabled());
                } else if (this.deleteButton != null) {
                    this.deleteButton.kill();
                    this.deleteButton = null;
                    this.validate();
                }
            }
            this.hasDeleteButton = hasDeleteButton;
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        if (currentOverPanel == this) {
            currentOverPanel = null;
        }
        this.removeFocusListener(this);
        for (CellPanel c : this.cells) {
            c.getModel().kill();
        }
        this.cells.clear();
        this.cells = null;
        this.model.kill();
        this.model = null;
        this.skin = null;
        this.frameSkin = null;
        if (this.rowContentPanel != null) {
            this.rowContentPanel.kill();
            this.rowContentPanel = null;
        }
        if (this.deleteButton != null) {
            this.deleteButton.kill();
            this.deleteButton = null;
        }
        if (this.scroller != null) {
            this.scroller.kill();
            this.scroller = null;
        }
        if (this.resizer != null) {
            this.resizer.kill();
            this.resizer = null;
        }
        if (this.smartButton1 != null) {
            this.smartButton1.kill();
            this.smartButton1 = null;
        }
        if (this.smartButton2 != null) {
            this.smartButton2.kill();
            this.smartButton2 = null;
        }
    }

    public ArrayList<CellPanel> getCellPanels() {
        return this.cells;
    }

    public void setDraggable(boolean isDraggable) {
        this.isDraggable = isDraggable;
    }

    protected void reSizePanel(int endWidth, int endHeight) {
        if (!this.resizer.isAnimating()) {
            this.resizer.setExcutable(new Runnable(){

                @Override
                public void run() {
                    RowPanel.this.calculatedHeight = RowPanel.this.getHeight();
                    if (RowPanel.this.model != null) {
                        RowPanel.this.model.callBackRelayout();
                    }
                }
            });
            this.resizer.setSizeSmooth(endWidth, endHeight);
        } else if (this.resizer.getEndHeight() != endHeight) {
            this.resizer.setEndHeight(endHeight);
        }
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setModel(RowModel<T> m) {
        this.model = m;
        if (!this.model.isAddRow() && !this.model.isHeader() && this.currentMode == MODE_EXPAND && this.model.isExpandable()) {
            this.expandIcon = new ExpandIcon(SizedSkin1Field.SkinSize.BIG);
            this.expandIcon.setExpanded(false);
            this.expandIcon.setMouseActiv(false);
            this.expandIcon.delegateMouseEvents(this, this, 255);
            this.expandIcon.addButtonListener(this);
            this.add(this.expandIcon);
        }
        this.refreshCalculatedHeight();
        if (this.model.getParentModel().getTable().isReady()) {
            this.configureSmartButtons();
        }
    }

    protected void refreshCalculatedHeight() {
        this.calculatedHeight = this.model.getColapsedRowHeight(this);
    }

    public List<Object> getColumnValues() {
        ArrayList<Object> l = new ArrayList<Object>();
        for (CellPanel p : this.cells) {
            l.add(p.getStringValue());
        }
        return l;
    }

    protected int getPreferredHeight() {
        return this.getModel().getRowHeight();
    }

    protected long getUnDoId() {
        return this.rowContentPanel.getUnDoId();
    }

    protected RowContentPanel getRowContentPanel() {
        return this.rowContentPanel;
    }

    @Override
    public Dimension getPreferredSize() {
        return ((RowPanelLayout)this.getLayout()).preferredLayoutSize(this);
    }

    public void setDisabledPermanent(boolean b) {
        this.isDisabledPermanent = false;
        this.setDisabled(b);
        this.isDisabledPermanent = b;
    }

    public void setDisabled(boolean b) {
        if (!this.isDisabledPermanent) {
            this.isDisabled = b;
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(!b && this.deleteButton.areValidatorsReady() && this.isRemoteValidated);
            }
            if (this.expandIcon != null) {
                this.expandIcon.setEnabled(!b);
            }
            if (this.smartButton1 != null) {
                this.smartButton1.setEnabled(!b && !this.isExpanded);
            }
            if (this.smartButton2 != null) {
                this.smartButton2.setEnabled(!b && !this.isExpanded);
            }
            if (this.cells != null) {
                for (CellPanel p : this.cells) {
                    p.willExpand(b);
                }
                this.repaint(32L);
            }
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (!this.isExpanded) {
            this.setDisabled(!isEnabled);
        }
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public int getCalculatedHeight() {
        if (!this.isAnimating && !this.isExpanded) {
            return this.model.getColapsedRowHeight(this);
        }
        return this.calculatedHeight;
    }

    public void addCell(int dx, CellPanel cell) {
        this.cells.add(dx, cell);
        this.add(cell);
        this.layoutCells(this.getWidth(), this.getHeight());
        cell.setVisible(true);
    }

    public boolean isAnimating() {
        return this.isAnimating;
    }

    protected void changeState(Button.ButtonState newState) {
        if (this.isDisabled) {
            this.state = Button.ButtonState.DISABLED;
            return;
        }
        if (!this.isExpanded && this.state == Button.ButtonState.STATE_SELECTED && this.hasFocus()) {
            return;
        }
        this.state = newState;
        if (this.state == Button.ButtonState.UP && this.expandIcon != null) {
            this.expandIcon.setState(Button.ButtonState.UP);
        }
        this.repaint(32L);
    }

    public boolean isExpandable() {
        return true;
    }

    public void expand() {
        if (this.isExpandable() && !this.model.isHeader()) {
            if (AnimationProvider.isAnimationActiv) {
                this.isGrowing = true;
                if (!this.isAnimating) {
                    this.panelRequestExpanding();
                    this.model.getParentModel().getAnimationTimer(this);
                    this.doScrollIfNeeded();
                } else {
                    this.animationTimeOffset = this.model.getParentModel().getAnimationTime() - this.lastTimeDiff;
                }
                this.animationStartTime = System.currentTimeMillis();
                this.isAnimating = true;
            } else {
                this.isGrowing = true;
                if (!this.isAnimating) {
                    this.panelRequestExpanding();
                    this.doScrollIfNeeded();
                } else {
                    this.animationTimeOffset = this.model.getParentModel().getAnimationTime() - this.lastTimeDiff;
                }
                this.rowContentPanel.grapDefaultFocus();
                this.actionPerformed(null);
            }
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(false);
            }
        }
    }

    protected void delegateNodeReset(Node node) {
    }

    private void doScrollIfNeeded() {
        int viewH;
        Table<T, ?> table;
        int viewY;
        int rowHeight;
        int rowY = this.getY();
        if (rowY + (rowHeight = this.model.getExpandedRowHeight()) - (viewY = (table = this.model.getParentModel().getTable()).getViewPortY()) > (viewH = table.getViewPortHeight())) {
            this.scroller = new Scroller<RowPanel, JScrollBar>(this, table.getScrollBar(1));
            this.scroller.scrollTo(viewY, this.getY());
        }
    }

    public void colapse() {
        if (this.isExpandable() && !this.model.isHeader()) {
            if (this.expandIcon != null) {
                this.expandIcon.setExpanded(false);
            }
            if (this.rowContentPanel != null) {
                this.rowContentPanel.setEnabled(false);
            }
            this.isGrowing = false;
            if (!this.isAnimating) {
                this.model.getParentModel().getAnimationTimer(this);
                this.doScrollIfNeeded();
            } else {
                this.animationTimeOffset = this.model.getParentModel().getAnimationTime() - this.lastTimeDiff;
            }
            this.animationStartTime = System.currentTimeMillis();
            this.isAnimating = true;
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape backClip = null;
        int xTrans = 0;
        int cWidth = 0;
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        g2.setColor(this.getBackground());
        if (this.model.isHeader()) {
            this.translateOffset = xTrans = this.model.getParentModel().getHorizontalScrollOffSet();
            cWidth = this.model.getParentModel().getTable().getViewableWidth(true);
            cWidth = this.getWidth();
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, header_gradient_start, 0.0f, this.getHeight(), header_gradient_end, true);
            g2.setPaint(gradient);
            g2.translate(-xTrans, 0);
            Rectangle nClip = new Rectangle(xTrans, 0, cWidth, this.getHeight());
            backClip = g2.getClip();
            g2.clip(nClip);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (!this.model.isHeader() && !this.isHidden) {
            this.skin.paint((Graphics)g2, this.getWidth(), this.model.getColapsedRowHeight(this), this.state, false, this.isSelected, this.isAnimating, this.isExpanded, this.hasFocus());
        }
        if (!this.isSelected) {
            switch (this.state) {
                case STATE_SELECTED: {
                    g2.setColor(lineColor_selected);
                    break;
                }
                case UP: {
                    g2.setColor(lineColor_up);
                    break;
                }
                case OVER: {
                    g2.setColor(lineColor_over);
                    break;
                }
                case DOWN: {
                    g2.setColor(lineColor_down);
                    break;
                }
                case HORIZONTAL: 
                case LEFT: 
                case RIGHT: 
                case STATE_COLAPSED_OVER: 
                case STATE_COLAPSED_UP: 
                case DISABLED: 
                case ERROR: 
                case STATE_EXPANDED: 
                case FOCUS: 
                case STATE_FOCUS_LEFT: 
                case STATE_FOCUS_RIGHT: 
                case STATE_NOTSELECTED: 
                case STATE_WARRNING: 
                case VERTICAL: {
                    DebugToolkit.unsupportedStateException(this.getClass(), "unknown", (Object)this.state, "paint");
                }
            }
        } else {
            g2.setColor(lineColor_selected);
        }
        int currentX = 0;
        if (this.model.isHeader()) {
            currentX += this.model.getParentModel().getTable().getHorizontalRowBorder() + 2;
        }
        int startY = 0;
        int endY = this.getHeight() - 1;
        if (!this.model.isHeader()) {
            startY = 1;
            endY = this.model.getColapsedRowHeight(this) - 2;
        }
        for (int i = 0; i < this.model.getParentModel().getColumnCount() - 1; ++i) {
            currentX += this.model.getParentModel().getColumnWidth(i);
            if (this.isHidden || this.model.isHeader()) {
                g2.drawLine(currentX - 2, startY, currentX - 2, endY);
                if (i != this.sortedRow) continue;
                int ah = this.sortSkin.getImage(Button.ButtonState.DOWN, true).getHeight();
                int aw = this.sortSkin.getImage(Button.ButtonState.DOWN, true).getWidth();
                this.sortSkin.paint(g2, currentX - (6 + aw), (this.getHeight() - ah) / 2, Button.ButtonState.UP, this.isAscendent);
                continue;
            }
            g2.drawLine(currentX, startY, currentX, endY);
        }
        if (this.sortedRow != -1 && this.sortedRow >= this.model.getParentModel().getColumnCount() - 1) {
            int ah = this.sortSkin.getImage(Button.ButtonState.DOWN, true).getHeight();
            int aw = this.sortSkin.getImage(Button.ButtonState.DOWN, true).getWidth();
            this.sortSkin.paint(g2, (currentX += this.model.getParentModel().getColumnWidth(this.model.getParentModel().getColumnCount() - 1)) - (6 + aw), (this.getHeight() - ah) / 2, Button.ButtonState.UP, this.isAscendent);
        }
        this.paintChildren(g2);
        if (this.model.isHeader()) {
            g2.setClip(backClip);
            g2.translate(xTrans, 0);
        } else if (!this.isHidden) {
            this.paintFrame(g2);
        }
        this.paintDisableOverlay(g2);
    }

    protected void paintDisableOverlay(Graphics2D g2) {
        if (this.isDisabled || !this.isEnabled()) {
            g2.setColor(overlayColor);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void paintFrame(Graphics2D g2) {
        if (this.isExpanded || this.isAnimating) {
            int width = this.getWidth();
            int height = this.getHeight();
            if (!this.model.isAddRow()) {
                this.frameSkin.paint(g2, 0, 0, width, height, this.state);
            }
        }
    }

    @Override
    public void setVisible(boolean vis) {
        for (CellPanel aCell : this.cells) {
            aCell.setVisible(vis);
        }
        super.setVisible(vis);
    }

    private void layoutCells(int width, int height) {
        int currentX = 1;
        if (this.expandIcon != null) {
            currentX = (int)(1.0 + this.expandIcon.getPreferredSize().getWidth());
        }
        if (this.model.isHeader()) {
            currentX += this.model.getParentModel().getTable().getHorizontalRowBorder();
        }
        if (this.expandIcon != null) {
            this.expandIcon.setLocation(1, 1);
            this.expandIcon.setSize(this.expandIcon.getPreferredSize());
        }
        int currentWidth = 0;
        int aHBorder = 3;
        int count = 0;
        int endInset = 0;
        switch (this.smartScreenType) {
            case 2: {
                if (this.smartButton1 != null) {
                    endInset = (int)((double)endInset + this.smartButton1.getPreferredSize().getWidth());
                }
                endInset += 5;
                break;
            }
            case 3: {
                if (this.smartButton2 != null) {
                    endInset = (int)((double)endInset + (this.smartButton1.getPreferredSize().getWidth() + this.smartButton2.getPreferredSize().getWidth()));
                }
                endInset += 5;
            }
        }
        for (CellPanel aCell : this.cells) {
            int w;
            currentWidth = w = this.model.getParentModel().getColumnWidth(count);
            if (count == 0) {
                if (this.expandIcon != null && !this.model.isHeader()) {
                    currentWidth -= this.expandIcon.getX();
                    currentWidth -= this.expandIcon.getWidth();
                    currentX = this.expandIcon.getX() + this.expandIcon.getWidth();
                } else {
                    currentX = this.model.isHeader() ? 4 : 0;
                }
            }
            if (this.model.isHeader()) {
                if (count != 0) {
                    aCell.setLocation(currentX + aHBorder * 2, 1);
                } else {
                    aCell.setLocation(currentX, 1);
                }
            } else {
                aCell.setLocation(currentX + aHBorder, 1);
            }
            if (count == this.cells.size() - 1 && this.hasDeleteButton && !this.model.isHeader()) {
                int buttonspace = 5;
                currentWidth = (int)((double)currentWidth - ((double)buttonspace + this.deleteButton.getPreferredSize().getWidth()));
                this.deleteButton.setLocation(currentX + currentWidth, (int)(((double)this.model.getColapsedRowHeight(this) - this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                this.deleteButton.setSize(this.deleteButton.getPreferredSize());
            }
            aCell.setSize(currentWidth - 2 * aHBorder, aCell.getModel().getCellHeight());
            currentX += currentWidth;
            ++count;
        }
        switch (this.smartScreenType) {
            case 2: {
                if (this.smartButton1 == null) break;
                this.smartButton1.setLocation((int)((double)width - this.smartButton1.getPreferredSize().getWidth()) - 1, 1);
                this.smartButton1.setSize(this.smartButton1.getPreferredSize());
                break;
            }
            case 3: {
                if (this.smartButton2 == null) break;
                this.smartButton2.setLocation((int)((double)width - this.smartButton2.getPreferredSize().getWidth()) - 1, 1);
                this.smartButton2.setSize(this.smartButton2.getPreferredSize());
                if (this.smartButton1 == null) break;
                this.smartButton1.setLocation((int)((double)this.smartButton2.getX() - this.smartButton1.getPreferredSize().getWidth()), 1);
                this.smartButton1.setSize(this.smartButton1.getPreferredSize());
            }
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
    }

    public void requestExpand(boolean expand) {
        this.model.expandRow(expand);
    }

    public void setIsHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    protected boolean shouldProcessMouseEvent(MouseEvent e) {
        if (e.isConsumed()) {
            return false;
        }
        return !this.isKilled();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isDisabled) {
            return;
        }
        this.isOver = true;
        if (!this.shouldProcessMouseEvent(e)) {
            return;
        }
        if (currentOverPanel != null && currentOverPanel != this) {
            currentOverPanel.mouseExited(e);
        }
        currentOverPanel = this;
        if (this.model.getParentModel().getTable().isEnabled()) {
            if (Button.pressedItem == null) {
                this.changeState(Button.ButtonState.OVER);
            } else if (Button.pressedItem == this) {
                this.changeState(Button.ButtonState.DOWN);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isDisabled) {
            return;
        }
        this.isOver = false;
        if (!this.shouldProcessMouseEvent(e)) {
            return;
        }
        if (currentOverPanel != null && currentOverPanel == this) {
            currentOverPanel = null;
        }
        if (e != null && this.model != null && this.model.getParentModel().getTable() != null && this.model.getParentModel().getTable().isEnabled()) {
            this.changeState(Button.ButtonState.UP);
        }
        if (this.pressedType == 2 && this.expandIcon != null) {
            this.expandIcon.setState(Button.ButtonState.UP);
        } else if (this.pressedType == 1 && this.deleteButton != null) {
            this.deleteButton.setState(Button.ButtonState.UP);
        }
        if (this.smartButton1 != null) {
            this.smartButton1.setState(Button.ButtonState.UP);
        }
        if (this.smartButton2 != null) {
            this.smartButton2.setState(Button.ButtonState.UP);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isDisabled || !this.shouldProcessMouseEvent(e)) {
            return;
        }
        if (this.model.getParentModel().getTable().isEnabled()) {
            if (!this.model.isAddRow() && !this.model.isHeader()) {
                this.requestFocusInWindow();
            }
            if (this.draggedColumnIndex != -1) {
                this.draggBackupPoint = new Point(e.getX(), e.getY());
            }
            Button.pressedItem = this;
            this.changeState(Button.ButtonState.DOWN);
            if (this.deleteButton != null && e.getX() > this.deleteButton.getX() && e.getX() < this.deleteButton.getX() + this.deleteButton.getWidth() && e.getY() > this.deleteButton.getY() && e.getY() < this.deleteButton.getY() + this.deleteButton.getHeight()) {
                this.pressedType = 1;
            } else if (this.expandIcon != null && e.getX() < this.expandIcon.getWidth() && e.getY() < this.expandIcon.getHeight()) {
                this.pressedType = 2;
            }
        }
    }

    public void setTableSortAttribute(Enum<?> e, boolean isAsc) {
        int columnNr = this.model.getParentModel().getColumnIndex4Enum(e);
        if (columnNr != -1) {
            TableColumnInfo columnInfo = this.model.getParentModel().getColumnInfo(columnNr);
            Enum<?> com = columnInfo.getColumnAttribute();
            if (com == null) {
                return;
            }
            this.isAscendent = isAsc;
            columnInfo.setReversedSorting(this.isAscendent);
            this.model.getParentModel().getTable().sortTable(com, this.isAscendent);
        }
        if (this.sortedRow != columnNr) {
            this.sortedRow = columnNr;
        }
        this.repaint(32L);
    }

    public int getSortedRow() {
        return this.sortedRow;
    }

    private void ensureTableSort(int x) {
        int columnNr = this.model.getParentModel().getColumnIndex4X(x);
        if (columnNr != -1) {
            TableColumnInfo columnInfo = this.model.getParentModel().getColumnInfo(columnNr);
            Enum<?> com = columnInfo.getColumnAttribute();
            if (com == null) {
                return;
            }
            this.isAscendent = !columnInfo.isReversedSorting();
            columnInfo.setReversedSorting(this.isAscendent);
            this.model.getParentModel().getTable().sortTable(com, this.isAscendent);
        }
        if (this.sortedRow != columnNr) {
            this.sortedRow = columnNr;
        }
        this.repaint(32L);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isDisabled || !this.shouldProcessMouseEvent(e)) {
            return;
        }
        if (!this.isDragging) {
            if (this.model.isHeader() && !this.model.getParentModel().isARowExpanded()) {
                this.ensureTableSort(e.getX());
            }
            boolean isContaining = this.contains(e.getX(), e.getY());
            if (this.getModel().isAddRow()) {
                boolean bl = isContaining = this.model.getParentModel().getTable().getAddRow() != null && this.model.getParentModel().getTable().getAddRow().contains(e.getX(), e.getY());
            }
            if (isContaining) {
                if (!this.shouldProcessMouseEvent(e)) {
                    return;
                }
                if (!this.model.isHeader()) {
                    if (this.currentMode == MODE_CLICK || this.model.isAddRow()) {
                        if (this.isExpanded) {
                            if (this.isAnimating) {
                                if (this.isGrowing) {
                                    this.requestExpand(false);
                                } else {
                                    this.requestExpand(true);
                                }
                            } else {
                                this.requestExpand(false);
                            }
                        } else if (this.isSelected || this.model.isAddRow()) {
                            if (!this.isSelected) {
                                this.model.getParentModel().setSelectedModel(this.model, false);
                            }
                            if (this.isAnimating) {
                                if (this.isGrowing) {
                                    this.requestExpand(false);
                                } else {
                                    this.requestExpand(true);
                                }
                            } else {
                                this.requestExpand(true);
                            }
                        } else {
                            this.model.getParentModel().setSelectedModel(this.model, false);
                        }
                    } else if (this.currentMode == MODE_EXPAND) {
                        Boolean isExpand = null;
                        boolean isDelete = false;
                        boolean isSmartOne = false;
                        boolean isSmartTwo = false;
                        if (this.deleteButton != null && this.pressedType == 1 && e.getX() > this.deleteButton.getX() && e.getX() < this.deleteButton.getX() + this.deleteButton.getWidth() && e.getY() > this.deleteButton.getY() && e.getY() < this.deleteButton.getY() + this.deleteButton.getHeight()) {
                            isDelete = true;
                        }
                        if (this.smartButton1 != null && e.getX() > this.smartButton1.getX() && e.getX() < this.smartButton1.getX() + this.smartButton1.getWidth() && e.getY() > this.smartButton1.getY() && e.getY() < this.smartButton1.getY() + this.smartButton1.getHeight()) {
                            isSmartOne = true;
                        }
                        if (this.smartButton2 != null && e.getX() > this.smartButton2.getX() && e.getX() < this.smartButton2.getX() + this.smartButton2.getWidth() && e.getY() > this.smartButton2.getY() && e.getY() < this.smartButton2.getY() + this.smartButton2.getHeight()) {
                            isSmartTwo = true;
                        }
                        if (!isDelete) {
                            if (this.isSelected) {
                                if (this.expandIcon != null && this.pressedType == 2) {
                                    if (e.getX() < this.expandIcon.getWidth() && e.getY() < this.expandIcon.getHeight()) {
                                        isExpand = !this.isExpanded;
                                    } else {
                                        this.model.getParentModel().setSelectedModel(null, false);
                                    }
                                }
                            } else {
                                this.model.getParentModel().setSelectedModel(this.model, false);
                                if (this.expandIcon != null && this.pressedType == 2 && e.getX() < this.expandIcon.getWidth() && e.getY() < this.expandIcon.getHeight()) {
                                    isExpand = !this.isExpanded;
                                }
                            }
                            if (isExpand != null && isExpand.booleanValue() && !this.isExpanded()) {
                                this.expandIcon.buttonPressed(this.expandIcon, e.getX(), e.getY());
                                if (this.expandIcon.isExpanded()) {
                                    this.requestExpand(true);
                                }
                            } else if (isExpand != null && !isExpand.booleanValue() && this.isExpanded() && !this.expandIcon.isExpanded()) {
                                this.rowContentPanel.getRowEditor().buttonPressed(this.rowContentPanel.getRowEditor().getAddButton(), 0, 0);
                            }
                        } else {
                            this.buttonPressed(this.deleteButton, e.getX(), e.getY());
                        }
                        if (isSmartOne) {
                            this.buttonPressed(this.smartButton1, e.getX() - this.smartButton1.getX(), e.getY());
                        } else if (isSmartTwo) {
                            this.buttonPressed(this.smartButton2, e.getX() - this.smartButton2.getX(), e.getY());
                        }
                    }
                } else if (this.draggedColumnIndex != -1) {
                    this.draggBackupPoint = new Point(e.getX(), e.getY());
                }
            }
            Button.pressedItem = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.shouldProcessMouseEvent(e)) {
            return;
        }
        if (this.draggedColumnIndex != -1 && this.model.getParentModel().getTable().isEnabled() && this.isDraggable) {
            this.isDragging = true;
            int dx = (int)(this.draggBackupPoint.getX() - (double)e.getX());
            int newSize = (int)(this.draggBackupPoint.getX() - (double)dx);
            this.model.getParentModel().ensureColumnWidths(this.draggedColumnIndex, newSize -= this.cumulatedWidth, false, false);
        } else if (!(this.model.isHeader() || this.model.isAddRow() || this.isDisabled || this.isExpanded)) {
            if (this.pressedType == 2 && e.getX() < this.expandIcon.getWidth() && e.getY() < this.expandIcon.getHeight()) {
                if (this.expandIcon.getState() != Button.ButtonState.OVER) {
                    this.expandIcon.setState(Button.ButtonState.OVER);
                }
                if (this.deleteButton != null && this.deleteButton.getState() != Button.ButtonState.UP) {
                    this.deleteButton.setState(Button.ButtonState.UP);
                }
            } else if (this.pressedType == 1 && this.deleteButton != null && e.getX() > this.deleteButton.getX() && e.getX() < this.deleteButton.getWidth() + this.deleteButton.getX() && e.getY() > this.deleteButton.getY() && e.getY() < this.deleteButton.getY() + this.deleteButton.getHeight()) {
                if (this.deleteButton.getState() != Button.ButtonState.OVER) {
                    this.deleteButton.setState(Button.ButtonState.OVER);
                }
                if (this.expandIcon.getState() != Button.ButtonState.UP) {
                    this.expandIcon.setState(Button.ButtonState.UP);
                }
            } else {
                if (this.expandIcon != null && this.expandIcon.getState() != Button.ButtonState.UP) {
                    this.expandIcon.setState(Button.ButtonState.UP);
                }
                if (this.deleteButton != null) {
                    this.deleteButton.setState(Button.ButtonState.UP);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.shouldProcessMouseEvent(e)) {
            return;
        }
        if (this.isDraggable && this.model.isHeader() && this.model.getParentModel().getTable().isEnabled()) {
            if (e.getY() > 0 && e.getY() < this.getHeight()) {
                int currentX = -this.translateOffset;
                for (int i = 0; i < this.model.getParentModel().getColumnCount(); ++i) {
                    if (e.getX() >= currentX + this.model.getParentModel().getColumnWidth(i) - 1 && e.getX() <= currentX + this.model.getParentModel().getColumnWidth(i) + 1) {
                        this.setCursor(new Cursor(10));
                        this.draggedColumnIndex = i;
                        this.cumulatedWidth = currentX;
                        return;
                    }
                    currentX += this.model.getParentModel().getColumnWidth(i);
                }
            }
            this.draggedColumnIndex = -1;
            this.setCursor(new Cursor(0));
        }
        if (!(this.model.isHeader() || this.model.isAddRow() || this.isDisabled || this.isExpanded)) {
            if (this.expandIcon != null && e.getX() < this.expandIcon.getWidth() && e.getY() < this.expandIcon.getHeight()) {
                if (this.expandIcon.getState() != Button.ButtonState.OVER) {
                    this.expandIcon.setState(Button.ButtonState.OVER);
                }
                this.setStateUPTo(385);
            } else if (this.deleteButton != null && e.getX() > this.deleteButton.getX() && e.getX() < this.deleteButton.getWidth() + this.deleteButton.getX() && e.getY() > this.deleteButton.getY() && e.getY() < this.deleteButton.getY() + this.deleteButton.getHeight()) {
                if (this.deleteButton.getState() != Button.ButtonState.OVER) {
                    this.deleteButton.setState(Button.ButtonState.OVER);
                    this.setStateUPTo(105);
                }
            } else if (this.smartButton1 != null && e.getX() > this.smartButton1.getX() && e.getX() < this.smartButton1.getWidth() + this.smartButton1.getX() && e.getY() > this.smartButton1.getY() && e.getY() < this.smartButton1.getY() + this.smartButton1.getHeight()) {
                if (this.smartButton1.getState() != Button.ButtonState.OVER) {
                    this.smartButton1.setState(Button.ButtonState.OVER);
                    this.setStateUPTo(231);
                }
            } else if (this.smartButton2 != null && e.getX() > this.smartButton2.getX() && e.getX() < this.smartButton2.getWidth() + this.smartButton2.getX() && e.getY() > this.smartButton2.getY() && e.getY() < this.smartButton2.getY() + this.smartButton2.getHeight()) {
                if (this.smartButton2.getState() != Button.ButtonState.OVER) {
                    this.smartButton2.setState(Button.ButtonState.OVER);
                    this.setStateUPTo(165);
                }
            } else {
                this.setStateUPTo(1155);
            }
        }
    }

    private void setStateUPTo(int buttCode) {
        if (buttCode % 3 == 0 && this.expandIcon != null) {
            this.expandIcon.setState(Button.ButtonState.UP);
        }
        if (buttCode % 5 == 0 && this.smartButton1 != null && this.smartButton1.getState() != Button.ButtonState.UP) {
            this.smartButton1.setState(Button.ButtonState.UP);
        }
        if (buttCode % 7 == 0 && this.smartButton2 != null && this.smartButton2.getState() != Button.ButtonState.UP) {
            this.smartButton2.setState(Button.ButtonState.UP);
        }
        if (buttCode % 11 == 0 && this.deleteButton != null && this.deleteButton.getState() != Button.ButtonState.UP) {
            this.deleteButton.setState(Button.ButtonState.UP);
        }
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.validate();
    }

    protected boolean reCalculateHeight() {
        int newCalculatedHeight = this.model.getExpandedRowHeight();
        if (newCalculatedHeight != this.calculatedHeight && !this.isAnimating) {
            this.calculatedHeight = newCalculatedHeight;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.model == null || this.model.getParentModel() == null) {
            return;
        }
        long now = System.currentTimeMillis();
        long diff = now - this.animationStartTime;
        this.lastTimeDiff = diff + this.animationTimeOffset;
        double prog = 1.1;
        if (this.model != null && this.model.getParentModel() != null) {
            prog = (double)(diff + this.animationTimeOffset) / (double)this.model.getParentModel().getAnimationTime();
        }
        if (this.isGrowing) {
            if (prog > 1.0 || !AnimationProvider.isAnimationActiv) {
                this.animationStartTime = 0L;
                this.animationTimeOffset = 0L;
                this.lastTimeDiff = 0L;
                this.model.getParentModel().tryToStopAnimationTimer(this);
                this.isAnimating = false;
                this.isGrowing = false;
                this.isExpanded = true;
                this.calculatedHeight = this.model.getExpandedRowHeight();
                if (this.rowContentPanel != null && this.rowContentPanel.getRowEditor() != null) {
                    this.rowContentPanel.getRowEditor().expandAnimationDone();
                }
                this.setDisabled(false);
                if (this.smartButton1 != null) {
                    this.smartButton1.setDisabled(true);
                    this.smartButton1.setEnabled(false);
                }
                if (this.smartButton2 != null) {
                    this.smartButton2.setDisabled(true);
                    this.smartButton2.setEnabled(false);
                }
            } else {
                int newHeight;
                double np = Math.sin(1.5707963267948966 * prog);
                int hD = this.model.getExpandedRowHeight() - this.model.getColapsedRowHeight(this);
                this.calculatedHeight = newHeight = (int)((double)this.model.getColapsedRowHeight(this) + (double)hD * np);
            }
        } else if (prog > 1.0 || !AnimationProvider.isAnimationActiv) {
            this.animationStartTime = 0L;
            this.animationTimeOffset = 0L;
            this.lastTimeDiff = 0L;
            this.model.getParentModel().tryToStopAnimationTimer(this);
            this.isAnimating = false;
            this.isGrowing = false;
            this.isExpanded = false;
            this.calculatedHeight = this.model.getColapsedRowHeight(this);
            this.panelColapsed();
        } else {
            int newHeight;
            double np = Math.sin(1.5707963267948966 * prog);
            int hD = this.model.getExpandedRowHeight() - this.model.getColapsedRowHeight(this);
            this.calculatedHeight = newHeight = (int)((double)this.model.getExpandedRowHeight() - (double)hD * np);
        }
        this.model.callBackRelayout();
    }

    private void panelRequestExpanding() {
        if (this.rowContentPanel != null) {
            this.rowContentPanel.kill();
        }
        this.rowContentPanel = new RowContentPanel(this.model.getRowEditorFactory().getRowEditor(this.model));
        this.rowContentPanel.setVisible(true);
        this.add(this.rowContentPanel);
    }

    protected void resetHolePanel() {
        this.panelRequestExpanding();
    }

    protected void panelColapsed() {
        for (CellPanel p : this.cells) {
            p.willExpand(false);
        }
        if (this.smartButton1 != null) {
            this.smartButton1.setDisabled(false);
        }
        if (this.smartButton2 != null) {
            this.smartButton2.setDisabled(false);
        }
        if (this.isOver) {
            this.changeState(Button.ButtonState.OVER);
        } else {
            this.changeState(Button.ButtonState.UP);
        }
        if (this.rowContentPanel != null) {
            this.rowContentPanel.kill();
            this.rowContentPanel = null;
        }
        if (this.deleteButton != null) {
            this.deleteButton.removeButtonListener(this);
            this.deleteButton.addButtonListener(this);
        }
        this.requestFocusInWindow();
        this.model.getParentModel().panelColapsed(this);
    }

    public void select(boolean b) {
        if (b != this.isSelected) {
            this.isSelected = b;
            if (this.isOver) {
                this.changeState(Button.ButtonState.OVER);
            } else {
                this.changeState(Button.ButtonState.UP);
            }
            this.requestFocusInWindow();
            this.repaint(32L);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.deleteButton) {
            if (this.isExpanded) {
                this.requestExpand(false);
            } else {
                InnerPopupFactory.showDesicionPopup("Delete?", "<b>Are you sure to delete this Entry?</b><br/><br/>This Operation can not be undone.", source, new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        if (xargs == null) {
                            return;
                        }
                        RowPanel.this.model.getNode().getParent().removeChild(RowPanel.this.model.getNode(), System.currentTimeMillis());
                    }
                }, -1, -1, PopupType.NORMAL);
            }
        } else if (source == this.expandIcon) {
            if (this.model.isExpandable()) {
                if (this.expandIcon.isExpanded()) {
                    this.doExpand();
                    if (this.smartButton1 != null) {
                        this.smartButton1.setEnabled(false);
                    }
                    if (this.smartButton2 != null) {
                        this.smartButton2.setEnabled(false);
                    }
                } else {
                    this.model.cancelRow();
                    this.expandIcon.setEnabled(true);
                    if (this.smartButton1 != null) {
                        this.smartButton1.setEnabled(true);
                    }
                    if (this.smartButton2 != null) {
                        this.smartButton2.setEnabled(true);
                    }
                }
            }
        } else if (source == this.smartButton2) {
            if (this.isExpanded) {
                return;
            }
            if (this.model.getNode() != null && this.model.getNode().getListenerCount() == 0) {
                this.model.getNode().addNodeListener(this.model);
            }
            this.model.getParentModel().setSelectedModel(this.model, true);
            this.isOver = false;
            this.showSmartPopup(x, y);
        } else if (source == this.smartButton1) {
            if (this.isExpanded) {
                return;
            }
            if (this.model.getNode().getListenerCount() == 0) {
                this.model.getNode().addNodeListener(this.model);
            }
            this.model.getParentModel().setSelectedModel(this.model, true);
            this.isOver = false;
            this.screenLoader.loadScreen(((SubModuleAccessRightComplete)this.smartButton1.getUserObject()).getModule(), x, y, this);
        }
    }

    private void showSmartPopup(int x, int y) {
        if (this.currentSmartScreens != null) {
            this.popUp = InnerPopUp2.getInnerPopUp();
            this.popUp.setAttributes(this.smartButton2, false, false, "");
            ConnectionToOutside t = this.getModel().getParentModel().getTable().getOutSideConnection();
            if (t != null && this.popUp != null && this.smartButton2 != null) {
                this.popUp.setView(new TableRowSmartScreenAccessPopupInsert<T>(this.currentSmartScreens, t.getMainFrame(), this.screenLoader, null));
                this.popUp.showPopUp(0, this.smartButton2.getHeight(), 200, -1, null, this.smartButton2, PopupType.SMARTACCES);
            }
        }
    }

    private void doExpand() {
        if (!this.model.isExpandable()) {
            return;
        }
        if (this.deleteButton != null) {
            this.deleteButton.removeButtonListener(this);
        }
        for (CellPanel p : this.cells) {
            p.willExpand(true);
        }
        if (this.isExpanded) {
            if (this.isAnimating) {
                if (this.isGrowing) {
                    this.requestExpand(false);
                } else {
                    this.requestExpand(true);
                }
            } else {
                this.requestExpand(false);
            }
        } else if (!this.model.isHeader()) {
            if (this.isAnimating) {
                if (this.isGrowing) {
                    this.requestExpand(false);
                } else {
                    this.requestExpand(true);
                }
            } else {
                this.requestExpand(true);
            }
        }
    }

    @Override
    public Component getTopParent() {
        return this.model.getParentModel().getTable();
    }

    @Override
    public int isSelected() {
        return 0;
    }

    @Override
    public void setSelected(int level) {
    }

    public Object getInnerSelectedDTO() {
        if (this.rowContentPanel != null) {
            return this.rowContentPanel.getInnerSelectedDTO();
        }
        return null;
    }

    @Override
    public void loadImages() {
        if (lineColor_up == null) {
            this.setGradientColors(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_header_background_gradient_color_start")), AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_header_background_gradient_color_end")));
            lineColor_up = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_column_line_color_up"));
            lineColor_over = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_column_line_color_over"));
            lineColor_down = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_column_line_color_down"));
            lineColor_selected = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_column_line_color_selected"));
            overlayColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_row_disabled_overlay_color"));
        }
    }

    @Override
    public boolean stillAlive() {
        return this.model != null;
    }

    public void disableSmartButtons(boolean isDisabled2) {
        if (this.smartButton1 != null) {
            this.smartButton1.setEnabled(!isDisabled2);
        }
        if (this.smartButton2 != null) {
            this.smartButton2.setEnabled(!isDisabled2);
        }
    }

    public void toggleExpandButton(boolean b) {
        if (b) {
            if (this.expandIcon != null) {
                this.expandIcon.setExpanded(true);
            }
            if (this.smartButton1 != null) {
                this.smartButton1.setEnabled(false);
            }
            if (this.smartButton2 != null) {
                this.smartButton2.setEnabled(false);
            }
        } else {
            if (this.expandIcon != null) {
                this.expandIcon.setExpanded(false);
            }
            if (this.smartButton1 != null) {
                this.smartButton1.setEnabled(true);
            }
            if (this.smartButton2 != null) {
                this.smartButton2.setEnabled(true);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint(32L);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint(32L);
    }

    public void refreshCells() {
        for (CellPanel cell : this.cells) {
            cell.setState(cell.getState(), true);
        }
    }

    @Override
    public void clearImages() {
        lineColor_up = null;
        this.loadImages();
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
        float maxOpacity = 1.0f;
        if (isDeleted) {
            maxOpacity = 0.4f;
        }
        this.getFader().setMaxValue(maxOpacity);
    }

    public void setLocationSmooth(int sx, int sy, int x, int y) {
        switch (MainFrame.usedState) {
            case FADIN: {
                this.setLocation(x, y);
                break;
            }
            case MOVEIN: {
                if (this.mover != null) {
                    this.mover.setLocationSmooth(sx, sy, x, y);
                    break;
                }
                this.setLocation(x, y);
                break;
            }
        }
    }

    public void setLocationSmooth(int x, int y) {
        switch (MainFrame.usedState) {
            case FADIN: {
                this.setLocation(x, y);
                break;
            }
            case MOVEIN: {
                if (this.mover != null) {
                    this.mover.setLocationSmooth(x, y);
                    break;
                }
                this.setLocation(x, y);
                break;
            }
        }
    }

    public void setRemoveIndex(int indexOf) {
        this.removeIndex = indexOf;
    }

    public int getRemoveIndex() {
        return this.removeIndex;
    }

    public Mover<RowPanel<T>> getMover() {
        return this.mover;
    }

    static {
        isInit = false;
        MODE_CLICK = 2;
        MODE_EXPAND = 5;
    }

    private class RowPanelLayout
    extends DefaultLayout {
        private RowPanelLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int width = parent.getWidth();
            int height = parent.getHeight();
            RowPanel.this.layoutCells(width, height);
            if (RowPanel.this.rowContentPanel != null) {
                if (!RowPanel.this.isHidden) {
                    RowPanel.this.rowContentPanel.setLocation(2, RowPanel.this.model.getColapsedRowHeight(RowPanel.this));
                } else {
                    RowPanel.this.rowContentPanel.setLocation(2, 0);
                }
                RowPanel.this.rowContentPanel.setSize(width - 4, RowPanel.this.rowContentPanel.getPreferredHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int height = RowPanel.this.model.getColapsedRowHeight(RowPanel.this);
            if (RowPanel.this.rowContentPanel != null) {
                height += RowPanel.this.rowContentPanel.getPreferredHeight();
            }
            return new Dimension(parent.getWidth(), height);
        }
    }
}

