/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.StateSkin;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultTwoStateSkin1Field;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class CellViewModificationStateERenderer
extends CellRenderer
implements AttributeListener {
    private static final long serialVersionUID = 1L;
    private DefaultTwoStateSkin1Field skin;
    private int xInsert;
    private ModificationStateE currentState;

    public CellViewModificationStateERenderer(ModificationStateE state) {
        this.currentState = state;
        this.skin = (DefaultTwoStateSkin1Field)DefaultSkins.TwoStateIcon.createDynamicSkin();
        this.attributeChanged("All attributes changed");
    }

    @Override
    public Dimension getPreferredSize() {
        int a = this.skin.getImage(Button.ButtonState.UP, StateSkin.StateType.Green.convert(this.currentState)).getWidth();
        int b = this.skin.getImage(Button.ButtonState.UP, StateSkin.StateType.Green.convert(this.currentState)).getHeight();
        return new Dimension(a * 4 + 3, b);
    }

    @Override
    public String getStringValue() {
        return CellViewModificationStateERenderer.getValueString(this.currentState);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int currentX = 0;
        int currentY = 0;
        currentX = this.isFirstColumn ? this.firstColumnInset : this.xInsert;
        currentY = (this.getHeight() - this.skin.getImage(Button.ButtonState.UP, StateSkin.StateType.Green.convert(this.currentState)).getHeight()) / 2;
        this.skin.paint(g2, currentX, currentY, Button.ButtonState.UP, StateSkin.StateType.Green.convert(this.currentState));
        this.paintChildren(g2);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.xInsert = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding"));
            this.firstColumnInset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_first_column_inset"));
            this.repaint(32L);
        }
    }

    public static String getValueString(ModificationStateE currentState2) {
        if (currentState2 == null) {
            return "";
        }
        return currentState2.toString();
    }
}

