/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.MouseConsumer;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDRadioButton;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitledItem<T extends Component>
extends JPanelFadable
implements LafListener,
Focusable,
MouseConsumer {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TitledItem.class);
    private T item;
    private TextLabel title;
    private int titleInset;
    private final TitledItemOrientation orientation;
    private boolean ignorePrefWidth = false;
    private boolean ignorePrefHeight = false;
    private int overridePrefHeight = -1;
    private Component config;
    private boolean hasTitle = true;
    private Object userObject;
    private int columnWidth = 0;
    private int innerGap = 0;

    public TitledItem(T item, String text, TitledItemOrientation orientation) {
        this.title = new TextLabel(text);
        this.hasTitle = text != null && !text.equals("");
        this.item = item;
        this.orientation = orientation;
        this.setOpaque(false);
        this.setLayout(new Layout());
        if (orientation == TitledItemOrientation.EAST || orientation == TitledItemOrientation.WEST) {
            this.setInnerGap(5);
        }
        this.lafAttributeChanged("All attribues changed");
        if (item instanceof CheckBox || item instanceof RadioButton || item instanceof RDCheckBox || item instanceof RDRadioButton) {
            this.setTitleShouldDelegateMouseEvents(true);
        }
        this.add(this.title);
        this.add((Component)this.item);
        if (item instanceof Fadable) {
            ((Fadable)item).setProgress(1.0f);
        }
    }

    public void setOverridePrefHeight(int overridePrefHeight) {
        this.overridePrefHeight = overridePrefHeight;
    }

    public int getTitleInset() {
        return this.titleInset;
    }

    public void setTitleInset(int titleInset) {
        this.titleInset = titleInset;
    }

    public void addConfig(Component c) {
        this.config = c;
        this.add(this.config);
    }

    public void setColumnWidth(int cw) {
        this.columnWidth = cw;
    }

    public int getTitleWidth() {
        return (int)this.title.getPreferredSize().getWidth();
    }

    public void setAlignment(int type) {
        this.title.setAlignment(type);
    }

    public TextLabel getTitle() {
        return this.title;
    }

    public int getAlignment() {
        return this.title.getAlignment();
    }

    public boolean isIgnorePrefWidth() {
        return this.ignorePrefWidth;
    }

    public void setIgnorePrefHeight(boolean isIgnore) {
        this.ignorePrefHeight = isIgnore;
    }

    public void setIgnorePrefWidth(boolean ignorePrefWidth) {
        this.ignorePrefWidth = ignorePrefWidth;
    }

    public void setTitleShouldDelegateMouseEvents(boolean isDelegate) {
        if (isDelegate) {
            this.title.setDelegateComponent((Component)this.item);
        } else {
            this.title.setDelegateComponent(null);
        }
    }

    public int getInnerGap() {
        return this.innerGap;
    }

    public void setInnerGap(int innerGap) {
        this.innerGap = innerGap;
        this.revalidate();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.item instanceof Killable) {
            ((Killable)this.item).kill();
        }
        if (this.title != null) {
            this.title.kill();
        }
        this.item = null;
        this.title = null;
    }

    public T getElement() {
        return this.item;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getLayout() != null) {
            return this.getLayout().preferredLayoutSize(this);
        }
        return new Dimension(0, 0);
    }

    public void setTitleText(String t) {
        this.title.setText(t);
        this.hasTitle = t != null && !t.equals("");
    }

    public void setTitleFont(Font f) {
        this.title.setFont(f);
        this.validate();
    }

    public void setTitleForeground(Color c) {
        this.title.setForeground(c);
    }

    public Color getTitleForeground() {
        return this.title.getForeground();
    }

    public void setItemFont(Font f) {
        ((Component)this.item).setFont(f);
        this.validate();
    }

    public void setItemForeground(Color c) {
        ((Component)this.item).setForeground(c);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.item != null) {
            ((Component)this.item).setEnabled(isEnabled);
        }
        if (this.title != null) {
            this.title.setEnabled(isEnabled);
        }
        this.revalidate();
    }

    @Override
    public void lafAttributeChanged(String att) {
        if ("All attribues changed".equals(att)) {
            this.setTitleFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
            this.setTitleForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
            this.repaint(32L);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.item instanceof Focusable) {
            CheckedListAdder.addToList(a, (Focusable)this.item);
        }
        return a;
    }

    public Dimension getTitlePreferredSize() {
        return this.title.getPreferredSize();
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        if (this.item instanceof Focusable) {
            ((Focusable)this.item).setVisibleContainer(pane);
        }
    }

    @Override
    public String toString() {
        double d = -1.0;
        if (this.item instanceof Fadable) {
            d = ((Fadable)this.item).getProgress();
        }
        return "Inner element is " + this.item + ", currentProgress " + this.getProgress() + ", innerProgress " + d;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.item != null && this.item instanceof Focusable) {
            ((Focusable)this.item).requestFocusInWindowNow();
        }
    }

    public TitledItemOrientation getOrientation() {
        return this.orientation;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.item instanceof MouseConsumer) {
            return ((MouseConsumer)this.item).isInnerComponent(c);
        }
        return false;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            switch (TitledItem.this.getOrientation()) {
                case NORTH: {
                    TitledItem.this.title.setLocation(TitledItem.this.titleInset, 0);
                    if (TitledItem.this.hasTitle) {
                        TitledItem.this.title.setSize(w, (int)TitledItem.this.title.getPreferredSize().getHeight());
                    } else {
                        TitledItem.this.title.setSize(w, 0);
                    }
                    TitledItem.this.item.setLocation(0, TitledItem.this.title.getHeight() + TitledItem.this.innerGap);
                    int i = w;
                    if (TitledItem.this.item instanceof CheckBox) {
                        i = (int)TitledItem.this.item.getPreferredSize().getWidth();
                    }
                    if (TitledItem.this.ignorePrefHeight) {
                        TitledItem.this.item.setSize(i, parent.getHeight() - TitledItem.this.item.getY());
                        break;
                    }
                    TitledItem.this.item.setSize(i, (int)TitledItem.this.item.getPreferredSize().getHeight());
                    break;
                }
                case EAST: {
                    TitledItem.this.item.setLocation(0, 0);
                    int aw = (int)((double)parent.getWidth() - TitledItem.this.title.getPreferredSize().getWidth());
                    aw -= TitledItem.this.innerGap;
                    if ((double)aw > TitledItem.this.item.getPreferredSize().getWidth() && !TitledItem.this.ignorePrefWidth) {
                        aw = (int)TitledItem.this.item.getPreferredSize().getWidth();
                    }
                    if (TitledItem.this.item instanceof CheckBox) {
                        aw = (int)TitledItem.this.item.getPreferredSize().getWidth();
                    }
                    if (TitledItem.this.item instanceof RadioButton) {
                        aw = (int)TitledItem.this.item.getPreferredSize().getWidth();
                    }
                    TitledItem.this.item.setSize(aw, (int)TitledItem.this.item.getPreferredSize().getHeight());
                    TitledItem.this.title.setLocation(TitledItem.this.item.getWidth() + TitledItem.this.innerGap, (int)(((double)TitledItem.this.item.getHeight() - TitledItem.this.title.getPreferredSize().getHeight()) / 2.0) - 1);
                    if (TitledItem.this.hasTitle) {
                        TitledItem.this.title.setSize(w - TitledItem.this.title.getX(), (int)TitledItem.this.title.getPreferredSize().getHeight());
                    } else {
                        TitledItem.this.title.setSize(w - TitledItem.this.title.getX(), 0);
                    }
                    if (TitledItem.this.config == null) break;
                    TitledItem.this.config.setLocation(TitledItem.this.item.getX() + TitledItem.this.item.getWidth(), TitledItem.this.item.getY() + TitledItem.this.item.getHeight() + 5);
                    break;
                }
                case SOUTH: {
                    TitledItem.this.item.setSize(w, (int)TitledItem.this.item.getPreferredSize().getHeight());
                    if (TitledItem.this.hasTitle) {
                        TitledItem.this.title.setSize(w, (int)TitledItem.this.title.getPreferredSize().getHeight());
                    } else {
                        TitledItem.this.title.setSize(w, 0);
                    }
                    TitledItem.this.title.setLocation((int)(((double)w - TitledItem.this.title.getPreferredSize().getWidth()) / 2.0), TitledItem.this.item.getHeight() + TitledItem.this.innerGap);
                    TitledItem.this.item.setLocation((int)(((double)w - TitledItem.this.item.getPreferredSize().getWidth()) / 2.0), 0);
                    break;
                }
                case WEST: {
                    if (TitledItem.this.columnWidth != 0) {
                        int tw = (int)TitledItem.this.title.getPreferredSize().getWidth();
                        TitledItem.this.title.setLocation(0, (int)((TitledItem.this.item.getPreferredSize().getHeight() - TitledItem.this.title.getPreferredSize().getHeight()) / 2.0));
                        if (tw > TitledItem.this.columnWidth - TitledItem.this.innerGap) {
                            tw = TitledItem.this.columnWidth - TitledItem.this.innerGap;
                        }
                        TitledItem.this.title.setSize(tw, (int)TitledItem.this.title.getPreferredSize().getHeight());
                        TitledItem.this.item.setLocation(TitledItem.this.columnWidth, (int)(((double)parent.getHeight() - TitledItem.this.item.getPreferredSize().getHeight()) / 2.0));
                        int aw = w - TitledItem.this.item.getX();
                        if (TitledItem.this.item instanceof CheckBox) {
                            aw = (int)TitledItem.this.item.getPreferredSize().getWidth();
                        } else if (!(TitledItem.this.item instanceof ComboBox) && !(TitledItem.this.item instanceof TextField) && (double)aw > TitledItem.this.item.getPreferredSize().getWidth()) {
                            aw = (int)TitledItem.this.item.getPreferredSize().getWidth();
                        }
                        TitledItem.this.item.setSize(aw, (int)TitledItem.this.item.getPreferredSize().getHeight());
                        break;
                    }
                    int tw = (w - TitledItem.this.innerGap) / 2;
                    if (TitledItem.this.title.getPreferredSize().getWidth() > (double)tw || TitledItem.this.ignorePrefWidth) {
                        tw = (int)TitledItem.this.title.getPreferredSize().getWidth();
                    }
                    if (TitledItem.this.hasTitle) {
                        TitledItem.this.title.setSize(tw, (int)TitledItem.this.title.getPreferredSize().getHeight());
                    } else {
                        TitledItem.this.title.setSize(0, 0);
                    }
                    int ax = (int)(((double)parent.getHeight() - TitledItem.this.item.getPreferredSize().getHeight()) / 2.0);
                    if (TitledItem.this.item instanceof CheckBox) {
                        // empty if block
                    }
                    if (TitledItem.this.item instanceof RadioButton) {
                        // empty if block
                    }
                    TitledItem.this.item.setLocation(TitledItem.this.title.getWidth() + TitledItem.this.innerGap, ax);
                    int aw = w - TitledItem.this.item.getX();
                    if (TitledItem.this.item instanceof CheckBox) {
                        aw = (int)TitledItem.this.item.getPreferredSize().getWidth();
                    }
                    TitledItem.this.item.setSize(aw, (int)TitledItem.this.item.getPreferredSize().getHeight());
                    TitledItem.this.title.setLocation(0, (int)(((double)parent.getHeight() - TitledItem.this.title.getPreferredSize().getHeight()) / 2.0));
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = parent.getWidth();
            int h = 0;
            if (TitledItem.this.getOrientation() == TitledItemOrientation.NORTH || TitledItem.this.getOrientation() == TitledItemOrientation.SOUTH) {
                h = TitledItem.this.hasTitle ? (int)(TitledItem.this.title.getPreferredSize().getHeight() + TitledItem.this.item.getPreferredSize().getHeight() + (double)TitledItem.this.innerGap) : (int)(TitledItem.this.item.getPreferredSize().getHeight() + (double)TitledItem.this.innerGap);
                w = (int)TitledItem.this.title.getPreferredSize().getWidth();
                if ((double)w < TitledItem.this.item.getPreferredSize().getWidth()) {
                    w = (int)TitledItem.this.item.getPreferredSize().getWidth();
                }
            } else {
                h = (int)TitledItem.this.title.getPreferredSize().getHeight();
                if ((double)h < TitledItem.this.item.getPreferredSize().getHeight()) {
                    h = (int)TitledItem.this.item.getPreferredSize().getHeight();
                }
                w = (int)(TitledItem.this.item.getPreferredSize().getWidth() + (double)((int)TitledItem.this.title.getPreferredSize().getWidth())) + TitledItem.this.innerGap;
                if (TitledItem.this.config != null) {
                    h += 5;
                    h = (int)((double)h + TitledItem.this.config.getPreferredSize().getHeight());
                    int w2 = (int)((double)(TitledItem.this.item.getX() + TitledItem.this.item.getWidth()) + TitledItem.this.config.getPreferredSize().getWidth());
                    if (w2 > w) {
                        w = w2;
                    }
                }
            }
            if (TitledItem.this.overridePrefHeight != -1) {
                h = TitledItem.this.overridePrefHeight;
            }
            return new Dimension(w, h);
        }
    }

    public static enum TitledItemOrientation {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

