/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Stringable;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.skins.ToggleSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class CheckBox
extends Button
implements ButtonListener,
NodeListener,
Validatable,
UIStateLoadable,
Stringable,
Nodable {
    private static final long serialVersionUID = 1L;
    private Object userObject;
    protected ToggleSkin1Field skin;
    private boolean isPersistable = true;
    private boolean isChecked;
    private boolean isUnDisable;
    private Node<Boolean> node;
    private String id;
    private boolean defaultValue;
    private boolean isPermanent;

    public CheckBox() {
        this(true);
    }

    public CheckBox(Node<Boolean> node) {
        this();
        this.setNode(node);
    }

    public CheckBox(boolean isFocusable) {
        super(isFocusable);
        this.init();
    }

    @Override
    public String getPersistString() {
        return "" + this.isChecked;
    }

    @Override
    public void loadState(String state, String id) {
        Boolean b = Boolean.valueOf(state);
        this.setChecked(b != null ? b : false);
        for (ButtonListener listener : (ArrayList)this.listeners.clone()) {
            if (listener == this) continue;
            listener.buttonPressed(this, 0, 0);
        }
    }

    private void init() {
        this.setOpaque(false);
        this.setToolTipText(Words.TOGGLE);
        this.skin = (ToggleSkin1Field)DefaultSkins.CheckBoxIcon.createDynamicSkin();
        this.addButtonListener(this);
        this.setSize(this.getPreferredSize());
    }

    public Node<Boolean> getNode() {
        return this.node;
    }

    @Override
    public void setNode(Node<?> n) {
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = n;
        if (this.node != null) {
            this.node.addNodeListener((NodeListener)this);
            if (this.node.getValue() == null) {
                this.node.setValue((Object)false, 0L);
            }
            this.selectValue();
        }
    }

    public boolean isUnDisable() {
        return this.isUnDisable;
    }

    public void setUnDisable(boolean isUnDisable) {
        this.isUnDisable = isUnDisable;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    private void selectValue() {
        if (this.node.getValue() != null) {
            if (this.node.getValue() instanceof Boolean) {
                this.setChecked((Boolean)this.node.getValue());
            } else {
                this.setChecked(true);
            }
        }
    }

    @Override
    public void kill() {
        super.kill();
        this.removeKeyListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.skin.getImage(this.state, this.isChecked).getWidth(), this.skin.getImage(this.state, this.isChecked).getHeight());
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, 0, this.state, this.isChecked);
        this.paintChildren(g2);
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
        if (this.node != null && this.node.getValue() instanceof Boolean && (Boolean)this.node.getValue() != isChecked) {
            this.node.setValueSilent((Object)isChecked, false, System.currentTimeMillis(), new NodeListener[]{this});
        }
        this.repaint(32L);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (this.node != null) {
            this.node.setValue((Object)(!this.isChecked ? 1 : 0), System.currentTimeMillis());
        } else {
            this.setChecked(!this.isChecked);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (!this.isUnDisable) {
            super.setEnabled(isEnabled);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.fireEvent(0, 0);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        this.selectValue();
    }

    public static int getPreferredWidth() {
        CheckBox n = new CheckBox();
        int w = (int)n.getPreferredSize().getWidth();
        n.kill();
        n = null;
        return w;
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.state == Button.ButtonState.ERROR) {
            this.setState(Button.ButtonState.DOWN);
        }
        super.mousePressed(e);
    }

    public void setID(String id) {
        this.id = id;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setValid() {
        this.setState(Button.ButtonState.UP);
    }

    @Override
    public void setInvalid() {
        this.setState(Button.ButtonState.ERROR);
    }

    @Override
    public void setWarning() {
        this.setState(Button.ButtonState.STATE_WARRNING);
    }

    @Override
    public String getStringValue() {
        if (this.isChecked) {
            return "checked";
        }
        return "unchecked";
    }

    @Override
    public boolean shouldPersist() {
        return this.isPersistable;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
        this.isPersistable = isPersisting;
    }

    public void setDefaultValue(boolean selected) {
        this.defaultValue = selected;
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public void setPermanent(boolean isPermanent) {
        this.isPermanent = isPermanent;
    }
}

