/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.TypedSkin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.TabbedBackButtonSkin;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class TabbedBackButton
extends Button
implements LafListener,
ImageConsumer {
    private static final long serialVersionUID = 1L;
    private BufferedImage icon_up;
    private String icon_up_att;
    private TypedSkin3Field skin;
    private ViewState viewState = ViewState.Single;

    public TabbedBackButton(String icon_up, ViewState viewState) {
        super(false);
        this.icon_up_att = icon_up;
        this.viewState = viewState;
        this.lafAttributeChanged("All attribues changed");
        this.skin = SkinRegistry.getSkin(TabbedBackButtonSkin.class);
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, 0, this.getWidth(), this.state, this.viewState);
        if (this.viewState == ViewState.Left) {
            int w = this.getWidth() - this.skin.getImageLeft(this.state, this.viewState).getWidth();
            g2.drawImage(this.icon_up, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, this.skin.getImageLeft(this.state, this.viewState).getWidth() + (w - this.icon_up.getWidth()) / 2 - 2, (this.getHeight() - this.icon_up.getHeight()) / 2), null);
        } else if (this.viewState == ViewState.Right) {
            int w = this.getWidth() - this.skin.getImageRight(this.state, this.viewState).getWidth();
            g2.drawImage(this.icon_up, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, (w - this.icon_up.getWidth()) / 2 + 2, (this.getHeight() - this.icon_up.getHeight()) / 2), null);
        } else {
            int w = this.getWidth();
            g2.drawImage(this.icon_up, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, (w - this.icon_up.getWidth()) / 2, (this.getHeight() - this.icon_up.getHeight()) / 2), null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ret = null;
        ret = new Dimension(this.skin.getImageMiddle(this.state, this.viewState).getWidth(), this.skin.getImageMiddle(this.state, this.viewState).getHeight());
        switch (this.viewState) {
            case Left: {
                ret = new Dimension(this.skin.getImageLeft(this.state, this.viewState).getWidth() + this.skin.getImageMiddle(this.state, this.viewState).getHeight() - 8, this.skin.getImageMiddle(this.state, this.viewState).getHeight());
                break;
            }
            case Middle: {
                ret = new Dimension(this.skin.getImageMiddle(this.state, this.viewState).getHeight(), this.skin.getImageMiddle(this.state, this.viewState).getHeight());
                break;
            }
            case Right: {
                ret = new Dimension(this.skin.getImageRight(this.state, this.viewState).getWidth() + this.skin.getImageMiddle(this.state, this.viewState).getHeight() - 2, this.skin.getImageMiddle(this.state, this.viewState).getHeight());
            }
        }
        return ret;
    }

    @Override
    public void loadImages() {
        this.icon_up = AttributesConverter.getBufferedImage4String(this.icon_up_att);
    }

    @Override
    public void clearImages() {
        this.loadImages();
    }

    public static enum ViewState {
        Left,
        Middle,
        Right,
        Single;

    }
}

