/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.image;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.clipboard.ClipBoardUtils;
import ch.icit.pegasus.client.gui.utils.file.FileChooserPopupInsert;
import ch.icit.pegasus.client.gui.utils.image.ImagePreviewPainter;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager2;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageFileChooserPopupInsert
extends FileChooserPopupInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private static final int STATE_CHOOSE_FILE = 3;
    private static final int STATE_PREVIEW_FILE = 5;
    private int currentState = 3;
    private TextButton back;
    private TextButton cancel;
    private TextButton ok;
    private ImagePreviewPainter painter = null;
    private TextLabel previewTitle;
    private BufferedImage currentImage;
    private HorizontalSeparator sep1;
    private SystemSettingsComplete settings;
    private File currentFile;
    private AWTEventListener keyadapter;
    private KeyListener keyAdapter;
    private boolean hadFile;
    private Node<PegasusFileComplete> node;
    private Node<PegasusFileComplete> targetNode;
    private TitledItem<CheckBox> fitImage;

    public ImageFileChooserPopupInsert(File file, boolean hadFileBefore) {
        this.hadFile = hadFileBefore;
        this.painter = new ImagePreviewPainter();
        this.fitImage = new TitledItem<CheckBox>(new CheckBox(), "Fit Image (Preview only)", TitledItem.TitledItemOrientation.WEST);
        this.fitImage.getElement().addButtonListener(this);
        this.fitImage.getFader().setPermanent(true);
        this.fitImage.getFader().setProgress(0.0f);
        this.add(this.fitImage);
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.keyAdapter = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 86 && e.isControlDown()) {
                    try {
                        ImageFileChooserPopupInsert.this.loadFromClipBoard();
                    }
                    catch (IOException e1) {
                        InnerPopupFactory.showErrorDialog("Unable to import image from clipboard!", (Component)ImageFileChooserPopupInsert.this);
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        };
        this.fitImage.getElement().addKeyListener(this.keyAdapter);
        this.switchToError("", "", true);
        this.currentFile = file;
        this.validateLoadedImage(this.currentFile);
    }

    public ImageFileChooserPopupInsert(Node<PegasusFileComplete> imageNode, boolean hadFileBefore) {
        this(new File(((PegasusFileComplete)imageNode.getValue()).getUri()), hadFileBefore);
        this.node = imageNode;
    }

    public ImageFileChooserPopupInsert(Node<PegasusFileComplete> imageNode, Node<PegasusFileComplete> targetNode, boolean hadFileBefore) {
        this(imageNode, hadFileBefore);
        this.targetNode = targetNode;
    }

    private void loadFromClipBoard() throws IOException {
        BufferedImage b = ClipBoardUtils.readImageFromSystemClipboard();
        if (b != null) {
            File f = File.createTempFile("img_", ".png");
            ImageIO.write((RenderedImage)b, "PNG", f);
            this.currentFile = f;
            ((PegasusFileComplete)this.node.getValue()).setUri(f.toURI());
            this.validateLoadedImage(f);
        }
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.back.isEnabled()) {
            a.addAll(this.back.getFocusComponents());
        }
        a.addAll(this.fitImage.getFocusComponents());
        a.addAll(this.ok.getFocusComponents());
        a.addAll(this.cancel.getFocusComponents());
        return a;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyadapter);
        this.keyadapter = null;
        if (this.back != null) {
            this.back.removeKeyListener(this.keyAdapter);
            this.back.kill();
        }
        if (this.cancel != null) {
            this.cancel.removeKeyListener(this.keyAdapter);
            this.cancel.kill();
        }
        if (this.ok != null) {
            this.ok.removeKeyListener(this.keyAdapter);
            this.ok.kill();
        }
        if (this.previewTitle != null) {
            this.previewTitle.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        if (this.fitImage != null) {
            this.fitImage.removeKeyListener(this.keyAdapter);
            this.fitImage.kill();
        }
        if (this.currentImage != null) {
            this.currentImage.flush();
            this.currentImage = null;
        }
        this.back = null;
        this.cancel = null;
        this.ok = null;
        this.previewTitle = null;
        this.sep1 = null;
        this.fitImage = null;
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getActionCommand().equals("CancelSelection")) {
            this.popup.hidePopUp(new Object[0]);
        }
        if (action.getActionCommand().equals("ApproveSelection")) {
            this.validateLoadedImage(this.fileChooser.getSelectedFile());
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.currentState == 5) {
            this.painter.paint(g2, this.previewTitle.getX() + 5, this.previewTitle.getY() + this.previewTitle.getHeight() + 5, this.getWidth(), this.getHeight() - (this.getHeight() - (this.sep1.getY() - 10)), this.settings, this.currentImage, this.fitImage.getElement().isChecked());
        }
        this.paintChildren(g2);
    }

    private void switchToError(String xmsg, String priceInfo, boolean imageLoaded) {
        this.fileChooser.setVisible(false);
        if (this.previewTitle == null) {
            this.previewTitle = new TextLabel(Words.PREVIEW);
            this.previewTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("screen_title_font_size"), LafLoader.getLafLoader().getAttribute("screen_title_font_type")));
            this.previewTitle.getFader().setPermanent(true);
            this.add(this.previewTitle);
        }
        if (this.sep1 == null) {
            this.sep1 = new HorizontalSeparator();
            this.sep1.getFader().setPermanent(true);
            this.sep1.setProgress(0.0f);
            this.add(this.sep1);
        }
        if (this.back == null) {
            this.back = new TextButton(Words.BACK);
            this.back.getFader().setPermanent(true);
            this.back.setProgress(0.0f);
            this.back.addButtonListener(this);
            this.back.addKeyListener(this.keyAdapter);
            this.add(this.back);
            this.back.setEnabled(false);
        }
        if (this.cancel == null) {
            this.cancel = new TextButton(TextButton.BUTTON_TYPES.CANCEL);
            this.cancel.getFader().setPermanent(true);
            this.cancel.setProgress(0.0f);
            this.cancel.addButtonListener(this);
            this.cancel.addKeyListener(this.keyAdapter);
            this.add(this.cancel);
        }
        if (this.ok == null) {
            this.ok = new TextButton(TextButton.BUTTON_TYPES.OK);
            this.ok.getFader().setPermanent(true);
            this.ok.setProgress(0.0f);
            this.ok.addButtonListener(this);
            this.ok.addKeyListener(this.keyAdapter);
            this.add(this.ok);
        }
        this.currentState = 5;
        if (!imageLoaded) {
            this.ok.setEnabled(false);
        }
        this.validate();
        this.previewTitle.fadeIn();
        this.sep1.fadeIn();
        this.back.fadeIn();
        this.cancel.fadeIn();
        this.ok.fadeIn();
        this.fitImage.fadeIn();
    }

    private void switchToChooser() {
        this.currentState = 3;
        if (this.back != null) {
            this.back.fadeOut(false);
        }
        if (this.cancel != null) {
            this.cancel.fadeOut(false);
        }
        if (this.ok != null) {
            this.ok.fadeOut(false);
        }
        if (this.previewTitle != null) {
            this.previewTitle.fadeOut(false);
        }
        if (this.currentImage != null) {
            this.currentImage.flush();
            this.currentImage = null;
        }
        if (this.sep1 != null) {
            this.sep1.fadeOut(false);
        }
        if (this.fitImage != null) {
            this.fitImage.fadeOut(false);
        }
        this.fileChooser.setVisible(true);
    }

    private void validateLoadedImage(File image) {
        boolean isImageLoadable = true;
        String errorMsg = "";
        String imageInfo = "";
        BufferedImage ci = null;
        try {
            ci = ImageIO.read(image);
        }
        catch (IOException e) {
            ci = null;
        }
        if (ci == null) {
            isImageLoadable = false;
            errorMsg = Words.UNABLE_TO_LOAD_FILE;
        }
        if (this.currentImage != null) {
            this.currentImage.flush();
            this.currentImage = null;
        }
        this.currentImage = ci;
        this.switchToError(errorMsg, imageInfo, isImageLoadable);
    }

    @Override
    public LayoutManager2 getCustomLayouter() {
        return new Layout();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.back) {
            this.switchToChooser();
        } else if (source == this.cancel) {
            this.popup.hidePopUp(new Object[0]);
        } else if (this.fitImage.getElement() == source) {
            this.repaint(32L);
        } else if (source == this.ok) {
            if (this.hadFile) {
                InnerPopUp2 p = InnerPopupFactory.showWarningDialog("This Product already has an image. The old image will be deleted", new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        if (xargs == null) {
                            return;
                        }
                        if (ImageFileChooserPopupInsert.this.targetNode != null) {
                            ImageFileChooserPopupInsert.this.targetNode.setValue(ImageFileChooserPopupInsert.this.node.getValue(), 0L);
                        }
                        ImageFileChooserPopupInsert.this.popup.hidePopUp(ImageFileChooserPopupInsert.this.currentImage, ImageFileChooserPopupInsert.this.currentFile, true);
                    }
                }, (Component)this.ok);
                p.setOkButtonText("Replace Image");
            } else {
                if (this.targetNode != null) {
                    this.targetNode.setValue(this.node.getValue(), 0L);
                }
                this.popup.hidePopUp(this.currentImage, this.currentFile, false);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (ImageFileChooserPopupInsert.this.currentState == 3) {
                ImageFileChooserPopupInsert.this.fileChooser.setLocation(0, 0);
                ImageFileChooserPopupInsert.this.fileChooser.setSize(parent.getWidth(), parent.getHeight());
            } else {
                ImageFileChooserPopupInsert.this.back.setLocation(10, (int)((double)parent.getHeight() - (ImageFileChooserPopupInsert.this.back.getPreferredSize().getHeight() + 10.0)));
                ImageFileChooserPopupInsert.this.back.setSize(ImageFileChooserPopupInsert.this.back.getPreferredSize());
                ImageFileChooserPopupInsert.this.fitImage.setLocation(ImageFileChooserPopupInsert.this.back.getX() + ImageFileChooserPopupInsert.this.back.getWidth() + 10, (int)((double)ImageFileChooserPopupInsert.this.back.getY() + ((double)ImageFileChooserPopupInsert.this.back.getHeight() - ImageFileChooserPopupInsert.this.fitImage.getPreferredSize().getHeight()) / 2.0));
                ImageFileChooserPopupInsert.this.fitImage.setSize(ImageFileChooserPopupInsert.this.fitImage.getPreferredSize());
                ImageFileChooserPopupInsert.this.cancel.setLocation((int)((double)parent.getWidth() - (ImageFileChooserPopupInsert.this.cancel.getPreferredSize().getWidth() + 10.0)), ImageFileChooserPopupInsert.this.back.getY());
                ImageFileChooserPopupInsert.this.cancel.setSize(ImageFileChooserPopupInsert.this.cancel.getPreferredSize());
                ImageFileChooserPopupInsert.this.ok.setLocation((int)((double)ImageFileChooserPopupInsert.this.cancel.getX() - (ImageFileChooserPopupInsert.this.ok.getPreferredSize().getWidth() + 5.0)), ImageFileChooserPopupInsert.this.cancel.getY());
                ImageFileChooserPopupInsert.this.ok.setSize(ImageFileChooserPopupInsert.this.ok.getPreferredSize());
                ImageFileChooserPopupInsert.this.previewTitle.setLocation(10, 10);
                ImageFileChooserPopupInsert.this.previewTitle.setSize(ImageFileChooserPopupInsert.this.previewTitle.getPreferredSize());
                ImageFileChooserPopupInsert.this.sep1.setLocation(0, (int)((double)ImageFileChooserPopupInsert.this.ok.getY() - (10.0 + ImageFileChooserPopupInsert.this.sep1.getPreferredSize().getHeight())));
                ImageFileChooserPopupInsert.this.sep1.setSize(parent.getWidth(), (int)ImageFileChooserPopupInsert.this.sep1.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return ImageFileChooserPopupInsert.this.fileChooser.getPreferredSize();
        }
    }
}

