/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.List;
import javax.swing.JComponent;

public class StringPopUpInsert
extends PopUpInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private ScrollPane scrollPane;
    private JComponent viewPort;
    private Color backgroundColor;
    protected MultiLineTextLabel label;
    private Converter converter;
    private LoadingAnimation loadingAnimation;

    public StringPopUpInsert(Converter converter) {
        this.converter = converter;
        this.initLayout();
        this.initMultiLabelThings("", false);
        this.ensureAnimation("Load Charge Transactions", "Load Charge Transactions");
    }

    public StringPopUpInsert(String text) {
        this.initLayout();
        if (text != null) {
            this.initMultiLabelThings(text, false);
        }
    }

    protected void ensureAnimation(String max, String current) {
        if (this.loadingAnimation == null) {
            this.loadingAnimation = new LoadingAnimation();
            this.loadingAnimation.stateChanged(current);
            this.add(this.loadingAnimation);
            this.loadingAnimation.start();
            this.loadingAnimation.fadeIn();
        }
        if (this.scrollPane != null) {
            this.scrollPane.setVisible(false);
        }
    }

    protected void hideAnimation() {
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stop();
            this.loadingAnimation.fadeOut(true);
            this.loadingAnimation = null;
        }
        if (this.scrollPane != null) {
            this.scrollPane.setVisible(true);
        }
    }

    public void setLoadable(ThreadSafeExecutable run) {
        ThreadSafeLoader.run(run);
    }

    private void initLayout() {
        this.setOpaque(false);
        this.setLayout(new InnerLayout());
    }

    protected void initMultiLabelThings(String text, boolean withFadin) {
        this.label = new MultiLineTextLabel();
        this.backgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setScrollPaneBackground(this.backgroundColor);
        this.viewPort = new Port();
        this.viewPort.setLayout(new ViewPortLayout());
        this.setText(text);
        this.viewPort.add(this.label);
        this.scrollPane.setViewportView(this.viewPort);
        if (withFadin) {
            this.label.setProgress(0.0f);
        }
        this.add(this.scrollPane);
        if (withFadin) {
            this.label.fadeIn();
        }
        this.invalidate();
        this.validate();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.label != null) {
            this.label.kill();
            this.label = null;
        }
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stop();
            this.loadingAnimation.kill();
            this.loadingAnimation = null;
        }
    }

    public void setText(String t) {
        if (this.label != null) {
            this.label.setLabelText(t);
        }
    }

    public String getText() {
        if (this.label != null) {
            return this.label.getText();
        }
        return "";
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            return new Object[1];
        }
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.hideAnimation();
        String t = (String)this.converter.convert(node.getValue(), node, new Object[0]);
        this.initMultiLabelThings(t, true);
    }

    private class ViewPortLayout
    extends DefaultLayout {
        private ViewPortLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)((double)StringPopUpInsert.this.scrollPane.getWidth() - StringPopUpInsert.this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            int h = (int)StringPopUpInsert.this.label.getPreferredSize().getHeight();
            if (StringPopUpInsert.this.loadingAnimation != null && (double)h < StringPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight()) {
                h = (int)StringPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight();
            }
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            StringPopUpInsert.this.label.setLocation(0, 0);
            StringPopUpInsert.this.label.setSize(parent.getWidth(), (int)StringPopUpInsert.this.label.getPreferredSize().getHeight());
        }
    }

    private class Port
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private Port() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(StringPopUpInsert.this.backgroundColor);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintChildren(g2);
        }
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (StringPopUpInsert.this.loadingAnimation != null) {
                StringPopUpInsert.this.loadingAnimation.setLocation((int)((double)parent.getWidth() - StringPopUpInsert.this.loadingAnimation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - StringPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight()) / 2.0));
                StringPopUpInsert.this.loadingAnimation.setSize(StringPopUpInsert.this.loadingAnimation.getPreferredSize());
            }
            if (StringPopUpInsert.this.scrollPane != null) {
                StringPopUpInsert.this.scrollPane.setLocation(0, 0);
                StringPopUpInsert.this.scrollPane.setSize(parent.getSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = new Dimension();
            if (StringPopUpInsert.this.userPrefHeight != null) {
                d.setSize(d.getWidth(), (double)StringPopUpInsert.this.userPrefHeight.intValue());
            } else if (StringPopUpInsert.this.viewPort != null) {
                d.setSize(d.getWidth(), StringPopUpInsert.this.viewPort.getPreferredSize().getHeight());
            } else {
                d.setSize(d.getWidth(), (double)(StringPopUpInsert.this.loadingAnimation.getHeight() + 10));
            }
            if (StringPopUpInsert.this.userPrefWidth != null) {
                d.setSize((double)StringPopUpInsert.this.userPrefWidth.intValue(), d.getHeight());
            } else if (StringPopUpInsert.this.viewPort != null) {
                d.setSize(StringPopUpInsert.this.viewPort.getPreferredSize().getWidth(), d.getHeight());
            } else {
                d.setSize(StringPopUpInsert.this.loadingAnimation.getPreferredSize().getWidth() + 10.0, d.getHeight());
            }
            return d;
        }
    }
}

