/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.productionweeklyplan;

import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.productionweeklyplan.DayView;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class ProductionWeeklyPlanTableHeader
extends Table2HeaderPanel {
    private static final long serialVersionUID = 1L;
    private List<TextLabel> titles;
    private DayView mo = new DayView("mo", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getMondayUpdateCount());
    private DayView tue = new DayView("tue", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getTuesdayUpdateCount());
    private DayView wed = new DayView("wed", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getWednesdayUpdateCount());
    private DayView thu = new DayView("thu", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getThursdayUpdateCount());
    private DayView fri = new DayView("fri", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getFridayUpdateCount());
    private DayView sat = new DayView("sat", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getSaturdayUpdateCount());
    private DayView sun = new DayView("sun", null, ((WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue()).getSundayUpdateCount());
    private Node<WeeklyPlanComplete> node;

    public ProductionWeeklyPlanTableHeader(Table2RowModel m) {
        super(m, 7, 2);
        this.titles = new ArrayList<TextLabel>();
        for (int i = 0; i < 7; ++i) {
            TextLabel title = new TextLabel("");
            title.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_table_header_foreground")));
            title.setFont(title.getFont().deriveFont(11.0f).deriveFont(1));
            this.titles.add(title);
            this.add(title);
        }
        this.setIgnoreLineOverTitle(false);
        this.setLayout(new TableHeaderPanelLayout());
    }

    public void setNode(Node<WeeklyPlanComplete> node) {
        this.node = node;
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.");
        Date startDate = (Date)node.getChildNamed(new DtoField[]{WeeklyPlanComplete_.period, PeriodComplete_.startDate}).getValue();
        Date currentDate = new Date(startDate.getTime());
        this.titles.get(0).setText(DateUtil.getDayName((java.util.Date)currentDate) + " " + df.format(currentDate));
        currentDate = (Date)DateUtil.addDays((java.util.Date)currentDate, (int)1);
        this.titles.get(1).setText(DateUtil.getDayName((java.util.Date)currentDate) + " " + df.format(currentDate));
        currentDate = (Date)DateUtil.addDays((java.util.Date)currentDate, (int)1);
        this.titles.get(2).setText(DateUtil.getDayName((java.util.Date)currentDate) + " " + df.format(currentDate));
        currentDate = (Date)DateUtil.addDays((java.util.Date)currentDate, (int)1);
        this.titles.get(3).setText(DateUtil.getDayName((java.util.Date)currentDate) + " " + df.format(currentDate));
        currentDate = (Date)DateUtil.addDays((java.util.Date)currentDate, (int)1);
        this.titles.get(4).setText(DateUtil.getDayName((java.util.Date)currentDate) + " " + df.format(currentDate));
        currentDate = (Date)DateUtil.addDays((java.util.Date)currentDate, (int)1);
        this.titles.get(5).setText(DateUtil.getDayName((java.util.Date)currentDate) + " " + df.format(currentDate));
        currentDate = (Date)DateUtil.addDays((java.util.Date)currentDate, (int)1);
        this.titles.get(6).setText(DateUtil.getDayName((java.util.Date)currentDate) + " " + df.format(currentDate));
    }

    @Override
    public void updateHeaderValues(int alignment) {
        for (JComponent l : this.headerValues) {
            if (!(l instanceof Killable)) continue;
            ((Killable)((Object)l)).kill();
        }
        this.headerValues.clear();
        for (int i = 0; i < this.model.getParentModel().getColumnCount(); ++i) {
            String name = this.model.getParentModel().getColumnName(i);
            MultiLineTextLabel l = new MultiLineTextLabel(name);
            this.headerValues.add(l);
            this.add(l);
            l.setProgress(1.0f);
        }
        this.lafAttributeChanged("All attribues changed");
    }

    @Override
    public int getLineStart() {
        return 25;
    }

    @Override
    public boolean isPrefSizeSet() {
        return true;
    }

    private void layoutTitle(int currentX, int w, TextLabel title) {
        title.setLocation((int)((double)currentX + ((double)w - title.getPreferredSize().getWidth()) / 2.0), 2);
        title.setSize(title.getPreferredSize());
    }

    private class TableHeaderPanelLayout
    extends DefaultLayout {
        private TableHeaderPanelLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentWidth = 0;
            int currentX = 0;
            int startX = 0;
            CustomerLight customer = null;
            if (ProductionWeeklyPlanTableHeader.this.node != null) {
                customer = (CustomerLight)ProductionWeeklyPlanTableHeader.this.node.getChildNamed(WeeklyPlanComplete_.customer).getValue();
            }
            int moIndex = 4 + ProductionWeeklyPlanTableHeader.this.mo.getColumnCount(customer);
            int tueIndex = moIndex + ProductionWeeklyPlanTableHeader.this.tue.getColumnCount(customer);
            int wedIndex = tueIndex + ProductionWeeklyPlanTableHeader.this.wed.getColumnCount(customer);
            int thuIndex = wedIndex + ProductionWeeklyPlanTableHeader.this.thu.getColumnCount(customer);
            int friIndex = thuIndex + ProductionWeeklyPlanTableHeader.this.fri.getColumnCount(customer);
            int satIndex = friIndex + ProductionWeeklyPlanTableHeader.this.sat.getColumnCount(customer);
            int sunIndex = satIndex + ProductionWeeklyPlanTableHeader.this.sun.getColumnCount(customer);
            for (int i = 0; i < ProductionWeeklyPlanTableHeader.this.model.getParentModel().getColumnCount(); ++i) {
                int w = ProductionWeeklyPlanTableHeader.this.model.getParentModel().getColumnWidth(i);
                if (i == 4 || i == moIndex || i == tueIndex || i == wedIndex || i == thuIndex || i == friIndex || i == satIndex || i == sunIndex) {
                    startX = currentX;
                    currentWidth = 0;
                }
                currentWidth += w;
                if (i == moIndex - 1) {
                    ProductionWeeklyPlanTableHeader.this.layoutTitle(startX, currentWidth, (TextLabel)ProductionWeeklyPlanTableHeader.this.titles.get(0));
                }
                if (i == tueIndex - 1) {
                    ProductionWeeklyPlanTableHeader.this.layoutTitle(startX, currentWidth, (TextLabel)ProductionWeeklyPlanTableHeader.this.titles.get(1));
                }
                if (i == wedIndex - 1) {
                    ProductionWeeklyPlanTableHeader.this.layoutTitle(startX, currentWidth, (TextLabel)ProductionWeeklyPlanTableHeader.this.titles.get(2));
                }
                if (i == thuIndex - 1) {
                    ProductionWeeklyPlanTableHeader.this.layoutTitle(startX, currentWidth, (TextLabel)ProductionWeeklyPlanTableHeader.this.titles.get(3));
                }
                if (i == friIndex - 1) {
                    ProductionWeeklyPlanTableHeader.this.layoutTitle(startX, currentWidth, (TextLabel)ProductionWeeklyPlanTableHeader.this.titles.get(4));
                }
                if (i == satIndex - 1) {
                    ProductionWeeklyPlanTableHeader.this.layoutTitle(startX, currentWidth, (TextLabel)ProductionWeeklyPlanTableHeader.this.titles.get(5));
                }
                if (i == sunIndex - 1) {
                    ProductionWeeklyPlanTableHeader.this.layoutTitle(startX, currentWidth, (TextLabel)ProductionWeeklyPlanTableHeader.this.titles.get(6));
                }
                currentX += w;
            }
            int currentIndex = 0;
            currentWidth = 0;
            for (JComponent l : ProductionWeeklyPlanTableHeader.this.headerValues) {
                int w = ProductionWeeklyPlanTableHeader.this.model.getParentModel().getColumnWidth(currentIndex);
                l.setLocation(currentWidth + ProductionWeeklyPlanTableHeader.this.getCellPadding(), (int)((double)parent.getHeight() - (5.0 + l.getPreferredSize().getHeight())));
                l.setSize(w - (ProductionWeeklyPlanTableHeader.this.getCellPadding() + ProductionWeeklyPlanTableHeader.this.getCellPadding()), (int)l.getPreferredSize().getHeight());
                currentWidth += w;
                ++currentIndex;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)((double)ProductionWeeklyPlanTableHeader.this.getDefaultRowHeight() * 1.5));
        }
    }
}

