/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.rightdependant;

import ch.icit.pegasus.client.converter.AircraftConverter;
import ch.icit.pegasus.client.converter.AirportConverter;
import ch.icit.pegasus.client.converter.ArticleGroupConverter;
import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.FlightConverter;
import ch.icit.pegasus.client.converter.IngredientConverter;
import ch.icit.pegasus.client.converter.InventoryConverter;
import ch.icit.pegasus.client.converter.InventoryTransitionConverter;
import ch.icit.pegasus.client.converter.MealPlanConverter;
import ch.icit.pegasus.client.converter.ProductCatalogConverter;
import ch.icit.pegasus.client.converter.ProductVariantConverter;
import ch.icit.pegasus.client.converter.ProductViewConverter;
import ch.icit.pegasus.client.converter.RecipeConverter;
import ch.icit.pegasus.client.converter.ReorderLevelConverter;
import ch.icit.pegasus.client.converter.RestaurantConverter;
import ch.icit.pegasus.client.converter.SafetyStockConverter;
import ch.icit.pegasus.client.converter.StorePositionConverter;
import ch.icit.pegasus.client.converter.StoreViewConverter;
import ch.icit.pegasus.client.converter.StowingListNameConverter;
import ch.icit.pegasus.client.converter.SupplierConverter;
import ch.icit.pegasus.client.converter.TruckConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.iconmapper.IconMapper;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDField;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.ordering.articlegroup.ArticleGroupLight;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelLight;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockLight;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;

public class RDSearchTextField2<T extends IDTO>
extends RDField<SearchTextField2<T>, TextLabel> {
    private static final long serialVersionUID = 1L;
    private Converter converter;
    private SearchTypes st;
    private Object[] additionals;
    private Class<IconMapper> iconMapping;
    private SearchTextField2Listener listener;
    private List<ADTO> doNotMerge;
    private boolean isDeletable;

    public RDSearchTextField2(RDProvider provider, SearchTypes searchType, boolean isDeletable) {
        super(provider);
        this.isDeletable = isDeletable;
        this.st = searchType;
    }

    public RDSearchTextField2(RDProvider provider, SearchTypes searchType) {
        this(provider, searchType, false);
    }

    @Override
    public Dimension getNodeLessPreferredSize() {
        int h = ((Skin3Field)DefaultSkins.SearchFieldTexture.createDynamicSkin()).getImageLeft(Button.ButtonState.UP).getHeight();
        return new Dimension(h, h);
    }

    @Override
    public SearchTextField2<T> createEditor(Node<?> node) {
        SearchTextField2 w = null;
        w = this.createField(this.st, node);
        if (w != null) {
            if (this.doNotMerge != null) {
                w.setDoNotMergeDTOs(this.doNotMerge);
            }
            w.setIconMapperClass(this.iconMapping);
            w.setAdditionalSearchField(this.additionals);
            if (this.converter != null) {
                w.setDefaultEntryConverter(this.converter);
                w.setDefaultViewConverter(this.converter);
            }
            if (this.listener != null) {
                w.addSearchTextFieldListener(this.listener);
            }
            w.setEnabled(this.isEnabled);
        }
        return w;
    }

    private SearchTextField2 createField(SearchTypes type, Node n) {
        switch (type) {
            case RESTAURANT: {
                return SearchTextField2Factory.getRestaurantSearch(this.isDeletable, (Node<RestaurantComplete>)n);
            }
            case ARTICLE_GROUP: {
                return SearchTextField2Factory.getArticleGroupSearch(this.isDeletable, (Node<ArticleGroupLight>)n);
            }
            case SAFETY_STOCK: {
                return SearchTextField2Factory.getSafetyStockSearch(this.isDeletable, (Node<SafetyStockLight>)n);
            }
            case REORDER_LEVEL: {
                return SearchTextField2Factory.getReorderLevelSearch(this.isDeletable, (Node<ReorderLevelLight>)n);
            }
            case AIRCRAFT: {
                return SearchTextField2Factory.getAircraftSearchField(this.isDeletable, n);
            }
            case AIRPORT: {
                return SearchTextField2Factory.getAirportSearchField(this.isDeletable, n);
            }
            case ALACARTE_CATALOG: {
                return SearchTextField2Factory.getALaCarteProductCatalogSearchField(this.isDeletable, n);
            }
            case ARTICLE: {
                return SearchTextField2Factory.getBasicArticleSearchField(this.isDeletable, n);
            }
            case CUSTOMER: {
                return SearchTextField2Factory.getCustomerSearchField(this.isDeletable, n);
            }
            case DEFAULT_CATALOG: {
                return SearchTextField2Factory.getStandardProductCatalogSearchField(this.isDeletable, n);
            }
            case INGREDIENT: {
                return SearchTextField2Factory.getIngredientSearchField(this.isDeletable, n);
            }
            case MEALPLAN: {
                return SearchTextField2Factory.getMealplanSearchField(this.isDeletable, n);
            }
            case PRODUCT: {
                return SearchTextField2Factory.getProductSearchField(this.isDeletable, n);
            }
            case RECIPE: {
                return SearchTextField2Factory.getRecipeSearchField(this.isDeletable, n);
            }
            case SPML_CATALOG: {
                return SearchTextField2Factory.getSPMLProductCatalogSearchField(this.isDeletable, n);
            }
            case STORE: {
                return SearchTextField2Factory.getStoreSearchField(this.isDeletable, n);
            }
            case STOREPOSITION: {
                return SearchTextField2Factory.getStorePositionSearchField(this.isDeletable, n);
            }
            case STOWINGLIST: {
                return SearchTextField2Factory.getStowingSearchField(this.isDeletable, n);
            }
            case STOWINGLIST_TEMPLATE: {
                return SearchTextField2Factory.getStowingTemplateSearchField(this.isDeletable, n);
            }
            case SUPPLIER: {
                return SearchTextField2Factory.getSupplierSearchField(this.isDeletable, n);
            }
            case INVENTORY_TRANSITION: {
                return SearchTextField2Factory.getInventoryTransitionSearchField(this.isDeletable, n);
            }
            case PRODUCT_VARIANT: {
                return SearchTextField2Factory.getProductVariantSearchField(this.isDeletable, n);
            }
            case INVENTORY: {
                return SearchTextField2Factory.getInventorySearchField(this.isDeletable, (Node<InventoryLight>)n);
            }
            case FLIGHT: {
                return SearchTextField2Factory.getFlightSearchField(this.isDeletable, n);
            }
            case USER: {
                return SearchTextField2Factory.getUserSearchField(this.isDeletable, n);
            }
            case TRUCK: {
                return SearchTextField2Factory.getTruckSearchField(this.isDeletable, n);
            }
            case PURCHASE_ORDER: {
                return SearchTextField2Factory.getPurchaseOrderSearchField(this.isDeletable, n);
            }
        }
        return null;
    }

    private void update(SearchTypes type, SearchTextField2 textField) {
        switch (this.st) {
            case RESTAURANT: {
                SearchTextField2Factory.config2RestaurantSearchField(textField);
                break;
            }
            case REORDER_LEVEL: {
                SearchTextField2Factory.config2ReorderLevelSearchField(textField);
                break;
            }
            case SAFETY_STOCK: {
                SearchTextField2Factory.config2SafetyStockSearchField(textField);
                break;
            }
            case ARTICLE_GROUP: {
                SearchTextField2Factory.config2ArticleGroupSearchField(textField);
                break;
            }
            case ARTICLE: {
                SearchTextField2Factory.config2BasicArticleSearchField(textField, false);
                break;
            }
            case CUSTOMER: {
                SearchTextField2Factory.config2CustomerSearchField(textField);
                break;
            }
            case SUPPLIER: {
                SearchTextField2Factory.config2SupplierSearchField(textField);
                break;
            }
            case STORE: {
                SearchTextField2Factory.config2StoreSearchField(textField);
                break;
            }
            case PRODUCT: {
                SearchTextField2Factory.config2ProductSearchField(textField);
                break;
            }
            case RECIPE: {
                SearchTextField2Factory.config2RecipeSearchField(textField);
                break;
            }
            case STOREPOSITION: {
                SearchTextField2Factory.config2StorePositionSearchField(textField);
                break;
            }
            case INGREDIENT: {
                SearchTextField2Factory.config2IngredientSearchField(textField);
                break;
            }
            case AIRCRAFT: {
                SearchTextField2Factory.config2AircraftSearchField(textField);
                break;
            }
            case MEALPLAN: {
                SearchTextField2Factory.config2MealplanSearchField(textField);
                break;
            }
            case STOWINGLIST: {
                SearchTextField2Factory.config2StowingSearchField(textField);
                break;
            }
            case STOWINGLIST_TEMPLATE: {
                SearchTextField2Factory.config2StowingTemplateSearchField(textField);
                break;
            }
            case AIRPORT: {
                SearchTextField2Factory.config2AirportSearchField(textField);
                break;
            }
            case DEFAULT_CATALOG: {
                SearchTextField2Factory.config2StandardProductCatalogSearchField(textField);
                break;
            }
            case ALACARTE_CATALOG: {
                SearchTextField2Factory.config2aLaCarteProductCatalogSearchField(textField);
                break;
            }
            case SPML_CATALOG: {
                SearchTextField2Factory.config2SPMLProductCatalogSearchField(textField);
                break;
            }
            case INVENTORY_TRANSITION: {
                SearchTextField2Factory.config2InventoryTransitionSearchField(textField);
                break;
            }
            case PRODUCT_VARIANT: {
                SearchTextField2Factory.config2ProductVariantSearchField(textField);
                break;
            }
            case INVENTORY: {
                SearchTextField2Factory.config2InventorySearchField(textField);
                break;
            }
            case FLIGHT: {
                SearchTextField2Factory.config2FlightSearchField(textField);
                break;
            }
            case USER: {
                SearchTextField2Factory.config2UserSearchField(textField);
                break;
            }
            case TRUCK: {
                SearchTextField2Factory.config2TruckSearchField(textField);
                break;
            }
            case PURCHASE_ORDER: {
                SearchTextField2Factory.config2PurchaseOrderSearchField(textField);
            }
        }
    }

    @Override
    public TextLabel createRenderer(Node<?> node) {
        TextLabel t = null;
        switch (this.st) {
            case RESTAURANT: {
                t = new TextLabel(node, ConverterRegistry.getConverter(RestaurantConverter.class));
                break;
            }
            case ARTICLE_GROUP: {
                t = new TextLabel(node, ConverterRegistry.getConverter(ArticleGroupConverter.class));
                break;
            }
            case SAFETY_STOCK: {
                t = new TextLabel(node, ConverterRegistry.getConverter(SafetyStockConverter.class));
                break;
            }
            case REORDER_LEVEL: {
                t = new TextLabel(node, ConverterRegistry.getConverter(ReorderLevelConverter.class));
                break;
            }
            case ARTICLE: {
                t = new TextLabel(node, ConverterRegistry.getConverter(BasicArticleConverter.class));
                break;
            }
            case CUSTOMER: {
                t = new TextLabel(node, ConverterRegistry.getConverter(CustomerConverter.class));
                break;
            }
            case SUPPLIER: {
                t = new TextLabel(node, ConverterRegistry.getConverter(SupplierConverter.class));
                break;
            }
            case STORE: {
                t = new TextLabel(node, ConverterRegistry.getConverter(StoreViewConverter.class));
                break;
            }
            case PRODUCT: {
                t = new TextLabel(node, ConverterRegistry.getConverter(ProductViewConverter.class));
                break;
            }
            case RECIPE: {
                t = new TextLabel(node, ConverterRegistry.getConverter(RecipeConverter.class));
                break;
            }
            case STOREPOSITION: {
                t = new TextLabel(node, ConverterRegistry.getConverter(StorePositionConverter.class));
                break;
            }
            case INGREDIENT: {
                t = new TextLabel(node, ConverterRegistry.getConverter(IngredientConverter.class));
                break;
            }
            case AIRCRAFT: {
                t = new TextLabel(node, ConverterRegistry.getConverter(AircraftConverter.class));
                break;
            }
            case MEALPLAN: {
                t = new TextLabel(node, ConverterRegistry.getConverter(MealPlanConverter.class));
                break;
            }
            case STOWINGLIST: {
                t = new TextLabel(node, ConverterRegistry.getConverter(StowingListNameConverter.class));
                break;
            }
            case STOWINGLIST_TEMPLATE: {
                t = new TextLabel(node, ConverterRegistry.getConverter(StowingListNameConverter.class));
                break;
            }
            case AIRPORT: {
                t = new TextLabel(node, ConverterRegistry.getConverter(AirportConverter.class));
                break;
            }
            case ALACARTE_CATALOG: 
            case DEFAULT_CATALOG: 
            case SPML_CATALOG: {
                t = new TextLabel(node, ConverterRegistry.getConverter(ProductCatalogConverter.class));
                break;
            }
            case INVENTORY_TRANSITION: {
                t = new TextLabel(node, ConverterRegistry.getConverter(InventoryTransitionConverter.class));
                break;
            }
            case PRODUCT_VARIANT: {
                t = new TextLabel(node, ConverterRegistry.getConverter(ProductVariantConverter.class));
                break;
            }
            case INVENTORY: {
                t = new TextLabel(node, ConverterRegistry.getConverter(InventoryConverter.class));
                break;
            }
            case FLIGHT: {
                t = new TextLabel(node, ConverterRegistry.getConverter(FlightConverter.class));
                break;
            }
            case USER: {
                t = new TextLabel(node, ConverterRegistry.getConverter(UserConverter.class));
                break;
            }
            case TRUCK: {
                t = new TextLabel(node, ConverterRegistry.getConverter(TruckConverter.class));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Search Field Type found");
            }
        }
        if (this.converter != null) {
            t.setViewConverter(this.converter);
        }
        t.setReadOnlyTextField(true);
        t.setEnabled(this.isEnabled);
        return t;
    }

    public void addSearchTextFieldListener(SearchTextField2Listener basicDetailsPanel) {
        if (this.wField != null) {
            ((SearchTextField2)this.wField).addSearchTextFieldListener(basicDetailsPanel);
        }
        this.listener = basicDetailsPanel;
    }

    public boolean isItemSelected() {
        if (this.wField != null) {
            return ((SearchTextField2)this.wField).isItemSelected();
        }
        if (this.rField != null) {
            return !((TextLabel)this.rField).getText().isEmpty();
        }
        return false;
    }

    public void setSelectiveDelegation(Selectable supplierDetailsTableRowImpl) {
        if (this.wField != null) {
            ((SearchTextField2)this.wField).setSelectiveDelegation(supplierDetailsTableRowImpl);
        }
    }

    public Component getTextField() {
        if (this.wField != null) {
            return ((SearchTextField2)this.wField).getTextField();
        }
        return null;
    }

    public void setAdditionalSearchField(Object[] o) {
        this.additionals = o;
        if (this.wField != null) {
            ((SearchTextField2)this.wField).setAdditionalSearchField(this.additionals);
        }
    }

    public void setSearchType(SearchTypes article) {
        this.st = article;
        if (this.wField != null) {
            this.update(this.st, (SearchTextField2)this.wField);
        }
    }

    public void tryToSelectOne(boolean isProxy) {
        if (this.wField != null) {
            ((SearchTextField2)this.wField).tryToSelectOne(isProxy);
        }
    }

    public boolean isInnerComponent(Component c) {
        if (this.wField != null) {
            return ((SearchTextField2)this.wField).isInnerComponent(c);
        }
        return false;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setIconMapperClass(Class<? extends IconMapper> class1) {
        if (this.wField != null) {
            ((SearchTextField2)this.wField).setIconMapperClass(class1);
        }
        this.iconMapping = class1;
    }

    public void setDoNotMerges(List<ADTO> value) {
        this.doNotMerge = value;
        if (this.wField != null) {
            ((SearchTextField2)this.wField).setDoNotMergeDTOs(this.doNotMerge);
        }
    }

    public static enum SearchTypes {
        ARTICLE,
        CUSTOMER,
        SUPPLIER,
        STORE,
        PRODUCT,
        STOREPOSITION,
        INGREDIENT,
        AIRCRAFT,
        MEALPLAN,
        STOWINGLIST,
        STOWINGLIST_TEMPLATE,
        AIRPORT,
        DEFAULT_CATALOG,
        SPML_CATALOG,
        ALACARTE_CATALOG,
        INVENTORY_TRANSITION,
        SAFETY_STOCK,
        REORDER_LEVEL,
        ARTICLE_GROUP,
        PRODUCT_VARIANT,
        RESTAURANT,
        INVENTORY,
        FLIGHT,
        USER,
        TRUCK,
        RECIPE,
        PURCHASE_ORDER;

    }
}

