/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.ScreenViewProvider;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.StowingListTemplateVariantConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchList;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Screen;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightScheduleAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class StowingListVariantTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private final MainFrame mainFrame;
    private final InnerPopUp2 usedPopup;
    private SubModuleAccessDefinition toolFlightScheduleStowingEditorReal;

    public StowingListVariantTable(MainFrame mainFrame, InnerPopUp2 usedPopup, SubModuleAccessDefinition toolFlightScheduleStowingEditorReal) {
        super(false, "", false, false);
        this.mainFrame = mainFrame;
        this.usedPopup = usedPopup;
        this.toolFlightScheduleStowingEditorReal = toolFlightScheduleStowingEditorReal;
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                StowingListVariantTable.this.getParent().revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                DTOProxyNode node = new DTOProxyNode();
                StowingListVariantTable.this.getModel().getNode().addChild((Node)node, 0L);
                StowingListVariantTable.this.getParent().revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo(Words.VALIDITY, null, null, null, "", TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        int tw = 100 + 2 * this.getCellPadding();
        columns.add(new TableColumnInfo(Words.EDIT, null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.setComparator((o1, o2) -> {
            TableRowImpl t1 = (TableRowImpl)o1;
            TableRowImpl t2 = (TableRowImpl)o2;
            StowingListTemplateVariantLight v1 = (StowingListTemplateVariantLight)t1.getModel().getNode().getValue(StowingListTemplateVariantLight.class);
            StowingListTemplateVariantLight v2 = (StowingListTemplateVariantLight)t2.getModel().getNode().getValue(StowingListTemplateVariantLight.class);
            return v1.getValidityPeriod().getStartDate().compareTo(v2.getValidityPeriod().getStartDate());
        });
    }

    public void loadScreen(SubModuleDefinitionComplete m, int x, int y, Component invoker, BatchList<?, ?> batchList, Node selectedVariant) {
        String screenName;
        Screen screen;
        ThreadSafeLoader.clearLoadingList();
        MainFrame mf = this.mainFrame;
        if (mf != null && (screen = (Screen)ScreenViewProvider.forName(HUDToolkit.getScreenClassForInvoker(screenName = m.getInvokingName()), this.mainFrame, m.getDisplayName(), this.mainFrame.getCurrenScreen(), selectedVariant)) != null && screen instanceof Screen) {
            this.mainFrame.showScreen(screen, HUDToolkit.getScreenClassForInvoker(screenName));
        }
    }

    public void setNode(Node<?> node) {
        this.getModel().setNode(node);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel name;
        private TextLabel period;
        private TextButton enterButton;
        private Runnable runnerLambda;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            Converter converter = ConverterRegistry.getConverter(StowingListTemplateVariantConverter.class);
            this.name = new TextLabel(m.getNode(), converter);
            this.enterButton = new TextButton("Enter");
            this.period = new TextLabel(m.getNode().getChildNamed(StowingListTemplateVariantLight_.validityPeriod), ConverterRegistry.getConverter(PeriodConverter.class));
            this.enterButton.addButtonListener((source, x, y) -> {
                StowingListVariantTable.this.loadScreen(FlightScheduleAccess.getSubModuleDefinition((SubModuleAccessDefinition)StowingListVariantTable.this.toolFlightScheduleStowingEditorReal), 0, 0, this, null, m.getNode());
                StowingListVariantTable.this.usedPopup.hidePopUp(new Object[0]);
            });
            this.setLayout(new Layout());
            this.add(this.name);
            this.add(this.period);
            this.add(this.enterButton);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.enterButton.kill();
            this.name.kill();
            this.period.kill();
            this.name = null;
            this.enterButton = null;
            this.period = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.enterButton);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.name.setEnabled(isEnabled);
            this.enterButton.setEnabled(isEnabled);
            this.period.setEnabled(isEnabled);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.period.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.period.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.period.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.period.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.enterButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.enterButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.enterButton.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                TableRowImpl.this.setControlsX(currentX);
            }
        }
    }
}

