/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.PriceConverter2;
import ch.icit.pegasus.client.converter.ProductCategoryConverter;
import ch.icit.pegasus.client.converter.ProductTypeConverter;
import ch.icit.pegasus.client.converter.ProductViewConverter;
import ch.icit.pegasus.client.converter.ServiceTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterManMinutesPriceComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.SalesPriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.CateringPointCostComplete;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.MealPlanAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductCatalogAccess;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.utils.ExcelRow;
import java.sql.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ProductToolkit {
    public static final int VALIDITY = 3;
    public static final int SALES_PRICE = 5;
    public static final int CATEGORY = 7;
    public static final int TYPE = 11;
    public static final int SERVICE_TYPE = 13;
    public static final int CYCLE = 17;
    public static final int STATE = 19;
    public static final int HINT = 23;

    public static boolean canExportFlightProductCosts() {
        UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        ModuleAccessRightComplete r = HUDToolkit.getCurrentAccessRight(FlightAccess.MODULE_FLIGHT, user);
        boolean showProductionCosts = false;
        if (r != null) {
            for (DataFieldAccessRightComplete a : r.getFieldAccessRights()) {
                if (!a.getField().getName().equals("exportProductionCosts")) continue;
                showProductionCosts = true;
            }
        }
        return showProductionCosts;
    }

    public static boolean canExportProductCosts(boolean fromCatalog) {
        UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        ModuleAccessRightComplete r = HUDToolkit.getCurrentAccessRight(fromCatalog ? ProductCatalogAccess.MODULE_PRODUCT_CATALOG : ProductAccess.MODULE_PRODUCT, user);
        boolean showProductionCosts = false;
        if (r != null) {
            for (DataFieldAccessRightComplete a : r.getFieldAccessRights()) {
                if (!a.getField().getName().equals("exportProductionCosts")) continue;
                showProductionCosts = true;
            }
        }
        return showProductionCosts;
    }

    public static boolean canExportMealPlanProductCosts() {
        UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        ModuleAccessRightComplete r = HUDToolkit.getCurrentAccessRight(MealPlanAccess.MODULE_MEAL_PLAN, user);
        boolean showProductionCosts = false;
        if (r != null) {
            for (DataFieldAccessRightComplete a : r.getFieldAccessRights()) {
                if (!a.getField().getName().equals("exportProductionCosts")) continue;
                showProductionCosts = true;
            }
        }
        return showProductionCosts;
    }

    public static boolean canExportTenderProductCosts() {
        UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        ModuleAccessRightComplete r = HUDToolkit.getCurrentAccessRight(FlightAccess.MODULE_FLIGHT, user);
        boolean showProductionCosts = false;
        if (r != null) {
            for (DataFieldAccessRightComplete a : r.getFieldAccessRights()) {
                if (!a.getField().getName().equals("exportTenderVariants")) continue;
                showProductionCosts = true;
            }
        }
        return showProductionCosts;
    }

    public static ExcelRow fillDefaultHeader(ExcelRow r) {
        return ProductToolkit.fillDefaultHeader(r, false);
    }

    public static ExcelRow fillDefaultHeader(ExcelRow r, boolean withProduct) {
        if (r == null) {
            r = new ExcelRow(true);
        }
        r.addCell((Object)(withProduct ? "Product No" : "No"), new String[0]);
        r.addCell((Object)"CIN", new String[0]);
        r.addCell((Object)(withProduct ? "Product Name" : "Name"), new String[0]);
        r.addCell((Object)"Allergen Info Sheet Name", new String[0]);
        r.addCell((Object)(withProduct ? "Product Category" : "Category"), new String[0]);
        r.addCell((Object)(withProduct ? "Product Group" : "Group"), new String[0]);
        r.addCell((Object)"Validity Start", new String[0]);
        r.addCell((Object)"Validity End", new String[0]);
        r.addCell((Object)(withProduct ? "Product Customer" : "Customer"), new String[0]);
        r.addCell((Object)"Recipe", new String[0]);
        r.addCell((Object)"RC", new String[0]);
        r.addCell((Object)"Sob", new String[0]);
        r.addCell((Object)(withProduct ? "Product Bonded" : "Bonded"), new String[0]);
        r.addCell((Object)"Auto Checkout", new String[0]);
        return r;
    }

    public static void fillDefault(ExcelRow r, ProductVariantComplete variant) {
        r.addCell((Object)variant.getProduct().getNumber(), new String[0]);
        r.addCell((Object)variant.getCustomerProductNumber(), new String[0]);
        r.addCell((Object)variant.getName(), new String[0]);
        r.addCell((Object)variant.getPaxName(), new String[0]);
        r.addCell((Object)ProductToolkit.getCategory(variant.getCategory()), new String[0]);
        r.addCell((Object)ProductToolkit.getgroup(variant.getCategory()), new String[0]);
        r.addCell((Object)variant.getValidityPeriod().getStartDate(), new String[0]);
        r.addCell((Object)variant.getValidityPeriod().getEndDate(), new String[0]);
        r.addCell((Object)variant.getProduct().getCustomer().getCode(), new String[0]);
        if (variant instanceof ComplexProductVariantComplete) {
            r.addCell((Object)WordsToolkit.toLowerCase((String)Words.YES), new String[0]);
        } else {
            r.addCell((Object)WordsToolkit.toLowerCase((String)Words.NO_ANSWER), new String[0]);
        }
        if (variant.getProduct().getReturnsCountType() != null) {
            switch (variant.getProduct().getReturnsCountType()) {
                case NONE: {
                    r.addCell((Object)Words.NOT_COUNTED, new String[0]);
                    break;
                }
                case RETURN: {
                    r.addCell((Object)Words.RETURNSCOUNT, new String[0]);
                    break;
                }
                case UPLIFT: {
                    r.addCell((Object)Words.UPLIFTCOUNT, new String[0]);
                }
            }
        } else {
            r.addCell((Object)Words.NOT_COUNTED, new String[0]);
        }
        if (Boolean.TRUE.equals(variant.getProduct().getSalesOnBoard())) {
            r.addCell((Object)WordsToolkit.toLowerCase((String)Words.YES), new String[0]);
        } else {
            r.addCell((Object)WordsToolkit.toLowerCase((String)Words.NO_ANSWER), new String[0]);
        }
        if (Boolean.TRUE.equals(variant.getProduct().getBonded())) {
            r.addCell((Object)WordsToolkit.toLowerCase((String)Words.YES), new String[0]);
        } else {
            r.addCell((Object)WordsToolkit.toLowerCase((String)Words.NO_ANSWER), new String[0]);
        }
        if (Boolean.TRUE.equals(variant.getProduct().getAutoCheckout())) {
            r.addCell((Object)WordsToolkit.toLowerCase((String)Words.YES), new String[0]);
        } else {
            r.addCell((Object)WordsToolkit.toLowerCase((String)Words.NO_ANSWER), new String[0]);
        }
    }

    private static String getCategory(ProductCategoryLight cat) {
        ProductCategoryLight c = cat;
        while (c.getParent() != null) {
            c = c.getParent();
        }
        return c.getName();
    }

    private static String getgroup(ProductCategoryLight cat) {
        return cat.getName();
    }

    public static String createProcessCostInfoButton(CateringPointCostComplete value, Node<CateringPointCostComplete> node) {
        Converter c;
        String tt;
        Converter cc = ConverterRegistry.getConverter(CostCenterConverter.class);
        String t = "<b>Catering Point Costs for " + (String)cc.convert((Object)value.getCostCenter(), node.getChildNamed(new String[]{"costCenter"}), new Object[0]) + "<br/><hr/></b><br/>";
        t = t + "<b>Cost per Man Hour</b>";
        Date today = new Date(System.currentTimeMillis());
        PriceComplete price = null;
        if (node.getChildNamed(new String[]{"costCenter"}).getValue() instanceof InternalCostCenterComplete) {
            InternalCostCenterComplete costCenter = (InternalCostCenterComplete)node.getChildNamed(new String[]{"costCenter"}).getValue();
            for (InternalCostCenterManMinutesPriceComplete pricePerHour : costCenter.getPricePerHour()) {
                if (!pricePerHour.getValidity().within(today).booleanValue()) continue;
                price = pricePerHour.getPricePerHour();
            }
        }
        if (price == null) {
            price = new PriceComplete();
        }
        if ((tt = (String)(c = ConverterRegistry.getConverter(PriceConverter2.class)).convert((Object)price, null, new Object[0])) == null || tt.trim().isEmpty()) {
            tt = "no Price set";
        }
        tt = "<ul><li>" + tt + "</li></ul>";
        t = t + tt;
        return t;
    }

    public static String getCycleDescriptionString() {
        String t = "<b>Cycle Descriptor<br/><hr/></b><ul>";
        t = t + "<li>to add a range of Cycles use 1-3</li>";
        t = t + "<li>to add single Cycle use 1,2,3</li>";
        t = t + "<li>use any combination like 1-3,8,10-12</li>";
        t = t + "<li>Cycle 0 means all Cycles with 0</li>";
        t = t + "<li>empty Cycle description selects all Cycles</li>";
        t = t + "</ul>";
        return t;
    }

    public static String getStringRangeDescription() {
        String t = "<b>Descriptor<br/><hr/></b><ul>";
        t = t + "<li>to add a range of Numbers use 1-3</li>";
        t = t + "<li>to add single Number use 1,2,3</li>";
        t = t + "<li>use any combination like 1-3,8,10-12</li>";
        t = t + "</ul>";
        return t;
    }

    public static String getProductInfoString(ProductComplete p, int magicNumber) {
        return ProductToolkit.getProductInfoString(p, p.getCurrentVariant(), magicNumber);
    }

    public static String getAdditionalInfoString(SalesPriceFactorComplete factor) {
        String t = "";
        t = t + "<b>" + factor.getName() + "<b><hr/><br/>";
        if (Boolean.TRUE.equals(factor.getUseVariantsPricing())) {
            t = t + "<b>Use Variant Price from Master Data</b><br/>";
        } else {
            t = t + "<b>Default Value</b><br/>";
            t = t + "<ul><li>" + factor.getDefaultValue() + " %</li></ul>";
            t = t + "<b>Code</b><br/>";
            t = t + "<ul><li>" + factor.getCode() + "</li></ul>";
        }
        return t;
    }

    public static String getProductInfoString(ProductComplete p, ProductVariantLight variant, int magicNumber) {
        Converter typeConverter;
        String t = "";
        if (p == null) {
            return "Product not set";
        }
        Converter conv = ConverterRegistry.getConverter(ProductViewConverter.class);
        String tlop = (String)conv.convert((Object)p, null, new Object[0]);
        if (tlop != null && !tlop.isEmpty()) {
            t = t + "<b>" + tlop + "</b><br/><hr/><br/>";
        }
        Converter c = ConverterRegistry.getConverter(PeriodConverter.class);
        if (magicNumber % 3 == 0) {
            t = t + "<b>Product Validity</b><ul>";
            t = t + "<li>" + (String)c.convert((Object)p.getPeriod(), null, new Object[0]);
            t = t + "</li></ul>";
        }
        t = t + "<b>Current Variant validity</b><ul>";
        t = t + "<li>" + (String)c.convert((Object)variant.getValidityPeriod(), null, new Object[0]);
        t = t + "</li></ul>";
        if (magicNumber % 5 == 0) {
            Converter costConverter = ConverterRegistry.getConverter(PriceConverter1.class);
            t = t + "<b>Sales Price</b><ul>";
            t = t + "<li>" + (String)costConverter.convert((Object)variant.getSalesPrice(), null, new Object[0]);
            t = t + "</li></ul>";
        }
        if (magicNumber % 7 == 0) {
            Converter catConverter = ConverterRegistry.getConverter(ProductCategoryConverter.class);
            t = t + "<b>Category</b><ul>";
            t = t + "<li>" + (String)catConverter.convert((Object)variant.getCategory(), null, new Object[0]);
            t = t + "</li></ul>";
        }
        if (magicNumber % 11 == 0) {
            typeConverter = ConverterRegistry.getConverter(ProductTypeConverter.class);
            t = t + "<b>Production Type</b><ul>";
            t = t + "<li>" + (String)typeConverter.convert((Object)variant.getType(), null, new Object[0]);
            t = t + "</li></ul>";
        }
        if (magicNumber % 13 == 0) {
            typeConverter = ConverterRegistry.getConverter(ServiceTypeConverter.class);
            t = t + "<b>Service Types</b><ul>";
            for (CateringServiceTypeComplete type : variant.getServiceTypes()) {
                t = t + "<li>" + (String)typeConverter.convert((Object)type, null, new Object[0]) + "</li>";
            }
            t = t + "</ul>";
        }
        if (magicNumber % 17 == 0) {
            t = t + "<b>Cycle</b><ul>";
            t = t + "<li>" + variant.getProductCycle();
            t = t + "</li></ul>";
        }
        if (magicNumber % 19 == 0) {
            c = ConverterRegistry.getConverter(ModificationStateEConverter.class);
            t = t + "<b>State</b><ul>";
            t = t + "<li>" + (String)c.convert((Object)variant.getState(), null, new Object[0]);
            t = t + "</li></ul>";
        }
        if (magicNumber % 23 == 0) {
            t = t + "<b>Hint</b><ul>";
            t = variant.getAdditionalComment() != null ? (!variant.getAdditionalComment().isEmpty() ? t + "<li>" + variant.getAdditionalComment() : t + "<li>not set") : t + "<li>not set";
            t = t + "</li></ul>";
        }
        return t;
    }

    public static int getAllTypes() {
        return 111546435;
    }

    public static void validateProduct(Node<ProductComplete> node, RDProvider provider, List<ScreenValidationObject> o) {
        if (provider.isWritable("customer") && node.getChildNamed(new String[]{"customer"}).getValue() == null) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Customer must be set"));
        }
        Iterator it = node.getChildNamed(new String[]{"variants"}).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (!(n.getValue(ProductVariantComplete.class) instanceof ProductVariantComplete)) continue;
            String variantName = "";
            DateConverter cd = (DateConverter)ConverterRegistry.getConverter(DateConverter.class);
            variantName = "Variant (" + cd.convert(n.getChildNamed(new String[]{"validityPeriod-startDate"}).getValue(), null, new Object[0]);
            variantName = variantName + " - " + cd.convert(n.getChildNamed(new String[]{"validityPeriod-endDate"}).getValue(), null, new Object[0]);
            variantName = variantName + "): ";
            if (provider.isWritable("state") && n.getChildNamed(new String[]{"state"}).getValue() == null) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, variantName + "State must be set"));
            }
            if (provider.isWritable("name") && (n.getChildNamed(new String[]{"name"}).getValue() == null || ((String)n.getChildNamed(new String[]{"name"}).getValue()).isEmpty())) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, variantName + "Product Name must be set"));
            }
            if (provider.isWritable("shortName") && n.getChildNamed(new String[]{"state"}).getValue() != ModificationStateE.ACCEPTED) {
                if (n.getChildNamed(new String[]{"labelName"}).getValue() == null) {
                    o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, variantName + "Product Label Name must be set"));
                } else if (((String)n.getChildNamed(new String[]{"labelName"}).getValue()).isEmpty()) {
                    o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, variantName + "Product Label Name must be set"));
                }
            }
            boolean valid = true;
            boolean notSet = false;
            HashSet<HandlingCostComplete> handlingCost = new HashSet<HandlingCostComplete>();
            Iterator it2 = n.getChildNamed(new String[]{"handlingCosts"}).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node nn = (Node)it2.next();
                HandlingCostComplete hc = (HandlingCostComplete)nn.getValue();
                if (hc == null) {
                    notSet = true;
                    continue;
                }
                if (handlingCost.add(hc)) continue;
                valid = false;
            }
            if (notSet) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, variantName + "Review Handling Costs. Select a Cost for each entry in list."));
            }
            if (!valid) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, variantName + "Review Handling Costs. Each handling cost is only allowed once per variant."));
            }
            if (n.getValue(SimpleProductVariantComplete.class) != null && provider.isWritable("article") && n.getChildNamed(new String[]{"component-article"}).getValue() == null) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, variantName + "Article must be set"));
            }
            if (!Boolean.TRUE.equals(node.getChildNamed(ProductComplete_.salesOnBoard).getValue())) continue;
        }
    }
}

