/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;

public class UnitToolkit {
    public static Node<?> getAllUnits() {
        ViewNode n = new ViewNode("");
        Node list = NodeToolkit.getAffixList(UnitSystemComplete.class);
        Iterator it = list.getChilds();
        while (it.hasNext()) {
            Node currentSystem = (Node)it.next();
            Node n2 = currentSystem.getChildNamed(new String[]{"maxUnit"});
            List<Node<UnitComplete>> l = UnitToolkit.generateUnitView((Node<UnitComplete>)n2, null, null, true);
            for (Node<UnitComplete> ll : l) {
                Iterator it2 = n.getChilds();
                boolean found = false;
                while (it2.hasNext()) {
                    Node nn = (Node)it2.next();
                    if (nn.getValue() == null || !nn.getValue().equals(ll.getValue())) continue;
                    found = true;
                }
                if (found) continue;
                n.addChild(ll, 0L);
            }
        }
        return n;
    }

    private static boolean isLowerUnit(UnitComplete currentUnit, UnitComplete exceptioUnit) {
        for (UnitComplete c = currentUnit.getSuperUnit(); c != null; c = c.getSuperUnit()) {
            if (!c.equals((Object)exceptioUnit)) continue;
            return true;
        }
        return false;
    }

    public static UnitComplete getNotUsedUnit(UnitComplete ... u) {
        Iterator it = NodeToolkit.getAffixList(UnitComplete.class).getChilds();
        while (it.hasNext()) {
            Node a = (Node)it.next();
            boolean found = false;
            for (UnitComplete unit : u) {
                if (!((UnitComplete)a.getValue()).equals((Object)unit)) continue;
                found = true;
            }
            if (found) continue;
            return (UnitComplete)a.getValue();
        }
        return null;
    }

    public static List<Node<UnitComplete>> generateUnitView(Node<UnitComplete> unit, UnitComplete exception, List<Node<UnitComplete>> l, boolean recursive) {
        Node p;
        List<Node<UnitComplete>> list = null;
        list = l == null ? new ArrayList<Node<UnitComplete>>() : l;
        Node currentUnit = null;
        currentUnit = unit instanceof ProxyNode ? ((ProxyNode)unit).getRefNode() : unit;
        if (recursive) {
            for (p = currentUnit; p != null && p.getValue() != null && ((UnitComplete)p.getValue()).getSuperUnit() != null; p = p.getChildNamed(new String[]{"superUnit"})) {
            }
        }
        UnitToolkit.addIt(list, (Node<UnitComplete>)p, exception);
        return list;
    }

    private static void addIt(List<Node<UnitComplete>> list, Node<UnitComplete> p, UnitComplete exception) {
        boolean found = false;
        for (Node<UnitComplete> n : list) {
            for (UnitComplete o : n.getData()) {
                if (o == null || !o.equals(p.getValue())) continue;
                found = true;
            }
        }
        if (!found && p != null) {
            list.add(p);
            Node cu = p;
            if (cu.getChildNamed(new String[]{"subUnit"}) != null && cu.getChildNamed(new String[]{"subUnit"}).getValue() != null) {
                cu = cu.getChildNamed(new String[]{"subUnit"});
                UnitToolkit.addIt(list, (Node<UnitComplete>)cu, exception);
            }
        }
    }

    private static boolean isUnitContaining(UnitComplete sourceUnit, UnitComplete destUnit) {
        if (sourceUnit.equals((Object)destUnit)) {
            return true;
        }
        UnitComplete cu = sourceUnit;
        while (cu.getSuperUnit() != null) {
            if (cu.equals((Object)destUnit)) {
                return true;
            }
            cu = cu.getSuperUnit();
        }
        cu = sourceUnit;
        while (cu.getSubUnit() != null) {
            if (cu.equals((Object)destUnit)) {
                return true;
            }
            cu = cu.getSubUnit();
        }
        return false;
    }

    public static UnitSystemComplete getUnitSystem4Unit(UnitComplete unit) {
        Node n = NodeToolkit.getAffixList(UnitSystemComplete.class);
        if (n != null) {
            Iterator it = n.getChilds();
            while (it.hasNext()) {
                Node us = (Node)it.next();
                UnitSystemComplete usc = (UnitSystemComplete)us.getValue();
                UnitComplete tu = usc.getMaxUnit();
                while (!tu.equals((Object)unit) && tu.getSubUnit() != null) {
                    tu = tu.getSubUnit();
                }
                if (tu == null || !tu.equals((Object)unit)) continue;
                return usc;
            }
        }
        return null;
    }

    public static long convertDateDurationComplete2Millis(DateDurationComplete data) {
        long inMillis = 0L;
        long oneDay = 86400000L;
        switch (data.getUnit()) {
            case DAY: {
                inMillis = (long)((double)oneDay * data.getDuration());
                break;
            }
            case MONTH: {
                long oneMonth = 30L * oneDay;
                inMillis = (long)((double)oneMonth * data.getDuration());
                break;
            }
            case WEEK: {
                long oneWeek = oneDay * 7L;
                inMillis = (long)((double)oneWeek * data.getDuration());
                break;
            }
            case YEAR: {
                long oneYear = 365L * oneDay;
                inMillis = (long)((double)oneYear * data.getDuration());
            }
        }
        return inMillis;
    }

    public static Date createExpiryDate(BasicArticleComplete article, Timestamp validity) {
        long max = 0L;
        boolean isNever = false;
        for (SupplierConditionBaseComplete base : article.getSuppliers()) {
            for (SupplierConditionCategoryComplete category : base.getSupplierConditionCategory()) {
                for (SupplierConditionComplete condition : category.getConditions()) {
                    if (condition.getValidity().getStartDate().getTime() > validity.getTime() || condition.getValidity().getEndDate().getTime() < validity.getTime()) continue;
                    if (condition.getShelfLife() == null) {
                        Calendar a = TimeUtil.createCalendar();
                        a.set(5, 6);
                        a.set(2, 6);
                        a.set(1, 6666);
                        max = a.getTimeInMillis();
                        isNever = true;
                        continue;
                    }
                    long t = UnitToolkit.convertDateDurationComplete2Millis(condition.getShelfLife());
                    if (max >= t) continue;
                    max = t;
                }
            }
        }
        Date d = isNever ? new Date(max) : new Date(System.currentTimeMillis() + max);
        return d;
    }

    public static Date createExpiryDate(BasicArticleComplete article, SupplierLight supplier, Boolean useTaxZone, TaxZoneComplete taxZone, Timestamp validity) {
        long max = 0L;
        boolean isnever = false;
        SupplierConditionBaseComplete base = article.getSupplier((SupplierReference)supplier);
        if (base != null) {
            for (SupplierConditionCategoryComplete category : base.getSupplierConditionCategory()) {
                boolean taxZoneOk = false;
                if (Boolean.TRUE.equals(useTaxZone)) {
                    if (category.getTaxZone() != null && category.getTaxZone().equals((Object)taxZone)) {
                        taxZoneOk = true;
                    }
                    if (category.getTaxZone() == null && taxZone == null) {
                        taxZoneOk = true;
                    }
                } else {
                    taxZoneOk = true;
                }
                if (!taxZoneOk) continue;
                for (SupplierConditionComplete condition : category.getConditions()) {
                    if (condition.getValidity().getStartDate().getTime() > validity.getTime() || condition.getValidity().getEndDate().getTime() < validity.getTime()) continue;
                    if (condition.getShelfLife() == null) {
                        Calendar a = TimeUtil.createCalendar();
                        a.set(5, 6);
                        a.set(2, 6);
                        a.set(1, 6666);
                        max = a.getTimeInMillis();
                        isnever = true;
                        continue;
                    }
                    long t = UnitToolkit.convertDateDurationComplete2Millis(condition.getShelfLife());
                    if (max >= t) continue;
                    max = t;
                }
            }
        }
        Date d = null;
        d = isnever ? new Date(max) : new Date(System.currentTimeMillis() + max);
        return d;
    }

    public static boolean isSmaller(UnitComplete unit2Test, UnitComplete referenceUnit, BasicArticleComplete article) {
        UnitSystemComplete sy2;
        UnitSystemComplete sy1 = UnitToolkit.getUnitSystem4Unit(unit2Test);
        if (sy1.equals((Object)(sy2 = UnitToolkit.getUnitSystem4Unit(referenceUnit)))) {
            int a = 0;
            UnitComplete u1 = unit2Test;
            while (u1.getSuperUnit() != null) {
                ++a;
                u1 = u1.getSuperUnit();
            }
            int a2 = 0;
            UnitComplete u2 = referenceUnit;
            while (u2.getSuperUnit() != null) {
                ++a2;
                u2 = u2.getSuperUnit();
            }
            return a > a2;
        }
        for (PackagingQuantityBaseComplete baseComplete : article.getPackingQuantitiesVariants()) {
            for (PackagingQuantityComplete p : baseComplete.getPackingQuantities()) {
                UnitSystemComplete sy3 = UnitToolkit.getUnitSystem4Unit(p.getUnit());
                if (sy3.equals((Object)sy1)) {
                    return false;
                }
                if (!sy3.equals((Object)sy2)) continue;
                return true;
            }
        }
        return false;
    }

    public static UnitComplete getUnitForString(String string) {
        Node<?> units = UnitToolkit.getAllUnits();
        Iterator it2 = units.getChilds();
        while (it2.hasNext()) {
            UnitComplete unit = (UnitComplete)((Node)it2.next()).getValue();
            if (!unit.getShortName().equals(string)) continue;
            return unit;
        }
        throw new IllegalArgumentException("No Unit found for " + string);
    }

    public static Date getSelfLifeDate(ArticleCategoryLight category) {
        Date selfLifeDate = CalendarUtil.getInfinityDate();
        DateDurationComplete shelfLife = null;
        Boolean useShelfLife = category.getUseShelfLife();
        if (useShelfLife != null && useShelfLife.booleanValue()) {
            shelfLife = category.getShelfLife();
            selfLifeDate = new Date(System.currentTimeMillis());
            DateTime dt = new DateTime(selfLifeDate.getTime());
            DateTime dateTime = DateUtil.addPeriod((DateTime)dt, (DateDurationComplete)shelfLife);
            selfLifeDate = new Date(dateTime.getMillis());
        } else if (category.getParent() != null) {
            selfLifeDate = UnitToolkit.getSelfLifeDate((ArticleCategoryLight)category.getParent());
        }
        return selfLifeDate;
    }

    public static Boolean getSelfLifeMandatory(ArticleCategoryLight category) {
        Boolean shelfLifeManadatory = category.getShelfLifeMandatory();
        if (!(shelfLifeManadatory != null && shelfLifeManadatory.booleanValue() || category.getParent() == null)) {
            shelfLifeManadatory = UnitToolkit.getSelfLifeMandatory((ArticleCategoryLight)category.getParent());
        }
        if (shelfLifeManadatory == null) {
            shelfLifeManadatory = false;
        }
        return shelfLifeManadatory;
    }

    public static Date getExpiryDate(BasicArticleComplete artC, Timestamp selfLife) {
        Date exp = UnitToolkit.createExpiryDate(artC, selfLife);
        if (CalendarUtil.isInfinityDate((Date)exp)) {
            exp = UnitToolkit.getSelfLifeDate(artC.getCategory());
        }
        return exp;
    }

    public static Boolean checkSelfLifeDateIsSet(BasicArticleLight artC, Date selfLifeDate) {
        Boolean mandatory = UnitToolkit.getSelfLifeMandatory(artC.getCategory());
        if (CalendarUtil.isInfinityDate((Date)selfLifeDate) && mandatory.booleanValue()) {
            return true;
        }
        return false;
    }

    public static void loadUnits() throws ClientServerCallException {
        Node units = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(UnitComplete.class);
        Node unitSystems = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(UnitSystemComplete.class);
        for (UnitComplete unit : (List)units.getValue()) {
            unit.resolveReferences();
        }
        for (UnitComplete unit : (List)units.getValue()) {
            unit.resolveChilds();
        }
        for (UnitComplete unit : (List)units.getValue()) {
            unit.resolveParents();
        }
        for (UnitSystemComplete system : (List)unitSystems.getValue()) {
            system.resolveReferences();
        }
    }
}

