/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.utils;

import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCookingWasteVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticlePriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReturnsRateComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleTenderPriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorComplete;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorTenderVariantComplete;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorVariantComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collections;

public class ArticlePriceCalculationToolkit {
    public static PriceComplete getCheapestPurchasePrice(BasicArticleComplete article, CurrencyComplete baseCurrency, CurrencyVariantAccessor accessor, Timestamp validityDate) {
        PriceComplete c = new PriceComplete();
        c.setCurrency(baseCurrency);
        double costs = Double.MAX_VALUE;
        for (SupplierConditionBaseComplete base : article.getSuppliers()) {
            for (SupplierConditionCategoryComplete category : base.getSupplierConditionCategory()) {
                Collections.sort(category.getConditions());
                for (SupplierConditionComplete condition : category.getConditions()) {
                    if (condition.getValidity().getStartDate().getTime() > validityDate.getTime() || condition.getValidity().getEndDate().getTime() < validityDate.getTime() || condition.getStepPrice() == null || condition.getStepPrice().getSteps().size() <= 0) continue;
                    Double p = ((StepPriceFunctionComplete)condition.getStepPrice().getSteps().get(0)).getPrice().getPrice();
                    CurrencyComplete supCur = ((StepPriceFunctionComplete)condition.getStepPrice().getSteps().get(0)).getPrice().getCurrency();
                    if (p == null || supCur == null) continue;
                    double preis = p;
                    try {
                        CurrencyVariantComplete cv = (CurrencyVariantComplete)accessor.loadData(supCur, validityDate);
                        if (!((preis *= cv.getExchangeRate().doubleValue()) < costs)) continue;
                        costs = preis;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (costs == Double.MAX_VALUE) {
            costs = 0.0;
        }
        c.setPrice(Double.valueOf(costs));
        return c;
    }

    public static PriceComplete getMaterialPrice(Double enteredAmount, MaterialCostFactorComplete factor, CurrencyComplete baseCurrency) {
        PriceComplete p = new PriceComplete();
        p.setCurrency(baseCurrency);
        double a = enteredAmount * (factor.getValue() / 100.0);
        p.setPrice(Double.valueOf(a));
        return p;
    }

    public static PriceComplete getNettoPrice(BasicArticleLight article, java.util.Date validityDate, CustomerReference customer, boolean useTender) {
        return ArticlePriceCalculationToolkit.getNettoPrice(article, new Timestamp(validityDate.getTime()), customer, useTender);
    }

    public static PriceComplete getNettoPrice(BasicArticleLight article, Timestamp validityDate, CustomerReference customer, boolean useTender) {
        if (useTender) {
            return ArticlePriceCalculationToolkit.getTenderNettoPrice(article, validityDate, customer);
        }
        return ArticlePriceCalculationToolkit.getStdNettoPrice(article, validityDate);
    }

    private static PriceComplete getTenderNettoPrice(BasicArticleLight article, Timestamp validityDate, CustomerReference customer) {
        Collections.sort(article.getTenderPrices());
        if (customer != null) {
            for (BasicArticleTenderPriceComplete p : article.getTenderPrices()) {
                if (!customer.equals((Object)p.getCustomer()) || validityDate.getTime() < p.getValidity().getStartDate().getTime() || validityDate.getTime() > p.getValidity().getEndDate().getTime()) continue;
                return new PriceComplete(p.getPrice());
            }
        }
        for (BasicArticleTenderPriceComplete p : article.getTenderPrices()) {
            if (p.getCustomer() != null || validityDate.getTime() < p.getValidity().getStartDate().getTime() || validityDate.getTime() > p.getValidity().getEndDate().getTime()) continue;
            return new PriceComplete(p.getPrice());
        }
        return ArticlePriceCalculationToolkit.getStdNettoPrice(article, validityDate);
    }

    private static PriceComplete getStdNettoPrice(BasicArticleLight article, Timestamp validityDate) {
        BasicArticlePriceComplete latestPrice = null;
        for (BasicArticlePriceComplete p : article.getPrices()) {
            if (validityDate.getTime() >= p.getValidity().getStartDate().getTime() && validityDate.getTime() <= p.getValidity().getEndDate().getTime()) {
                return new PriceComplete(p.getPrice());
            }
            if (latestPrice == null) {
                latestPrice = p;
                continue;
            }
            if (latestPrice.getValidity().getStartDate().getTime() >= p.getValidity().getStartDate().getTime()) continue;
            latestPrice = p;
        }
        if (latestPrice != null) {
            return new PriceComplete(latestPrice.getPrice());
        }
        return null;
    }

    public static PriceComplete getBruttoPrice(BasicArticleLight article, java.util.Date validityDate, CustomerReference customer, boolean useTender) {
        return ArticlePriceCalculationToolkit.getBruttoPrice(article, new Timestamp(validityDate.getTime()), customer, useTender);
    }

    public static PriceComplete getBruttoPrice(BasicArticleLight article, Timestamp validityDate, CustomerReference customer, boolean useTender) {
        if (useTender) {
            return ArticlePriceCalculationToolkit.getTenderBruttoPrice(article, validityDate, customer);
        }
        return ArticlePriceCalculationToolkit.getStdBruttoPrice(article, validityDate);
    }

    private static PriceComplete getStdBruttoPrice(BasicArticleLight article, Timestamp validityDate) {
        PriceComplete price = ArticlePriceCalculationToolkit.getStdNettoPrice(article, validityDate);
        if (price == null) {
            throw new IllegalArgumentException("No price found for article " + article.getNumber() + " - " + article.getName());
        }
        if (Boolean.TRUE.equals(article.getCustomerArticleNumber())) {
            price.setPrice(Double.valueOf(0.0));
            return price;
        }
        double factor = 0.0;
        MaterialCostFactorVariantComplete mcf = ArticlePriceCalculationToolkit.getMaterialCostFactor(article, validityDate);
        if (mcf != null) {
            for (MaterialCostFactorComplete mf : mcf.getMaterialCostFactors()) {
                factor += mf.getValue() / 100.0;
            }
        }
        price.setPrice(Double.valueOf(price.getPrice() + price.getPrice() * factor));
        return price;
    }

    public static MaterialCostFactorVariantComplete getMaterialCostFactor(BasicArticleLight article, Timestamp validityDate) {
        if (article.getMaterialCostFactorVariants().isEmpty()) {
            return null;
        }
        for (MaterialCostFactorVariantComplete p : article.getMaterialCostFactorVariants()) {
            if (validityDate.getTime() < p.getValidityPeriod().getStartDate().getTime() || validityDate.getTime() > p.getValidityPeriod().getEndDate().getTime()) continue;
            return p;
        }
        return (MaterialCostFactorVariantComplete)article.getMaterialCostFactorVariants().get(article.getMaterialCostFactorVariants().size() - 1);
    }

    public static MaterialCostFactorTenderVariantComplete getMaterialCostFactorTender(BasicArticleLight article, CustomerReference customer, Timestamp validityDate) {
        if (article.getMaterialCostFactorTenderVariants().isEmpty()) {
            return null;
        }
        for (MaterialCostFactorTenderVariantComplete p : article.getMaterialCostFactorTenderVariants()) {
            if (!(customer == null && p.getCustomer() == null ? validityDate.getTime() >= p.getValidityPeriod().getStartDate().getTime() && validityDate.getTime() <= p.getValidityPeriod().getEndDate().getTime() : customer != null && customer.equals((Object)p.getCustomer()) && validityDate.getTime() >= p.getValidityPeriod().getStartDate().getTime() && validityDate.getTime() <= p.getValidityPeriod().getEndDate().getTime())) continue;
            return p;
        }
        Collections.sort(article.getMaterialCostFactorTenderVariants());
        return (MaterialCostFactorTenderVariantComplete)article.getMaterialCostFactorTenderVariants().get(article.getMaterialCostFactorTenderVariants().size() - 1);
    }

    private static PriceComplete getTenderBruttoPrice(BasicArticleLight article, Timestamp validityDate, CustomerReference customer) {
        MaterialCostFactorTenderVariantComplete factors;
        PriceComplete price = ArticlePriceCalculationToolkit.getTenderNettoPrice(article, validityDate, customer);
        if (Boolean.TRUE.equals(article.getCustomerArticleNumber())) {
            price.setPrice(Double.valueOf(0.0));
            return price;
        }
        if (price == null) {
            price = ArticlePriceCalculationToolkit.getStdBruttoPrice(article, validityDate);
        }
        if ((factors = ArticlePriceCalculationToolkit.getMaterialCostFactorTender(article, customer, validityDate)) == null && customer != null) {
            factors = ArticlePriceCalculationToolkit.getMaterialCostFactorTender(article, null, validityDate);
        }
        if (factors != null) {
            double factor = 0.0;
            for (MaterialCostFactorComplete mf : factors.getMaterialCostFactors()) {
                factor += mf.getValue() / 100.0;
            }
            price.setPrice(Double.valueOf(price.getPrice() + price.getPrice() * factor));
            return price;
        }
        return price;
    }

    public static PriceComplete getBruttoForQuantity(BasicArticleComplete article, QuantityComplete quantity, Timestamp validityDate, CustomerReference customer, boolean useTender) {
        return ArticlePriceCalculationToolkit.getBruttoForQuantity(article, quantity, null, customer, validityDate, useTender);
    }

    public static PriceComplete getBruttoForQuantity(BasicArticleComplete article, QuantityComplete quantity, PriceComplete calculationPrice, CustomerReference customer, Timestamp validityDate, boolean useTender) {
        return ArticlePriceCalculationToolkit.getBruttoForQuantity(article, quantity, calculationPrice, article.getPriceUnit(), customer, validityDate, useTender);
    }

    public static PriceComplete getBruttoForQuantity(BasicArticleComplete article, QuantityComplete quantity, PriceComplete calculationPrice, UnitComplete priceUnit, CustomerReference customer, Timestamp validityDate, boolean useTender) {
        return ArticlePriceCalculationToolkit.getBruttoForQuantity(article, quantity, calculationPrice, priceUnit, true, customer, validityDate, useTender);
    }

    public static PriceComplete getBruttoForQuantity(BasicArticleComplete article, QuantityComplete quantity, PriceComplete calculationPrice, UnitComplete priceUnit, boolean includePurchaseWaste, CustomerReference customer, Timestamp validityDate, boolean useTender) {
        return ArticlePriceCalculationToolkit.getBruttoForQuantity(article, quantity, calculationPrice, priceUnit, includePurchaseWaste, false, customer, validityDate, useTender);
    }

    public static PriceComplete getBruttoForQuantity(BasicArticleComplete article, QuantityComplete quantity, PriceComplete calculationPrice, UnitComplete priceUnit, boolean includePurchaseWaste, boolean includeReturnsRate, CustomerReference customer, Timestamp validityDate, boolean useTender) {
        PriceComplete pc = new PriceComplete();
        if (calculationPrice != null && calculationPrice.getCurrency() != null) {
            pc.setCurrency(calculationPrice.getCurrency());
        } else {
            pc = ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)article, validityDate, customer, useTender);
        }
        if (priceUnit == null) {
            priceUnit = article.getPriceUnit();
        }
        if (Boolean.TRUE.equals(article.getCustomerIsOwner()) || Boolean.TRUE.equals(article.getExcludeFromMaterialCostCalculations())) {
            pc.setPrice(Double.valueOf(0.0));
        }
        double convertedAmount = UnitConversionToolkit.convertUnit(quantity.getUnit(), priceUnit, (double)quantity.getQuantity(), (BasicArticleLight)article, validityDate);
        if (includePurchaseWaste) {
            convertedAmount /= (100.0 - ArticlePriceCalculationToolkit.getArticlePurchaseWaste(article, useTender)) / 100.0;
        }
        if (includeReturnsRate) {
            double rRate = ArticlePriceCalculationToolkit.getArticleReturnsRate(article, customer);
            if ((rRate = 100.0 - rRate) != 0.0) {
                rRate /= 100.0;
            }
            convertedAmount *= rRate;
        }
        double price = 0.0;
        price = calculationPrice != null && calculationPrice.getPrice() != null ? convertedAmount * calculationPrice.getPrice() : convertedAmount * pc.getPrice();
        pc.setPrice(Double.valueOf(price));
        return pc;
    }

    public static double getArticlePurchaseWaste(BasicArticleComplete article, boolean tender) {
        if (Boolean.TRUE.equals(article.getIsNominated())) {
            return 0.0;
        }
        if (tender) {
            if (article.getUseTenderPurchaseWaste().booleanValue()) {
                return article.getTenderPurchaseWaste();
            }
            return ArticlePriceCalculationToolkit.getCategoryPurchaseWaste(article, true);
        }
        if (article.getUseArticlePurchaseWaste().booleanValue()) {
            return article.getPurchaseWaste();
        }
        return ArticlePriceCalculationToolkit.getCategoryPurchaseWaste(article, false);
    }

    public static double getCategoryPurchaseWaste(BasicArticleComplete article, boolean tender) {
        if (Boolean.TRUE.equals(article.getIsNominated())) {
            return 0.0;
        }
        for (ArticleCategoryLight cat = article.getCategory(); cat != null; cat = cat.getParent()) {
            if (tender) {
                if (!Boolean.TRUE.equals(cat.getUseTenderPurchaseWaste())) continue;
                return cat.getDefaultTenderPurchaseWaste();
            }
            if (!Boolean.TRUE.equals(cat.getUsePurchaseWaste())) continue;
            return cat.getDefaultPurchaseWaste();
        }
        return 0.0;
    }

    public static double getArticleReturnsRate(BasicArticleComplete article) {
        return ArticlePriceCalculationToolkit.getArticleReturnsRate(article, null);
    }

    public static double getArticleReturnsRate(BasicArticleComplete article, CustomerReference customer) {
        if (article.getUseArticleReturnsRate().booleanValue()) {
            if (customer == null) {
                return article.getReturnsRate();
            }
            for (BasicArticleReturnsRateComplete r : article.getCustomerReturnsRate()) {
                if (!r.getCustomer().equals((Object)customer)) continue;
                return r.getReturnsRate();
            }
            return article.getReturnsRate();
        }
        return 0.0;
    }

    public static double getCookingWaste(BasicArticleComplete article, CustomerReference customer, boolean tender) {
        if (Boolean.TRUE.equals(article.getIsNominated())) {
            return 0.0;
        }
        if (tender) {
            if (article.getUseTenderCookingWaste().booleanValue()) {
                return article.getTenderCookingWaste();
            }
            return ArticlePriceCalculationToolkit.getGroupCookingWaste(article, true);
        }
        if (article.getUseArticleCookingWaste().booleanValue()) {
            return article.getCookingWaste();
        }
        return ArticlePriceCalculationToolkit.getGroupCookingWaste(article, false);
    }

    public static double getGroupCookingWaste(BasicArticleComplete article, boolean tender) {
        if (Boolean.TRUE.equals(article.getIsNominated())) {
            return 0.0;
        }
        if (tender) {
            if (Boolean.TRUE.equals(article.getCategory().getUseTenderWaste())) {
                return article.getCategory().getDefaultTenderCookingWaste();
            }
            if (article.getCategory().getParent() != null) {
                if (Boolean.TRUE.equals(article.getCategory().getParent().getUseTenderWaste())) {
                    return article.getCategory().getParent().getDefaultTenderCookingWaste();
                }
                if (article.getCategory().getParent().getParent() != null) {
                    if (Boolean.TRUE.equals(article.getCategory().getParent().getParent().getUseTenderWaste())) {
                        return article.getCategory().getParent().getParent().getDefaultTenderCookingWaste();
                    }
                    if (article.getCategory().getParent().getParent().getParent() != null) {
                        if (Boolean.TRUE.equals(article.getCategory().getParent().getParent().getParent().getUseTenderWaste())) {
                            return article.getCategory().getParent().getParent().getParent().getDefaultTenderCookingWaste();
                        }
                        if (article.getCategory().getParent().getParent().getParent().getParent() != null && Boolean.TRUE.equals(article.getCategory().getParent().getParent().getParent().getParent().getUseTenderWaste())) {
                            return article.getCategory().getParent().getParent().getParent().getParent().getDefaultTenderCookingWaste();
                        }
                    }
                }
            }
        } else {
            if (Boolean.TRUE.equals(article.getCategory().getUseWaste())) {
                return article.getCategory().getDefaultCookingWaste();
            }
            if (article.getCategory().getParent() != null) {
                if (Boolean.TRUE.equals(article.getCategory().getParent().getUseWaste())) {
                    return article.getCategory().getParent().getDefaultCookingWaste();
                }
                if (article.getCategory().getParent().getParent() != null) {
                    if (Boolean.TRUE.equals(article.getCategory().getParent().getParent().getUseWaste())) {
                        return article.getCategory().getParent().getParent().getDefaultCookingWaste();
                    }
                    if (article.getCategory().getParent().getParent().getParent() != null) {
                        if (Boolean.TRUE.equals(article.getCategory().getParent().getParent().getParent().getUseWaste())) {
                            return article.getCategory().getParent().getParent().getParent().getDefaultCookingWaste();
                        }
                        if (article.getCategory().getParent().getParent().getParent().getParent() != null && Boolean.TRUE.equals(article.getCategory().getParent().getParent().getParent().getParent().getUseWaste())) {
                            return article.getCategory().getParent().getParent().getParent().getParent().getDefaultCookingWaste();
                        }
                    }
                }
            }
        }
        return 0.0;
    }

    private static RecipeCookingWasteVariantComplete getCookingWasteVariant(RecipeCategoryLight category, Date validity) {
        for (RecipeCookingWasteVariantComplete waste : category.getCookingWaste()) {
            if (!waste.getValidity().within(validity).booleanValue()) continue;
            return waste;
        }
        Collections.sort(category.getCookingWaste());
        return (RecipeCookingWasteVariantComplete)category.getCookingWaste().get(category.getCookingWaste().size() - 1);
    }

    public static double getRecipeGroupProductiveCookingWaste(RecipeVariantLight recipe, Date validity) {
        RecipeCookingWasteVariantComplete catWaste = ArticlePriceCalculationToolkit.getCookingWasteVariant(recipe.getCategory(), validity);
        if (Boolean.TRUE.equals(catWaste.getUseWaste())) {
            return catWaste.getDefaultCookingWaste();
        }
        if (recipe.getCategory().getParent() != null) {
            catWaste = ArticlePriceCalculationToolkit.getCookingWasteVariant((RecipeCategoryLight)recipe.getCategory().getParent(), validity);
            if (Boolean.TRUE.equals(catWaste.getUseWaste())) {
                return catWaste.getDefaultCookingWaste();
            }
            if (recipe.getCategory().getParent().getParent() != null) {
                catWaste = ArticlePriceCalculationToolkit.getCookingWasteVariant((RecipeCategoryLight)recipe.getCategory().getParent().getParent(), validity);
                if (Boolean.TRUE.equals(catWaste.getUseWaste())) {
                    return catWaste.getDefaultCookingWaste();
                }
                if (recipe.getCategory().getParent().getParent().getParent() != null) {
                    catWaste = ArticlePriceCalculationToolkit.getCookingWasteVariant((RecipeCategoryLight)recipe.getCategory().getParent().getParent().getParent(), validity);
                    if (Boolean.TRUE.equals(catWaste)) {
                        return catWaste.getDefaultCookingWaste();
                    }
                    if (recipe.getCategory().getParent().getParent().getParent().getParent() != null && Boolean.TRUE.equals((catWaste = ArticlePriceCalculationToolkit.getCookingWasteVariant((RecipeCategoryLight)recipe.getCategory().getParent().getParent().getParent().getParent(), validity)).getUseWaste())) {
                        return catWaste.getDefaultCookingWaste();
                    }
                }
            }
        }
        return 0.0;
    }

    public static double getRecipeGroupTenderCookingWaste(RecipeVariantLight recipe, Date validity) {
        RecipeCookingWasteVariantComplete catWaste = ArticlePriceCalculationToolkit.getCookingWasteVariant(recipe.getCategory(), validity);
        if (Boolean.TRUE.equals(catWaste.getUseTenderWaste())) {
            return catWaste.getDefaultTenderCookingWaste();
        }
        if (recipe.getCategory().getParent() != null) {
            catWaste = ArticlePriceCalculationToolkit.getCookingWasteVariant((RecipeCategoryLight)recipe.getCategory().getParent(), validity);
            if (Boolean.TRUE.equals(catWaste.getUseTenderWaste())) {
                return catWaste.getDefaultTenderCookingWaste();
            }
            if (recipe.getCategory().getParent().getParent() != null) {
                catWaste = ArticlePriceCalculationToolkit.getCookingWasteVariant((RecipeCategoryLight)recipe.getCategory().getParent().getParent(), validity);
                if (Boolean.TRUE.equals(catWaste.getUseTenderWaste())) {
                    return catWaste.getDefaultTenderCookingWaste();
                }
                if (recipe.getCategory().getParent().getParent().getParent() != null) {
                    catWaste = ArticlePriceCalculationToolkit.getCookingWasteVariant((RecipeCategoryLight)recipe.getCategory().getParent().getParent().getParent(), validity);
                    if (Boolean.TRUE.equals(catWaste)) {
                        return catWaste.getDefaultTenderCookingWaste();
                    }
                    if (recipe.getCategory().getParent().getParent().getParent().getParent() != null && Boolean.TRUE.equals((catWaste = ArticlePriceCalculationToolkit.getCookingWasteVariant((RecipeCategoryLight)recipe.getCategory().getParent().getParent().getParent().getParent(), validity)).getUseTenderWaste())) {
                        return catWaste.getDefaultTenderCookingWaste();
                    }
                }
            }
        }
        return 0.0;
    }
}

