/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.utils;

import ch.icit.pegasus.server.core.dtos.masterdata.PasswordSecurityLevelComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;

public class PasswordSecurityToolkit {
    public static boolean validatePasswordRules(String newPassword, SystemSettingsComplete settings) {
        boolean foundLower = false;
        boolean foundUpper = false;
        boolean foundDigit = false;
        boolean foundSpecial = false;
        PasswordSecurityLevelComplete secLevel = settings.getSecurityLevel();
        if (secLevel == null) {
            return true;
        }
        if (newPassword.length() < secLevel.getMinChars()) {
            return false;
        }
        for (int i = 0; i < newPassword.length(); ++i) {
            char ch = newPassword.charAt(i);
            if (Character.isLowerCase(ch)) {
                foundLower = true;
            }
            if (Character.isUpperCase(ch)) {
                foundUpper = true;
            }
            if (Character.isDigit(ch)) {
                foundDigit = true;
            }
            if (!(ch > ' ' && ch < '0' || ch > '9' && ch < 'A' || ch > 'Z' && ch < 'a' || ch > 'z' && ch < '\u007f' || ch == '\u0081' || ch == '\u0084' || ch == '\u0088' || ch == '\u008e' || ch == '\u0094' || ch == '\u0099') && ch != '\u009a') continue;
            foundSpecial = true;
        }
        int count = 0;
        if (foundLower) {
            ++count;
        }
        if (foundUpper) {
            ++count;
        }
        if (foundDigit) {
            ++count;
        }
        if (foundSpecial) {
            count += 3;
        }
        return count >= secLevel.getPasswordStrength();
    }
}

