/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.utils;

import ch.icit.pegasus.server.core.calculator.IQuantity;
import ch.icit.pegasus.server.core.calculator.UnitCalculator;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreArticleContentComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;

public class UnitConversionToolkit {
    public static final int TYPE_NORMAL_HIRARCHIE = 3;
    public static final int TYPE_CONVERSION_TABLE = 5;
    public static final int TYPE_UNCONVERTABLE = 11;

    public static PackagingQuantityBaseComplete getPackingQuantity(BasicArticleLight article, Timestamp validity) {
        ArrayList articleConversion = new ArrayList(article.getPackingQuantitiesVariants());
        Collections.sort(articleConversion);
        for (PackagingQuantityBaseComplete pack : articleConversion) {
            if (pack.getPeriod().getStartDate().getTime() > validity.getTime() || pack.getPeriod().getEndDate().getTime() < validity.getTime()) continue;
            return pack;
        }
        return (PackagingQuantityBaseComplete)articleConversion.get(articleConversion.size() - 1);
    }

    public static StoreQuantityComplete convertToStoreQuantity(QuantityComplete quantity, BasicArticleLight article, Timestamp validity) {
        int unitContaining;
        UnitComplete targetUnit = article.getBaseUnit();
        PackagingQuantityBaseComplete packingQuantity = UnitConversionToolkit.getPackingQuantity(article, validity);
        if (targetUnit != null && (unitContaining = UnitConversionToolkit.isUnitContaining(targetUnit, article, packingQuantity.getPackingQuantities())) == 11) {
            targetUnit = null;
        }
        if (targetUnit == null) {
            PackagingQuantityComplete q = null;
            Iterator iterator = packingQuantity.getPackingQuantities().iterator();
            while (iterator.hasNext()) {
                PackagingQuantityComplete packagingQuantityComplete;
                q = packagingQuantityComplete = (PackagingQuantityComplete)iterator.next();
            }
            targetUnit = q.getUnit();
        }
        if (targetUnit != null && (unitContaining = UnitConversionToolkit.isUnitContaining(quantity.getUnit(), targetUnit, article, packingQuantity.getPackingQuantities())) == 11) {
            targetUnit = null;
        }
        if (targetUnit == null) {
            PackagingQuantityComplete cp = (PackagingQuantityComplete)packingQuantity.getPackingQuantities().get(packingQuantity.getPackingQuantities().size() - 1);
            targetUnit = cp.getUnit();
        }
        while (targetUnit.getSubUnit() != null) {
            targetUnit = targetUnit.getSubUnit();
        }
        double d = UnitConversionToolkit.convertUnit(quantity.getUnit(), targetUnit, (double)quantity.getQuantity(), article, packingQuantity.getPackingQuantities());
        Long l = Double.valueOf(d).longValue();
        return new StoreQuantityComplete(l, targetUnit);
    }

    public static QuantityComplete normalizeQuantity(StoreQuantityComplete quantity, BasicArticleComplete article, Timestamp validity) {
        return UnitConversionToolkit.normalizeQuantity(new QuantityComplete(Double.valueOf(quantity.getAmount().doubleValue()), quantity.getUnit()), article, validity);
    }

    public static QuantityComplete normalizeQuantity(QuantityComplete quantity, BasicArticleComplete article, Timestamp validity) {
        double q;
        QuantityComplete qq = new QuantityComplete();
        qq.setQuantity(quantity.getQuantity());
        qq.setUnit(quantity.getUnit());
        if (article == null) {
            return qq;
        }
        if (article.getPackingQuantitiesVariants().isEmpty()) {
            return qq;
        }
        PackagingQuantityBaseComplete packingQuantity = UnitConversionToolkit.getPackingQuantity((BasicArticleLight)article, validity);
        Collections.sort(packingQuantity.getPackingQuantities());
        if (!((PackagingQuantityComplete)packingQuantity.getPackingQuantities().get(0)).getUnit().equals((Object)qq.getUnit())) {
            q = UnitConversionToolkit.convertUnit(qq.getUnit(), ((PackagingQuantityComplete)packingQuantity.getPackingQuantities().get(0)).getUnit(), (double)qq.getQuantity(), (BasicArticleLight)article, packingQuantity.getPackingQuantities());
            qq.setQuantity(Double.valueOf(q));
            qq.setUnit(((PackagingQuantityComplete)packingQuantity.getPackingQuantities().get(0)).getUnit());
        }
        if (qq.getQuantity() >= 1.0) {
            return qq;
        }
        if (qq.getQuantity() == 0.0) {
            return qq;
        }
        while (qq.getUnit().getSubUnit() != null && qq.getQuantity() < 1.0) {
            q = UnitConversionToolkit.convertUnit(qq.getUnit(), qq.getUnit().getSubUnit(), (double)qq.getQuantity(), (BasicArticleLight)article, packingQuantity.getPackingQuantities());
            qq.setQuantity(Double.valueOf(q));
            qq.setUnit(qq.getUnit().getSubUnit());
        }
        if (qq.getQuantity() >= 1.0) {
            return qq;
        }
        for (PackagingQuantityComplete pack : packingQuantity.getPackingQuantities()) {
            double q2 = UnitConversionToolkit.convertUnit(qq.getUnit(), pack.getUnit(), (double)qq.getQuantity(), (BasicArticleLight)article, packingQuantity.getPackingQuantities());
            qq.setQuantity(Double.valueOf(q2));
            qq.setUnit(pack.getUnit());
            if (qq.getQuantity() >= 1.0) {
                return qq;
            }
            while (qq.getUnit().getSubUnit() != null && qq.getQuantity() < 1.0) {
                q2 = UnitConversionToolkit.convertUnit(qq.getUnit(), qq.getUnit().getSubUnit(), (double)qq.getQuantity(), (BasicArticleLight)article, packingQuantity.getPackingQuantities());
                qq.setQuantity(Double.valueOf(q2));
                qq.setUnit(qq.getUnit().getSubUnit());
            }
            if (!(qq.getQuantity() >= 1.0)) continue;
            return qq;
        }
        return qq;
    }

    public static QuantityComplete normalizeQuantity(QuantityComplete quantity, BasicArticleComplete article, SupplierConditionComplete scc, Timestamp validity) {
        double q;
        QuantityComplete qq = new QuantityComplete();
        qq.setQuantity(quantity.getQuantity());
        qq.setUnit(quantity.getUnit());
        if (article == null) {
            return qq;
        }
        if (article.getPackingQuantitiesVariants().isEmpty()) {
            return qq;
        }
        PackagingQuantityBaseComplete packingQuantity = UnitConversionToolkit.getPackingQuantity((BasicArticleLight)article, validity);
        List packagingQuantityList = packingQuantity.getPackingQuantities();
        if (scc != null && scc.getUsePackingQuantity() != null && scc.getUsePackingQuantity().booleanValue() && scc.getPackingQuantities() != null && !scc.getPackingQuantities().isEmpty()) {
            packagingQuantityList = scc.getPackingQuantities();
            Collections.sort(packagingQuantityList);
        }
        if (!((PackagingQuantityComplete)packagingQuantityList.get(0)).getUnit().equals((Object)qq.getUnit())) {
            q = UnitConversionToolkit.convertUnit(qq.getUnit(), ((PackagingQuantityComplete)packagingQuantityList.get(0)).getUnit(), (double)qq.getQuantity(), (BasicArticleLight)article, scc, packagingQuantityList);
            qq.setQuantity(Double.valueOf(q));
            qq.setUnit(((PackagingQuantityComplete)packagingQuantityList.get(0)).getUnit());
        }
        if (qq.getQuantity() >= 1.0) {
            return qq;
        }
        if (qq.getQuantity() == 0.0) {
            qq.setUnit(article.getFloatStoreUnit());
            return qq;
        }
        while (qq.getUnit().getSubUnit() != null && qq.getQuantity() < 1.0) {
            q = UnitConversionToolkit.convertUnit(qq.getUnit(), qq.getUnit().getSubUnit(), (double)qq.getQuantity(), (BasicArticleLight)article, packagingQuantityList);
            qq.setQuantity(Double.valueOf(q));
            qq.setUnit(qq.getUnit().getSubUnit());
        }
        if (qq.getQuantity() >= 1.0) {
            return qq;
        }
        for (PackagingQuantityComplete pack : packagingQuantityList) {
            double q2 = UnitConversionToolkit.convertUnit(qq.getUnit(), pack.getUnit(), (double)qq.getQuantity(), (BasicArticleLight)article, packagingQuantityList);
            qq.setQuantity(Double.valueOf(q2));
            qq.setUnit(pack.getUnit());
            if (qq.getQuantity() >= 1.0) {
                return qq;
            }
            while (qq.getUnit().getSubUnit() != null && qq.getQuantity() < 1.0) {
                q2 = UnitConversionToolkit.convertUnit(qq.getUnit(), qq.getUnit().getSubUnit(), (double)qq.getQuantity(), (BasicArticleLight)article, packagingQuantityList);
                qq.setQuantity(Double.valueOf(q2));
                qq.setUnit(qq.getUnit().getSubUnit());
            }
            if (!(qq.getQuantity() >= 1.0)) continue;
            return qq;
        }
        return qq;
    }

    public static QuantityComplete normalizeQuantity(StoreQuantityComplete quantity) {
        return UnitConversionToolkit.normalizeQuantity(new QuantityComplete(Double.valueOf(quantity.getAmount().doubleValue()), quantity.getUnit()));
    }

    public static QuantityComplete normalizeQuantity(QuantityComplete quantity) {
        UnitComplete currentUnit = quantity.getUnit();
        if (currentUnit == null) {
            return quantity;
        }
        double currentValue = quantity.getQuantity();
        UnitComplete resultUnit = currentUnit;
        double resultValue = currentValue;
        double absValue = Math.abs(currentValue);
        if (absValue != 0.0) {
            if (absValue > 1.0) {
                UnitComplete superUnit = currentUnit.getSuperUnit();
                while (superUnit != null && Math.abs(currentValue) > (double)currentUnit.getConversionFactor().intValue()) {
                    currentValue /= (double)currentUnit.getConversionFactor().intValue();
                    currentUnit = superUnit;
                    superUnit = currentUnit.getSuperUnit();
                    if (!currentUnit.getDisplay().booleanValue()) continue;
                    resultUnit = currentUnit;
                    resultValue = currentValue;
                }
            } else if (absValue < 1.0) {
                boolean displayableSubUnitFound = false;
                UnitComplete subUnit = currentUnit.getSubUnit();
                while (subUnit != null && (!displayableSubUnitFound || Math.abs(currentValue) < 1.0)) {
                    currentValue *= (double)subUnit.getConversionFactor().intValue();
                    currentUnit = subUnit;
                    subUnit = currentUnit.getSubUnit();
                    displayableSubUnitFound = currentUnit.getDisplay();
                }
                if (currentUnit.getDisplay().booleanValue()) {
                    displayableSubUnitFound = true;
                    resultUnit = currentUnit;
                    resultValue = currentValue;
                }
            }
        }
        quantity.setQuantity(Double.valueOf(resultValue));
        quantity.setUnit(resultUnit);
        return quantity;
    }

    public static double convertUnit(UnitComplete sourceUnit, UnitComplete destinationUnit, double sourceAmount, BasicArticleLight article, Timestamp validity) {
        List packingQuantities = null;
        if (article != null) {
            PackagingQuantityBaseComplete packingQuantity = UnitConversionToolkit.getPackingQuantity(article, validity);
            packingQuantities = packingQuantity.getPackingQuantities();
        }
        return UnitConversionToolkit.convertUnit(sourceUnit, destinationUnit, sourceAmount, article, packingQuantities);
    }

    public static double convertUnit(UnitComplete sourceUnit, UnitComplete destinationUnit, double sourceAmount, BasicArticleComplete article, SupplierConditionComplete scc, Timestamp validity) {
        List packingQuantities = null;
        if (scc != null && scc.getUsePackingQuantity() != null && scc.getUsePackingQuantity().booleanValue() && scc.getPackingQuantities() != null && !scc.getPackingQuantities().isEmpty()) {
            packingQuantities = scc.getPackingQuantities();
            Collections.sort(packingQuantities);
        }
        if (article != null && packingQuantities == null) {
            PackagingQuantityBaseComplete packingQuantity = UnitConversionToolkit.getPackingQuantity((BasicArticleLight)article, validity);
            packingQuantities = packingQuantity.getPackingQuantities();
        }
        return UnitConversionToolkit.convertUnit(sourceUnit, destinationUnit, sourceAmount, (BasicArticleLight)article, scc, packingQuantities);
    }

    public static double convertUnit(UnitComplete sourceUnit, UnitComplete destinationUnit, double sourceAmount, BasicArticleLight article, SupplierConditionComplete scc, List<PackagingQuantityComplete> packagingQuantityCompletes) {
        List<PackagingQuantityComplete> packingQuantities = packagingQuantityCompletes;
        return UnitConversionToolkit.convertUnit(sourceUnit, destinationUnit, sourceAmount, article, packingQuantities);
    }

    public static double convertUnit(UnitComplete sourceUnit, UnitComplete destinationUnit, double sourceAmount, BasicArticleLight article, List<PackagingQuantityComplete> packagingQuantityComplete) {
        int t = UnitConversionToolkit.isUnitContaining(sourceUnit, destinationUnit, article, packagingQuantityComplete);
        if (t < 11) {
            double conFactor = 0.0;
            double nValue = 0.0;
            conFactor = UnitConversionToolkit.getConversionFactor(article, sourceUnit, destinationUnit, t, packagingQuantityComplete);
            nValue = sourceAmount * conFactor;
            return nValue;
        }
        return sourceAmount;
    }

    public static QuantityComplete convertToTargetUnitIfPossibleElseToBaseUnit(StoreQuantityComplete sourceQuantity, UnitComplete targetUnit, BasicArticleLight article, List<PackagingQuantityComplete> packagingQuantityComplete) {
        UnitComplete sourceUnit = sourceQuantity.getUnit();
        int t = UnitConversionToolkit.isUnitContaining(sourceUnit, targetUnit, article, packagingQuantityComplete);
        if (t >= 11) {
            targetUnit = article.getBaseUnit();
        }
        double v = UnitConversionToolkit.convertUnit(sourceQuantity.getUnit(), targetUnit, (double)sourceQuantity.getAmount().longValue(), article, packagingQuantityComplete);
        return new QuantityComplete(Double.valueOf(v), targetUnit);
    }

    public static QuantityComplete convertToTargetUnitIfPossibleElseToBaseUnit(QuantityComplete sourceQuantity, UnitComplete targetUnit, BasicArticleLight article, List<PackagingQuantityComplete> packagingQuantityComplete) {
        UnitComplete sourceUnit = sourceQuantity.getUnit();
        int t = UnitConversionToolkit.isUnitContaining(sourceUnit, targetUnit, article, packagingQuantityComplete);
        if (t >= 11) {
            targetUnit = article.getBaseUnit();
        }
        double v = UnitConversionToolkit.convertUnit(sourceQuantity.getUnit(), targetUnit, (double)sourceQuantity.getQuantity(), article, packagingQuantityComplete);
        return new QuantityComplete(Double.valueOf(v), targetUnit);
    }

    public static Double getConversionFactor(UnitComplete sourceUnit, UnitComplete targetUnit) {
        UnitComplete currentUnit;
        if (Objects.equals(sourceUnit, targetUnit)) {
            return 1.0;
        }
        double factor = 1.0;
        boolean found = false;
        for (currentUnit = sourceUnit; currentUnit != null && !found; currentUnit = currentUnit.getSuperUnit()) {
            if (currentUnit.equals((Object)targetUnit)) {
                found = true;
                continue;
            }
            if (currentUnit.getConversionFactor() == null) continue;
            factor /= (double)currentUnit.getConversionFactor().intValue();
        }
        if (found) {
            return factor;
        }
        factor = 1.0;
        currentUnit = sourceUnit;
        while (currentUnit != null && !found) {
            if (currentUnit.equals((Object)targetUnit)) {
                found = true;
                continue;
            }
            if (currentUnit.getSubUnit() != null && currentUnit.getSubUnit().getConversionFactor() != null) {
                factor *= (double)currentUnit.getSubUnit().getConversionFactor().intValue();
            }
            currentUnit = currentUnit.getSubUnit();
        }
        return factor;
    }

    public static double getConversionFactor(BasicArticleLight article, UnitComplete sourceUnit, UnitComplete destinationUnit, int conversionType, Timestamp validity) {
        PackagingQuantityBaseComplete packingQuantity = UnitConversionToolkit.getPackingQuantity(article, validity);
        return UnitConversionToolkit.getConversionFactor(article, sourceUnit, destinationUnit, conversionType, packingQuantity.getPackingQuantities());
    }

    public static double getConversionFactor(BasicArticleLight article, UnitComplete sourceUnit, UnitComplete destinationUnit, int conversionType, List<PackagingQuantityComplete> packing) {
        if (conversionType == 3) {
            double convertFactor = UnitConversionToolkit.getConversionFactor(sourceUnit, destinationUnit);
            return convertFactor;
        }
        if (conversionType == 5) {
            double targetFactor = 1.0;
            double sourceFactor = 1.0;
            boolean foundTargetFactor = false;
            boolean foundSourceFactor = false;
            boolean found = false;
            ArrayList<PackagingQuantityComplete> packingList = new ArrayList<PackagingQuantityComplete>(packing);
            Collections.sort(packingList);
            Iterator it = packingList.iterator();
            while (it.hasNext() && !found) {
                double d;
                PackagingQuantityComplete currentPackQuant = (PackagingQuantityComplete)it.next();
                if (!foundSourceFactor) {
                    if (UnitConversionToolkit.isUnitContaining(sourceUnit, currentPackQuant.getUnit(), article, packing) == 3) {
                        foundSourceFactor = true;
                        d = UnitConversionToolkit.getConversionFactor(article, sourceUnit, currentPackQuant.getUnit(), 3, packing);
                        sourceFactor /= d;
                        sourceFactor *= (double)currentPackQuant.getAmount().intValue();
                    } else {
                        sourceFactor *= (double)currentPackQuant.getAmount().intValue();
                    }
                }
                if (!foundTargetFactor) {
                    if (UnitConversionToolkit.isUnitContaining(destinationUnit, currentPackQuant.getUnit(), article, packing) == 3) {
                        foundTargetFactor = true;
                        d = UnitConversionToolkit.getConversionFactor(article, destinationUnit, currentPackQuant.getUnit(), 3, packing);
                        targetFactor /= d;
                        targetFactor *= (double)currentPackQuant.getAmount().intValue();
                    } else {
                        targetFactor *= (double)currentPackQuant.getAmount().intValue();
                    }
                }
                if (!foundSourceFactor || !foundTargetFactor) continue;
                found = true;
            }
            return targetFactor / sourceFactor;
        }
        return 1.0;
    }

    public static int isUnitContaining(UnitComplete sourceUnit, UnitComplete destUnit, BasicArticleLight article, Timestamp validity) {
        List packingQuantities = null;
        if (article != null) {
            PackagingQuantityBaseComplete packingQuantity = UnitConversionToolkit.getPackingQuantity(article, validity);
            packingQuantities = packingQuantity.getPackingQuantities();
        }
        return UnitConversionToolkit.isUnitContaining(sourceUnit, destUnit, article, packingQuantities);
    }

    public static int isUnitContaining(UnitComplete sourceUnit, UnitComplete destUnit, BasicArticleLight article, SupplierConditionComplete scc, Timestamp validity) {
        List packingQuantities = null;
        if (article != null && packingQuantities == null) {
            PackagingQuantityBaseComplete packingQuantity = UnitConversionToolkit.getPackingQuantity(article, validity);
            packingQuantities = packingQuantity.getPackingQuantities();
        }
        return UnitConversionToolkit.isUnitContaining(sourceUnit, destUnit, article, packingQuantities);
    }

    public static int isUnitContaining(UnitComplete unit, BasicArticleLight article, Timestamp validity) {
        return UnitConversionToolkit.isUnitContaining(article.getBaseUnit(), unit, article, validity);
    }

    public static int isUnitContaining(UnitComplete unit, BasicArticleLight article, List<PackagingQuantityComplete> packingList) {
        return UnitConversionToolkit.isUnitContaining(article.getBaseUnit(), unit, article, packingList);
    }

    public static boolean isUnitContaining(UnitComplete unit, List<PackagingQuantityComplete> packing) {
        for (PackagingQuantityComplete quantityComplete : packing) {
            for (UnitComplete maxUnit = quantityComplete.getUnit().getUnitSystem().getMaxUnit(); maxUnit != null; maxUnit = maxUnit.getSubUnit()) {
                if (!maxUnit.equals((Object)unit)) continue;
                return true;
            }
        }
        return false;
    }

    public static int isUnitContaining(UnitComplete sourceUnit, UnitComplete destUnit, BasicArticleLight article, List<PackagingQuantityComplete> packingList) {
        UnitComplete currentUnit;
        if (sourceUnit != null && sourceUnit.equals((Object)destUnit)) {
            return 3;
        }
        for (currentUnit = sourceUnit; currentUnit != null; currentUnit = currentUnit.getSuperUnit()) {
            if (!currentUnit.equals((Object)destUnit)) continue;
            return 3;
        }
        for (currentUnit = destUnit; currentUnit != null; currentUnit = currentUnit.getSuperUnit()) {
            if (!currentUnit.equals((Object)sourceUnit)) continue;
            return 3;
        }
        if (article != null) {
            boolean containsTargetUnit = false;
            ArrayList<PackagingQuantityComplete> qts = new ArrayList<PackagingQuantityComplete>(packingList);
            Collections.sort(qts);
            for (PackagingQuantityComplete currentPackQuant : qts) {
                UnitComplete u = currentPackQuant.getUnit();
                if (UnitConversionToolkit.isUnitContaining(destUnit, u, null, packingList) >= 11) continue;
                containsTargetUnit = true;
            }
            boolean containsSourceUnit = false;
            for (PackagingQuantityComplete currentPackQuant : qts) {
                UnitComplete u = currentPackQuant.getUnit();
                if (UnitConversionToolkit.isUnitContaining(sourceUnit, u, null, packingList) >= 11) continue;
                containsSourceUnit = true;
            }
            if (containsSourceUnit && containsTargetUnit) {
                return 5;
            }
        }
        return 11;
    }

    public static List<UnitComplete> getAllUnits(UnitSystemComplete unitSystem) {
        HashSet<UnitComplete> units = new HashSet<UnitComplete>();
        for (UnitComplete currentUnit = unitSystem.getMaxUnit(); currentUnit != null; currentUnit = currentUnit.getSubUnit()) {
            units.add(currentUnit);
        }
        return new ArrayList<UnitComplete>(units);
    }

    public static List<UnitComplete> getAllUnits(UnitComplete unit) {
        UnitComplete currentUnit;
        HashSet<UnitComplete> units = new HashSet<UnitComplete>();
        units.add(unit);
        for (currentUnit = unit.getSuperUnit(); currentUnit != null; currentUnit = currentUnit.getSuperUnit()) {
            units.add(currentUnit);
        }
        for (currentUnit = unit.getSubUnit(); currentUnit != null; currentUnit = currentUnit.getSubUnit()) {
            units.add(currentUnit);
        }
        return new ArrayList<UnitComplete>(units);
    }

    public static List<UnitComplete> getPossibleUnits(BasicArticleLight art, Timestamp validity, boolean allUnitsAllowed, SystemSettingsComplete settings) {
        ArrayList<UnitComplete> units = new ArrayList<UnitComplete>();
        if (art == null) {
            return units;
        }
        PackagingQuantityBaseComplete base = UnitConversionToolkit.getPackingQuantity(art, validity);
        ArrayList copy = new ArrayList(base.getPackingQuantities());
        Collections.sort(copy);
        for (PackagingQuantityComplete currentConversion : copy) {
            UnitComplete unit = currentConversion.getUnit();
            units.addAll(UnitConversionToolkit.getAllUnits(unit));
            if (allUnitsAllowed || settings == null || !currentConversion.getUnit().equals((Object)art.getBaseUnit())) continue;
            break;
        }
        return units;
    }

    public static List<UnitComplete> getPossibleUnits(ArticleChargeComplete charge, boolean allUnitsAllowed, SystemSettingsComplete settings) {
        ArrayList<UnitComplete> units = new ArrayList<UnitComplete>();
        if (charge == null) {
            return units;
        }
        Collections.sort(charge.getPackingQuantities());
        for (PackagingQuantityComplete currentConversion : charge.getPackingQuantities()) {
            UnitComplete unit = currentConversion.getUnit();
            units.addAll(UnitConversionToolkit.getAllUnits(unit));
            if (allUnitsAllowed || settings == null || !currentConversion.getUnit().equals((Object)charge.getBasicArticle().getBaseUnit())) continue;
            break;
        }
        return units;
    }

    public static List<UnitComplete> getPossibleUnits(List<PackagingQuantityComplete> pt) {
        ArrayList<UnitComplete> units = new ArrayList<UnitComplete>();
        if (pt == null) {
            return units;
        }
        Collections.sort(pt);
        for (PackagingQuantityComplete currentConversion : pt) {
            UnitComplete unit = currentConversion.getUnit();
            units.addAll(UnitConversionToolkit.getAllUnits(unit));
        }
        return units;
    }

    public static List<UnitComplete> getPossibleUnits(RecipeVariantLight recipe) {
        return UnitConversionToolkit.getAllUnits(recipe.getYield().getUnit());
    }

    public static double getPriceIn(CurrencyComplete targetCurrency, PriceComplete sourcePrice, CurrencyVariantAccessor accessor, Timestamp timestamp) {
        try {
            CurrencyVariantComplete targetVariant = (CurrencyVariantComplete)accessor.loadData(targetCurrency, timestamp);
            CurrencyVariantComplete sourceVariant = (CurrencyVariantComplete)accessor.loadData(sourcePrice.getCurrency(), timestamp);
            double f1 = targetVariant.getExchangeRate();
            double f2 = sourceVariant.getExchangeRate();
            double a1 = sourcePrice.getPrice() * f2 / f1;
            return a1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static PriceComplete convertPrice(CurrencyComplete targetCurrency, PriceComplete sourcePrice, CurrencyVariantAccessor accessor, Timestamp validityDate) {
        return new PriceComplete(targetCurrency, Double.valueOf(UnitConversionToolkit.getPriceIn(targetCurrency, sourcePrice, accessor, validityDate)));
    }

    public static QuantityComplete getTotalQuantityInStoreUnit(StoreArticleContentComplete articleContent) {
        StorePositionLight position;
        StoreLight store;
        double totalAmount = 0.0;
        UnitComplete targetUnit = articleContent.getArticle().getBaseUnit();
        if (articleContent.getBatches().size() > 0 && (store = (position = ((ArticleChargeBatchComplete)articleContent.getBatches().get(0)).getPosition()).getStore()) != null) {
            targetUnit = store.getMainStore() != false ? articleContent.getArticle().getMainStoreUnit() : articleContent.getArticle().getFloatStoreUnit();
        }
        UnitComplete finalTargetUnit = targetUnit;
        boolean allChargesAreConvertibleToStoreUnit = articleContent.getBatches().stream().allMatch(b -> UnitConversionToolkit.isUnitContaining(finalTargetUnit, b.getCharge().getPackingQuantities()));
        if (!allChargesAreConvertibleToStoreUnit) {
            targetUnit = articleContent.getArticle().getBaseUnit();
        }
        for (ArticleChargeBatchComplete batch : articleContent.getBatches()) {
            QuantityComplete quantity = UnitConversionToolkit.convertToStoreQuantity(batch, targetUnit);
            totalAmount += quantity.getQuantity().doubleValue();
        }
        return new QuantityComplete(Double.valueOf(totalAmount), targetUnit);
    }

    private static QuantityComplete convertToStoreQuantity(ArticleChargeBatchComplete batch, UnitComplete targetUnit) {
        StoreQuantityComplete storeQuantity = batch.getQuantity();
        QuantityComplete quantity = new QuantityComplete(Double.valueOf(storeQuantity.getAmount().longValue()), storeQuantity.getUnit());
        return UnitConversionToolkit.convertToStoreQuantity(quantity, batch.getCharge(), targetUnit);
    }

    public static QuantityComplete getQuantityInTargetUnit(ArticleChargeBatchComplete batch, UnitComplete targetUnit) {
        List packingQuantities = batch.getCharge().getPackingQuantities();
        return UnitConversionToolkit.convertToTargetUnitIfPossibleElseToBaseUnit(UnitConversionToolkit.convertToStoreQuantity(batch, targetUnit), targetUnit, batch.getCharge().getBasicArticle(), (List<PackagingQuantityComplete>)packingQuantities);
    }

    private static QuantityComplete convertToStoreQuantity(QuantityComplete quantity, ArticleChargeComplete charge, UnitComplete targetUnit) {
        List packingQuantities = charge.getPackingQuantities();
        QuantityComplete quantityComplete = UnitConversionToolkit.convertToTargetUnitIfPossibleElseToBaseUnit(quantity, targetUnit, charge.getBasicArticle(), (List<PackagingQuantityComplete>)packingQuantities);
        return quantityComplete;
    }

    public static QuantityComplete getOptimalStoreQuantity(ArticleChargeBatchComplete batch, SystemSettingsComplete settings, BasicArticleComplete article) {
        return UnitConversionToolkit.getOptimalStoreQuantity(batch, settings, article, batch.getCharge().getPackingQuantities());
    }

    public static QuantityComplete getOptimalStoreQuantity(ArticleChargeBatchComplete batch, SystemSettingsComplete settings, BasicArticleComplete article, List<PackagingQuantityComplete> packing) {
        Object pg;
        StorePositionLight position = batch.getPosition();
        StoreLight store = position.getStore() != null ? position.getStore() : null;
        UnitComplete targetUnit = article.getPriceUnit();
        if (store != null) {
            targetUnit = store.getMainStore() != false ? article.getMainStoreUnit() : article.getFloatStoreUnit();
        }
        StoreQuantityComplete quantity = batch.getQuantity();
        if (targetUnit.getSubUnit() == null && targetUnit.getSuperUnit() == null) {
            QuantityComplete quantityComplete = UnitConversionToolkit.convertToTargetUnitIfPossibleElseToBaseUnit(quantity, targetUnit, (BasicArticleLight)article, packing);
            double d = quantityComplete.getQuantity().intValue();
            int di = (int)d;
            if (di > 0) {
                return quantityComplete;
            }
            Collections.sort(packing);
            Stack<PackagingQuantityComplete> spq = new Stack<PackagingQuantityComplete>();
            boolean found = false;
            for (PackagingQuantityComplete pg2 : packing) {
                if (found) continue;
                spq.push(pg2);
                if (!UnitConversionToolkit.isUnitEquals(pg2.getUnit(), quantity.getUnit())) continue;
                found = true;
            }
            int latest = 0;
            double latestD = 0.0;
            UnitComplete latestUnit = null;
            while (!spq.isEmpty()) {
                PackagingQuantityComplete pg3 = (PackagingQuantityComplete)spq.pop();
                if (pg3.getUnit().getSubUnit() != null || pg3.getUnit().getSuperUnit() != null) continue;
                d = UnitConversionToolkit.convertUnit(quantity.getUnit(), pg3.getUnit(), (double)quantity.getAmount().longValue(), (BasicArticleLight)article, packing);
                di = (int)d;
                if (di == 0 && latest > 0) {
                    return new QuantityComplete(Double.valueOf(latestD), latestUnit);
                }
                latestD = d;
                latest = di;
                latestUnit = pg3.getUnit();
            }
            if (latest > 0) {
                return new QuantityComplete(Double.valueOf(latestD), latestUnit);
            }
        }
        if (targetUnit.equals((Object)settings.getPieceUnit())) {
            double d = UnitConversionToolkit.convertUnit(quantity.getUnit(), targetUnit, (double)quantity.getAmount().longValue(), (BasicArticleLight)article, packing);
            return new QuantityComplete(Double.valueOf(d), targetUnit);
        }
        Collections.sort(packing);
        Stack<PackagingQuantityComplete> spq = new Stack<PackagingQuantityComplete>();
        boolean found = false;
        for (PackagingQuantityComplete pg4 : packing) {
            if (found) continue;
            spq.push(pg4);
        }
        while (!spq.isEmpty()) {
            pg = (PackagingQuantityComplete)spq.pop();
            if (!pg.getUnit().equals((Object)settings.getPieceUnit())) continue;
            double d = UnitConversionToolkit.convertUnit(quantity.getUnit(), pg.getUnit(), (double)quantity.getAmount().longValue(), (BasicArticleLight)article, packing);
            return new QuantityComplete(Double.valueOf(d), pg.getUnit());
        }
        if (targetUnit.getSubUnit() != null || targetUnit.getSuperUnit() != null) {
            Collections.sort(packing);
            spq = new Stack();
            found = false;
            for (PackagingQuantityComplete pg5 : packing) {
                if (found) continue;
                spq.push(pg5);
                if (!UnitConversionToolkit.isUnitEquals(pg5.getUnit(), quantity.getUnit())) continue;
                found = true;
            }
            while (!spq.isEmpty()) {
                pg = (PackagingQuantityComplete)spq.pop();
                if (pg.getUnit().getSubUnit() != null || pg.getUnit().getSuperUnit() != null) continue;
                double d = UnitConversionToolkit.convertUnit(quantity.getUnit(), pg.getUnit(), (double)quantity.getAmount().longValue(), (BasicArticleLight)article, packing);
                return new QuantityComplete(Double.valueOf(d), pg.getUnit());
            }
        } else {
            double d = UnitConversionToolkit.convertUnit(quantity.getUnit(), targetUnit, (double)quantity.getAmount().longValue(), (BasicArticleLight)article, packing);
            return new QuantityComplete(Double.valueOf(d), targetUnit);
        }
        return new QuantityComplete(Double.valueOf(quantity.getAmount().doubleValue()), quantity.getUnit());
    }

    private static boolean isUnitEquals(UnitComplete unit, UnitComplete unit2) {
        UnitComplete u;
        for (u = unit2; u != null; u = u.getSubUnit()) {
            if (!u.equals((Object)unit)) continue;
            return true;
        }
        for (u = unit2; u != null; u = u.getSuperUnit()) {
            if (!u.equals((Object)unit)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConvertible(BasicArticleComplete source, BasicArticleComplete destination, Timestamp validity) {
        if (source == null || destination == null) {
            return false;
        }
        if (source.getPriceUnit().equals((Object)destination.getPriceUnit())) {
            return true;
        }
        if (UnitConversionToolkit.isUnitContaining(source.getPriceUnit(), destination.getPriceUnit(), (BasicArticleLight)source, validity) != 11) {
            return true;
        }
        PackagingQuantityBaseComplete base = UnitConversionToolkit.getPackingQuantity((BasicArticleLight)destination, validity);
        for (PackagingQuantityComplete q : base.getPackingQuantities()) {
            if (UnitConversionToolkit.isUnitContaining(source.getPriceUnit(), q.getUnit(), (BasicArticleLight)source, validity) == 11) continue;
            return true;
        }
        return false;
    }

    public static List<UnitComplete> getCommonUnits(List<List<PackagingQuantityComplete>> packingList) {
        HashMap<UnitComplete, Integer> countMap = new HashMap<UnitComplete, Integer>();
        HashSet commonUnits = new HashSet();
        ArrayList<UnitComplete> allCommonUnits = new ArrayList<UnitComplete>();
        for (List<PackagingQuantityComplete> list : packingList) {
            for (PackagingQuantityComplete quantityComplete : list) {
                UnitComplete unit = quantityComplete.getUnit();
                if (countMap.containsKey(unit)) {
                    Integer integer;
                    Integer n = integer = (Integer)countMap.get(unit);
                    Integer n2 = integer = Integer.valueOf(integer + 1);
                    countMap.put(unit, n);
                    continue;
                }
                countMap.put(unit, 1);
            }
        }
        for (Map.Entry entry : countMap.entrySet()) {
            if (((Integer)entry.getValue()).intValue() != packingList.size()) continue;
            commonUnits.add(entry.getKey());
        }
        for (UnitComplete unitComplete : commonUnits) {
            allCommonUnits.addAll(UnitConversionToolkit.getAllUnits(unitComplete));
        }
        return allCommonUnits;
    }

    public static String formatConversion(List<PackagingQuantityComplete> quantities) {
        String retString = "";
        Collections.sort(quantities);
        double amount = 1.0;
        for (PackagingQuantityComplete q : quantities) {
            QuantityComplete currentAmount = new QuantityComplete(Double.valueOf(amount *= (double)q.getAmount().intValue()), q.getUnit());
            currentAmount = (QuantityComplete)UnitCalculator.normalizeQuantity((IQuantity)currentAmount);
            String fr = UnitConversionToolkit.formatDouble(currentAmount.getAmount(), "#.##");
            retString = retString + fr + " " + currentAmount.getUnit().getShortName() + " = ";
        }
        if (retString.length() > 3) {
            retString = retString.substring(0, retString.length() - 3);
            retString = retString + " \n";
        }
        return retString;
    }

    public static String formatDouble(double d, String pattern) {
        DecimalFormat df = new DecimalFormat(pattern);
        df.setRoundingMode(RoundingMode.HALF_UP);
        String f = df.format(d);
        return f;
    }
}

