/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.flightschedule;

import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.SqlTimeAdapter;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.StowingListConfigurationAdapter;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.Bidirectional;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@DTO(target="ch.icit.pegasus.server.core.entities.flight.FlightSchedule")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FlightScheduleLight
extends FlightScheduleReference {
    @DTOField(nullable=false)
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private CustomerLight customer;
    @IgnoreField
    private List<Boolean> daysOfWeek;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @Bidirectional(target="flightSchedule")
    @XmlJavaTypeAdapter(value=StowingListConfigurationAdapter.class)
    private StowingListConfigurationComplete defaultStowingList;
    @XmlAttribute
    private String inboundCode;
    @XmlAttribute
    private String outboundCode;
    @Bidirectional(target="flightSchedule")
    private List<FlightScheduleLegComplete> legs = new ArrayList<FlightScheduleLegComplete>();
    @DTOField(nullable=false)
    @XmlJavaTypeAdapter(value=SqlTimeAdapter.class)
    private Time sta;
    @DTOField(nullable=false)
    @XmlJavaTypeAdapter(value=SqlTimeAdapter.class)
    private Time std;
    @DTOField(nullable=false)
    private FlightTypeE flightType;
    private PeriodComplete period;
    private ModificationStateE state;
    @XmlAttribute
    private Boolean autoCheckout = false;
    private FlightCategoryComplete category;
    @DTOField(readonly=true)
    @XmlAttribute
    private Integer number;
    @XmlAttribute
    private String shortFlightCode;
    @XmlAttribute
    private Boolean excludeFromKitchenForecast;
    @XmlJavaTypeAdapter(value=SqlTimeAdapter.class)
    private Time kitchenReadyTime;

    public FlightScheduleLight() {
        this.daysOfWeek = new ArrayList<Boolean>();
        this.daysOfWeek.add(false);
        this.daysOfWeek.add(false);
        this.daysOfWeek.add(false);
        this.daysOfWeek.add(false);
        this.daysOfWeek.add(false);
        this.daysOfWeek.add(false);
        this.daysOfWeek.add(false);
    }

    @Override
    public String toString() {
        return this.outboundCode + "(" + this.inboundCode + " - " + this.period + ")";
    }

    public ModificationStateE getState() {
        return this.state;
    }

    public void setState(ModificationStateE state) {
        this.state = state;
    }

    public CustomerLight getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerLight customer) {
        this.customer = customer;
    }

    public List<Boolean> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public void setDaysOfWeek(List<Boolean> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public String getInboundCode() {
        return this.inboundCode;
    }

    public void setInboundCode(String inboundCode) {
        this.inboundCode = inboundCode;
    }

    public String getOutboundCode() {
        return this.outboundCode;
    }

    public void setOutboundCode(String outboundCode) {
        this.outboundCode = outboundCode;
    }

    public List<FlightScheduleLegComplete> getLegs() {
        return this.legs;
    }

    public void setLegs(List<FlightScheduleLegComplete> legs) {
        this.legs = legs;
    }

    public Time getSta() {
        return this.sta;
    }

    public void setSta(Time sta) {
        this.sta = sta;
    }

    public Time getStd() {
        return this.std;
    }

    public void setStd(Time std) {
        this.std = std;
    }

    public FlightTypeE getFlightType() {
        return this.flightType;
    }

    public void setFlightType(FlightTypeE flightType) {
        this.flightType = flightType;
    }

    public void setPeriod(PeriodComplete period) {
        this.period = period;
    }

    public PeriodComplete getPeriod() {
        return this.period;
    }

    public StowingListConfigurationComplete getDefaultStowingList() {
        return this.defaultStowingList;
    }

    public void setDefaultStowingList(StowingListConfigurationComplete defaultStowingList) {
        this.defaultStowingList = defaultStowingList;
    }

    public Boolean getAutoCheckout() {
        return this.autoCheckout;
    }

    public void setAutoCheckout(Boolean autoCheckout) {
        this.autoCheckout = autoCheckout;
    }

    public FlightCategoryComplete getCategory() {
        return this.category;
    }

    public void setCategory(FlightCategoryComplete category) {
        this.category = category;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getShortFlightCode() {
        return this.shortFlightCode;
    }

    public void setShortFlightCode(String shortFlightCode) {
        this.shortFlightCode = shortFlightCode;
    }

    public Boolean getExcludeFromKitchenForecast() {
        return this.excludeFromKitchenForecast;
    }

    public void setExcludeFromKitchenForecast(Boolean excludeFromKitchenForecast) {
        this.excludeFromKitchenForecast = excludeFromKitchenForecast;
    }

    public Time getKitchenReadyTime() {
        return this.kitchenReadyTime;
    }

    public void setKitchenReadyTime(Time kitchenReadyTime) {
        this.kitchenReadyTime = kitchenReadyTime;
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.getDefaultStowingList() != null) {
            XmlCache.getXmlCache().put(this.getDefaultStowingList().getId(), this.getDefaultStowingList());
        }
    }
}

