/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.product;

import ch.icit.pegasus.server.core.dtos.BasicLogComplete;
import ch.icit.pegasus.server.core.dtos.LoggedComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.product.ReturnsCountTypeE;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.VariantMasterLight;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.SqlTimestampAdapter;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.Bidirectional;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@DTO(target="ch.icit.pegasus.server.core.entities.product.Product")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class ProductComplete
extends ProductReference
implements LoggedComplete,
VariantMasterLight<ProductVariantReference>,
Comparable<ProductComplete> {
    @DTOField(readonly=true)
    private BasicLogComplete log;
    @DTOField(readonly=true)
    @XmlAttribute
    private Integer number;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @Bidirectional(target="availableProducts")
    @DTOField(nullable=false)
    private CustomerLight customer;
    @DTOField(nullable=false)
    private PeriodComplete period;
    @DTOField(readonly=true)
    @XmlJavaTypeAdapter(value=SqlTimestampAdapter.class)
    private Timestamp creationDate;
    @Bidirectional(target="product")
    @DTOField(empty=false)
    private List<ProductVariantReference> variants;
    @XmlAttribute
    private Boolean salesOnBoard = false;
    @XmlAttribute
    private Boolean bonded;
    @DTOField(nullable=false)
    private ReturnsCountTypeE returnsCountType = ReturnsCountTypeE.NONE;
    private ProductGroupComplete productGroup;
    @IgnoreField
    private ModificationStateE state = ModificationStateE.DRAFT;
    @XmlAttribute
    private Boolean autoCheckout = true;
    @XmlAttribute
    private Boolean showOnKitchenSheet = true;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @IgnoreField
    private ProductVariantLight currentVariant;

    public ProductComplete() {
        this.variants = new ArrayList<ProductVariantReference>();
    }

    public ModificationStateE getState() {
        return this.currentVariant != null ? this.currentVariant.getState() : ModificationStateE.DRAFT;
    }

    public void setState(ModificationStateE state) {
        this.state = state;
    }

    @Override
    public String toString() {
        return "product " + this.number;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    @Override
    public List<ProductVariantReference> getVariants() {
        return this.variants;
    }

    @Override
    public void setVariants(List<ProductVariantReference> variants) {
        this.variants = variants;
    }

    public ProductVariantLight getCurrentVariant() {
        return this.currentVariant;
    }

    public void setCurrentVariant(ProductVariantLight currentVariant) {
        this.currentVariant = currentVariant;
    }

    public CustomerLight getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerLight customer) {
        this.customer = customer;
    }

    public PeriodComplete getPeriod() {
        return this.period;
    }

    public void setPeriod(PeriodComplete period) {
        this.period = period;
    }

    public Timestamp getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Timestamp creationDate) {
        this.creationDate = creationDate;
    }

    public Boolean getSalesOnBoard() {
        return this.salesOnBoard;
    }

    public void setSalesOnBoard(Boolean salesOnBoard) {
        this.salesOnBoard = salesOnBoard;
    }

    public Boolean getBonded() {
        return this.bonded;
    }

    public void setBonded(Boolean bonded) {
        this.bonded = bonded;
    }

    public ProductGroupComplete getProductGroup() {
        return this.productGroup;
    }

    public void setProductGroup(ProductGroupComplete productGroup) {
        this.productGroup = productGroup;
    }

    public Boolean getAutoCheckout() {
        return this.autoCheckout;
    }

    public void setAutoCheckout(Boolean autoCheckout) {
        this.autoCheckout = autoCheckout;
    }

    public ReturnsCountTypeE getReturnsCountType() {
        return this.returnsCountType;
    }

    public void setReturnsCountType(ReturnsCountTypeE returnsCountType) {
        this.returnsCountType = returnsCountType;
    }

    public Boolean getShowOnKitchenSheet() {
        return this.showOnKitchenSheet;
    }

    public void setShowOnKitchenSheet(Boolean showOnKitchenSheet) {
        this.showOnKitchenSheet = showOnKitchenSheet;
    }

    @Override
    public BasicLogComplete getLog() {
        return this.log;
    }

    @Override
    public void setLog(BasicLogComplete log) {
        this.log = log;
    }

    @Override
    public int compareTo(ProductComplete o) {
        return this.number - o.getNumber();
    }

    public void afterUnmarshal(Unmarshaller u, Object product) {
        XmlCache.getXmlCache().put(this.getCacheId(), this);
    }
}

