/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.supply;

import ch.icit.pegasus.server.core.dtos.edelweiss.reportconfig.EdelweissReportConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.BankConnectionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CreditCardRangeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.sob.CrewMemberComplete;
import ch.icit.pegasus.server.core.dtos.sob.SobCurrencyComplete;
import ch.icit.pegasus.server.core.dtos.supply.AllergenInfoSheetCustomerConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.DeliverySlipBoxConfigComplete;
import ch.icit.pegasus.server.core.dtos.supply.DeliverySlipTemperatureLogEntryComplete;
import ch.icit.pegasus.server.core.dtos.supply.DepartmentManHoursCostComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.Bidirectional;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@DTO(target="ch.icit.pegasus.server.core.entities.supply.Customer")
public class CustomerComplete
extends CustomerLight {
    private List<DepartmentManHoursCostComplete> manHourCosts;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private ContactComplete deliveryContact;
    @IgnoreField
    @XmlAttribute
    private Long deliveryContactId;
    @XmlAttribute
    private Integer maxRoomTemperatureFoodExposureAtOPRP05;
    @XmlAttribute
    private Integer paymentDays;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private CurrencyComplete paymentCurrency;
    @XmlAttribute
    private Boolean discountAllowed = false;
    @XmlAttribute
    private Integer discountDays;
    @XmlAttribute
    private Double discountRate;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private BankConnectionComplete accountConnection;
    @Bidirectional(target="customer")
    private List<CreditCardRangeComplete> creditCardRanges;
    @Bidirectional(target="customer")
    private List<SobCurrencyComplete> sobCurrencies;
    @Bidirectional(target="customer")
    private List<CrewMemberComplete> crewMembers;
    @XmlAttribute
    private Double crewSoBDiscount;
    @XmlAttribute
    private Double crewCommission;
    @XmlAttribute
    private Double airlineCommission;
    @XmlAttribute
    private String sobCrewText;
    @XmlAttribute
    private String invoiceFormat = "{No} {Date}";
    @XmlAttribute
    private String vatNumber;
    @XmlAttribute
    private String information;
    @XmlAttribute
    private String signatureFieldText;
    @XmlAttribute
    private String signatureFieldCheckerText;
    @XmlAttribute
    private String signatureFieldDSText;
    @XmlAttribute
    private String signatureFieldAISText;
    @XmlAttribute
    private Boolean showAdditionalDelivery = false;
    @XmlAttribute
    private Boolean showAdditionalUplift = false;
    private List<DeliverySlipBoxConfigComplete> loadBoxes = new ArrayList<DeliverySlipBoxConfigComplete>();
    @XmlAttribute
    private Boolean showAllergenErrorLogAtBeginning = false;
    @XmlAttribute
    private Integer allergenErrorLogCount = 1;
    @XmlAttribute
    private Boolean showAllergenCodeIndexAtBeginning = false;
    @XmlAttribute
    private Integer allergenCodeIndexCount = 1;
    @XmlAttribute
    private Boolean overrideDefaultAllergenCodeIndexAtTheEndCount = false;
    @XmlAttribute
    private Integer allergenCodeIndexAtTheEndCount = 1;
    @XmlAttribute
    private Boolean showProductCustomerNoOnAllergeInfoSheet = false;
    private List<AllergenInfoSheetCustomerConfigurationComplete> allergenInfoSheetByClassConfig;
    @XmlAttribute
    private Integer updateMaxCount;
    @XmlAttribute
    private Boolean showEmailOnInvoiceHeader;
    private List<DeliverySlipTemperatureLogEntryComplete> deliverySlipTemperatureLogEntries;
    @XmlAttribute
    private String globalLocationNumber;
    private EdelweissReportConfigurationComplete edelweissReportConfiguration;

    public CustomerComplete() {
        this.creditCardRanges = new ArrayList<CreditCardRangeComplete>();
        this.sobCurrencies = new ArrayList<SobCurrencyComplete>();
        this.crewMembers = new ArrayList<CrewMemberComplete>();
        this.manHourCosts = new ArrayList<DepartmentManHoursCostComplete>();
        this.allergenInfoSheetByClassConfig = new ArrayList<AllergenInfoSheetCustomerConfigurationComplete>();
        this.deliverySlipTemperatureLogEntries = new ArrayList<DeliverySlipTemperatureLogEntryComplete>();
    }

    public Integer getMaxRoomTemperatureFoodExposureAtOPRP05() {
        return this.maxRoomTemperatureFoodExposureAtOPRP05;
    }

    public void setMaxRoomTemperatureFoodExposureAtOPRP05(Integer maxRoomTemperatureFoodExposureAtOPRP05) {
        this.maxRoomTemperatureFoodExposureAtOPRP05 = maxRoomTemperatureFoodExposureAtOPRP05;
    }

    public EdelweissReportConfigurationComplete getEdelweissReportConfiguration() {
        return this.edelweissReportConfiguration;
    }

    public void setEdelweissReportConfiguration(EdelweissReportConfigurationComplete edelweissReportConfiguration) {
        this.edelweissReportConfiguration = edelweissReportConfiguration;
    }

    public ContactComplete getDeliveryContact() {
        return this.deliveryContact;
    }

    public void setDeliveryContact(ContactComplete deliveryContact) {
        this.deliveryContact = deliveryContact;
    }

    public String getInvoiceFormat() {
        return this.invoiceFormat;
    }

    public void setInvoiceFormat(String invoiceFormat) {
        this.invoiceFormat = invoiceFormat;
    }

    public Double getCrewSoBDiscount() {
        return this.crewSoBDiscount;
    }

    public void setCrewSoBDiscount(Double crewSoBDiscount) {
        this.crewSoBDiscount = crewSoBDiscount;
    }

    public List<SobCurrencyComplete> getSobCurrencies() {
        return this.sobCurrencies;
    }

    public void setSobCurrencies(List<SobCurrencyComplete> sobCurrencies) {
        this.sobCurrencies = sobCurrencies;
    }

    public List<CreditCardRangeComplete> getCreditCardRanges() {
        return this.creditCardRanges;
    }

    public void setCreditCardRanges(List<CreditCardRangeComplete> creditCardRanges) {
        this.creditCardRanges = creditCardRanges;
    }

    public Double getDiscountRate() {
        return this.discountRate;
    }

    public void setDiscountRate(Double discountRate) {
        this.discountRate = discountRate;
    }

    public Boolean getDiscountAllowed() {
        return this.discountAllowed;
    }

    public void setDiscountAllowed(Boolean discountAllowed) {
        this.discountAllowed = discountAllowed;
    }

    public Integer getDiscountDays() {
        return this.discountDays;
    }

    public void setDiscountDays(Integer discountDays) {
        this.discountDays = discountDays;
    }

    public BankConnectionComplete getAccountConnection() {
        return this.accountConnection;
    }

    public void setAccountConnection(BankConnectionComplete accountConnection) {
        this.accountConnection = accountConnection;
    }

    public Integer getPaymentDays() {
        return this.paymentDays;
    }

    public void setPaymentDays(Integer paymentDays) {
        this.paymentDays = paymentDays;
    }

    public CurrencyComplete getPaymentCurrency() {
        return this.paymentCurrency;
    }

    public void setPaymentCurrency(CurrencyComplete paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
    }

    public List<CrewMemberComplete> getCrewMembers() {
        return this.crewMembers;
    }

    public void setCrewMembers(List<CrewMemberComplete> crewMembers) {
        this.crewMembers = crewMembers;
    }

    public String getSobCrewText() {
        return this.sobCrewText;
    }

    public void setSobCrewText(String sobCrewText) {
        this.sobCrewText = sobCrewText;
    }

    public Double getCrewCommission() {
        return this.crewCommission;
    }

    public void setCrewCommission(Double crewCommission) {
        this.crewCommission = crewCommission;
    }

    public Double getAirlineCommission() {
        return this.airlineCommission;
    }

    public void setAirlineCommission(Double airlineCommission) {
        this.airlineCommission = airlineCommission;
    }

    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public String getInformation() {
        return this.information;
    }

    public void setInformation(String information) {
        this.information = information;
    }

    public String getSignatureFieldText() {
        return this.signatureFieldText;
    }

    public void setSignatureFieldText(String signatureFieldText) {
        this.signatureFieldText = signatureFieldText;
    }

    public Boolean getShowAdditionalUplift() {
        return this.showAdditionalUplift;
    }

    public void setShowAdditionalUplift(Boolean showAdditionalUplift) {
        this.showAdditionalUplift = showAdditionalUplift;
    }

    public List<DeliverySlipBoxConfigComplete> getLoadBoxes() {
        return this.loadBoxes;
    }

    public void setLoadBoxes(List<DeliverySlipBoxConfigComplete> loadBoxes) {
        this.loadBoxes = loadBoxes;
    }

    public Boolean getShowAdditionalDelivery() {
        return this.showAdditionalDelivery;
    }

    public void setShowAdditionalDelivery(Boolean showAdditionalDelivery) {
        this.showAdditionalDelivery = showAdditionalDelivery;
    }

    public String getSignatureFieldCheckerText() {
        return this.signatureFieldCheckerText;
    }

    public void setSignatureFieldCheckerText(String signatureFieldCheckerText) {
        this.signatureFieldCheckerText = signatureFieldCheckerText;
    }

    public String getSignatureFieldDSText() {
        return this.signatureFieldDSText;
    }

    public void setSignatureFieldDSText(String signatureFieldDSText) {
        this.signatureFieldDSText = signatureFieldDSText;
    }

    public String getSignatureFieldAISText() {
        return this.signatureFieldAISText;
    }

    public void setSignatureFieldAISText(String signatureFieldAISText) {
        this.signatureFieldAISText = signatureFieldAISText;
    }

    public List<DepartmentManHoursCostComplete> getManHourCosts() {
        return this.manHourCosts;
    }

    public void setManHourCosts(List<DepartmentManHoursCostComplete> manHourCosts) {
        this.manHourCosts = manHourCosts;
    }

    public Boolean getShowAllergenErrorLogAtBeginning() {
        return this.showAllergenErrorLogAtBeginning;
    }

    public void setShowAllergenErrorLogAtBeginning(Boolean showAllergenErrorLogAtBeginning) {
        this.showAllergenErrorLogAtBeginning = showAllergenErrorLogAtBeginning;
    }

    public Integer getAllergenErrorLogCount() {
        return this.allergenErrorLogCount;
    }

    public void setAllergenErrorLogCount(Integer allergenErrorLogCount) {
        this.allergenErrorLogCount = allergenErrorLogCount;
    }

    public Boolean getShowAllergenCodeIndexAtBeginning() {
        return this.showAllergenCodeIndexAtBeginning;
    }

    public void setShowAllergenCodeIndexAtBeginning(Boolean showAllergenCodeIndexAtBeginning) {
        this.showAllergenCodeIndexAtBeginning = showAllergenCodeIndexAtBeginning;
    }

    public Integer getAllergenCodeIndexCount() {
        return this.allergenCodeIndexCount;
    }

    public void setAllergenCodeIndexCount(Integer allergenCodeIndexCount) {
        this.allergenCodeIndexCount = allergenCodeIndexCount;
    }

    public Boolean getOverrideDefaultAllergenCodeIndexAtTheEndCount() {
        return this.overrideDefaultAllergenCodeIndexAtTheEndCount;
    }

    public void setOverrideDefaultAllergenCodeIndexAtTheEndCount(Boolean overrideDefaultAllergenCodeIndexAtTheEndCount) {
        this.overrideDefaultAllergenCodeIndexAtTheEndCount = overrideDefaultAllergenCodeIndexAtTheEndCount;
    }

    public Integer getAllergenCodeIndexAtTheEndCount() {
        return this.allergenCodeIndexAtTheEndCount;
    }

    public void setAllergenCodeIndexAtTheEndCount(Integer allergenCodeIndexAtTheEndCount) {
        this.allergenCodeIndexAtTheEndCount = allergenCodeIndexAtTheEndCount;
    }

    public Boolean getShowProductCustomerNoOnAllergeInfoSheet() {
        return this.showProductCustomerNoOnAllergeInfoSheet;
    }

    public void setShowProductCustomerNoOnAllergeInfoSheet(Boolean showProductCustomerNoOnAllergeInfoSheet) {
        this.showProductCustomerNoOnAllergeInfoSheet = showProductCustomerNoOnAllergeInfoSheet;
    }

    public List<AllergenInfoSheetCustomerConfigurationComplete> getAllergenInfoSheetByClassConfig() {
        return this.allergenInfoSheetByClassConfig;
    }

    public void setAllergenInfoSheetByClassConfig(List<AllergenInfoSheetCustomerConfigurationComplete> allergenInfoSheetByClassConfig) {
        this.allergenInfoSheetByClassConfig = allergenInfoSheetByClassConfig;
    }

    public Integer getUpdateMaxCount() {
        return this.updateMaxCount;
    }

    public void setUpdateMaxCount(Integer updateMaxCount) {
        this.updateMaxCount = updateMaxCount;
    }

    public Boolean getShowEmailOnInvoiceHeader() {
        return this.showEmailOnInvoiceHeader;
    }

    public void setShowEmailOnInvoiceHeader(Boolean showEmailOnInvoiceHeader) {
        this.showEmailOnInvoiceHeader = showEmailOnInvoiceHeader;
    }

    public List<DeliverySlipTemperatureLogEntryComplete> getDeliverySlipTemperatureLogEntries() {
        return this.deliverySlipTemperatureLogEntries;
    }

    public void setDeliverySlipTemperatureLogEntries(List<DeliverySlipTemperatureLogEntryComplete> deliverySlipTemperatureLogEntries) {
        this.deliverySlipTemperatureLogEntries = deliverySlipTemperatureLogEntries;
    }

    public String getGlobalLocationNumber() {
        return this.globalLocationNumber;
    }

    public void setGlobalLocationNumber(String globalLocationNumber) {
        this.globalLocationNumber = globalLocationNumber;
    }

    public Long getDeliveryContactId() {
        return this.deliveryContactId;
    }

    public void setDeliveryContactId(Long deliveryContactId) {
        this.deliveryContactId = deliveryContactId;
    }

    @Override
    void beforeMarshal(Marshaller m) {
        super.beforeMarshal(m);
        if (this.deliveryContact != null) {
            this.deliveryContactId = this.deliveryContact.getId() != null ? this.deliveryContact.getId() : this.deliveryContact.getClientOId();
            this.deliveryContact = null;
        }
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        super.afterUnmarshal(u, parent);
        XmlCache.getXmlCache().put(this.getCacheId(), this);
        if (this.deliveryContactId != null) {
            this.setDeliveryContact((ContactComplete)XmlCache.getXmlCache().get(this.deliveryContactId));
        }
    }
}

