/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.flightschedule;

import ch.icit.pegasus.server.core.dtos.BasicLogComplete;
import ch.icit.pegasus.server.core.dtos.LoggedComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ReturnsCountStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete;
import ch.icit.pegasus.server.core.dtos.sob.CrewMemberComplete;
import ch.icit.pegasus.server.core.dtos.sob.SalesOnBoardStateE;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.SalesPersonComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.SqlTimestampAdapter;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.Bidirectional;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.FieldOrder;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@DTO(target="ch.icit.pegasus.server.core.entities.flight.Flight")
@FieldOrder(value={"legs", "activeStowingList"}, otherFields=FieldOrder.Order.AFTER)
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FlightLight
extends FlightReference
implements LoggedComplete,
Comparable<FlightLight> {
    @DTOField(readonly=true)
    private BasicLogComplete log;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @DTOField(nullable=false)
    private CustomerLight customer;
    private FlightTypeE flightType;
    @DTOField(updatable=false)
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private FlightScheduleReference flightSchedule;
    @DTOField(nullable=false)
    private FlightStateE flightState;
    @DTOField(nullable=false, empty=false)
    @XmlAttribute
    private String outboundCode;
    @IgnoreField
    @XmlAttribute
    private Integer flightScheduleNo;
    @DTOField(nullable=false, empty=false)
    @XmlAttribute
    private String inboundCode;
    @DTOField(nullable=false)
    @XmlJavaTypeAdapter(value=SqlTimestampAdapter.class)
    private Timestamp std;
    @DTOField(nullable=false)
    @XmlJavaTypeAdapter(value=SqlTimestampAdapter.class)
    private Timestamp sta;
    @XmlJavaTypeAdapter(value=SqlTimestampAdapter.class)
    private Timestamp realstd;
    @XmlJavaTypeAdapter(value=SqlTimestampAdapter.class)
    private Timestamp realsta;
    @DTOField(readonly=true)
    @XmlAttribute
    private Integer trackingNumber;
    @XmlJavaTypeAdapter(value=SqlTimestampAdapter.class)
    private Timestamp kitchenReadyTime;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private PaxFigureTypeComplete selectedPaxType;
    @XmlAttribute
    private Boolean invoicePaxSelected = false;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private StowingListLight activeStowingList;
    @Bidirectional(target="flight")
    @DTOField(empty=false)
    private List<FlightLegComplete> legs;
    @DTOField(target="adHoc")
    @XmlAttribute
    private Boolean adHoc;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private AirportComplete deliveryAirport;
    @IgnoreField
    @XmlAttribute
    private Boolean upliftCount = false;
    @XmlAttribute
    private Boolean hasStockTransactions = false;
    @DTOField(readonly=true)
    @XmlAttribute
    private Boolean hasStowingListChanged = false;
    @DTOField(readonly=true)
    private ReturnsCountStateE returnsCountState = ReturnsCountStateE.NOT_COUNTED;
    @IgnoreField
    @XmlAttribute
    private Boolean isSobInvoiced = false;
    @DTOField(updatable=false)
    @XmlAttribute
    private String cancelRemark;
    @DTOField(readonly=true)
    @XmlJavaTypeAdapter(value=SqlTimestampAdapter.class)
    @XmlElement(name="cancelTimestamp")
    private Timestamp cancelTime;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @DTOField(readonly=true)
    private UserLight cancelUser;
    private List<CustomsDocumentComplete> customsDocuments;
    @XmlAttribute
    private Boolean noStockIrregularities = true;
    @IgnoreField(readonly=true)
    @XmlAttribute
    private Boolean isInvoiceClosed = false;
    @XmlAttribute
    private Boolean autoCheckout = true;
    private SalesOnBoardStateE sobState = SalesOnBoardStateE.NONE;
    @XmlAttribute
    private Boolean sobLoadFlightToHandheld = false;
    @XmlAttribute
    private String sobBarSetNumber;
    private List<CrewMemberComplete> sobCrewMembers;
    @XmlAttribute
    private Boolean sobFIrregularity = false;
    @XmlAttribute
    private String sobFIrregularityComment;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private HaulTypeComplete haulType;
    @XmlAttribute
    private Boolean predefineInvoiceCanceledFlightMeal = false;
    @XmlAttribute
    private Boolean predefineInvoiceCanceledFlightHandling = false;
    @XmlAttribute
    private Boolean predefineInvoiceCanceledFlightStandard = false;
    @XmlAttribute
    private Boolean predefineInvoiceCanceledFlightAdditional = false;
    @XmlAttribute
    private Boolean predefineInvoiceCanceledFlightHandlingFromStowing = false;
    @XmlAttribute
    private Boolean substitutionsApproved = false;
    @XmlJavaTypeAdapter(value=SqlTimestampAdapter.class)
    private Timestamp substitutionsApprovedDate;
    private UserReference substitutionsApprovedUser;
    @XmlAttribute
    private Boolean hasSubstitutions = false;
    @XmlAttribute
    private Boolean createdFromCIS = false;
    @XmlAttribute
    private Boolean ediFlight;
    @XmlAttribute
    private Boolean ediFlightBlocked;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private FlightCategoryComplete category;
    @XmlAttribute
    private Boolean aisPrintNeeded = false;
    @XmlAttribute
    private Boolean fillEmptyEquipments = false;
    @XmlAttribute
    private Boolean retailInMotionImportState;
    @XmlAttribute
    private Boolean retailInMotionTransactionValidity;
    @XmlAttribute
    private Boolean hasRetailInMotionTransactions;
    @XmlAttribute
    private String shortFlightCode;
    @IgnoreField(readonly=true)
    @XmlAttribute
    private Boolean invoiceNormalMeal = false;
    @IgnoreField(readonly=true)
    @XmlAttribute
    private Boolean invoiceNormalHandling = false;
    @IgnoreField(readonly=true)
    @XmlAttribute
    private Boolean invoiceNormalHandlingFromStowing = false;
    @IgnoreField(readonly=true)
    @XmlAttribute
    private Boolean invoiceNormalStandard = false;
    @IgnoreField(readonly=true)
    @XmlAttribute
    private Boolean invoiceNormalAdditional = false;
    @XmlAttribute
    private Boolean hasGroTransactions = false;
    @IgnoreField(readonly=true)
    @XmlAttribute
    private Boolean invoiceSent;
    @XmlAttribute
    private Boolean retailInMotionCheckoutDone;
    @XmlAttribute
    private Boolean retailInMotionCheckinDone;
    @XmlAttribute
    private Boolean hasTuiFlyPreOrders;
    @XmlAttribute
    private Boolean tuiFlyPreOrderValidity;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private SalesPersonComplete commissionSalesPerson;
    @XmlAttribute
    private Boolean excludeFromKitchenForecast;
    @XmlAttribute
    @IgnoreField
    private Boolean deliverySlipSent;
    @DTOField(readonly=true)
    @XmlJavaTypeAdapter(value=SqlTimestampAdapter.class)
    @XmlElement(name="checkoutTimestamp")
    private Timestamp checkoutTime;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @DTOField(readonly=true)
    private UserLight checkoutUser;
    @XmlAttribute
    private Boolean checkout;
    @XmlAttribute
    private Boolean edelweissPaxUpdate;
    private RestaurantComplete restaurant;
    @XmlAttribute
    private Boolean flightOrderReceived;
    @XmlJavaTypeAdapter(value=SqlTimestampAdapter.class)
    private Timestamp lastLimeFlightUpdate;
    @XmlAttribute
    private String lastLimeFlightUpdateType;
    @XmlAttribute
    private Boolean allowStowingListReload;
    @XmlAttribute
    private Boolean ignoreLimeFlightUpdate;

    public FlightLight() {
        this.legs = new ArrayList<FlightLegComplete>();
        this.customsDocuments = new ArrayList<CustomsDocumentComplete>();
        this.sobCrewMembers = new ArrayList<CrewMemberComplete>();
    }

    public Boolean getIgnoreLimeFlightUpdate() {
        return this.ignoreLimeFlightUpdate;
    }

    public void setIgnoreLimeFlightUpdate(Boolean ignoreLimeFlightUpdate) {
        this.ignoreLimeFlightUpdate = ignoreLimeFlightUpdate;
    }

    public Boolean getAllowStowingListReload() {
        return this.allowStowingListReload;
    }

    public void setAllowStowingListReload(Boolean allowStowingListReload) {
        this.allowStowingListReload = allowStowingListReload;
    }

    public String getLastLimeFlightUpdateType() {
        return this.lastLimeFlightUpdateType;
    }

    public void setLastLimeFlightUpdateType(String lastLimeFlightUpdateType) {
        this.lastLimeFlightUpdateType = lastLimeFlightUpdateType;
    }

    public Timestamp getLastLimeFlightUpdate() {
        return this.lastLimeFlightUpdate;
    }

    public void setLastLimeFlightUpdate(Timestamp lastLimeFlightUpdate) {
        this.lastLimeFlightUpdate = lastLimeFlightUpdate;
    }

    public Boolean getFlightOrderReceived() {
        return this.flightOrderReceived;
    }

    public void setFlightOrderReceived(Boolean flightOrderReceived) {
        this.flightOrderReceived = flightOrderReceived;
    }

    public Boolean getEdelweissPaxUpdate() {
        return this.edelweissPaxUpdate;
    }

    public void setEdelweissPaxUpdate(Boolean edelweissPaxUpdate) {
        this.edelweissPaxUpdate = edelweissPaxUpdate;
    }

    public HaulTypeComplete getHaulType() {
        return this.haulType;
    }

    public void setHaulType(HaulTypeComplete haulType) {
        this.haulType = haulType;
    }

    public Boolean getPredefineInvoiceCanceledFlightAdditional() {
        return this.predefineInvoiceCanceledFlightAdditional;
    }

    public void setPredefineInvoiceCanceledFlightAdditional(Boolean predefineInvoiceCanceledFlightAdditional) {
        this.predefineInvoiceCanceledFlightAdditional = predefineInvoiceCanceledFlightAdditional;
    }

    public Boolean getPredefineInvoiceCanceledFlightMeal() {
        return this.predefineInvoiceCanceledFlightMeal;
    }

    public void setPredefineInvoiceCanceledFlightMeal(Boolean predefineInvoiceCanceledFlightMeal) {
        this.predefineInvoiceCanceledFlightMeal = predefineInvoiceCanceledFlightMeal;
    }

    public Boolean getPredefineInvoiceCanceledFlightHandling() {
        return this.predefineInvoiceCanceledFlightHandling;
    }

    public void setPredefineInvoiceCanceledFlightHandling(Boolean predefineInvoiceCanceledFlightHandling) {
        this.predefineInvoiceCanceledFlightHandling = predefineInvoiceCanceledFlightHandling;
    }

    public Boolean getPredefineInvoiceCanceledFlightStandard() {
        return this.predefineInvoiceCanceledFlightStandard;
    }

    public void setPredefineInvoiceCanceledFlightStandard(Boolean predefineInvoiceCanceledFlightStandard) {
        this.predefineInvoiceCanceledFlightStandard = predefineInvoiceCanceledFlightStandard;
    }

    public Boolean getAutoCheckout() {
        return this.autoCheckout;
    }

    public void setAutoCheckout(Boolean autoCheckout) {
        this.autoCheckout = autoCheckout;
    }

    public Boolean getIsInvoiceClosed() {
        return this.isInvoiceClosed;
    }

    public void setIsInvoiceClosed(Boolean isInvoiceClosed) {
        this.isInvoiceClosed = isInvoiceClosed;
    }

    public String getCancelRemark() {
        return this.cancelRemark;
    }

    public void setCancelRemark(String cancelRemark) {
        this.cancelRemark = cancelRemark;
    }

    public Timestamp getCancelTime() {
        return this.cancelTime;
    }

    public void setCancelTime(Timestamp cancelTime) {
        this.cancelTime = cancelTime;
    }

    public UserLight getCancelUser() {
        return this.cancelUser;
    }

    public void setCancelUser(UserLight cancelUser) {
        this.cancelUser = cancelUser;
    }

    public Integer getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(Integer trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.std).append(" - ");
        str.append(this.customer == null ? null : this.customer.getCode()).append(" - ");
        str.append(this.outboundCode);
        return str.toString();
    }

    public Boolean isInvoiced() {
        return Boolean.TRUE.equals(this.invoiceNormalAdditional) || Boolean.TRUE.equals(this.invoiceNormalHandling) || Boolean.TRUE.equals(this.invoiceNormalMeal) || Boolean.TRUE.equals(this.invoiceNormalAdditional);
    }

    public Timestamp getRealstd() {
        return this.realstd;
    }

    public void setRealstd(Timestamp realstd) {
        this.realstd = realstd;
    }

    public Timestamp getRealsta() {
        return this.realsta;
    }

    public void setRealsta(Timestamp realsta) {
        this.realsta = realsta;
    }

    public String getInboundCode() {
        return this.inboundCode;
    }

    public void setInboundCode(String inboundCode) {
        this.inboundCode = inboundCode;
    }

    public FlightTypeE getFlightType() {
        return this.flightType;
    }

    public void setFlightType(FlightTypeE flightType) {
        this.flightType = flightType;
    }

    public List<FlightLegComplete> getLegs() {
        return this.legs;
    }

    public void setLegs(List<FlightLegComplete> legs) {
        this.legs = legs;
    }

    public CustomerLight getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerLight customer) {
        this.customer = customer;
    }

    public FlightScheduleReference getFlightSchedule() {
        return this.flightSchedule;
    }

    public void setFlightSchedule(FlightScheduleReference flightSchedule) {
        this.flightSchedule = flightSchedule;
    }

    public FlightStateE getFlightState() {
        return this.flightState;
    }

    public void setFlightState(FlightStateE flightState) {
        this.flightState = flightState;
    }

    public String getOutboundCode() {
        return this.outboundCode;
    }

    public void setOutboundCode(String outboundCode) {
        this.outboundCode = outboundCode;
    }

    public Timestamp getStd() {
        return this.std;
    }

    public void setStd(Timestamp std) {
        this.std = std;
    }

    public StowingListLight getActiveStowingList() {
        return this.activeStowingList;
    }

    public void setActiveStowingList(StowingListLight activeStowingList) {
        this.activeStowingList = activeStowingList;
    }

    public void setSta(Timestamp sta) {
        this.sta = sta;
    }

    public Timestamp getSta() {
        return this.sta;
    }

    public Boolean getAdHoc() {
        return this.adHoc;
    }

    public void setAdHoc(Boolean adHoc) {
        this.adHoc = adHoc;
    }

    public AirportComplete getDeliveryAirport() {
        return this.deliveryAirport;
    }

    public void setDeliveryAirport(AirportComplete deliveryAirport) {
        this.deliveryAirport = deliveryAirport;
    }

    public Boolean getUpliftCount() {
        return this.upliftCount;
    }

    public void setUpliftCount(Boolean upliftCount) {
        this.upliftCount = upliftCount;
    }

    @Override
    public BasicLogComplete getLog() {
        return this.log;
    }

    @Override
    public void setLog(BasicLogComplete log) {
        this.log = log;
    }

    public Boolean getHasStowingListChanged() {
        return this.hasStowingListChanged;
    }

    public void setHasStowingListChanged(Boolean hasStowingListChanged) {
        this.hasStowingListChanged = hasStowingListChanged;
    }

    public ReturnsCountStateE getReturnsCountState() {
        return this.returnsCountState;
    }

    public void setReturnsCountState(ReturnsCountStateE returnsCountState) {
        this.returnsCountState = returnsCountState;
    }

    public Boolean getHasStockTransactions() {
        return this.hasStockTransactions;
    }

    public void setHasStockTransactions(Boolean hasStockTransactions) {
        this.hasStockTransactions = hasStockTransactions;
    }

    public List<CustomsDocumentComplete> getCustomsDocuments() {
        return this.customsDocuments;
    }

    public void setCustomsDocuments(List<CustomsDocumentComplete> customsDocuments) {
        this.customsDocuments = customsDocuments;
    }

    public Boolean getNoStockIrregularities() {
        return this.noStockIrregularities;
    }

    public void setNoStockIrregularities(Boolean noStockIrregularities) {
        this.noStockIrregularities = noStockIrregularities;
    }

    public Boolean getIsSobInvoiced() {
        return this.isSobInvoiced;
    }

    public void setIsSobInvoiced(Boolean isSobInvoiced) {
        this.isSobInvoiced = isSobInvoiced;
    }

    public Boolean getSubstitutionsApproved() {
        return this.substitutionsApproved;
    }

    public void setSubstitutionsApproved(Boolean substitutionsApproved) {
        this.substitutionsApproved = substitutionsApproved;
    }

    public Timestamp getSubstitutionsApprovedDate() {
        return this.substitutionsApprovedDate;
    }

    public void setSubstitutionsApprovedDate(Timestamp substitutionsApprovedDate) {
        this.substitutionsApprovedDate = substitutionsApprovedDate;
    }

    public UserReference getSubstitutionsApprovedUser() {
        return this.substitutionsApprovedUser;
    }

    public void setSubstitutionsApprovedUser(UserReference substitutionsApprovedUser) {
        this.substitutionsApprovedUser = substitutionsApprovedUser;
    }

    @Override
    public int compareTo(FlightLight o) {
        return this.std.compareTo(o.getStd());
    }

    public Boolean getCreatedFromCIS() {
        return this.createdFromCIS;
    }

    public void setCreatedFromCIS(Boolean createdFromCIS) {
        this.createdFromCIS = createdFromCIS;
    }

    public FlightCategoryComplete getCategory() {
        return this.category;
    }

    public void setCategory(FlightCategoryComplete category) {
        this.category = category;
    }

    public Boolean getHasSubstitutions() {
        return this.hasSubstitutions;
    }

    public void setHasSubstitutions(Boolean hasSubstitutions) {
        this.hasSubstitutions = hasSubstitutions;
    }

    public SalesOnBoardStateE getSobState() {
        return this.sobState;
    }

    public void setSobState(SalesOnBoardStateE sobState) {
        this.sobState = sobState;
    }

    public Boolean getSobLoadFlightToHandheld() {
        return this.sobLoadFlightToHandheld;
    }

    public void setSobLoadFlightToHandheld(Boolean sobLoadFlightToHandheld) {
        this.sobLoadFlightToHandheld = sobLoadFlightToHandheld;
    }

    public String getSobBarSetNumber() {
        return this.sobBarSetNumber;
    }

    public void setSobBarSetNumber(String sobBarSetNumber) {
        this.sobBarSetNumber = sobBarSetNumber;
    }

    public List<CrewMemberComplete> getSobCrewMembers() {
        return this.sobCrewMembers;
    }

    public void setSobCrewMembers(List<CrewMemberComplete> sobCrewMembers) {
        this.sobCrewMembers = sobCrewMembers;
    }

    public Boolean getSobFIrregularity() {
        return this.sobFIrregularity;
    }

    public void setSobFIrregularity(Boolean sobFIrregularity) {
        this.sobFIrregularity = sobFIrregularity;
    }

    public String getSobFIrregularityComment() {
        return this.sobFIrregularityComment;
    }

    public void setSobFIrregularityComment(String sobFIrregularityComment) {
        this.sobFIrregularityComment = sobFIrregularityComment;
    }

    public Boolean getAisPrintNeeded() {
        return this.aisPrintNeeded;
    }

    public void setAisPrintNeeded(Boolean aisPrintNeeded) {
        this.aisPrintNeeded = aisPrintNeeded;
    }

    public PaxFigureTypeComplete getSelectedPaxType() {
        return this.selectedPaxType;
    }

    public void setSelectedPaxType(PaxFigureTypeComplete selectedPaxType) {
        this.selectedPaxType = selectedPaxType;
    }

    public Boolean getInvoicePaxSelected() {
        return this.invoicePaxSelected;
    }

    public void setInvoicePaxSelected(Boolean invoicePaxSelected) {
        this.invoicePaxSelected = invoicePaxSelected;
    }

    public Boolean getFillEmptyEquipments() {
        return this.fillEmptyEquipments;
    }

    public void setFillEmptyEquipments(Boolean fillEmptyEquipments) {
        this.fillEmptyEquipments = fillEmptyEquipments;
    }

    public Boolean getRetailInMotionImportState() {
        return this.retailInMotionImportState;
    }

    public void setRetailInMotionImportState(Boolean retailInMotionImportState) {
        this.retailInMotionImportState = retailInMotionImportState;
    }

    public Boolean getRetailInMotionTransactionValidity() {
        return this.retailInMotionTransactionValidity;
    }

    public void setRetailInMotionTransactionValidity(Boolean retailInMotionTransactionValidity) {
        this.retailInMotionTransactionValidity = retailInMotionTransactionValidity;
    }

    public Boolean getHasRetailInMotionTransactions() {
        return this.hasRetailInMotionTransactions;
    }

    public void setHasRetailInMotionTransactions(Boolean hasRetailInMotionTransactions) {
        this.hasRetailInMotionTransactions = hasRetailInMotionTransactions;
    }

    public String getShortFlightCode() {
        return this.shortFlightCode;
    }

    public void setShortFlightCode(String shortFlightCode) {
        this.shortFlightCode = shortFlightCode;
    }

    public Boolean getInvoiceNormalMeal() {
        return this.invoiceNormalMeal;
    }

    public void setInvoiceNormalMeal(Boolean invoiceNormalMeal) {
        this.invoiceNormalMeal = invoiceNormalMeal;
    }

    public Boolean getInvoiceNormalHandling() {
        return this.invoiceNormalHandling;
    }

    public void setInvoiceNormalHandling(Boolean invoiceNormalHandling) {
        this.invoiceNormalHandling = invoiceNormalHandling;
    }

    public Boolean getInvoiceNormalStandard() {
        return this.invoiceNormalStandard;
    }

    public void setInvoiceNormalStandard(Boolean invoiceNormalStandard) {
        this.invoiceNormalStandard = invoiceNormalStandard;
    }

    public Boolean getInvoiceNormalAdditional() {
        return this.invoiceNormalAdditional;
    }

    public void setInvoiceNormalAdditional(Boolean invoiceNormalAdditional) {
        this.invoiceNormalAdditional = invoiceNormalAdditional;
    }

    public Boolean getHasGroTransactions() {
        return this.hasGroTransactions;
    }

    public void setHasGroTransactions(Boolean hasGroTransactions) {
        this.hasGroTransactions = hasGroTransactions;
    }

    public Boolean getInvoiceSent() {
        return this.invoiceSent;
    }

    public void setInvoiceSent(Boolean invoiceSent) {
        this.invoiceSent = invoiceSent;
    }

    public Boolean getRetailInMotionCheckoutDone() {
        return this.retailInMotionCheckoutDone;
    }

    public void setRetailInMotionCheckoutDone(Boolean retailInMotionCheckoutDone) {
        this.retailInMotionCheckoutDone = retailInMotionCheckoutDone;
    }

    public Boolean getRetailInMotionCheckinDone() {
        return this.retailInMotionCheckinDone;
    }

    public void setRetailInMotionCheckinDone(Boolean retailInMotionCheckinDone) {
        this.retailInMotionCheckinDone = retailInMotionCheckinDone;
    }

    public Boolean getExcludeFromKitchenForecast() {
        return this.excludeFromKitchenForecast;
    }

    public void setExcludeFromKitchenForecast(Boolean excludeFromKitchenForecast) {
        this.excludeFromKitchenForecast = excludeFromKitchenForecast;
    }

    public SalesPersonComplete getCommissionSalesPerson() {
        return this.commissionSalesPerson;
    }

    public void setCommissionSalesPerson(SalesPersonComplete commissionSalesPerson) {
        this.commissionSalesPerson = commissionSalesPerson;
    }

    public Timestamp getKitchenReadyTime() {
        return this.kitchenReadyTime;
    }

    public void setKitchenReadyTime(Timestamp kitchenReadyTime) {
        this.kitchenReadyTime = kitchenReadyTime;
    }

    public Boolean getPredefineInvoiceCanceledFlightHandlingFromStowing() {
        return this.predefineInvoiceCanceledFlightHandlingFromStowing;
    }

    public void setPredefineInvoiceCanceledFlightHandlingFromStowing(Boolean predefineInvoiceCanceledFlightHandlingFromStowing) {
        this.predefineInvoiceCanceledFlightHandlingFromStowing = predefineInvoiceCanceledFlightHandlingFromStowing;
    }

    public Boolean getInvoiceNormalHandlingFromStowing() {
        return this.invoiceNormalHandlingFromStowing;
    }

    public void setInvoiceNormalHandlingFromStowing(Boolean invoiceNormalHandlingFromStowing) {
        this.invoiceNormalHandlingFromStowing = invoiceNormalHandlingFromStowing;
    }

    public Boolean getHasTuiFlyPreOrders() {
        return this.hasTuiFlyPreOrders;
    }

    public void setHasTuiFlyPreOrders(Boolean hasTuiFlyPreOrders) {
        this.hasTuiFlyPreOrders = hasTuiFlyPreOrders;
    }

    public Boolean getTuiFlyPreOrderValidity() {
        return this.tuiFlyPreOrderValidity;
    }

    public void setTuiFlyPreOrderValidity(Boolean tuiFlyPreOrderValidity) {
        this.tuiFlyPreOrderValidity = tuiFlyPreOrderValidity;
    }

    public void setDeliverySlipSent(Boolean deliverySlipSent) {
        this.deliverySlipSent = deliverySlipSent;
    }

    public Boolean getDeliverySlipSent() {
        return this.deliverySlipSent;
    }

    public void beforeMarshal(Marshaller m) {
        XmlCache.getXmlCache().put(this.getId() != null ? this.getId() : this.getClientOId(), this);
    }

    public void afterMarshal(Unmarshaller m, Object o) {
        XmlCache.getXmlCache().put(this.getId() != null ? this.getId() : this.getClientOId(), this);
    }

    public UserLight getCheckoutUser() {
        return this.checkoutUser;
    }

    public void setCheckoutUser(UserLight checkoutUser) {
        this.checkoutUser = checkoutUser;
    }

    public Timestamp getCheckoutTime() {
        return this.checkoutTime;
    }

    public void setCheckoutTime(Timestamp checkoutTime) {
        this.checkoutTime = checkoutTime;
    }

    public Boolean getCheckout() {
        return this.checkout;
    }

    public void setCheckout(Boolean checkout) {
        this.checkout = checkout;
    }

    public RestaurantComplete getRestaurant() {
        return this.restaurant;
    }

    public void setRestaurant(RestaurantComplete restaurant) {
        this.restaurant = restaurant;
    }

    public Boolean getEdiFlight() {
        return this.ediFlight;
    }

    public void setEdiFlight(Boolean ediFlight) {
        this.ediFlight = ediFlight;
    }

    public Boolean getEdiFlightBlocked() {
        return this.ediFlightBlocked;
    }

    public void setEdiFlightBlocked(Boolean ediFlightBlocked) {
        this.ediFlightBlocked = ediFlightBlocked;
    }

    public Integer getFlightScheduleNo() {
        return this.flightScheduleNo;
    }

    public void setFlightScheduleNo(Integer flightScheduleNo) {
        this.flightScheduleNo = flightScheduleNo;
    }
}

