/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.flightschedule.stowing;

import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.EquipmentDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyDistributionRuleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSpecificationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.IStowingListComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightLevelComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceComplete;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.FieldOrder;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.Unmarshaller;

@DTO(target="ch.icit.pegasus.server.core.entities.stowing.StowingList")
@FieldOrder(value={"galleyEquipmentSets"}, otherFields=FieldOrder.Order.AFTER)
public class StowingListComplete
extends StowingListLight
implements IStowingListComplete {
    private Collection<DeliverableComplete> deliverables;
    private Collection<GalleyEquipmentSetComplete> galleyEquipmentSets = new ArrayList<GalleyEquipmentSetComplete>();
    @IgnoreField(readonly=true)
    private List<CateringServiceComplete> services = new ArrayList<CateringServiceComplete>();
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private FlightLevelComplete flightLevel;

    public StowingListComplete() {
        this.deliverables = new ArrayList<DeliverableComplete>();
    }

    public FlightLevelComplete getFlightLevel() {
        return this.flightLevel;
    }

    public void setFlightLevel(FlightLevelComplete flightLevel) {
        this.flightLevel = flightLevel;
    }

    @Override
    public Collection<GalleyEquipmentSetComplete> getGalleyEquipmentSets() {
        return this.galleyEquipmentSets;
    }

    @Override
    public void setGalleyEquipmentSets(Collection<GalleyEquipmentSetComplete> galleyEquipmentSets) {
        this.galleyEquipmentSets = galleyEquipmentSets;
    }

    public List<CateringServiceComplete> getServices() {
        return this.services;
    }

    public void setServices(List<CateringServiceComplete> services) {
        this.services = services;
    }

    @Override
    public Collection<DeliverableComplete> getDeliverables() {
        return this.deliverables;
    }

    @Override
    public void setDeliverables(Collection<DeliverableComplete> deliverables) {
        this.deliverables = deliverables;
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object o) {
        super.afterUnmarshal(u, o);
        this.refreshStowingAfterMarshal(this);
    }

    private void refreshStowingAfterMarshal(StowingListComplete l) {
        for (GalleyEquipmentSetComplete galleyEquipmentSet : l.getGalleyEquipmentSets()) {
            galleyEquipmentSet.afterMarshal(null, l);
            for (GalleyEquipmentSpecificationComplete spec : galleyEquipmentSet.getGalleyEquipmentSpecifications()) {
                this.refreshSpecification(galleyEquipmentSet, spec);
            }
            this.refreshSpecification(galleyEquipmentSet, galleyEquipmentSet.getLooseEquipment());
            this.refreshDistributions(galleyEquipmentSet.getGalleyDistributionRules());
        }
        for (DeliverableComplete deliverable : l.getDeliverables()) {
            this.refreshDistributions(deliverable.getDeliveryInstruction().getGalleyDistributionRules());
        }
    }

    private void refreshDistributions(List<GalleyDistributionRuleComplete> gdrs) {
        for (GalleyDistributionRuleComplete gdr : gdrs) {
            gdr.afterUnmarshal(null, null);
            this.refreshEqDistribution(gdr, gdr.getEquipmentDistributionRules());
        }
    }

    private void refreshEqDistribution(GalleyDistributionRuleComplete gdr, List<EquipmentDistributionRuleComplete> edrs) {
        for (EquipmentDistributionRuleComplete edr : edrs) {
            edr.afterUnmarshal(null, gdr);
            this.refreshSpaceDistribution(edr, edr.getInsertDistributionRule());
        }
    }

    private void refreshSpaceDistribution(EquipmentDistributionRuleComplete edr, List<DeliverySpaceDistributionRuleComplete> idrs) {
        for (DeliverySpaceDistributionRuleComplete idr : idrs) {
            idr.afterUnmarshal(null, edr);
        }
    }

    private void refreshSpecification(GalleyEquipmentSetComplete galleyEquipmentSet, GalleyEquipmentSpecificationComplete spec) {
        this.refreshEq(galleyEquipmentSet, spec.getUsedGalleyEquipment());
        this.refreshEq(galleyEquipmentSet, spec.getAlternativeEquipment());
    }

    private void refreshEq(GalleyEquipmentSetComplete galleyEquipmentSet, List<GalleyEquipmentComplete> eqs) {
        for (GalleyEquipmentComplete eq : eqs) {
            eq.afterUnmarshal(null, galleyEquipmentSet);
            this.refreshEqDistribution(null, eq.getEquipmentDistributionRules());
            for (DeliverySpaceComplete deliverySpace : eq.getDeliverySpaces()) {
                deliverySpace.afterUnmarshal(null, eq);
                this.refreshSpaceDistribution(null, deliverySpace.getDistributionRules());
            }
        }
    }
}

