/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.handlingcost;

import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostTypeE;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantReference;
import ch.icit.pegasus.server.core.dtos.handlingcost.PriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.DiscountTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.CateringPointCostComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.util.VariantLight;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@DTO(target="ch.icit.pegasus.server.core.entities.handlingcost.HandlingCostVariant")
public class HandlingCostVariantComplete
extends HandlingCostVariantReference
implements VariantLight,
Comparable<HandlingCostVariantComplete> {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.NONE)
    private static Logger logger = LoggerFactory.getLogger(HandlingCostVariantComplete.class);
    private PeriodComplete validityPeriod;
    @DTOField(readonly=true)
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private HandlingCostComplete base;
    @IgnoreField
    @XmlAttribute
    private Long baseId;
    @IgnoreField
    @XmlAttribute
    private Integer baseNumber;
    @IgnoreField
    @XmlAttribute
    private String baseCustomer;
    @IgnoreField
    @XmlAttribute
    private Boolean baseDeleted;
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String customerInvoiceNumber;
    private HandlingCostTypeE type;
    private PriceCalculationComplete quantity;
    private ModificationStateE state;
    private HandlingCostDeliverableComplete deliverable;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<CabinClassComplete> paxClasses = new ArrayList<CabinClassComplete>();
    private List<CateringPointCostComplete> cateringPointCosts = new ArrayList<CateringPointCostComplete>();
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<TaxRateComplete> taxRates = new ArrayList<TaxRateComplete>();
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<DiscountTypeComplete> discounts = new ArrayList<DiscountTypeComplete>();
    @XmlAttribute
    private Boolean spmlPax;
    @XmlAttribute
    private String reportName;
    @XmlAttribute
    private Boolean liableToCustoms = false;
    @XmlAttribute
    private String remark;
    @XmlAttribute
    private String comment;
    @XmlAttribute
    private Boolean excludeFromCanBeUseFromOtherCustomers;

    public Double getTotalDiscountRate() {
        Double dis = 0.0;
        for (DiscountTypeComplete dicType : this.discounts) {
            dis = dis + dicType.getRate();
        }
        return dis;
    }

    public Boolean getSpmlPax() {
        return this.spmlPax;
    }

    public void setSpmlPax(Boolean spmlPax) {
        this.spmlPax = spmlPax;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public HandlingCostComplete getBase() {
        return this.base;
    }

    public void setBase(HandlingCostComplete base) {
        this.base = base;
    }

    @Override
    public PeriodComplete getValidityPeriod() {
        return this.validityPeriod;
    }

    @Override
    public void setValidityPeriod(PeriodComplete validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HandlingCostTypeE getType() {
        return this.type;
    }

    public void setType(HandlingCostTypeE type) {
        this.type = type;
    }

    public PriceCalculationComplete getQuantity() {
        return this.quantity;
    }

    public void setQuantity(PriceCalculationComplete quantity) {
        this.quantity = quantity;
    }

    public ModificationStateE getState() {
        return this.state;
    }

    public void setState(ModificationStateE state) {
        this.state = state;
    }

    public HandlingCostDeliverableComplete getDeliverable() {
        return this.deliverable;
    }

    public void setDeliverable(HandlingCostDeliverableComplete deliverable) {
        this.deliverable = deliverable;
    }

    public List<CabinClassComplete> getPaxClasses() {
        return this.paxClasses;
    }

    public void setPaxClasses(List<CabinClassComplete> paxClasses) {
        this.paxClasses = paxClasses;
    }

    public List<CateringPointCostComplete> getCateringPointCosts() {
        return this.cateringPointCosts;
    }

    public void setCateringPointCosts(List<CateringPointCostComplete> cateringPointCosts) {
        this.cateringPointCosts = cateringPointCosts;
    }

    public List<TaxRateComplete> getTaxRates() {
        return this.taxRates;
    }

    public void setTaxRates(List<TaxRateComplete> taxRates) {
        this.taxRates = taxRates;
    }

    public String getCustomerInvoiceNumber() {
        return this.customerInvoiceNumber;
    }

    public void setCustomerInvoiceNumber(String customerInvoiceNumber) {
        this.customerInvoiceNumber = customerInvoiceNumber;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Boolean getLiableToCustoms() {
        return this.liableToCustoms;
    }

    public void setLiableToCustoms(Boolean liableToCustoms) {
        this.liableToCustoms = liableToCustoms;
    }

    @Override
    public int compareTo(HandlingCostVariantComplete o) {
        return this.base.getNumber() - o.getBase().getNumber();
    }

    public List<DiscountTypeComplete> getDiscounts() {
        return this.discounts;
    }

    public void setDiscounts(List<DiscountTypeComplete> discounts) {
        this.discounts = discounts;
    }

    public Boolean getExcludeFromCanBeUseFromOtherCustomers() {
        return this.excludeFromCanBeUseFromOtherCustomers;
    }

    public void setExcludeFromCanBeUseFromOtherCustomers(Boolean excludeFromCanBeUseFromOtherCustomers) {
        this.excludeFromCanBeUseFromOtherCustomers = excludeFromCanBeUseFromOtherCustomers;
    }

    public Long getBaseId() {
        return this.baseId;
    }

    public void setBaseId(Long baseId) {
        this.baseId = baseId;
    }

    public Integer getBaseNumber() {
        return this.baseNumber;
    }

    public void setBaseNumber(Integer baseNumber) {
        this.baseNumber = baseNumber;
    }

    public String getBaseCustomer() {
        return this.baseCustomer;
    }

    public void setBaseCustomer(String baseCustomer) {
        this.baseCustomer = baseCustomer;
    }

    public Boolean getBaseDeleted() {
        return this.baseDeleted;
    }

    public void setBaseDeleted(Boolean baseDeleted) {
        this.baseDeleted = baseDeleted;
    }

    public void beforeMarshal(Marshaller m) {
        try {
            if (this.getBase() != null) {
                this.setBaseId(this.getBase().getId());
                this.setBaseNumber(this.getBase().getNumber());
                if (this.getBase().getCustomer() != null) {
                    this.setBaseCustomer(this.getBase().getCustomer().getNumber() + " - " + this.getBase().getCustomer().getName());
                }
                this.setBaseDeleted(this.getBase().getIsDeleted());
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        if (parent instanceof HandlingCostComplete) {
            this.base = (HandlingCostComplete)parent;
        } else if (this.getBaseId() != null && XmlCache.getXmlCache().get(this.getBaseId()) != null) {
            this.setBase((HandlingCostComplete)XmlCache.getXmlCache().get(this.getBaseId()));
        }
    }
}

