/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.recipe;

import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryLight;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DTO(target="ch.icit.pegasus.server.core.entities.masterdata.RecipeCategory")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class RecipeCategoryComplete
extends RecipeCategoryLight {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.NONE)
    private static Logger logger = LoggerFactory.getLogger(RecipeCategoryComplete.class);
    private List<RecipeCategoryComplete> subCategories = new ArrayList<RecipeCategoryComplete>();

    public RecipeCategoryComplete() {
    }

    public RecipeCategoryComplete(Long id, String name, RecipeCategoryComplete parent) {
        this();
        this.setId(id);
        this.setName(name);
        this.setParent(parent);
    }

    public List<RecipeCategoryComplete> getSubCategories() {
        return this.subCategories;
    }

    public void setSubCategories(List<RecipeCategoryComplete> subCategories) {
        this.subCategories = subCategories;
    }

    @Override
    public void beforeMarshal(Marshaller m) {
        try {
            super.beforeMarshal(m);
            this.subCategories.forEach(productCategoryComplete -> productCategoryComplete.beforeMarshal(m));
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    @Override
    public void afterUnmarshal(Unmarshaller u, Object parent) {
        try {
            XmlCache.getXmlCache().put(this.getCacheId(), this);
            super.afterUnmarshal(u, parent);
            for (RecipeCategoryComplete subCategory : this.subCategories) {
                subCategory.setParent(this);
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }
}

