/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.recipe;

import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CommodityLight;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PreparationGroupComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.RecipeProductGroupComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.util.VariantLight;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.SqlTimestampAdapter;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.sql.Timestamp;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@DTO(target="ch.icit.pegasus.server.core.entities.recipe.RecipeVariant")
public class RecipeVariantLight
extends RecipeVariantReference
implements CommodityLight,
VariantLight,
Comparable<RecipeVariantLight> {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.NONE)
    private static Logger logger = LoggerFactory.getLogger(RecipeVariantLight.class);
    @XmlAttribute
    private Integer number;
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String englishName;
    @XmlJavaTypeAdapter(value=SqlTimestampAdapter.class)
    private Timestamp creationDate;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private RecipeCategoryLight category;
    private PegasusFileComplete imageReference;
    private ModificationStateE state;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private RecipeComplete recipe;
    @IgnoreField
    @XmlAttribute
    private Long recipeId;
    @IgnoreField
    @XmlAttribute
    private Integer recipeNumber;
    @IgnoreField
    @XmlAttribute
    private Boolean deleted;
    @IgnoreField
    @XmlAttribute
    private Boolean serviceItem;
    @XmlAttribute
    private String recipeEanCode;
    @XmlAttribute
    private Boolean halal = false;
    private PriceComplete price;
    private CustomerLight customer;
    @XmlAttribute
    private Double conversionToDefaultUnit;
    @DTOField(nullable=false)
    private QuantityComplete yield;
    private PeriodComplete validityPeriod;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private CostCenterComplete defaultCostCenter;
    @XmlAttribute
    private Boolean useDefaultCostCenterForCCP2;
    @XmlAttribute
    private String internalVariantComment;
    @XmlAttribute
    private Boolean hasYieldValidationWarning;
    private PreparationGroupComplete preparationGroup;
    private RecipeProductGroupComplete productGroup;
    @XmlAttribute
    private Boolean directlyInProduct;

    public Boolean getDirectlyInProduct() {
        return this.directlyInProduct;
    }

    public void setDirectlyInProduct(Boolean directlyInProduct) {
        this.directlyInProduct = directlyInProduct;
    }

    public QuantityComplete getYield() {
        return this.yield;
    }

    public void setYield(QuantityComplete yield) {
        this.yield = yield;
    }

    public PriceComplete getPrice() {
        return this.price;
    }

    public void setPrice(PriceComplete price) {
        this.price = price;
    }

    public RecipeComplete getRecipe() {
        return this.recipe;
    }

    public void setRecipe(RecipeComplete recipe) {
        this.recipe = recipe;
    }

    public PegasusFileComplete getImageReference() {
        return this.imageReference;
    }

    public void setImageReference(PegasusFileComplete imageReference) {
        this.imageReference = imageReference;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Timestamp getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Timestamp creationDate) {
        this.creationDate = creationDate;
    }

    public RecipeCategoryLight getCategory() {
        return this.category;
    }

    public void setCategory(RecipeCategoryLight category) {
        this.category = category;
    }

    @Override
    public String toString() {
        return "recipe  (" + this.name + ")";
    }

    public ModificationStateE getState() {
        return this.state;
    }

    public void setState(ModificationStateE state) {
        this.state = state;
    }

    @Override
    public PeriodComplete getValidityPeriod() {
        return this.validityPeriod;
    }

    @Override
    public void setValidityPeriod(PeriodComplete validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    @Override
    public Integer getNumber() {
        return this.number;
    }

    @Override
    public void setNumber(Integer number) {
        this.number = number;
    }

    public CostCenterComplete getDefaultCostCenter() {
        return this.defaultCostCenter;
    }

    public void setDefaultCostCenter(CostCenterComplete defaultCostCenter) {
        this.defaultCostCenter = defaultCostCenter;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public void setEnglishName(String englishName) {
        this.englishName = englishName;
    }

    public String getInternalVariantComment() {
        return this.internalVariantComment;
    }

    public void setInternalVariantComment(String internalVariantComment) {
        this.internalVariantComment = internalVariantComment;
    }

    public Boolean getHasYieldValidationWarning() {
        return this.hasYieldValidationWarning;
    }

    public void setHasYieldValidationWarning(Boolean hasYieldValidationWarning) {
        this.hasYieldValidationWarning = hasYieldValidationWarning;
    }

    public Boolean getHalal() {
        return this.halal;
    }

    public void setHalal(Boolean halal) {
        this.halal = halal;
    }

    public PreparationGroupComplete getPreparationGroup() {
        return this.preparationGroup;
    }

    public void setPreparationGroup(PreparationGroupComplete preparationGroup) {
        this.preparationGroup = preparationGroup;
    }

    @Override
    public int compareTo(RecipeVariantLight o) {
        return this.validityPeriod.compareTo(o.validityPeriod);
    }

    public CustomerLight getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerLight customer) {
        this.customer = customer;
    }

    public Double getConversionToDefaultUnit() {
        return this.conversionToDefaultUnit;
    }

    public void setConversionToDefaultUnit(Double conversionToDefaultUnit) {
        this.conversionToDefaultUnit = conversionToDefaultUnit;
    }

    public RecipeProductGroupComplete getProductGroup() {
        return this.productGroup;
    }

    public void setProductGroup(RecipeProductGroupComplete productGroup) {
        this.productGroup = productGroup;
    }

    public Long getRecipeId() {
        return this.recipeId;
    }

    public void setRecipeId(Long recipeId) {
        this.recipeId = recipeId;
    }

    public Integer getRecipeNumber() {
        return this.recipeNumber;
    }

    public void setRecipeNumber(Integer recipeNumber) {
        this.recipeNumber = recipeNumber;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Boolean getServiceItem() {
        return this.serviceItem;
    }

    public void setServiceItem(Boolean serviceItem) {
        this.serviceItem = serviceItem;
    }

    public void beforeMarshal(Marshaller m) {
        try {
            if (this.getRecipe() != null) {
                this.setRecipeId(this.getRecipe().getId());
                this.setRecipeNumber(this.getRecipe().getNumber());
                this.setDeleted(this.getRecipe().getIsDeleted());
                this.setServiceItem(this.getRecipe().getServiceItem());
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        if (parent instanceof RecipeComplete) {
            this.recipe = (RecipeComplete)parent;
        } else if (this.getRecipeId() != null && XmlCache.getXmlCache().get(this.getRecipeId()) != null) {
            this.setRecipe((RecipeComplete)XmlCache.getXmlCache().get(this.getRecipeId()));
        }
    }

    public Boolean getUseDefaultCostCenterForCCP2() {
        return this.useDefaultCostCenterForCCP2;
    }

    public void setUseDefaultCostCenterForCCP2(Boolean useDefaultCostCenterForCCP2) {
        this.useDefaultCostCenterForCCP2 = useDefaultCostCenterForCCP2;
    }

    public String getRecipeEanCode() {
        return this.recipeEanCode;
    }

    public void setRecipeEanCode(String recipeEanCode) {
        this.recipeEanCode = recipeEanCode;
    }
}

