/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.report.analysis;

import ch.icit.pegasus.server.core.dtos.acountdistribution.AccountDistributionComplete;
import ch.icit.pegasus.server.core.dtos.acountdistribution.AccountDistributionReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderReference;
import ch.icit.pegasus.server.core.dtos.report.AReportConfigurationWithoutSearch;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsReference;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.Tuple;
import java.util.ArrayList;
import java.util.List;

public class FlightInvoiceReportConfiguration
extends AReportConfigurationWithoutSearch {
    private List<FlightReference> flights = new ArrayList<FlightReference>();
    private List<TradeGoodsReference> realTradeGoods = new ArrayList<TradeGoodsReference>();
    private List<PurchaseOrderReference> purchaseOrders = new ArrayList<PurchaseOrderReference>();
    private List<RequisitionOrderReference> requisitionOrders = new ArrayList<RequisitionOrderReference>();
    private List<AccountDistributionReference> accountDistributions = new ArrayList<AccountDistributionReference>();
    private boolean sortByMealPlan;
    private boolean sortByNumber;
    private boolean sortByName;
    private boolean includeTaxes;
    private boolean includeZeroValues;
    private boolean includeZeroPaxClasses;
    private boolean groupByCabinClass;
    private boolean groupByFlightNo;
    private boolean groupByMealPlan;
    private boolean includeByDateSheet;
    private boolean includeQty;
    private boolean includeSum;
    private boolean includeTotalSum;
    private boolean byFlight;
    private boolean groupByProductType;
    private boolean includeIgnoreOnInvoiceMeals;
    private boolean filterForAccountDistributions;
    private boolean includeCateringServiceInfo;
    private boolean flatPax;
    private boolean flatProducts = true;

    protected void getConfiguration(List list) {
    }

    @Override
    public Long getMaxResults() {
        return new Long(this.flights.size() + this.realTradeGoods.size() + this.purchaseOrders.size() + this.requisitionOrders.size());
    }

    public List<FlightReference> getFlights() {
        return this.flights;
    }

    public void setFlights(List<FlightReference> flights) {
        this.flights = flights;
    }

    public List<TradeGoodsReference> getRealTradeGoods() {
        return this.realTradeGoods;
    }

    public void setRealTradeGoods(List<TradeGoodsReference> realTradeGoods) {
        this.realTradeGoods = realTradeGoods;
    }

    public List<PurchaseOrderReference> getPurchaseOrders() {
        return this.purchaseOrders;
    }

    public void setPurchaseOrders(List<PurchaseOrderReference> purchaseOrders) {
        this.purchaseOrders = purchaseOrders;
    }

    public List<RequisitionOrderReference> getRequisitionOrders() {
        return this.requisitionOrders;
    }

    public void setRequisitionOrders(List<RequisitionOrderReference> requisitionOrders) {
        this.requisitionOrders = requisitionOrders;
    }

    public List<AccountDistributionReference> getAccountDistributions() {
        return this.accountDistributions;
    }

    public void setAccountDistributions(List<AccountDistributionReference> accountDistributions) {
        this.accountDistributions = accountDistributions;
    }

    public boolean isSortByMealPlan() {
        return this.sortByMealPlan;
    }

    public void setSortByMealPlan(boolean sortByMealPlan) {
        this.sortByMealPlan = sortByMealPlan;
    }

    public boolean isSortByNumber() {
        return this.sortByNumber;
    }

    public void setSortByNumber(boolean sortByNumber) {
        this.sortByNumber = sortByNumber;
    }

    public boolean isSortByName() {
        return this.sortByName;
    }

    public void setSortByName(boolean sortByName) {
        this.sortByName = sortByName;
    }

    public boolean isIncludeTaxes() {
        return this.includeTaxes;
    }

    public void setIncludeTaxes(boolean includeTaxes) {
        this.includeTaxes = includeTaxes;
    }

    public boolean isIncludeZeroValues() {
        return this.includeZeroValues;
    }

    public void setIncludeZeroValues(boolean includeZeroValues) {
        this.includeZeroValues = includeZeroValues;
    }

    public boolean isIncludeZeroPaxClasses() {
        return this.includeZeroPaxClasses;
    }

    public void setIncludeZeroPaxClasses(boolean includeZeroPaxClasses) {
        this.includeZeroPaxClasses = includeZeroPaxClasses;
    }

    public boolean isGroupByCabinClass() {
        return this.groupByCabinClass;
    }

    public void setGroupByCabinClass(boolean groupByCabinClass) {
        this.groupByCabinClass = groupByCabinClass;
    }

    public boolean isGroupByFlightNo() {
        return this.groupByFlightNo;
    }

    public void setGroupByFlightNo(boolean groupByFlightNo) {
        this.groupByFlightNo = groupByFlightNo;
    }

    public boolean isGroupByMealPlan() {
        return this.groupByMealPlan;
    }

    public void setGroupByMealPlan(boolean groupByMealPlan) {
        this.groupByMealPlan = groupByMealPlan;
    }

    public boolean isIncludeByDateSheet() {
        return this.includeByDateSheet;
    }

    public void setIncludeByDateSheet(boolean includeByDateSheet) {
        this.includeByDateSheet = includeByDateSheet;
    }

    public boolean isIncludeQty() {
        return this.includeQty;
    }

    public void setIncludeQty(boolean includeQty) {
        this.includeQty = includeQty;
    }

    public boolean isIncludeSum() {
        return this.includeSum;
    }

    public void setIncludeSum(boolean includeSum) {
        this.includeSum = includeSum;
    }

    public boolean isIncludeTotalSum() {
        return this.includeTotalSum;
    }

    public void setIncludeTotalSum(boolean includeTotalSum) {
        this.includeTotalSum = includeTotalSum;
    }

    public boolean isByFlight() {
        return this.byFlight;
    }

    public void setByFlight(boolean byFlight) {
        this.byFlight = byFlight;
    }

    public boolean isGroupByProductType() {
        return this.groupByProductType;
    }

    public void setGroupByProductType(boolean groupByProductType) {
        this.groupByProductType = groupByProductType;
    }

    public boolean getIncludeIgnoreOnInvoiceMeals() {
        return this.includeIgnoreOnInvoiceMeals;
    }

    public void setIncludeIgnoreOnInvoiceMeals(boolean includeIgnoreOnInvoiceMeals) {
        this.includeIgnoreOnInvoiceMeals = includeIgnoreOnInvoiceMeals;
    }

    public boolean getFilterForAccountDistributions() {
        return this.filterForAccountDistributions;
    }

    public void setFilterForAccountDistributions(boolean filterForAccountDistributions) {
        this.filterForAccountDistributions = filterForAccountDistributions;
    }

    public boolean getIncludeCateringServiceInfo() {
        return this.includeCateringServiceInfo;
    }

    public void setIncludeCateringServiceInfo(boolean includeCateringServiceInfo) {
        this.includeCateringServiceInfo = includeCateringServiceInfo;
    }

    public List<Tuple<String, Object>> getReportConfiguration(List<AccountDistributionComplete> accountDistributions) {
        ArrayList<Tuple<String, Object>> list = new ArrayList<Tuple<String, Object>>();
        list.add(new Tuple((Object)"", null));
        list.add(new Tuple((Object)Words.SORT_BY, null));
        list.add(new Tuple((Object)Words.MEAL_PLAN, (Object)this.sortByMealPlan));
        list.add(new Tuple((Object)Words.NAME, (Object)this.sortByName));
        list.add(new Tuple((Object)Words.NUMBER, (Object)this.sortByNumber));
        list.add(new Tuple((Object)"", null));
        list.add(new Tuple((Object)Words.ADD_GROUPED_FLIGHTS_BY, null));
        list.add(new Tuple((Object)Words.FLIGHT_NUMBER, (Object)this.groupByFlightNo));
        list.add(new Tuple((Object)Words.MEAL_PLAN, (Object)this.groupByMealPlan));
        list.add(new Tuple((Object)Words.DATE, (Object)this.includeByDateSheet));
        list.add(new Tuple((Object)"", null));
        list.add(new Tuple((Object)Words.SHEET_CONFIGURATION, null));
        list.add(new Tuple((Object)Words.BY_DATE, (Object)(!this.byFlight ? 1 : 0)));
        list.add(new Tuple((Object)Words.BY_FLIGHT, (Object)this.byFlight));
        list.add(new Tuple((Object)Words.INCLUDE_TAXES, (Object)this.includeTaxes));
        list.add(new Tuple((Object)Words.INCLUDE_ZERO_PRICE_ITEMS, (Object)this.includeZeroValues));
        list.add(new Tuple((Object)Words.INCLUDE_ZERO_PAX_CLASSES, (Object)this.includeZeroPaxClasses));
        list.add(new Tuple((Object)Words.INCLUDE_QUANTITY, (Object)this.includeQty));
        list.add(new Tuple((Object)Words.SHOW_SUM, (Object)this.includeTotalSum));
        list.add(new Tuple((Object)Words.INCLUDE_SUM, (Object)this.includeTotalSum));
        list.add(new Tuple((Object)Words.GROUP_BY_CABINCLASS, (Object)this.groupByCabinClass));
        list.add(new Tuple((Object)Words.GROUP_BY_PRODUCT_TYPE, (Object)this.groupByProductType));
        list.add(new Tuple((Object)Words.INCLUDE_IGNORE_ON_INVOICE_MEALS, (Object)this.includeIgnoreOnInvoiceMeals));
        list.add(new Tuple((Object)Words.INCLUDE_CATERING_SERVICE_INFO, (Object)this.includeCateringServiceInfo));
        list.add(new Tuple((Object)"", null));
        list.add(new Tuple((Object)Words.ACCOUNT_DISTRIBUTION_FILTER, null));
        list.add(new Tuple((Object)Words.FILTER_ACTIVE, (Object)this.filterForAccountDistributions));
        for (AccountDistributionComplete accountDistribution : accountDistributions) {
            list.add((Tuple<String, Object>)new Tuple((Object)"", (Object)accountDistribution.getName()));
        }
        return list;
    }

    public boolean isFlatPax() {
        return this.flatPax;
    }

    public void setFlatPax(boolean flatPax) {
        this.flatPax = flatPax;
    }

    public boolean isFlatProducts() {
        return this.flatProducts;
    }

    public void setFlatProducts(boolean flatProducts) {
        this.flatProducts = flatProducts;
    }
}

