/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.search;

import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ReturnsCountStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceTypeE;
import ch.icit.pegasus.server.core.dtos.invoice.RetailInvoiceStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchTypeE;
import ch.icit.pegasus.server.core.dtos.sob.SalesOnBoardStateE;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.SalesPersonComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.SqlDateAdapter;
import ch.icit.pegasus.server.core.general.SearchImplType;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FlightSearchConfiguration
extends ADtoSearchConfiguration<FlightLight, FLIGHT_COLUMN> {
    @XmlAttribute
    private String flightNumber;
    private FlightStateE flightState;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private CustomerLight customer;
    private TimestampPeriodComplete lastUpdate;
    private FlightTypeE flightType;
    private RetailInvoiceStateE retailInvoiceState;
    @XmlAttribute
    private Boolean hasSobIrregularity;
    @XmlAttribute
    private Boolean closedForTransaction;
    private PeriodComplete dayPeriod;
    private TimestampPeriodComplete dayTimePeriod;
    private FlightCategoryComplete category;
    private FLIGHT_STD_STA flightStdSta;
    @XmlAttribute
    private Boolean isInvoiced;
    private InvoiceTypeE searchedType;
    @XmlAttribute
    private Boolean invertState = false;
    @Deprecated
    @XmlAttribute
    private Boolean onlyOpenFlights = false;
    @XmlAttribute
    private Boolean ignoreCancelledFlights = false;
    @XmlAttribute
    private Boolean autoCheckout;
    @XmlAttribute
    private Boolean hasStockTransactions;
    @XmlAttribute
    private Boolean hasIrregularity;
    @XmlAttribute
    private Boolean approvedState;
    @XmlAttribute
    private Boolean hasSubstitions;
    @XmlAttribute
    private Boolean aisPrintNeeded;
    private PaxFigureTypeComplete paxType;
    private AirportComplete deliveryAirport;
    private STOWAGE_TYPE_COLUMN stowageType = STOWAGE_TYPE_COLUMN.ALL;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private HaulTypeComplete haulType;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ReturnsCountStateE rcState;
    private List<HaulTypeComplete> haulTypeList = new ArrayList<HaulTypeComplete>();
    @XmlAttribute
    private Boolean showNullHaulTypes = Boolean.FALSE;
    private SalesOnBoardStateE sobState;
    @XmlJavaTypeAdapter(value=SqlDateAdapter.class)
    private Date upToDate;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private HandlingCostComplete handling;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private StowingListTemplateReference stowingListTemplate;
    @XmlAttribute
    private Boolean hasRetailInMotionData;
    @XmlAttribute
    private Boolean paxTypeFinalOnly;
    @XmlAttribute
    private String customsDocumentId;
    private CustomsDocumentTypeComplete customsDocumentType;
    @XmlAttribute
    private Boolean hasGroTransactions;
    @XmlAttribute
    private Boolean retailInMotionCheckoutDone;
    @XmlAttribute
    private Boolean retailInMotionCheckinDone;
    @XmlAttribute
    private Boolean checkoutPerformed;
    private AircraftComplete aircraft;
    private FlightSearchTypeE searchFlightType = FlightSearchTypeE.FLIGHT_CODE;
    private boolean fromRetailModule;
    @XmlAttribute
    private Boolean edelweissPaxUpdate;
    @XmlAttribute
    private Boolean filterByRestaurant;
    private List<RestaurantComplete> possibleRestaurants = new ArrayList<RestaurantComplete>();
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private SalesPersonComplete salesPerson;
    @XmlAttribute
    private Boolean flightOrderReceived;

    public Boolean getFilterByRestaurant() {
        return this.filterByRestaurant;
    }

    public void setFilterByRestaurant(Boolean filterByRestaurant) {
        this.filterByRestaurant = filterByRestaurant;
    }

    public List<RestaurantComplete> getPossibleRestaurants() {
        return this.possibleRestaurants;
    }

    public void setPossibleRestaurants(List<RestaurantComplete> possibleRestaurants) {
        this.possibleRestaurants = possibleRestaurants;
    }

    public Boolean getEdelweissPaxUpdate() {
        return this.edelweissPaxUpdate;
    }

    public void setEdelweissPaxUpdate(Boolean edelweissPaxUpdate) {
        this.edelweissPaxUpdate = edelweissPaxUpdate;
    }

    public AirportComplete getDeliveryAirport() {
        return this.deliveryAirport;
    }

    public void setDeliveryAirport(AirportComplete deliveryAirport) {
        this.deliveryAirport = deliveryAirport;
    }

    public void setFromRetailModule(boolean fromRetailModule) {
        this.fromRetailModule = fromRetailModule;
    }

    public boolean isFromRetailModule() {
        return this.fromRetailModule;
    }

    public AircraftComplete getAircraft() {
        return this.aircraft;
    }

    public void setAircraft(AircraftComplete aircraft) {
        this.aircraft = aircraft;
    }

    public Boolean getCheckoutPerformed() {
        return this.checkoutPerformed;
    }

    public void setCheckoutPerformed(Boolean checkoutPerformed) {
        this.checkoutPerformed = checkoutPerformed;
    }

    public void setFlightOrderReceived(Boolean flightOrderReceived) {
        this.flightOrderReceived = flightOrderReceived;
    }

    public Boolean getFlightOrderReceived() {
        return this.flightOrderReceived;
    }

    public Boolean getClosedForTransaction() {
        return this.closedForTransaction;
    }

    public void setClosedForTransaction(Boolean closedForTransaction) {
        this.closedForTransaction = closedForTransaction;
    }

    public Boolean getRetailInMotionCheckoutDone() {
        return this.retailInMotionCheckoutDone;
    }

    public void setRetailInMotionCheckoutDone(Boolean retailInMotionCheckoutDone) {
        this.retailInMotionCheckoutDone = retailInMotionCheckoutDone;
    }

    public Boolean getRetailInMotionCheckinDone() {
        return this.retailInMotionCheckinDone;
    }

    public void setRetailInMotionCheckinDone(Boolean retailInMotionCheckinDone) {
        this.retailInMotionCheckinDone = retailInMotionCheckinDone;
    }

    public SearchImplType getIdentifier() {
        return SearchImplType.FLIGHT;
    }

    public FLIGHT_COLUMN getDefaultSortColumn() {
        return FLIGHT_COLUMN.PLANNED_DEPARTURE;
    }

    public Date getUpToDate() {
        return this.upToDate;
    }

    public void setUpToDate(Date uptoDate) {
        this.upToDate = new PeriodComplete(new Date(0L), uptoDate).getEndDate();
    }

    public Boolean getIsInvoiced() {
        return this.isInvoiced;
    }

    public void setIsInvoiced(Boolean isInvoiced) {
        this.isInvoiced = isInvoiced;
    }

    public String getFlightNumber() {
        return this.flightNumber;
    }

    public void setFlightNumber(String flightNumber) {
        this.flightNumber = this.limitString(flightNumber);
    }

    public FlightStateE getFlightState() {
        return this.flightState;
    }

    public void setFlightState(FlightStateE flightState) {
        this.flightState = flightState;
    }

    public CustomerLight getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerLight customer) {
        this.customer = customer;
    }

    public TimestampPeriodComplete getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(TimestampPeriodComplete lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public FlightTypeE getFlightType() {
        return this.flightType;
    }

    public void setFlightType(FlightTypeE flightType) {
        this.flightType = flightType;
    }

    public void setHandling(HandlingCostComplete handling) {
        this.handling = handling;
    }

    public HandlingCostComplete getHandling() {
        return this.handling;
    }

    public void setHaulType(HaulTypeComplete haulType) {
        this.haulType = haulType;
    }

    public HaulTypeComplete getHaulType() {
        return this.haulType;
    }

    public Boolean getOnlyOpenFlights() {
        return this.onlyOpenFlights;
    }

    public void setOnlyOpenFlights(Boolean onlyOpenFlights) {
        this.onlyOpenFlights = onlyOpenFlights;
    }

    public Boolean getInvertState() {
        return this.invertState;
    }

    public void setInvertState(Boolean invertState) {
        this.invertState = invertState;
    }

    public Boolean getAutoCheckout() {
        return this.autoCheckout;
    }

    public void setAutoCheckout(Boolean autoCheckout) {
        this.autoCheckout = autoCheckout;
    }

    public SalesOnBoardStateE getSobState() {
        return this.sobState;
    }

    public void setSobState(SalesOnBoardStateE sobState) {
        this.sobState = sobState;
    }

    public Boolean getHasStockTransactions() {
        return this.hasStockTransactions;
    }

    public void setHasStockTransactions(Boolean hasStockTransactions) {
        this.hasStockTransactions = hasStockTransactions;
    }

    public Boolean getHasIrregularity() {
        return this.hasIrregularity;
    }

    public void setHasIrregularity(Boolean hasIrregularity) {
        this.hasIrregularity = hasIrregularity;
    }

    public List<HaulTypeComplete> getHaulTypeList() {
        return this.haulTypeList;
    }

    public void setHaulTypeList(List<HaulTypeComplete> haulTypeList) {
        this.haulTypeList = haulTypeList;
    }

    public Boolean getShowNullHaulTypes() {
        return this.showNullHaulTypes;
    }

    public void setShowNullHaulTypes(Boolean showNullHaulTypes) {
        this.showNullHaulTypes = showNullHaulTypes;
    }

    public ReturnsCountStateE getRcState() {
        return this.rcState;
    }

    public void setRcState(ReturnsCountStateE rcState) {
        this.rcState = rcState;
    }

    public InvoiceTypeE getSearchedType() {
        return this.searchedType;
    }

    public void setSearchedType(InvoiceTypeE searchedType) {
        this.searchedType = searchedType;
    }

    public Boolean getApprovedState() {
        return this.approvedState;
    }

    public void setApprovedState(Boolean approvedState) {
        this.approvedState = approvedState;
    }

    public FLIGHT_STD_STA getFlightStdSta() {
        return this.flightStdSta;
    }

    public void setFlightStdSta(FLIGHT_STD_STA flightStdSta) {
        this.flightStdSta = flightStdSta;
    }

    public PeriodComplete getDayPeriod() {
        return this.dayPeriod;
    }

    public void setDayPeriod(PeriodComplete dayPeriod) {
        this.dayPeriod = dayPeriod;
    }

    public TimestampPeriodComplete getDayTimePeriod() {
        return this.dayTimePeriod;
    }

    public void setDayTimePeriod(TimestampPeriodComplete dayTimePeriod) {
        this.dayTimePeriod = dayTimePeriod;
    }

    public Boolean getHasSobIrregularity() {
        return this.hasSobIrregularity;
    }

    public void setHasSobIrregularity(Boolean hasSobIrregularity) {
        this.hasSobIrregularity = hasSobIrregularity;
    }

    public FlightCategoryComplete getCategory() {
        return this.category;
    }

    public void setCategory(FlightCategoryComplete category) {
        this.category = category;
    }

    public Boolean getHasSubstitions() {
        return this.hasSubstitions;
    }

    public void setHasSubstitions(Boolean hasSubstitions) {
        this.hasSubstitions = hasSubstitions;
    }

    public Boolean getAisPrintNeeded() {
        return this.aisPrintNeeded;
    }

    public void setAisPrintNeeded(Boolean aisPrintNeeded) {
        this.aisPrintNeeded = aisPrintNeeded;
    }

    public List<Tuple<String, String>> getSearchConfig() {
        ArrayList<Tuple<String, String>> configs = new ArrayList<Tuple<String, String>>();
        configs.add(new Tuple((Object)"Flight No", (Object)this.getFlightNumber()));
        configs.add(new Tuple((Object)"State", (Object)(this.getOnlyOpenFlights() != false ? "All (except Planned)" : (this.getFlightState() != null ? this.getFlightState().toString() : ""))));
        configs.add(new Tuple((Object)"From", (Object)this.getDayPeriod().getStartDate().toString()));
        configs.add(new Tuple((Object)"To", (Object)this.getDayPeriod().getEndDate().toString()));
        configs.add(new Tuple((Object)"Customer", (Object)(this.getCustomer() != null ? this.getCustomer().getCode() : "")));
        configs.add(new Tuple((Object)"Stowage Type", (Object)(this.getStowageType() != null ? this.getStowageType().toString() : "")));
        configs.add(new Tuple((Object)"Auto Checkout", (Object)(Boolean.TRUE.equals(this.getAutoCheckout()) ? "yes" : (this.getAutoCheckout() == null ? "all" : "no"))));
        configs.add(new Tuple((Object)"Returns Count State", (Object)(this.getRcState() != null ? this.getRcState().toString() : "")));
        configs.add(new Tuple((Object)"Transactions", (Object)(Boolean.TRUE.equals(this.getHasStockTransactions()) ? "yes" : (this.getHasStockTransactions() == null ? "all" : "no"))));
        configs.add(new Tuple((Object)"Irregularity", (Object)(Boolean.TRUE.equals(this.getHasIrregularity()) ? "yes" : (this.getHasIrregularity() == null ? "all" : "no"))));
        configs.add(new Tuple((Object)"Category", (Object)(this.getCategory() != null ? this.getCategory().getCode() : "")));
        configs.add(new Tuple((Object)"AIS Print State", (Object)(this.getAisPrintNeeded() != null ? "needs print" : "no changes")));
        configs.addAll(this.getHaulTypeConfig());
        return configs;
    }

    private List<Tuple<String, String>> getHaulTypeConfig() {
        ArrayList<Tuple<String, String>> rets = new ArrayList<Tuple<String, String>>();
        rets.add(new Tuple((Object)"Show Null Haul Type", (Object)(this.getShowNullHaulTypes() != false ? "yes" : "no")));
        if (this.getHaulTypeList() != null) {
            for (HaulTypeComplete h : this.getHaulTypeList()) {
                rets.add((Tuple<String, String>)new Tuple((Object)"Haul Type", (Object)h.getCode()));
            }
        }
        return rets;
    }

    public PaxFigureTypeComplete getPaxType() {
        return this.paxType;
    }

    public void setPaxType(PaxFigureTypeComplete paxType) {
        this.paxType = paxType;
    }

    public StowingListTemplateReference getStowingListTemplate() {
        return this.stowingListTemplate;
    }

    public void setStowingListTemplate(StowingListTemplateReference stowingListTemplate) {
        this.stowingListTemplate = stowingListTemplate;
    }

    public void setHasRetailInMotionData(Boolean hasRetailInMotionData) {
        this.hasRetailInMotionData = hasRetailInMotionData;
    }

    public Boolean getHasRetailInMotionData() {
        return this.hasRetailInMotionData;
    }

    public Boolean getIgnoreCancelledFlights() {
        return this.ignoreCancelledFlights;
    }

    public void setIgnoreCancelledFlights(Boolean ignoreCancelledFlights) {
        this.ignoreCancelledFlights = ignoreCancelledFlights;
    }

    public Boolean getPaxTypeFinalOnly() {
        return this.paxTypeFinalOnly;
    }

    public void setPaxTypeFinalOnly(Boolean paxTypeFinalOnly) {
        this.paxTypeFinalOnly = paxTypeFinalOnly;
    }

    public String getCustomsDocumentId() {
        return this.customsDocumentId;
    }

    public void setCustomsDocumentId(String customsDocumentId) {
        this.customsDocumentId = this.limitString(customsDocumentId);
    }

    public CustomsDocumentTypeComplete getCustomsDocumentType() {
        return this.customsDocumentType;
    }

    public void setCustomsDocumentType(CustomsDocumentTypeComplete customsDocumentType) {
        this.customsDocumentType = customsDocumentType;
    }

    public STOWAGE_TYPE_COLUMN getStowageType() {
        return this.stowageType;
    }

    public void setStowageType(STOWAGE_TYPE_COLUMN stowageType) {
        this.stowageType = stowageType;
    }

    public Boolean getHasGroTransactions() {
        return this.hasGroTransactions;
    }

    public void setHasGroTransactions(Boolean hasGroTransactions) {
        this.hasGroTransactions = hasGroTransactions;
    }

    public FlightSearchTypeE getSearchFlightType() {
        return this.searchFlightType;
    }

    public void setSearchFlightType(FlightSearchTypeE searchFlightType) {
        this.searchFlightType = searchFlightType;
    }

    public SalesPersonComplete getSalesPerson() {
        return this.salesPerson;
    }

    public void setSalesPerson(SalesPersonComplete salesPerson) {
        this.salesPerson = salesPerson;
    }

    public RetailInvoiceStateE getRetailInvoiceState() {
        return this.retailInvoiceState;
    }

    public void setRetailInvoiceState(RetailInvoiceStateE retailInvoiceState) {
        this.retailInvoiceState = retailInvoiceState;
    }

    public static enum STOWAGE_TYPE_COLUMN {
        SALES_ON_BOARD,
        REGULAR,
        ALL;


        public String toString() {
            switch (this) {
                case ALL: {
                    return "All";
                }
                case REGULAR: {
                    return "No Sales on Board";
                }
                case SALES_ON_BOARD: {
                    return "Sales on Board";
                }
            }
            return "";
        }
    }

    public static enum FLIGHT_COLUMN {
        STATE,
        OUTBOUND_CODE,
        PLANNED_DEPARTURE,
        CARRIER,
        STOWINGLIST,
        LAST_UPDATE,
        DISPATCH,
        PLANNED_ARRIVAL,
        INBOUND_CODE,
        CATEGORY,
        TRACKING_NUMBER,
        CUSTOMS_ORDER_ID,
        SALES_PERSON,
        CHECKOUT_LAST_UPDATE,
        CHECKOUT,
        RESTAURANT,
        FLIGHT_ORDER_RECEIVED;

    }

    public static enum FLIGHT_STD_STA {
        stdOnly,
        staOnly,
        staStd;


        public String toString() {
            switch (this) {
                case staOnly: {
                    return "sta";
                }
                case stdOnly: {
                    return "std";
                }
                case staStd: {
                    return "std and sta";
                }
            }
            return null;
        }
    }
}

