/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.serviceproduct;

import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductVariantReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@DTO(target="ch.icit.pegasus.server.core.entities.serviceproduct.ServiceProductVariant")
public class ServiceProductVariantComplete
extends ServiceProductVariantReference
implements Comparable<ServiceProductVariantComplete> {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.NONE)
    private static Logger logger = LoggerFactory.getLogger(ServiceProductVariantComplete.class);
    private PeriodComplete validityPeriod;
    @DTOField(nullable=false, updatable=false, target="base")
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @XmlTransient
    private ServiceProductComplete serviceProduct;
    @IgnoreField
    @XmlAttribute
    private Long serviceProductId;
    @IgnoreField
    @XmlAttribute
    private Integer serviceProductNumber;
    @DTOField(nullable=false, empty=false)
    @XmlAttribute
    private String name = "";
    @XmlAttribute
    private String customerProductNumber;
    @DTOField(nullable=false)
    private ModificationStateE state;
    @DTOField(nullable=false)
    private PriceComplete salesPrice;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<TaxRateComplete> taxRates = new ArrayList<TaxRateComplete>();
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private AirportComplete deliveryAirport;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYLIST)
    private List<RecipeComplete> usedRecipes = new ArrayList<RecipeComplete>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PeriodComplete getValidityPeriod() {
        return this.validityPeriod;
    }

    public void setValidityPeriod(PeriodComplete validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public ServiceProductComplete getServiceProduct() {
        return this.serviceProduct;
    }

    public void setServiceProduct(ServiceProductComplete serviceProduct) {
        this.serviceProduct = serviceProduct;
    }

    public String getCustomerProductNumber() {
        return this.customerProductNumber;
    }

    public void setCustomerProductNumber(String customerProductNumber) {
        this.customerProductNumber = customerProductNumber;
    }

    public ModificationStateE getState() {
        return this.state;
    }

    public void setState(ModificationStateE state) {
        this.state = state;
    }

    public PriceComplete getSalesPrice() {
        return this.salesPrice;
    }

    public void setSalesPrice(PriceComplete salesPrice) {
        this.salesPrice = salesPrice;
    }

    public List<TaxRateComplete> getTaxRates() {
        return this.taxRates;
    }

    public void setTaxRates(List<TaxRateComplete> taxRates) {
        this.taxRates = taxRates;
    }

    public AirportComplete getDeliveryAirport() {
        return this.deliveryAirport;
    }

    public void setDeliveryAirport(AirportComplete deliveryAirport) {
        this.deliveryAirport = deliveryAirport;
    }

    @Override
    public int compareTo(ServiceProductVariantComplete o) {
        return this.validityPeriod.compareTo(o.validityPeriod);
    }

    public Long getServiceProductId() {
        return this.serviceProductId;
    }

    public void setServiceProductId(Long serviceProductId) {
        this.serviceProductId = serviceProductId;
    }

    public Integer getServiceProductNumber() {
        return this.serviceProductNumber;
    }

    public void setServiceProductNumber(Integer serviceProductNumber) {
        this.serviceProductNumber = serviceProductNumber;
    }

    public void beforeMarshal(Marshaller m) {
        try {
            if (this.getServiceProduct() != null) {
                this.setServiceProductId(this.getServiceProduct().getCacheId());
                this.setServiceProductNumber(this.getServiceProduct().getNumber());
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        if (parent instanceof ServiceProductComplete) {
            this.serviceProduct = (ServiceProductComplete)parent;
        } else if (this.getServiceProductId() != null && XmlCache.getXmlCache().get(this.getServiceProductId()) != null) {
            this.setServiceProduct((ServiceProductComplete)XmlCache.getXmlCache().get(this.getServiceProductId()));
        }
    }

    public List<RecipeComplete> getUsedRecipes() {
        return this.usedRecipes;
    }

    public void setUsedRecipes(List<RecipeComplete> usedRecipes) {
        this.usedRecipes = usedRecipes;
    }
}

